#
#	This is the spec file for building a SRPM from the dgap source tree
#
#	$Id: dgap.spec.proto,v 1.13 2003/12/02 19:56:17 scottk Exp $
#
#	Not really part of the spec file, this ties the Digi
#	International Part Number to traditional Linux Versioning
#
Summary:	The EPCA/DGAP Drivers and System Software
Name:		dgap
Version:	1.1
Release:	1
Copyright:	GPL
Group:		Applications/Communications
Source:		dgap-1.1.tgz
Url:		http://www.digi.com/
Distribution:	Digi EPCA/DGAP
Vendor:		Digi International
Packager:	Scott Kilau <scottk at digi dot com>
Requires:	ncurses
ExclusiveOS:	Linux
ExcludeArch:	alpha sparc sparc64 mipseb ppc m68k sgi rs6000
BuildRoot:	/var/tmp/%{name}-buildroot

%description
This packages contains the device drivers and the supporting management
applications for the following Digi International adapter families:
  Digi AccelePort EPC/X PCI
  Digi AccelePort C/X PCI
  Digi AccelePort Xem PCI
  Digi AccelePort Xr 8 port PCI
  Digi AccelePort Xr 920 2 port PCI
  Digi AccelePort Xr 920 4 port PCI
  Digi AccelePort Xr 920 8 port PCI
  Digi AccelePort Xr 422 PCI


%prep

%setup
if [ "$RPM_BUILD_ROOT" = "/" ]
then
	echo This package requires a seperate BuildRoot to build properly.
	exit 1
fi

#rm -rf $RPM_BUILD_ROOT/usr/src/dg/dgap
#mkdir -m 755 -p $RPM_BUILD_ROOT/usr/src/dg/dgap/drv/linux
#cp -R $RPM_BUILD_DIR/%{name}-%{version}-%{release}/* $RPM_BUILD_ROOT/usr/src/dg/dgap/drv/linux


%configure \
	%{?DISTRO:DISTRO%DISTRO}	\
	%{?DISTR:DISTR%DISTR}		\
	%{?DIST:DIST%DIST}


%build
make all


%install
make install BUILDROOT=$RPM_BUILD_ROOT
make clean

%clean
if [ "$RPM_BUILD_ROOT" != "/" ]
then
	rm -rf $RPM_BUILD_ROOT
else
	make uninstall BUILDROOT=$RPM_BUILD_ROOT
fi


%post
	if [ -d /etc/dgap -a -f /etc/dgap/postinstall ]
	then
		/etc/dgap/postinstall
	fi


%preun
	if [ -d /etc/dgap -a -f /etc/dgap/preuninstall ]
	then
		/etc/dgap/preuninstall
	fi


%postun  
	# Force a depmod after we have been removed.
	if [ -e /sbin/depmod ]
	then 
		/sbin/depmod -a
	fi


%files

#       
# directories potentially created and used by the kit
# 
%dir /usr
%dir /usr/bin
%dir /usr/sbin

#/dev/dg/dgap/
#/usr/src/dg/dgap/
#/usr/lib/dg/dgap/
# Could be .gz or .bz
/usr/*/man/man1/ditty.1*

# 
# this is all the binaries:
#       ditty.epca, mknod, dpa, and the driver module.
#
/usr/bin/ditty.dgap
/usr/bin/dpa.dgap
/usr/bin/dinc.dgap
/usr/sbin/dgap_mknod
/usr/sbin/dgapdl
/usr/bin/dgap_config
/usr/bin/mpi

#/usr/bin/dpa.epca
# Could be .o or .ko
/lib/modules/*/misc/dgap.*


%doc relnotes.txt
%doc COPYING

#
# depending on the system, the initialization scripts
# might be in /etc/rc.d/init.d or /etc/init.d.
# Package up our entire local /etc tree to capture
# them in either case.
#
# The firmware images are also picked up here as well.
/etc
