/* -*- linux-c -*- (Autoset linux indent style when using emacs */

/*
 * Copyright 1999-2001 by Digi International (www.digi.com)
 *    Jeff Randall <Jeff_Randall@digi.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY, EXPRESS OR IMPLIED; without even the 
 * implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
 * PURPOSE.  See the GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

/*
 * $Id: rascon.h,v 1.1 2003/06/25 23:06:33 scottk Exp $
 *
 * Things that are made public from the dgdm and epca drivers
 *
 * NOTE: These values should agree with <linux/serial.h> as much as
 *       possible to allow for maximum compatibility with standard utils
 *       and the line discipline.
 */

#if !defined(RASCON_H)
#define RASCON_H


/*
 * The usual flags (see serial.h) that are used in the
 * channel structure and are visible to users via setserial and/or ditty.
 */
#define RASCON_HUP_NOTIFY	0x00000001 /* Notify getty on hangups and
					      closes of the callout port */
#define RASCON_SAK		0x00000004 /* Secure Attention Key
					      (Orange book) */
#define RASCON_SPLIT_TERMIOS	0x00000008 /* Separate termios for
					      dialin/callout */ 

#define RASCON_SPD_MASK		0x00001030
#define RASCON_SPD_HI		0x00000010 /* Use 56000 instead of 38400 bps */
#define RASCON_SPD_VHI		0x00000020 /* Use 115200 instead of 38400 bps*/
#define RASCON_SPD_CUST		0x00000030 /* Use user-specified divisor */
#define RASCON_SPD_SHI		0x00001000 /* Use 230400 instead of 38400 bps*/
#define RASCON_SPD_WARP		0x00001010 /* Use 460800 instead of 38400 bps*/
#define RASCON_SPD_921		0x00001020 /* Use 921600 instead of 38400 bps*/
#define RASCON_SPD_1228		0x00001030 /* Use 1228800 instead            */

#define RASCON_SESSION_LOCKOUT	0x00000100 /* Lockout cug opens on session */
#define RASCON_PGRP_LOCKOUT	0x00000200 /* Lockout cug opens on pgrp */
#define RASCON_CALLOUT_NOHUP	0x00000400 /* Don't do hangups for cug devs */

#define RASCON_LOW_LATENCY	0x00002000 /* Request low latency behaviour */

#define RASCON_USR_MASK		0x00003430 /* Legal flags that non-privileged
					      users can set or reset */

/*
 * Internal flags used by the driver only.
 */
#define RASCON_INITIALIZED	0x80000000 /* Serial port was initialized */
#define RASCON_CALLOUT_ACTIVE	0x40000000 /* Call out device is active */
#define RASCON_NORMAL_ACTIVE	0x20000000 /* Normal device is active */
#define RASCON_CLOSING		0x10000000 /* Serial port is closing */
#define RASCON_ALTPIN		0x08000000 /* swap DCD and DSR pins */
#define RASCON_SOFTCAR		0x04000000 /* pretend carrier is always high */
#define RASCON_AIXON		0x02000000 /* use aux flow control chars */



/*
 * IOCTL defines for ditty(1) command
 */
 
#if !defined(TIOCMODG)
# define	TIOCMODG	('d'<<8) | 250	/* get modem ctrl state */
# define	TIOCMODS	('d'<<8) | 251	/* set modem ctrl state */
#endif
 
#if !defined(TIOCMSET)
# define	TIOCMSET	('d'<<8) | 252	/* set modem ctrl state */
# define	TIOCMGET	('d'<<8) | 253	/* set modem ctrl state */
#endif
 
#if !defined(TIOCMBIC)
# define	TIOCMBIC	('d'<<8) | 254	/* set modem ctrl state */
# define	TIOCMBIS	('d'<<8) | 255	/* set modem ctrl state */
#endif
 
#if !defined(TIOCSDTR)
# define	TIOCSDTR	('e'<<8) | 0	/* set DTR   */
# define	TIOCCDTR	('e'<<8) | 1	/* clear DTR */
#endif


#define	DIGI_GETA		('e'<<8) | 94	/* Read params		*/
#define DIGI_SETA		('e'<<8) | 95	/* Set params		*/
#define DIGI_SETAW		('e'<<8) | 96	/* Drain & set params   */
#define DIGI_SETAF		('e'<<8) | 97	/* Drain, flush & set params */
#define	DIGI_KME		('e'<<8) | 98	/* Read/Write Host
                                                 * Adapter Memory	*/
#define DIGI_GETFLOW		('e'<<8) | 99	/* Get startc/stopc flow
						 * control characters   */
#define DIGI_SETFLOW		('e'<<8) | 100	/* Set startc/stopc flow
						 * control characters   */
#define	DIGI_GETAFLOW		('e'<<8) | 101	/* Get Aux. startc/stopc
						 * flow control chars   */
#define	DIGI_SETAFLOW		('e'<<8) | 102	/* Set Aux. startc/stopc
						 * flow control chars   */
 
#define	DIGI_GETINFO		('e'<<8) | 103	/* Fill in digi_info	*/
#define	DIGI_POLLER		('e'<<8) | 104	/* Turn on/off poller	*/
#define	DIGI_INIT		('e'<<8) | 105	/* Allow things to run.	*/
#define	DIGI_DISABLE		('e'<<8) | 106	/* Disable this card	*/
 
/* C/X concentrator image - Unused by the dgdm driver */
#define	DIGI_CXCON_INIT		('e'<<8) | 107	/* Commence getting image */
#define	DIGI_CXCON_NEXT		('e'<<8) | 108	/* Get next chunk	  */
#define	DIGI_MODDEC		('e'<<8) | 109	/* Decrease module count  */
#define	DIGI_CONCTYPE		('e'<<8) | 110	/* Get Concentrator Type  */
#define	DIGI_EPCXCON_INIT	('e'<<8) | 111	/* Commence getting EPCX
                                                   image		  */
#define	DIGI_EPCXCON_NEXT	('e'<<8) | 112	/* Get next EPCX chunk	  */
#define DIGI_GETMAJOR		('e'<<8) | 113	/* Get a bank's major number */
/*
 *  In an effort to simplify the concentrator download process,
 *  new, generic ioctls are added.  Like the previous DIGI_CXCON_INIT,
 *  EPCXCON_INIT, etc., Unused by the dgdm driver
 */
#define	DIGI_CON_INIT		('e'<<8) | 114 /* Prepare to send next conc image */
#define	DIGI_CON_NEXT		('e'<<8) | 115 /* Send next image chunk */

#define DIGI_GETPRMAJOR		('e'<<8) | 116	/* Get a transparent printer */
						/* bank's major number */



/* FEP5 Ioctls - some Unused by the dgdm driver */
#define	DIGI_GETSTAT		('d'<<8) | 244	/* get board info	*/
#define	DIGI_GETCH		('d'<<8) | 245	/* get board info       */
#define DIGI_GEDELAY		('d'<<8) | 246	/* Get edelay		*/
#define DIGI_SEDELAY		('d'<<8) | 247	/* Set edelay		*/
#define	DIGI_GETDD		('d'<<8) | 248	/* get driver info	*/
#define	DIGI_GETBD		('d'<<8) | 249	/* get board info	*/
#define	DIGI_SETDEBUG		('d'<<8) | 250	/* set driver debug level */

#define DIGI_SPOLL		('d'<<8) | 254	/* change poller rate   */




/************************************************************************
 * Values for digi_flags
 ************************************************************************/
#define	DIGI_IXON	0x0001		/* Handle IXON in the FEP   */
#define	DIGI_FAST	0x0002		/* Fast baud rates          */
#define	RTSPACE		0x0004		/* RTS input flow control   */
#define	CTSPACE		0x0008		/* CTS output flow control  */
#define	DSRPACE		0x0010		/* DSR output flow control  */
#define	DCDPACE		0x0020		/* DCD output flow control  */
#define	DTRPACE		0x0040		/* DTR input flow control   */
#define DIGI_COOK	0x0080		/* Cooked processing in FEP */
#define	DIGI_FORCEDCD	0x0100		/* Force carrier            */
#define	DIGI_ALTPIN	0x0200		/* Alternate RJ-45 pin config*/
#define	DIGI_AIXON	0x0400		/* Aux flow control in fep  */

/* These are extended definitions - Not every digi product uses these */

#define	DIGI_PRINTER	0x0800		/* Hold port open for flowcntrl */
#define DIGI_PP_INPUT	0x1000		/* Change parallel port to input */
#define	DIGI_422	0x4000		/* for 422/232 selectable panel */



#define	DIGI_PLEN		28		/* String length	*/
#define	DIGI_TSIZ		10		/* Terminal string len	*/


/************************************************************************
 * Values for digiDload
 ************************************************************************/
#define NORMAL  0
#define PCI_CTL 1
 
#define SIZE8  0
#define SIZE16 1
#define SIZE32 2


/************************************************************************
 * Structure used with ioctl commands for DIGI parameters.
 ************************************************************************/
typedef struct digi_struct {
	unsigned short		digi_flags;	/* Flags (see above)    */
        unsigned short		digi_maxcps;	/* Max printer CPS	*/
        unsigned short		digi_maxchar;	/* Max chars in print queue */
        unsigned short		digi_bufsize;	/* Buffer size		*/
        unsigned char		digi_onlen;	/* Length of ON string	*/
        unsigned char		digi_offlen;	/* Length of OFF string	*/
        char		digi_onstr[DIGI_PLEN];	/* Printer on string	*/
        char		digi_offstr[DIGI_PLEN];	/* Printer off string	*/
        char		digi_term[DIGI_TSIZ];	/* terminal string	*/
} digi_t;
 
typedef struct  digiflow_struct {
	unsigned char	startc;		/* flow cntl start char */
	unsigned char	stopc;		/* flow cntl stop char  */
} digiflow_t;



/************************************************************************
 * KME definitions and structures.
 ************************************************************************/
#define RW_IDLE		0	/* Operation complete			*/
#define RW_READ		1	/* Read Concentrator Memory		*/
#define RW_WRITE	2	/* Write Concentrator Memory		*/
 
typedef struct {
	unsigned char	rw_req;		/* Request type			*/
	unsigned char	rw_board;	/* Host Adapter board number	*/
	unsigned char	rw_conc;	/* Concentrator number		*/
	unsigned char	rw_reserved;	/* Reserved for expansion	*/
	unsigned long	rw_addr;	/* Address in concentrator	*/
	unsigned short	rw_size;	/* Read/write request length	*/
	unsigned char	rw_data[128];	/* Data to read/write		*/
} rw_t;


/***********************************************************************
 * Shrink Buffer and Board Information definitions and structures.
 ************************************************************************/
			/* Board type return codes */
#define	PCXI_TYPE 1     /* Board type at the designated port is a PC/Xi */
#define PCXM_TYPE 2     /* Board type at the designated port is a PC/Xm */
#define	PCXE_TYPE 3     /* Board type at the designated port is a PC/Xe */
#define	MCXI_TYPE 4     /* Board type at the designated port is a MC/Xi */
#define COMXI_TYPE 5     /* Board type at the designated port is a COM/Xi */

			 /* Non-Zero Result codes. */
#define RESULT_NOBDFND 1 /* A Digi product at that port is not config
                          * installed */ 
#define RESULT_NODESCT 2 /* A memory descriptor was not obtainable */ 
#define RESULT_NOOSSIG 3 /* FEP/OS signature was not detected on the board */
#define RESULT_TOOSML  4 /* Too small an area to shrink.  */
#define RESULT_NOCHAN  5 /* Channel structure for the board was not found */

typedef struct {
	unsigned long	shrink_buf_vaddr;	/* Virtual address of board */
	unsigned long	shrink_buf_phys;	/* Physical address of board */
	unsigned long	shrink_buf_bseg;	/* Amount of board memory */
	unsigned long	shrink_buf_hseg;	/* '186 Begining of Dual-Port*/

	unsigned long	shrink_buf_lseg;	/* '186 Begining of freed
                                                 * memory		    */ 
	unsigned long	shrink_buf_mseg;	/* Linear address from start of
						 * dual-port were freed memory
                                                 * begins, host viewpoint. */

	unsigned long	shrink_buf_bdparam;	/* Parameter for xxmemon and
                                                 * xxmemoff */

	unsigned long	shrink_buf_reserva;	/* Reserved */
	unsigned long	shrink_buf_reservb;	/* Reserved */
	unsigned long	shrink_buf_reservc;	/* Reserved */
	unsigned long	shrink_buf_reservd;	/* Reserved */

	unsigned char	shrink_buf_result;	/* Reason for call failing
						   Zero is Good return */
	unsigned char	shrink_buf_init;	/* Non-Zero if it caused an
                                                 * xxinit call. */

	unsigned char	shrink_buf_anports;	/* Number of async ports  */
	unsigned char	shrink_buf_snports; 	/* Number of sync  ports */
	unsigned char	shrink_buf_type;	/* Board type 1 = PC/Xi,
                                                 *	      2 = PC/Xm,
                                                 *	      3 = PC/Xe  
                                                 *	      4 = MC/Xi  
                                                 *	      5 = COMX/i   */
	unsigned char	shrink_buf_card;	/* Card number */
	
} shrink_buf_struct;

/************************************************************************
 * Structure to get driver status information
 ************************************************************************/
struct digi_dinfo {
	unsigned long	dinfo_nboards;		/* # boards configured	*/
	char		dinfo_reserved[12];	/* for future expansion */
	char		dinfo_version[16];	/* driver version       */
};

 
/************************************************************************
 * Structure used with ioctl commands for per-board information
 *
 * physsize and memsize differ when board has "windowed" memory
 ************************************************************************/
struct digi_info {
	unsigned long	info_bdnum;		/* Board number (0 based)  */
	unsigned long	info_ioport;		/* io port address         */
	unsigned long	info_physaddr;		/* memory address          */
	unsigned long	info_physsize;		/* Size of host mem window */
	unsigned long	info_memsize;		/* Amount of dual-port mem */
						/* on board                */
	unsigned short	info_bdtype;		/* Board type              */
	unsigned short	info_nports;		/* number of ports         */
	char		info_bdstate;		/* board state             */
	char		info_reserved[5];	/* for future expansion    */

	/* Compatibility stuff */
         unsigned short firstchan;		/* First channel offset    */
};

 
struct digi_stat {
	unsigned int	info_chan;		/* Channel number (0 based)  */
	unsigned int	info_brd;		/* Board number (0 based)  */
	unsigned long	info_cflag;		/* cflag for channel       */
	unsigned long	info_iflag;		/* iflag for channel       */
	unsigned long	info_oflag;		/* oflag for channel       */
	unsigned long	info_mstat;		/* mstat for channel       */
	unsigned long	info_tx_data;		/* tx_data for channel       */
	unsigned long	info_rx_data;		/* rx_data for channel       */
	unsigned long	info_hflow;		/* hflow for channel       */
	unsigned long	info_reserved[8];	/* for future expansion    */
};

/************************************************************************
 *
 * Structure used with ioctl commands for per-channel information
 *
 ************************************************************************/
struct digi_ch {
	unsigned long	info_bdnum;		/* Board number (0 based)  */
	unsigned long	info_channel;		/* Channel index number    */
	unsigned long	info_ch_cflag;		/* Channel cflag   	   */
	unsigned long	info_ch_iflag;		/* Channel iflag   	   */
	unsigned long	info_ch_oflag;		/* Channel oflag   	   */
	unsigned long	info_chsize;		/* Channel structure size  */
	unsigned long	info_sleep_stat;	/* sleep status		   */
	dev_t		info_dev;		/* device number	   */
	unsigned char	info_initstate;		/* Channel init state	   */
	unsigned char	info_running;		/* Channel running state   */
	long		reserved[8];		/* reserved for future use */
};

/*
* This structure is used with the DIGI_FEPCMD ioctl to 
* tell the driver which port to send the command for.
*/
struct digi_cmd {
	int	cmd;
	int	word;
	int	ncmds;
	int	chan; /* channel index (zero based) */
	int	bdid; /* board index (zero based) */
};

/*
*  info_sleep_stat defines
*/
#define INFO_RUNWAIT	0x0001
#define INFO_WOPEN	0x0002
#define INFO_TTIOW	0x0004
#define INFO_CH_RWAIT	0x0008
#define INFO_CH_WEMPTY	0x0010
#define INFO_CH_WLOW	0x0020
#define INFO_XXBUF_BUSY 0x0040


/* Board type definitions */

#define	SUBTYPE		0007
#define	T_PCXI		0000
#define T_PCXEM		0001
#define T_PCXM		T_PCXEM
#define T_PCXE		0002
#define T_PCXR		0003
#define T_SP		0004
#define T_SP_PLUS	0005
#	define T_HERC	0000
#	define T_HOU	0001
#	define T_LON	0002
#	define T_CHA	0003
#define FAMILY		0070
#define T_COMXI		0000
#define T_PCXX		0010
#define T_CX		0020
#define T_EPC		0030
#define	T_PCLITE	0040
#define	T_SPXX		0050
#define	T_AVXX		0060
#define T_DXB		0070
#define T_A2K_4_8	0070
#define BUSTYPE		0700
#define T_ISABUS	0000
#define T_MCBUS		0100
#define	T_EISABUS	0200
#define	T_PCIBUS	0400

/* Board State Definitions */

#define	BD_RUNNING	0x0
#define	BD_REASON	0x7f
#define	BD_NOTFOUND	0x1
#define	BD_NOIOPORT	0x2
#define	BD_NOMEM	0x3
#define	BD_NOBIOS	0x4
#define	BD_NOFEP	0x5
#define	BD_FAILED	0x6
#define BD_ALLOCATED	0x7
#define BD_TRIBOOT	0x8
#define	BD_BADKME	0x80


#endif
