
/*
 Copyright 1999-2000 by Digi International (www.digi.com)

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2, or (at your option)
 any later version.
 
 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY, EXPRESS OR IMPLIED; without even the 
 implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
 PURPOSE.  See the GNU General Public License for more details.
 
 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

/*
 * pci_ids.h
 *
 */
/*
 *	$Id: pci_ids.h,v 1.1 2003/06/25 23:05:57 scottk Exp $
 *
 *	This file defines the PCI Ids for Houston, London and
 *	Chaska for both Digi Channel and OEM IBM boards. 
 *
 *	Abbreviated terminology used in this file:
 *		VID	= Vendor ID
 *		SVID	= Subsystem Vendor ID
 *		DID	= Device ID
 *		SSID	= Subsystem ID
 *		BCID	= Base Class
 *		SCID	= Sub Class
 */
#ifndef _PCIIDS_H
#define	_PCIIDS_H

/*********************************************
 *
 * DIGI Channel IDs follow...
 *
 *********************************************/
#define DIGI_VID			0x114f
#define DIGI_SVID			0x114f
#define DIGI_BCID			0x02
#define DIGI_SCID			0x80

/* PCI Houston */
#define DIGI_PCIHOUSTON_DID		0x001d
#define DIGI_PCIHOUSTON24_SSID		0x0052
#define DIGI_PCIHOUSTON30_SSID		0x0050
#define DIGI_PCIHOUSTON48_SSID		0x0053
#define DIGI_PCIHOUSTON60_SSID		0x0051

/* CompactPCI Houston */
#define DIGI_CPCIHOUSTON_DID		0x0035
#define DIGI_CPCIHOUSTON24_SSID		0x0056
#define DIGI_CPCIHOUSTON30_SSID		0x0054
#define DIGI_CPCIHOUSTON48_SSID		0x0057
#define DIGI_CPCIHOUSTON60_SSID		0x0055

/* London */
#define	DIGI_LONDON_DID			0x0024
#define DIGI_LONDONU_SSID		0x0030
#define DIGI_LONDONST_SSID		0x0031

/* Chaska */
#define DIGI_CHASKA_DID			0x0023
    /* 8 port */
#define DIGI_CHASKA80_SSID		0x0060 
#define DIGI_CHASKA81_SSID		0x0062
#define DIGI_CHASKA82_SSID		0x0064
#define DIGI_CHASKA83_SSID		0x0066
#define DIGI_CHASKA84_SSID		0x0068
#define DIGI_CHASKA85_SSID		0x006a
    /* 4 port */
#define DIGI_CHASKA40_SSID		0x0061
#define DIGI_CHASKA41_SSID		0x0063
#define DIGI_CHASKA42_SSID		0x0065
#define DIGI_CHASKA43_SSID		0x0067
#define DIGI_CHASKA44_SSID		0x0069
#define DIGI_CHASKA45_SSID		0x006b

/*********************************************
 *
 * PATTON Channel IDs follow...
 *
 *********************************************/
#define PATTON_VID			0x17D1
#define PATTON_SVID			0x17D1
#define PATTON_BCID			0x02
#define PATTON_SCID			0x80

/* PCI Houston */
#define PATTON_PCIHOUSTON_DID		0x001d
#define PATTON_PCIHOUSTON24_SSID		0x0052
#define PATTON_PCIHOUSTON30_SSID		0x0050
#define PATTON_PCIHOUSTON48_SSID		0x0053
#define PATTON_PCIHOUSTON60_SSID		0x0051

/* CompactPCI Houston */
#define PATTON_CPCIHOUSTON_DID		0x0035
#define PATTON_CPCIHOUSTON24_SSID		0x0056
#define PATTON_CPCIHOUSTON30_SSID		0x0054
#define PATTON_CPCIHOUSTON48_SSID		0x0057
#define PATTON_CPCIHOUSTON60_SSID		0x0055

/* London */
#define	PATTON_LONDON_DID			0x0024
#define PATTON_LONDONU_SSID		0x0030
#define PATTON_LONDONST_SSID		0x0031

/*********************************************
 *
 * IBM IDs follow...
 *
 *********************************************/
#define IBM_VID				0x1014
#define IBM_SVID			0x1014
#define IBM_BCID			0x02
#define IBM_SCID			0x80

/* PCI Houston */
#define IBM_PCIHOUSTON_DID		0x00c1
#define IBM_PCIHOUSTON24_SSID		0x00c2
#define IBM_PCIHOUSTON30_SSID		0x00f3
#define IBM_PCIHOUSTON48_SSID		0x00f4
#define IBM_PCIHOUSTON60_SSID		0x00f5

/* London */
#define	IBM_LONDON_DID			0x00bf
#define IBM_LONDONU_SSID		0x00f1
#define IBM_LONDONST_SSID		0x00c0

/* Chaska */
#define IBM_CHASKA_DID			0x00c3

    /* 8 port */
#define IBM_CHASKA80_SSID		0x00c4 
#define IBM_CHASKA81_SSID		0x0127
#define IBM_CHASKA82_SSID		0x0129
#define IBM_CHASKA83_SSID		0x012b
#define IBM_CHASKA84_SSID		0x012d
#define IBM_CHASKA85_SSID		0x012f
    /* 4 port */
#define IBM_CHASKA40_SSID		0x00f2
#define IBM_CHASKA41_SSID		0x0126
#define IBM_CHASKA42_SSID		0x0128
#define IBM_CHASKA43_SSID		0x012a
#define IBM_CHASKA44_SSID		0x012c
#define IBM_CHASKA45_SSID		0x012e

/* AccelePort2000 */
#define DIGI_AP2K_DID			0x0040

#define DIGI_AP2K2_SSID			0x0042
#define DIGI_AP2K4_SSID			0x0043
#define DIGI_AP2K8_SSID			0x0044
#define DIGI_AP2K16_SSID		0x0045
#define DIGI_AP2K32_SSID		0x004e

#define DIGI_AP2K4_MPI_SSID		0x004b
#define DIGI_AP2K8_MPI_SSID		0x004c
#define DIGI_AP2K16_MPI_SSID		0x004d

/*********************************************
 *
 * A translation from Digi Official Names to
 * Digi Internal Project Names follows... 
 *
 *********************************************/

#define DataFireRAS_P_DID		DIGI_PCIHOUSTON_DID
#define DataFireRAS_PT1_SSID		DIGI_PCIHOUSTON24_SSID
#define DataFireRAS_PT2_SSID		DIGI_PCIHOUSTON48_SSID
#define DataFireRAS_PE1_SSID		DIGI_PCIHOUSTON30_SSID
#define DataFireRAS_PE2_SSID		DIGI_PCIHOUSTON60_SSID

#define DataFireRAS_Pcpci_DID		DIGI_CPCIHOUSTON_DID
#define DataFireRAS_PT1cpci_SSID		DIGI_CPCIHOUSTON24_SSID
#define DataFireRAS_PT2cpci_SSID		DIGI_CPCIHOUSTON48_SSID
#define DataFireRAS_PE1cpci_SSID		DIGI_CPCIHOUSTON30_SSID
#define DataFireRAS_PE2cpci_SSID		DIGI_CPCIHOUSTON60_SSID

#define DataFireRAS_B4_DID		DIGI_LONDON_DID
#define DataFireRAS_B4U_SSID		DIGI_LONDONU_SSID
#define DataFireRAS_B4ST_SSID		DIGI_LONDONST_SSID

#define AccelePortRAS_A_DID		DIGI_CHASKA_DID
#define AccelePortRAS_A40_SSID		DIGI_CHASKA40_SSID
#define AccelePortRAS_A41_SSID		DIGI_CHASKA41_SSID
#define AccelePortRAS_A42_SSID		DIGI_CHASKA42_SSID
#define AccelePortRAS_A43_SSID		DIGI_CHASKA43_SSID
#define AccelePortRAS_A44_SSID		DIGI_CHASKA44_SSID
#define AccelePortRAS_A45_SSID		DIGI_CHASKA45_SSID
#define AccelePortRAS_A80_SSID		DIGI_CHASKA80_SSID
#define AccelePortRAS_A81_SSID		DIGI_CHASKA81_SSID
#define AccelePortRAS_A82_SSID		DIGI_CHASKA82_SSID
#define AccelePortRAS_A83_SSID		DIGI_CHASKA83_SSID
#define AccelePortRAS_A84_SSID		DIGI_CHASKA84_SSID
#define AccelePortRAS_A85_SSID		DIGI_CHASKA85_SSID

/*********************************************************/
/*                                                       */
/* Official DIGI Product Names.                          */
/*                                                       */
/*********************************************************/

#define DIGI_PCIHOUSTON_FAMILY_NAME       "DataFire RAS PTE"
#define DIGI_PCIHOUSTON24_NAME            "DataFire RAS 24 PT1"
#define DIGI_PCIHOUSTON48_NAME            "DataFire RAS 48 PT2"
#define DIGI_PCIHOUSTON30_NAME	          "DataFire RAS 30 PE1"
#define DIGI_PCIHOUSTON60_NAME            "DataFire RAS 60 PE2"

#define DIGI_CPCIHOUSTON_FAMILY_NAME       "DataFire DSP PTE cPCI"
#define DIGI_CPCIHOUSTON24_NAME            "DataFire DSP 24 PT1 cPCI"
#define DIGI_CPCIHOUSTON48_NAME            "DataFire DSP 48 PT2 cPCI"
#define DIGI_CPCIHOUSTON30_NAME	          "DataFire DSP 30 PE1 cPCI"
#define DIGI_CPCIHOUSTON60_NAME            "DataFire DSP 60 PE2 cPCI"

#define DIGI_LONDON_FAMILY_NAME       "DataFire RAS B4STU"
#define DIGI_LONDONU_NAME	          "DataFire RAS B4U"
#define DIGI_LONDONST_NAME	          "DataFire RAS B4ST"

#define DIGI_CHASKA_FAMILY_NAME       "AccelePort RAS"
#define DIGI_CHASKA40_NAME	          "AccelePort RAS 4"
#define DIGI_CHASKA41_NAME	          "AccelePort RAS 4"
#define DIGI_CHASKA42_NAME	          "AccelePort RAS 4"
#define DIGI_CHASKA43_NAME	          "AccelePort RAS 4"
#define DIGI_CHASKA44_NAME	          "AccelePort RAS 4"
#define DIGI_CHASKA45_NAME                "AccelePort RAS 4"	
#define DIGI_CHASKA80_NAME	          "AccelePort RAS 8"
#define DIGI_CHASKA81_NAME	          "AccelePort RAS 8"
#define DIGI_CHASKA82_NAME	          "AccelePort RAS 8"
#define DIGI_CHASKA83_NAME	          "AccelePort RAS 8"
#define DIGI_CHASKA84_NAME	          "AccelePort RAS 8"
#define DIGI_CHASKA85_NAME	          "AccelePort RAS 8"

/*
 *  The following are the names for the existing AccelePort Xp
 *  products.  Names have also been `reserved' for some of those
 *  products which are planned (of course replace the X with
 *  port count):
 *
 *     232, compact PCI:   AccelePort Xp cPCI
 *     multi, PCI:         AccelePort Xp MEI 
 *     multi, compact PCI: AccelePort Xp cPCI MEI
 */
#define DIGI_AP2K_FAMILY_NAME       "AccelePort Xp"
#define DIGI_AP2K_NAME			  "AccelePort 2p PCI"
#define DIGI_AP4K_NAME			  "AccelePort 4p PCI"
#define DIGI_AP8K_NAME			  "AccelePort 8p PCI"
#define DIGI_AP16K_NAME			  "AccelePort 16p PCI"
#define DIGI_AP32K_NAME			"Acceleport 32p PCI"

#define DIGI_AP4K_MPI_NAME		"Acceleport 4p MEI"
#define DIGI_AP8K_MPI_NAME		"Acceleport 8p MEI"
#define DIGI_AP16K_MPI_NAME		"Acceleport 16p MEI"

/*********************************************************/
/*                                                       */
/* Board adapter type values.                            */
/*                                                       */
/*********************************************************/

/* the new codes */
#define ADAPTER_HOUXX			0x50
#define ADAPTER_HOUXXD			0x51
#define ADAPTER_HOU30			0x50
#define ADAPTER_HOU60			0x51
#define ADAPTER_HOU24			0x52
#define ADAPTER_HOU48			0x53

#define ADAPTER_HOUXXcpci		0x80
#define ADAPTER_HOUXXDcpci		0x81
#define ADAPTER_HOU30cpci		0x84
#define ADAPTER_HOU60cpci		0x85
#define ADAPTER_HOU24cpci		0x86
#define ADAPTER_HOU48cpci		0x87

#define ADAPTER_HOU2			0x5c
#define ADAPTER_DAUGHTER		0x5d

#define ADAPTER_CHASKA8			0x60
#define ADAPTER_CHASKA4			0x61

/* the new codes */
#define ADAPTER_CHASKA8X		0x60
#define ADAPTER_CHASKA80		0x60
#define ADAPTER_CHASKA81		0x62
#define ADAPTER_CHASKA82		0x64
#define ADAPTER_CHASKA83		0x66
#define ADAPTER_CHASKA84		0x68
#define ADAPTER_CHASKA85		0x6a

#define ADAPTER_CHASKA4X		0x61
#define ADAPTER_CHASKA40		0x61
#define ADAPTER_CHASKA41		0x63
#define ADAPTER_CHASKA42		0x65
#define ADAPTER_CHASKA43		0x67
#define ADAPTER_CHASKA44		0x69
#define ADAPTER_CHASKA45		0x6b

#define ADAPTER_LON_U			0x70
#define ADAPTER_LON_ST			0x71

/* the new codes */
#define ADAPTER_LONXX			0x70
#define ADAPTER_LONU			0x70
#define ADAPTER_LONST			0x71

/* Some more new codes - for AP2K */
#define ADAPTER_AP2K2			0x181
#define ADAPTER_AP2K4			0x182
#define ADAPTER_AP2K8			0x183
#define ADAPTER_AP2K16			0x184
#define ADAPTER_AP2K32			0x188

#define ADAPTER_AP2K4_MPI		0x185
#define ADAPTER_AP2K8_MPI		0x186
#define ADAPTER_AP2K16_MPI		0x187

#endif
