/* ex:set ts=8 sw=4 */
/*
 Copyright 1999 by Digi International (www.digi.com)

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2, or (at your option)
 any later version.
 
 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY, EXPRESS OR IMPLIED; without even the 
 implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
 PURPOSE.  See the GNU General Public License for more details.
 
 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

/******************************************************************************
 * $Header: /cvs_tick/linux_dgap/include/dxb/include/mgmttigger.h,v 1.1 2003/06/25 23:05:57 scottk Exp $
 */

#ifndef _MGMTTIGGER_H_

#define _MGMTTIGGER_H_

#include "mgmtcmds.h"
#include "mgmtdflt.h"

/*
 * ADAPTER EXT STATE structure
 */
#ifndef MPENV
#define NPROC	4
#else
#define NPROC	MPENV
#endif

#define I_WANT_TO_KNOW_MORE	1
#undef I_WANT_TO_KNOW_MORE /* Define it if you do want to know more.
			    * undefing it to get swig to work. */

typedef struct
{
    dxb_uint32	ext_cpu_usage[NPROC - 1];
    dxb_uint32	padd[(NPROC - 1) * 7];
} adapter_ext_state_t;

#ifndef SWIG
#ifndef NO_MGMT_RR_TYPES
typedef adapter_ext_state_t	get_adapter_ext_state_t;
#endif
#endif

typedef struct
{
    dxb_uint32	rtc_hz;
    dxb_uint32	brg_hz;
    dxb_uint32	sys_clk;
    dxb_uint32	connector_count;
    dxb_uint32	pad[8];		/* for expansion */
} adapter_ext_info_t;

#ifndef SWIG
#ifndef NO_MGMT_RR_TYPES
typedef adapter_ext_info_t	get_adapter_ext_info_t;
#endif
#endif

/*
 * This is meant to be a copy of those settings that
 * are to be used while in test mode.
 */
typedef struct
{
    dxb_uint32	host_intr_period;

    dxb_uint32	rxb_count;
    dxb_uint32	rx_hiwat;
    dxb_uint32	rx_bmd_hiwat;
    dxb_uint32	rx_lowat;
    dxb_uint32	rx_bmd_lowat;

    dxb_uint32	ocol;
    dxb_uint32	breaktime;
    dxb_uint32	rxlnext;
    dxb_uint32	rmax;
    dxb_uint32	rtime;
    dxb_uint32	icdtime;
    dxb_uint32	rlast;		/* t.tics */
    dxb_uint32	icdlast;	/* t.tics */
    dxb_uint32	tmax;
    dxb_uint32	ttime;
    dxb_uint32	tpos;
    dxb_uint32	tlast;		/* t.tics */
    dxb_uint32	txseqin;
    dxb_uint32	rxseq;
    dxb_uint32	txseq;

    dxb_uint32	txaccm;
    dxb_uint32	rxaccm;
    dxb_uint16	ofcs;
    dxb_uint16	ifcs;
    dxb_uint32	maxlen;
    dxb_uint32	speed;

    dxb_uint16	cflags;
    dxb_uint16	iflags;
    dxb_uint16	oflags;
    dxb_uint16	xflags;
    dxb_uint16	fflags;
    dxb_uint16	hiprimesg;

    dxb_uint32	llast;
    dxb_uint16	ltime;

    dxb_uint8	mout;
    dxb_uint8	mflow;
    dxb_uint8	mctrl;
    dxb_uint8	mstat;
    dxb_uint8	mlast;
    dxb_uint8	mtran;
    dxb_uint8	mint;

    dxb_uint16	xon;
    dxb_uint16	xoff;
    dxb_uint16	xxon;
    dxb_uint16	xxoff;
    dxb_uint16	lnext;
    dxb_uint16	spcr;
    dxb_uint16	mspesc;
    dxb_uint16	idel;
    dxb_uint16	ffscan;
    dxb_uint16	msbr;
    dxb_uint16	mser;
    dxb_uint16	ichar;

    dxb_uint16	estat;
    dxb_uint16	elast;
    dxb_uint16	etran;
    dxb_uint16	eint;

    dxb_uint8	rplyin;
    dxb_uint8	rplyout;

    dxb_uint16	hpasync;
    dxb_uint16	lpasync;

#if defined(I_WANT_TO_KNOW_MORE)
    dxb_uint32	swc_regs;
    dxb_uint32	tx_int_status;
    dxb_uint32	rx_int_status;
    dxb_uint32	tx_bmdp;
    dxb_uint32	rx_bmdp;
#endif
} serial_dxb_config_t;

/*****************************************************************************
 * Per connector information.
 */

#   define UNKNOWN	0
#   define AGGREGATE	1	/* what's this - if it is not one of the */
				/* following and it is not UNKNOWN ??? */
#   define PORT		2
#   define SLINK_M	3	/* sync link master */
#   define SLINK_S	4	/* sync link slave */
#   define EXP_M	5	/* expansion master */
#   define EXP_S	5	/* expansion slave */

#   define HD_68	1
#   define RJ_11	2
#   define DB_09	3
#   define DB_25	4
#   define DB_78	5
#   define RJ_45	6

#   define ASYNC	1
#   define SYNCRONOUS	2
#   define ETHER	3

#   define LABEL_LEN	15
typedef struct
{
    dxb_uint32	cls;

    dxb_uint32	type;

    dxb_uint32	protocol;

    dxb_uint32	first_chan;
    dxb_uint32	chan_cnt;
    dxb_uint32	elements;

    dxb_uint8	label[LABEL_LEN + 1];
} connector_info_t;

#define CONNECTORS	32	/* If you have a better value - change it */
typedef struct
{
    connector_info_t	connectors[CONNECTORS];
} connector_location_t;

/*****************************************************************************
 * Serial Channel Modes.
 *	The means of implementing various Test modes.
 */
#   define TEST_MODE		(1 << 0)
#   define EXT_LOOP_AUTO	(1 << 1)
#   define EXT_LOOP_MANUAL	(1 << 2)
#   define ECHO_TEST		(1 << 3)
#   define REPORT_RESULTS	(1 << 4)
#   define STOP_TEST		(1 << 5)
#   define TEST_EXIT		(1 << 6)

typedef struct
{
    dxb_uint32	mode;
    dxb_uint32	fail;
    dxb_uint32	good;
} serial_channel_test_t;

typedef struct
{
    serial_ext_config_t	cf;
} serial_test_ext_config_t;

typedef struct
{
    serial_channel_test_t	tst;
    serial_dxb_config_t		cf;
} serial_test_t;

typedef struct
{
    serial_channel_test_t	test_info;
    dxb_uint32			count;
    dxb_uint8			data[128];
} serial_channel_manual_loop_t;

/* RS485/422 changes */

/* MPI Receiver and transmitter policy */
#define RS485_TXENABLE_RTS		1
#define RS485_TXENABLE_AUTO		2

#define RS485_RXENABLE_AUTO		1
#define RS485_RXENABLE_ALWAYS		2

typedef struct
{
    dxb_uint32	tx_enable;	/* TX follows RTS or automatic */
    dxb_uint32	rx_enable;	/* RX always on or off when TX */
} serial_rs485_config_t;





/*****************************************************************************
 * another set of structures derived from above.
 */

#ifndef SWIG
#ifndef NO_MGMT_RR_TYPES
/*
 * get adapter extended info payload. looks a lot like get_adapter_ext_info_t.
 */
typedef struct
{
    adapter_ext_info_t	info;
} get_adapter_ext_info_response_t;

/*
 * get adapter extended state payload.  looks a lot like get_adapter_state_t.
 */
typedef struct
{
    adapter_ext_state_t state;
} get_adapter_ext_state_response_t;

typedef struct
{
    dxb_uint32		channel;
} get_serial_dxb_config_request_t;

typedef struct
{
    serial_dxb_config_t	config;
} get_serial_dxb_config_response_t;

typedef struct
{
    serial_config_t	cf;
} get_serial_test_config_t;

typedef struct
{
    serial_status_t	st;
} get_serial_test_status_t;

typedef struct
{
    serial_ext_config_t	cf;
} get_serial_test_ext_config_t;

typedef struct
{
    serial_config_t	cf;
} get_default_serial_config_t;

typedef struct
{
    serial_status_t	st;
} get_default_serial_status_t;

typedef struct
{
    serial_dxb_config_t	cf;
} get_default_serial_dxb_config_t;

typedef struct
{
    dxb_uint32		channel;
} get_serial_channel_test_mode_request_t;

typedef struct
{
    serial_channel_test_t	mode;
} get_serial_channel_test_mode_response_t;

typedef struct
{
    dxb_uint32			channel;
    serial_channel_test_t	mode;
} set_serial_channel_test_mode_request_t;

typedef struct
{
    dxb_uint32			channel;
    serial_channel_manual_loop_t mode;
} set_serial_channel_manual_loop_request_t;

typedef struct
{
    dxb_uint32		channel;
} get_serial_test_config_request_t;

typedef struct
{
    serial_config_t	cf;
} get_serial_test_config_response_t;

typedef struct
{
    dxb_uint32		channel;
    serial_config_t	cf;
} set_serial_test_config_request_t;

typedef struct
{
    dxb_uint32		channel;
} get_serial_test_status_request_t;

typedef struct
{
    serial_status_t	st;
} get_serial_test_status_response_t;

typedef struct
{
    dxb_uint32		channel;
    serial_status_t	st;
} set_serial_test_status_request_t;

typedef struct
{
    dxb_uint32		channel;
    serial_ext_config_t	cf;
} set_serial_test_ext_config_request_t;

typedef struct
{
    dxb_uint32		channel;
} get_serial_dxb_default_config_request_t;

typedef struct
{
    serial_dxb_config_t	cf;
} get_serial_dxb_default_config_response_t;

typedef struct
{
    dxb_uint32		channel;
} get_serial_rs485_config_request_t;

typedef struct
{
    serial_rs485_config_t config;
} get_serial_rs485_config_response_t;

typedef struct
{
    dxb_uint32		channel;
    serial_rs485_config_t config;
} set_serial_rs485_config_request_t;


#endif
#endif

#endif

