
/*
 Copyright 1999 by Digi International (www.digi.com)

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2, or (at your option)
 any later version.
 
 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY, EXPRESS OR IMPLIED; without even the 
 implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
 PURPOSE.  See the GNU General Public License for more details.
 
 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

/*
 *	mgmtioc1.h
 *
 *	These data structures are the applications level API for
 *	issuing ioctl's to the dense modem family of products on
 *	operating systems, such as Unix and Linux, which use the
 *	traditional single in/out pointer ioctl() system call interface.
 *
 *	Typical use:
 *		#include <digi/dm_types.h>
 *		#include <digi/mgmtioc1.h>
 *
 *		setget_modem_config_t	modem;
 *
 *		modem.port = 1;
 *		modem.channel = 2;
 *
 *		ioctl(fd, GET_MODEM_CONFIG, &config);
 *
 *		modem.config.answer_rings = 666;
 *
 *		ioctl(fd, SET_MODEM_CONFIG, &set);
 *
 *
 *	N.B. These types also match the payload data of the DXB
 *	messages, and most likely are being used by device driver(s)
 *	to construct said messages.  So don't for a minute think
 *	this API can be willy-nilly changed.
 *
 *	FIXME: Add the comments for each structure (steal from *hlc.h)
 *
 *	$Id: mgmtioc1.h,v 1.1 2003/06/25 23:05:56 scottk Exp $
 */
#ifndef _MGMTIOC1_H_INCLUDED
#define _MGMTIOC1_H_INCLUDED

/*
 *	We don't need or want any of old management request/response types
 *	from mgmthlc.h.
 */
#define	NO_MGMT_RR_TYPES

#include "mgmthlc.h"
#include "mgmttigger.h"
#include "mgmtinternal.h"

/************************************************************************/
/*									*/
/*	Adapter level ioctl's.						*/
/*									*/
/************************************************************************/

typedef struct
{
	mgmt_protocol_version_t	version;
} get_mgmt_protocol_version_t;

typedef struct
{
	adapter_info_t		info ;
} get_adapter_info_t;

typedef struct
{
	adapter_ext_info_t	info;
} get_adapter_ext_info_t;

typedef struct
{
	adapter_state_t		state ;
} get_adapter_state_t;

typedef struct
{
	adapter_ext_state_t	state ;
} get_adapter_ext_state_t;

typedef struct
{
	modem_nationality_t	nation;
} getset_modem_nationality_t;


typedef dxb_uint32 nvram_config_t;

typedef struct {
	nvram_config_t		config;
} getset_nvram_config_t;


/************************************************************************/
/*									*/
/*	Port level ioctl's.						*/
/*									*/
/************************************************************************/

typedef struct
{
	dxb_uint32		port ;
	ds1_config_t		config;
} getset_ds1_config_t, getset_ds1_config_trc_t ;

typedef struct
{
	dxb_uint32		port ;
	ds1_status_t		status;
} get_ds1_status_t, getset_ds1_status_trc_t ;

typedef struct
{
	dxb_uint32		port ;
	ds1_ext_config_t	config;
} getset_ds1_ext_config_t, getset_ds1_ext_config_trc_t ;

typedef struct
{
	dxb_uint32		port ;
	ds1_ext_status_t	status;
} get_ds1_ext_status_t, getset_ds1_ext_status_trc_t ;

typedef struct
{
	dxb_uint32		port ;
	ds1_all_ct1_sig_status_t	status;
} get_ds1_all_ct1_sig_status_t ;

typedef struct
{
	dxb_uint32		port ;
	ds1_e1r2_config_t	config;
} getset_ds1_e1r2_config_t, getset_ds1_e1r2_config_trc_t ;

typedef struct
{
	dxb_uint32		port ;
	bri_config_t		config;
} getset_bri_config_t, getset_bri_config_trc_t ;

typedef struct
{
	dxb_uint32		port ;
	bri_status_t		status;
} get_bri_status_t, getset_bri_status_trc_t ;

typedef	struct
{
	dxb_uint32		count ;
	call_status_t		status[30];
} all_call_status_t;

typedef struct
{
	dxb_uint32		port ;
	all_call_status_t	status;
} get_all_call_status_t ;

typedef struct
{
	dxb_uint32		port ;
	dchan_ext_config_t	config;
} getset_dchan_ext_config_t, getset_dchan_ext_config_trc_t ;

typedef struct
{
	dxb_uint32		port ;
	dchan_config_t		config;
} getset_dchan_config_t ;


typedef struct {
	dxb_uint32		port;       /* Port */
	bri_config_t		b_config;   /* Same as SET_BRI_CONFIG */
	dchan_ext_config_t	d_config;   /* Same as SET_DCHAN_EXT_CONFIG */
	dxb_uint32		replumb;    /* 1-NO, 2-YES */
	dxb_uint32		reserved1;  /* Rsvd for future use */
	dxb_uint32		reserved2;  /* Rsvd for future use */
	dxb_uint32		reserved3;  /* Rsvd for future use */
	dxb_uint32		reserved4;  /* Rsvd for future use */
} getset_bri_and_dchan_ext_config_t, set_bri_and_dchan_ext_config_t;


typedef struct
{
	dxb_uint32		port ;
	dchan_ext_status_t	status;
} get_dchan_ext_status_t, getset_dchan_ext_status_trc_t ;

typedef struct
{
	dxb_uint32		port;
	dxb_uint32		trace_on;
} getset_port_data_trc_t ;

/************************************************************************/
/*									*/
/*	Channel level ioctl's.						*/
/*									*/
/************************************************************************/

typedef struct
{
	dxb_uint32		channel ;
	serial_config_t		config;
} getset_serial_config_t, getset_serial_config_trc_t ;

typedef struct
{
	dxb_uint32		channel ;
	serial_rs485_config_t	config ;
} getset_serial_rs485_config_t;

typedef struct
{
	dxb_uint32		channel ;
	serial_status_t		status;
} get_serial_status_t, getset_serial_status_trc_t ;

typedef struct
{
	dxb_uint32		channel ;
	serial_ext_config_t	config;
} getset_serial_ext_config_t, getset_serial_ext_config_trc_t ;

typedef struct
{
	dxb_uint32		channel ;
	serial_ext_status_t	status;
} get_serial_ext_status_t, getset_serial_ext_status_trc_t ;

typedef struct
{
	dxb_uint32		channel;
	serial_dxb_config_t	config;
} get_serial_dxb_config_t;

typedef struct
{
	dxb_uint32		channel;
	serial_channel_test_t	mode;
} getset_serial_channel_test_t;

typedef struct
{
    dxb_uint32				channel;
    serial_channel_manual_loop_t	mode;
} set_serial_channel_manual_loop_t;

#ifndef SWIG
/*
 *	You can't do this and expect SWIG to work properly.  -Rick
 */
#define serial_test_status_t	serial_status_t
#endif

typedef struct
{
    dxb_uint32		channel;
    serial_status_t	status;
} getset_serial_test_status_t;

#ifndef SWIG
/*
 *	You can't do this and expect SWIG to work properly.  -Rick
 */
#define serial_test_config_t	serial_config_t
#endif

typedef struct
{
    dxb_uint32		channel;
    serial_config_t	config;
} getset_serial_test_config_t;

typedef struct
{
	dxb_uint32		channel ;
	modem_config_t		config;
} getset_modem_config_t, getset_modem_config_trc_t ;

typedef struct
{
	dxb_uint32		channel ;
	modem_status_t		status;
} get_modem_status_t, getset_modem_status_trc_t ;

typedef struct
{
	dxb_uint32		channel ;
	modem_ext_config_t	config;
} getset_modem_ext_config_t, getset_modem_ext_config_trc_t ;

typedef struct
{
	dxb_uint32		channel ;
	modem_ext_status_t	status;
} get_modem_ext_status_t, getset_modem_ext_status_trc_t ;

typedef struct
{
	dxb_uint32		channel ;
	bchan_status_t		status;
} get_bchan_status_t, getset_bchan_status_trc_t ;

typedef struct
{
	dxb_uint32		channel ;
	bchan_ext_config_t	config;
} getset_bchan_ext_config_t, getset_bchan_ext_config_trc_t ;

typedef struct
{
	dxb_uint32		channel ;
	bchan_ext_status_t	status;
} get_bchan_ext_status_t, getset_bchan_ext_status_trc_t ;

typedef struct
{
	dxb_uint32		channel ;
	dxb_uint32		trace_on;
} getset_channel_data_trc_t, set_channel_data_trc_t ;

typedef struct
{
	dxb_uint32		channel_select;
	dxb_uint32		event_mask;
	dxb_uint32		trace;
	dxb_uint32		mask_action;
	dxb_uint32		reserved1;
	dxb_uint32		reserved2;
} set_blackbox_data_trc_t;


typedef struct
{
	daughter_serialid_t	serialnum;
} getset_daughter_serialid_t;


/************************************************************************/
/*									*/
/*	Channel and port level ioctl's.					*/
/*									*/
/************************************************************************/

typedef struct
{
	dxb_uint32		port ;
	dxb_uint32		channel ;
	ds1_ct1_sig_status_t	status;
} get_ds1_ct1_sig_status_t ;

typedef struct
{
	dxb_uint32		port ;
	dxb_uint32		channel ;
	call_status_t		status;
} get_call_status_t, getset_call_status_trc_t ;

typedef getset_channel_data_trc_t channel_data_trc_t;

/*
 *	These are obsolete as of 01/11/00.
 *	If you are in here in, say, a month, delete this section.
 */
typedef call_status_t call_status_trc_t;
/*typedef get_call_status_t getset_call_status_trc_t ; */

typedef ds1_config_t ds1_config_trc_t;
/*typedef get_ds1_status_t ds1_status_trc_t; */

typedef get_ds1_ext_status_t ds1_ext_status_trc_t;
/*typedef get_ds1_status_t getset_ds1_status_trc_t; */

/*typedef get_ds1_ext_status_t getset_ds1_ext_status_trc_t; */
/*typedef getset_ds1_config_t getset_ds1_config_trc_t ; */

typedef get_dchan_ext_status_t set_dchan_ext_status_trc_t;

#endif
