
/*
 Copyright 1999-2000 by Digi International (www.digi.com)

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2, or (at your option)
 any later version.
 
 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY, EXPRESS OR IMPLIED; without even the 
 implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
 PURPOSE.  See the GNU General Public License for more details.
 
 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

/*
 * mgmthlc.h
 *
 *
 * $Id: mgmthlc.h,v 1.1 2003/06/25 23:05:55 scottk Exp $
 *
 */
#ifndef MGMTHLC_H_DEFINED

#define MGMT_PROTOCOL_VERSION_VALUE 0x3

#include "mgmtcmds.h"
#include "mgmtdflt.h"
#include "pci_ids.h"

/*
 * Trace Message Data Structures and Defines
 */
#define MGMT_TRC_OFF	0x00
#define MGMT_TRC_ON	0x01
/* Data portion of received message */
#define TRC_HDR_PAYLOAD_LEN 4 
typedef struct TRACE_HEADER_TYPE
{
	dxb_uint32	data_type;  		/* i.e. DS1_CONFIG,DS1_STATUS */
	dxb_uint32	channel;		/* data_type context sensitive*/
	dxb_uint32	port;
	dxb_uint32	sequence;
	timestamp_t	time_stamp;	  	/* board or wall-time */
	dxb_uint32	length ;		/* Length (octets) of payload */
	dxb_uint32	status;			/* data_type context sensitive*/
	dxb_uint8   	payload[TRC_HDR_PAYLOAD_LEN];
} TRACE_HEADER_T, *PTRACE_HEADER_T, trace_header_t ;

/*
 * Adapter Level enums
 */
#define MGMT_NVRAM_ENABLED	1
#define MGMT_NVRAM_DISABLED	2

/*
 * MGMT Commands and associated data structures
 *
 * Commands are created from the enumerated types above.
 */

/************************************************************************/
/*									*/
/*	ADAPTER LEVEL							*/
/*									*/
/************************************************************************/

/*
 * Adapter Level Data Strucutres and Defines
 */

/*
 * ADAPTER_INFO data structure
 */

#define SN_MAX	32
#define PN_MAX	19+1

typedef struct 
{
	dxb_uint32	board_type ;
	dxb_uint32	port_count ;
	dxb_uint32	channels_per_port ;
	dxb_uint32	memory_size ;
	dxb_uint32	fep_version ;
	dxb_uint32	csc_version ;
	dxb_uint32	pump_version ;
	dxb_uint32	main_board_revision ;
	dxb_uint8	main_board_serial[SN_MAX] ;
	dxb_uint32	daughter_card_revision ;
	dxb_uint8	daughter_card_serial[SN_MAX] ;
	dxb_uint8	part_number[PN_MAX];
} adapter_info_t ;

#ifndef SWIG
#ifndef NO_MGMT_RR_TYPES
	typedef adapter_info_t	get_adapter_info_t;
#endif
#endif

/*
 * ADAPTER_STATE data structure
 */
typedef struct 
{
	dxb_uint32	memory_usage ;	/* % memory used */
	dxb_uint32	cpu_usage ;	/* % cpu used */
	dxb_uint32	dxb_h2a_count ;	/* rolling byte count */
	dxb_uint32	dxb_a2h_count ;	/* rolling byte count */
	timestamp_t	uptime ;	/* also doubles as heart beat */
} adapter_state_t ;

#ifndef SWIG
#ifndef NO_MGMT_RR_TYPES
	typedef adapter_state_t	get_adapter_state_t;
#endif
#endif

/*
 * GET_MODEM_NATIONALITY and SET_MODEM_NATIONALITY defines
 *
 * ISO 3166 Country Codes
 */
#include "mgmtcc.h"

typedef struct
{
	dxb_uint32	country_code ;
} modem_nationality_t ;

typedef struct
{
	dxb_uint32	version ;
} mgmt_protocol_version_t ;

/*
 * Additional Adapter Level Error Codes
 */
#define NAT_NOT_SUPPORTED		0x0011
#define WRONG_BOARD_TYPE		0x0012

#define	NO_CONNECTION			0x0013
#define NO_SWITCH_SUPPORT		0x0014


/************************************************************************/
/*									*/
/*	DS1 LEVEL							*/
/*									*/
/************************************************************************/

/*
 * DS1 Level Data Structures and Defines
 */
/*
 *(S|G)ET_DS1_CONFIG data structure and defines 
 */
/* framing */
#define	FRAME_ESF		1
#define	FRAME_D4		2
#define	FRAME_CEPT_CRC4		3
#define	FRAME_CEPT_WO_CRC4	4
#define	FRAME_CEPT_CRC4_PCS0	5
#define	FRAME_CEPT_WO_CRC4_PCS0	6
/* coding */
#define	LINE_CODE_B8ZS		1
#define	LINE_CODE_AMI		2
#define	LINE_CODE_HDB3		3
/* long_haul_lbo (valid only for T1) */
#define	LBO_00_0_DB		1
#define	LBO_07_5_DB		2
#define	LBO_15_0_DB		3
#define	LBO_22_5_DB		4
/* short_haul_len (valid only for T1) */
#define	SH_0_133		1
#define	SH_133_266		2
#define	SH_266_399		3
#define	SH_399_533		4
#define	SH_533_655		5
/* if_type */
#define	LONG_HAUL		1
#define	SHORT_HAUL		2
#define	LOOP_HAUL		3	/* Odd/even chan loopback for testing */
/* signaling ct1 */
#define	CT1_LOOP_START		1
#define	CT1_WINK_START		2
#define	CT1_GROUND_START	3
#define	CT1_IMMED_START		4

/* 
** signalling non-ISDN E1: 
*/
#define	E1_R2			12
#define	E1_R2_LAST           E1_R2  /* in case we put more in this range */

/* signalling pri */
#define	PRI_NONE		32
#define	PRI_NI2			33
#define	PRI_5ESS		34
#define	PRI_DMS100		35
#define	PRI_ETSI		36
#define	PRI_EURODSS1		PRI_ETSI
#define	PRI_JAPAN		37
#define	PRI_INS1500		PRI_JAPAN
#define PRI_MSA			38
#define PRI_ETSI_B              39   /* ISDN B Channel/CSC mapping set for ETSI only */ 
#define PRI_LAST                PRI_ETSI_B
/* wink digits - set to number of digits + 1 */
/* clocking */
#define	TIMING_LOOP		1
#define	TIMING_LOCAL		2
#define	TIMING_MVIP		3
#define TIMING_CHAN_MAPPING     0x8000
/* jitter attenuation */
#define	JITTER_TX		1
#define	JITTER_RX		2
#define	JITTER_AUTO		3
#define	JITTER_NONE		4
/* eq_gain_limit (valid only for T1) */
#define	EGL_LOW			1
#define	EGL_HIGH		2
/* nfas_master_port */
#define	NFAS_NONE		0
#define	NFAS_PORT0		1
#define	NFAS_PORT1		2
/* nfas_interface_id */
#define	NFAS_MODIFY_BIT		0x80000000
#define	NFAS_MODIFY_MASK	0x7FFFFFFF

/*
 * leased_mask
 *
 * Bit 0 in little Endian is the low order bit (rightmost bit) of dxb_uint32.
 *
 * T1: bits 0 through 23 are T1 channels. All other bits ignored except bit 31 
 * (the leased none bit).
 *
 * NA PRI: bits 0 through 22 are B-channels. All other bits ignored except bit 
 * 31 (the leased none bit).
 *
 * EU PRI: bits 0 through 30 (excluding bit 15) are B-channels. Bit 15 (the 
 * D-channel) and all other bits ignored except bit 31 (the leased none bit).
 */
#define DS1_LEASED_NONE	0x80000000
#define DS1_LEASED_UPDATE DS1_LEASED_NONE

/*
 * add a base directory number?
 */

typedef struct 
{
	dxb_uint32	coding ;
	dxb_uint32	framing ;
	dxb_uint32	if_type ;
	dxb_uint32	long_haul_lbo ;
	dxb_uint32	short_haul_len ;
	dxb_uint32	signalling ;
	dxb_uint32	wink_digits ;	/* Max value is 20. Set to n+1 */
	dxb_uint32	clocking ;
	dxb_uint32	jitter_atten ;
	dxb_uint32	eq_gain_limit ;
	dxb_uint32	leased_mask ;	/* ones based time slot mask; */
					/* bit 0 = slot 1 */
	/*
	 * Port to which this port is an NFAS slave.  0 implies NFAS
	 * deactivated for this port.  nfas_master_port == this port #
	 * implies that this is the primary interface (the span with the
	 * d-channel).
	 *
	 * Setting is always AND'd with NFAS_MODIFY_MASK, so set this
	 * parameter to NFAS_MODIFY_BIT if you wish to explicity change
	 * the firmware's setting to 0.
	 */
	dxb_uint32	nfas_master_port ;

	/*
	 * Interface ID to be used for this port.
	 * This value is disregarded if NFAS is not active.
	 *
	 * Setting is always AND'd with NFAS_MODIFY_MASK, so set this
	 * parameter to NFAS_MODIFY_BIT if you wish to explicity change
	 * the firmware's setting to 0.
	 */
	dxb_uint32	nfas_interface_id ;
} ds1_config_t ;

/*
 * GET_DS1_STATUS response data structure and defines
 */
/*
 * rx_special - this is a composite field, more than one of
 * the following may be true at any given time.
 */
#define	DS1_LOS				0x00001
#define	DS1_LFA				0x00002
#define	DS1_AIS				0x00004
#define	DS1_RFA				0x00008
#define DS1_LTS0MFA			0x00010
#define DS1_CREBIT			0x00020
#define DS1_FBE				0x00040
#define DS1_CRCE			0x00080
#define DS1_ECE				0x00100
#define DS1_REBIT			0x00200
#define DS1_LCRCATMX			0x00400
#define DS1_NFA				0x00800
#define DS1_SSFA			0x01000
#define DS1_BFA				0x02000
#define DS1_CMA				0x04000
#define DS1_LBFA                        0x08000
#define DS1_UNDEFINED	    		0x10000

/* alarm */
#define DS1_NO_ALARM		1
#define DS1_RED_ALARM		2
#define DS1_BLUE_ALARM		3
#define DS1_YELLOW_ALARM	4
/* loopback */
#define	DS1_NO_LOOP		1
#define	DS1_PAYLOAD_LOOP	2
#define	DS1_LINE_LOOP		3
#define	DS1_LOCAL_LOOP		4

typedef struct 
{
	dxb_uint32	rx_special ;
	dxb_uint32	alarm ;
	dxb_uint32	loopback ;
} ds1_status_t ;

/*
 * (S|G)ET_DS1_EXT_CONFIG data structure and defines
 */
/* tx_special -  "special" transmissions which override the usual signal. */
#define	DS1_TX_NORMAL		0x1	/* Restore normal operation */
#define	DS1_TX_PRSS		0x2	/* Pseudo-Random signal (2^15 -1) */
#define	DS1_TX_QRSS		0x3	/* Quasi-Random signal (ANSI QRSS) */
#define	DS1_TX_LLU		0x4	/* Framed ANSI Line Loop Up (001) */
#define	DS1_TX_LLD		0x5	/* Framed ANSI Line Loop Down (00001) */
#define	DS1_TX_FDL_LLU		0x6	/* FDL Line Loop Up (T1/ESF only) */
#define	DS1_TX_FDL_LLD		0x7	/* FDL Line Loop Down (T1/ESF only) */
#define	DS1_TX_FDL_PLU		0x8	/* FDL Payload Loop Up (T1/ESF only) */
#define	DS1_TX_FDL_PLD		0x9	/* FDL Payload Loop Down (T1/ESF only)*/
#define	DS1_TX_RFA		0xa	/* RFA - aka Yellow Alarm */
#define	DS1_TX_AIS		0xb	/* Unframed AIS */
/* auto_config */
#define DS1_AUTOCONFIG_OFF	1
#define DS1_AUTOCONFIG_ON	2

/* loopback  - uses the same fields as the ds1_status_t.loopback field. */

typedef struct 
{
	dxb_uint32	tx_special ;	/* transmit a special signal */
					/* (eg blue alarm) */
	dxb_uint32	auto_config ;
	dxb_uint32	loopback ;	/* locally commanded loopbacks. */
} ds1_ext_config_t ;

/*
 * GET_DS1_EXT_STATUS response data structure
 */
typedef struct 
{
	dxb_uint32	errored_seconds ;
	dxb_uint32	unavailable_seconds ;
	dxb_uint32	bursty_seconds ;
	dxb_uint32	severe_seconds ;
	dxb_uint32	severe_framing_seconds ;
	dxb_uint32	controlled_slip_seconds ;
	dxb_uint32	loss_of_frame_count ;
	dxb_uint32	degraded_minutes ;
	dxb_uint32	line_errored_seconds ;
	dxb_uint32	line_code_violations ;
	dxb_uint32	crc_error_count ;
} ds1_ext_status_t ;


/*
 * GET_DS1_CT1_SIG_STATUS and GET_DS1_ALL_CT1_SIG_STATUS data structure
 */
 #define CT1_SIG_MAX	24

typedef struct
{
	dxb_uint8	tx_signal_bits ;
	dxb_uint8	rx_signal_bits ;
	dxb_uint8	state ;
	dxb_uint8	pad ;
} ds1_ct1_sig_status_t ;

typedef struct
{
	ds1_ct1_sig_status_t	signal[CT1_SIG_MAX] ;
} ds1_all_ct1_sig_status_t ;

/*
 * (S|G)ET_DS1_E1R2_CONFIG data structure and defines
 */
/* bit to set an element to zero */
#define	E1R2_MODIFY_BIT		0x80000000
#define	E1R2_MODIFY_MASK	0x7FFFFFFF

/* r2_switch_type -  country or switch type defining R2 implementation */
/* ADD NEW SWITCH TYPES TO THE END OF THE LIST and update R2_LAST_SWITCH_TYPE */
#define R2_ITU                         1
#define R2_ABACUS                      2  /* default Abacus emulation */
#define R2_ARGENTINA                   3
#define R2_AUSTRALIA                   4
#define R2_BRAZIL                      5
#define R2_CHINA                       6
#define R2_COLUMBIA                    7
#define R2_COSTA_RICA                  8
#define R2_CZECH                       9
#define R2_EAST_EUROPE                10
#define R2_ECUADOR_ITU                11
#define R2_ECUADOR_LME                12
#define R2_GREECE                     13
#define R2_GUATEMALA                  14
#define R2_HONG_KONG                  15
#define R2_INDIA                      16
#define R2_INDONESIA                  17
#define R2_ISRAEL                     18
#define R2_KOREA                      19
#define R2_MALAYSIA                   20
#define R2_NEW_ZEALAND                21
#define R2_PARAGUAY                   22
#define R2_PERU                       23
#define R2_PHILLIPPINES               24
#define R2_SAUDI_ARABIA               25
#define R2_SINGAPORE                  26
#define R2_SOUTH_AFRICA_PANAFTEL      27
#define R2_MEXICO_TELMEX              28
#define R2_MEXICO_TELNOR              29
#define R2_THAILAND                   30
#define R2_URUGUAY                    31
#define R2_VENEZUELA                  32
#define R2_VIETNAM                    33
#define R2_MEXICO                     34
#define R2_LAST_SWITCH_TYPE           R2_MEXICO /* update as needed */

/* r2_cd_bits -  C and D bits to transmit */
#define E1_R2_C_BIT            0x2
#define E1_R2_D_BIT            0x1
#define E1_R2_GET_REG_DC(s) (((s&E1_R2_C_BIT)<<1)|((s&E1_R2_D_BIT)<<3))

/* r2_method -  expecting digital compelled */
#define R2_DIGITAL_COMPELLED   1
#define R2_DIGITAL_INVERTED    2 /* not currently implemented */
#define R2_DIGITAL_METERED     3 /* not currently implemented */
#define R2_ANALOG              4 /* never will be implemented */
#define R2_PULSE               5 /* never will be implemented */

/* max_dnis_digits and max_ani_digits - how to know if a number is finished */
#define R2_END_OF_PULSING 100 /* use END_OF_PULSING signal */

/*
 * MF R2 Signal definitions for:
 * ani_digit_signal, answer_signal, congestion_signal, busy_signal, etc. 
 */
/* forward signal definitions: */
#define MF_R2_FW_BASE  	0x0
#define MF_R2_FW_1	MF_R2_FW_BASE + 1
#define MF_R2_FW_2	MF_R2_FW_BASE + 2
#define MF_R2_FW_3	MF_R2_FW_BASE + 3
#define MF_R2_FW_4	MF_R2_FW_BASE + 4
#define MF_R2_FW_5	MF_R2_FW_BASE + 5
#define MF_R2_FW_6	MF_R2_FW_BASE + 6
#define MF_R2_FW_7	MF_R2_FW_BASE + 7
#define MF_R2_FW_8	MF_R2_FW_BASE + 8
#define MF_R2_FW_9	MF_R2_FW_BASE + 9
#define MF_R2_FW_10	MF_R2_FW_BASE + 10
#define MF_R2_FW_11	MF_R2_FW_BASE + 11
#define MF_R2_FW_12	MF_R2_FW_BASE + 12
#define MF_R2_FW_13	MF_R2_FW_BASE + 13
#define MF_R2_FW_14	MF_R2_FW_BASE + 14
#define MF_R2_FW_15	MF_R2_FW_BASE + 15

/*
 * MF R2 Signal definitions for:
 * ani_digit_signal, answer_signal, congestion_signal, busy_signal, etc. 
 */
/* backward signal definitions: */
#define MF_R2_BW_BASE  	0x10
#define MF_R2_BW_1	MF_R2_BW_BASE + 1
#define MF_R2_BW_2	MF_R2_BW_BASE + 2
#define MF_R2_BW_3	MF_R2_BW_BASE + 3
#define MF_R2_BW_4	MF_R2_BW_BASE + 4
#define MF_R2_BW_5	MF_R2_BW_BASE + 5
#define MF_R2_BW_6	MF_R2_BW_BASE + 6
#define MF_R2_BW_7	MF_R2_BW_BASE + 7
#define MF_R2_BW_8	MF_R2_BW_BASE + 8
#define MF_R2_BW_9	MF_R2_BW_BASE + 9
#define MF_R2_BW_10	MF_R2_BW_BASE + 10
#define MF_R2_BW_11	MF_R2_BW_BASE + 11
#define MF_R2_BW_12	MF_R2_BW_BASE + 12
#define MF_R2_BW_13	MF_R2_BW_BASE + 13
#define MF_R2_BW_14	MF_R2_BW_BASE + 14
#define MF_R2_BW_15	MF_R2_BW_BASE + 15

/* incoming_allow_mask - what subscriber calls will be accepted */
#define R2_ALL_SUBSCRIBERS 0x7fffffff

/* outgoing_type - what subscriber ident we supply on dial-out */
#define MF_R2_NATIONAL_SUBSCRIBER               MF_R2_FW_1
#define MF_R2_NATIONAL_PRIORITY_SUBSCRIBER      MF_R2_FW_2
#define MF_R2_NATIONAL_MAINTENANCE_EQUIPMENT    MF_R2_FW_3
#define MF_R2_NATIONAL_OPERATOR                 MF_R2_FW_5
#define MF_R2_NATIONAL_DATA_TRANSMISSION        MF_R2_FW_6
#define MF_R2_INTERNATIONAL_SUBSCRIBER          MF_R2_FW_7
#define MF_R2_INTERNATIONAL_DATA_TRANSMISSION   MF_R2_FW_8
#define MF_R2_INTERNATIONAL_PRIORITY_SUBSCRIBER MF_R2_FW_9


/* IF YOU CHANGE THIS STRUCT, change ds1_nv_e1r2_config_t in ds1.hh also! */
typedef struct
{
	dxb_uint32 r2_switch_type;
	dxb_uint32 r2_cd_bits;
	dxb_uint32 r2_method;
	dxb_uint32 min_dnis_digits;    /* min number of DNIS digits for RX */
	dxb_uint32 max_dnis_digits;    /* max number of DNIS digits for RX */
	dxb_uint32 min_ani_digits;     /* min number of ANI digits for RX */
	dxb_uint32 max_ani_digits;     /* max number of ANI digits for RX */

	dxb_uint32 send_ani_digits;    /* Boolean -- do we send our digits? */

	dxb_uint32 ani_digit_signal;   /* use mf.h definitions */
	dxb_uint32 answer_signal;      /* use mf.h definitions */
	dxb_uint32 congestion_signal;  /* use mf.h definitions */
	dxb_uint32 end_dnis_signal;    /* use mf.h definitions */
	dxb_uint32 busy_signal;        /* use mf.h definitions */
	dxb_uint32 seize_ack_delay;    /* ms delay before acking seize */
	dxb_uint32 answer_delay;       /* ms delay before answer mode */

	dxb_uint32 incoming_allow_mask;/* what types will be accepted */
	dxb_uint32 outgoing_type;      /* default outgoing type of call */

	dxb_uint32 linesig_min;        /* Debounce Timer for line signals */

	/* leave some room to grow for new options */
	dxb_uint32 reserved_0;
	dxb_uint32 reserved_1;
	dxb_uint32 reserved_2; 
	dxb_uint32 reserved_3; 
	dxb_uint32 reserved_4; 
	dxb_uint32 reserved_5; 
	dxb_uint32 reserved_6; 
	dxb_uint32 reserved_7; 
} ds1_e1r2_config_t;

/************************************************************************/
/*									*/
/*	BRI LEVEL							*/
/*									*/
/************************************************************************/

/*
 * BRI Level Data Structures and Defines
 */
/*
 * (S|G)ET_BRI_CONFIG data structure and defines
 *
 * if directory[] is null ignore; else reset all
 *
 * support auto-config ?
 */
/* switch_type */
#define BRI_NONE	16
#define	BRI_NI1		17
#define	BRI_5ESS	18
#define	BRI_DMS100	19
#define	BRI_ETSI	20
#define	BRI_EURODSS1	BRI_ETSI
#define	BRI_JAPAN	21
#define	BRI_INS64	BRI_JAPAN
#define	BRI_ETSI_PTP	22
#define	BRI_EURODSS1_PTP	BRI_ETSI_PTP
/* auto_spid */
#define BRI_AUTOSPID_OFF	1
#define BRI_AUTOSPID_ON		2
/*
 * leased_mask
 *
 * Bit 0 in little Endian is the low order bit  (rightmost bit) of the dxb_uint32.
 *
 * BRI: bits 0 and 1 are B-channels. All other bits ignored except bit 31 (the
 * leased none bit).
 */
#define BRI_LEASED_NONE	DS1_LEASED_NONE
#define BRI_LEASED_UPDATE BRI_LEASED_NONE

#define DN_LIMIT	20
#define DN_NULL_PAD	4
#define DN_MAX		DN_LIMIT+DN_NULL_PAD

#define	MSN_MAX		8

#define BRI_AUTOALERT_OFF	0x00000001
#define BRI_AUTOALERT_ON	0x00000002

#define BRI_MSN_OFF	0x00000001
#define BRI_MSN_ON	0x00000002

/*
 * The number of entries in the bri_directory_t array defined by
 * dir_count is or'd with BRI_DIR_UPDATE. If dir_count is zero
 * (dir_count is set to BRI_DIR_UPDATE), the stored directory
 * contents are cleared.
 *
 * Note - for back-to-back testing configure directory numbers and spids, 
 * but set the actual directory numbers to null strings.
 */

#define BRI_DIR_UPDATE	0x80000000

typedef struct
{
	dxb_uint8       number[DN_MAX] ; /* null terminated ascii string */
	dxb_uint8       sub_address[DN_MAX] ; /* null terminated ascii string */
	dxb_uint8       spid[DN_MAX] ;	/* null terminated ascii string */
} bri_directory_t;

typedef struct 
{
	dxb_uint32	switch_type ;
	dxb_uint32	auto_spid ;	/* enable auto_spid negotiation */
	dxb_uint32	leased_mask ;	/* ones based time slot mask; */
					/* bit 0 = slot 1 */
	bri_directory_t	directory[MSN_MAX] ;
	dxb_uint32	dir_count;
	dxb_uint32	msn;		/* Multiple subscriber number filtering enable */
	dxb_uint32	autoalert;	/* automatic generation of ALERTING message enable */
} bri_config_t ;

/*
 * GET_BRI_STATUS response data structure and defines
 */
/* power */
#define BRI_POWER_OFF		1
#define BRI_POWER_ON 		2
#define BRI_POWER_UNKNOWN	3
/* activation_state (from I.430) */
#define BRI_ACT_F1		1	/* inactive */
#define BRI_ACT_F2		2	/* sensing */
#define BRI_ACT_F3		3	/* deactivated */
#define BRI_ACT_F4		4	/* awaiting signal */
#define BRI_ACT_F5		5	/* identifying input */
#define BRI_ACT_F6		6	/* sychronized */
#define BRI_ACT_F7		7	/* activated */
#define BRI_ACT_F8		8	/* lost framing */
#define BRI_ACT_G0		BRI_ACT_F1
#define BRI_ACT_G1		BRI_ACT_F3
#define BRI_ACT_G2		BRI_ACT_F6
#define BRI_ACT_G3		BRI_ACT_F7
#define BRI_ACT_G4		BRI_ACT_F8
/* activation_state (from I.430) */
#define BRI_INFO_0		1	/* no signal */
#define BRI_INFO_1		2	/* continuous signal with pattern */
#define BRI_INFO_2		3	/* frame with zeroed data */
#define BRI_INFO_3		4	/* frame with operational data */
#define BRI_INFO_4		5	/* frame with operational data */
#define BRI_INFO_5		6	/* unknown signal */

/*  spid_state */
#define BRI_SPID_UNUSED             1
#define BRI_SPID_IDLE               2
#define BRI_SPID_SENT_INFO          3 
#define BRI_SPID_RECV_INFO          4
#define BRI_SPID_BAD_INFO           5
#define BRI_SPID_WAITING_FOR_DL     6
#define BRI_SPID_NEGOTIATE          7
#define BRI_SPID_NEGOTIATE_FAILED   8

/* clearer spid_state definitions */
#define BRI_SPID_NEGOTIATE_PENDING	BRI_SPID_IDLE
#define BRI_SPID_NEGOTIATE_ACTIVE	BRI_SPID_NEGOTIATE
#define BRI_SPID_NEGOTIATE_SUCCESS	BRI_SPID_RECV_INFO
#define BRI_SPID_NEGOTIATE_FAIL_REJECT	BRI_SPID_BAD_INFO
#define BRI_SPID_NEGOTIATE_FAIL_RETRIES	BRI_SPID_NEGOTIATE_FAILED


/* Limits for spid_state table and tei_state table */
#define BRI_MAX_TEIS 2
#define BRI_MAX_SPIDS BRI_MAX_TEIS


typedef struct 
{
	dxb_uint32	power ;			/* power status */
	dxb_uint32	activation_state ;	/*  F states 1 - 8 or G states 1 - 4 */
	dxb_uint32	rx_info_state ;		/* info states 0, 2, 4 and 5 (unknown) */
	dxb_uint32	tx_info_state ;		/* info states 0, 1, 3 and 5 (unknown) */
	dxb_uint32	loss_of_sync ;		/* loss of sync counter */
	dxb_uint32	collisions ;		/* S/T bus collision counter */
	dxb_uint32	spid_count ;		/* the number of configured spids 0 - 2 */
	dxb_uint32	spid_state[BRI_MAX_SPIDS] ; /* spid negotiation states */
} bri_status_t ;


/************************************************************************/
/*									*/
/*	SERIAL LEVEL							*/
/*									*/
/************************************************************************/

/*
 * Serial level data structures and defines
 */
/*
 * (G|S)ET_SERIAL_CONFIG data structures and defines
 */
/* port_type */
#define SERIAL_PORTTYPE_RS232		1
#define SERIAL_PORTTYPE_RS422		2
#define SERIAL_PORTTYPE_RS423		3
#define SERIAL_PORTTYPE_V35		4
#define SERIAL_PORTTYPE_RS485_2_M      	5
#define SERIAL_PORTTYPE_RS485_2_E	6
#define SERIAL_PORTTYPE_RS485_4_M      	7
#define SERIAL_PORTTYPE_RS485_4_E	8

/* clock_source */
#define	SERIAL_CLOCKSOURCE_INT		1
#define	SERIAL_CLOCKSOURCE_EXT		2
#define	SERIAL_CLOCKSOURCE_SPLIT	3	/* rx ext, tx int */

#define SERIAL_ALTPIN_OFF		1
#define SERIAL_ALTPIN_ON		2

typedef struct
{
	dxb_uint32	port_type;	/* rfc1317 rs232PortType */
	dxb_uint32	clock_source;	/* rfc1317 rs232SyncPortClockSource */
	dxb_uint32	alt_pin;	/* RJ-45 alt pin out; swap DCD & DSR */
} serial_config_t;

/*
 * GET_SERIAL_STATUS data structures and defines
 */
/* port_state */
#define	SERIAL_CLOSED 			1
#define	SERIAL_OPEN 			2
#define	SERIAL_ACTIVE		 	3
/* frame_mode */
#define	SERIAL_FRAME_NONE 		1
#define	SERIAL_FRAME_ASYNC_SLIP		2
#define	SERIAL_FRAME_ASYNC_PPP		3
#define	SERIAL_FRAME_SYNC_HDLC		4
/* flow types and states */
#define SERIAL_IN_FLOW_XONXOFF_INDEX	0
#define SERIAL_IN_FLOW_RTS_INDEX	1
#define SERIAL_IN_FLOW_DTR_INDEX	2
#define SERIAL_IN_FLOW_PAD_INDEX	3
#define SERIAL_IN_FLOW_MAX		4
#define SERIAL_OUT_FLOW_XONXOFF_INDEX	0
#define SERIAL_OUT_FLOW_CTS_INDEX	1
#define SERIAL_OUT_FLOW_DSR_INDEX	2
#define SERIAL_OUT_FLOW_PAD_INDEX	3
#define SERIAL_OUT_FLOW_MAX		4
#define SERIAL_FLOW_DISABLED		1
#define SERIAL_FLOW_ENABLED		2
#define SERIAL_FLOW_DEASSERTED		1
#define SERIAL_FLOW_ASSERTED		2
/* modem signals and states */
#define SERIAL_SIGNAL_RTS		0
#define SERIAL_SIGNAL_CTS		1
#define SERIAL_SIGNAL_DTR		2
#define SERIAL_SIGNAL_DSR		3
#define SERIAL_SIGNAL_RI		4
#define SERIAL_SIGNAL_DCD		5
#define SERIAL_SIGNAL_PAD1		6
#define SERIAL_SIGNAL_PAD2		7
#define SERIAL_SIGNAL_MAX		8
#define SERIAL_SIGNAL_DEASSERTED	1
#define SERIAL_SIGNAL_ASSERTED		2
/* autobaud */
#define SERIAL_AUTOBAUD_DISABLED	1
#define SERIAL_AUTOBAUD_ENABLED		2
/* data_bits */
#define SERIAL_DATABITS_8		1
#define SERIAL_DATABITS_7		2
#define SERIAL_DATABITS_6		3
#define SERIAL_DATABITS_5		4
/* stop_bits */
#define SERIAL_STOPBITS_1		1
#define SERIAL_STOPBITS_2		2
#define SERIAL_STOPBITS_ONEANDONEHALF	3
/* parity */
#define SERIAL_PARITY_NONE		1
#define SERIAL_PARITY_ODD		2
#define SERIAL_PARITY_EVEN		3
#define SERIAL_PARITY_SPACE		4
#define SERIAL_PARITY_MARK		5

typedef struct
{
	dxb_uint32 port_state;		   /* port operational state */
	dxb_uint32 frame_mode;		   /* framing mode */

	/* flow control states */
	dxb_uint8 in_flow_type[SERIAL_IN_FLOW_MAX];
	dxb_uint8 out_flow_type[SERIAL_OUT_FLOW_MAX];
	dxb_uint8 in_flow_state[SERIAL_IN_FLOW_MAX];
	dxb_uint8 out_flow_state[SERIAL_OUT_FLOW_MAX];

	/* modem signal states */
	dxb_uint8 mdm_sig_state[SERIAL_SIGNAL_MAX];

	dxb_uint32 in_speed;	/* rfc1317 rs232InSpeed, if known; else 0 */
	dxb_uint32 out_speed;	/* rfc1317 rs232OutSpeed, if known; else 0 */
	dxb_uint32 autobaud;	/* rfc1317 rs232AsyncPortAutobaud */

	dxb_uint32 data_bits;	/* rfc1317 rs232AsyncPortBits */
	dxb_uint32 stop_bits;	/* rfc1317 rs232AsyncPortStopBits */
	dxb_uint32 parity;	/* rfc1317 rs232AsyncPortParity */
} serial_status_t;

/*
 * (G|S)ET_SERIAL_EXT_CONFIG data structures and defines
 */
#define SERIAL_UNPAUSE		1
#define SERIAL_PORT_RESET	1
typedef struct
{
	dxb_uint32 unpause_rx; /* unconditionally transmit an xon, raise RTS */
	dxb_uint32 unpause_tx; /* act as if xoff was received */
	dxb_uint32 reset;      /* This may be the interesting feature */
} serial_ext_config_t;

/*
 * GET_EXT_SERIAL_STATUS data structures and defines
 */
typedef struct
{
	dxb_uint32 tx_bytes;		   /* cumulative count at uart, async or sync */
	dxb_uint32 rx_bytes;		   /* cumulative count at uart, async or sync */
	dxb_uint32 tx_frames;		   /* cumulative frame count */
	dxb_uint32 rx_frames;		   /* cumulative frame count */
	dxb_uint32 rx_bad_frames;	   /* total bad frame count */
	dxb_uint32 rx_short_frames;	   /* short frame count */
	dxb_uint32 rx_long_frames;	   /* long frame count */
	dxb_uint32 rx_aborts;		   /* rfc1317 rs232SyncPortAbortedFrames */
	dxb_uint32 rx_overruns;		   /* rfc1317 rs232SyncPortReceiveOverrunErrs */
	dxb_uint32 rx_crc_errors;	   /* rfc1317 rs232SyncPortFrameCheckErrs */
	dxb_uint32 rx_buffer_overflows;	   /* internal buffer overflow count */
	dxb_uint32 tx_underruns;	   /* rfc1317 rs232SyncPortTransmitUnderrun */

	dxb_uint32 interrupted_frames;	   /* rfc1317 rs232SyncPortInterruptedFrames */

	dxb_uint32 breaks_received;
	dxb_uint32 parity_errs;		   /* rfc1317 rs232AsyncPortParityErrs */
	dxb_uint32 framing_errs;	   /* rfc1317 rs232AsyncPortFramingErrs */
	dxb_uint32 overrun_errs;	   /* rfc1317 rs232AsyncPortOverrunErrs */

	dxb_uint32 txaccm;		   /* async control character map */
	dxb_uint32 rxaccm;		   /* async control character map */
} serial_ext_status_t;

/************************************************************************/
/*									*/
/*	CALL STATUS LEVEL						*/
/*									*/
/************************************************************************/
/*
 * Call status data structure and defines
 */
/* call_type definitions */
#define CALL_BCHAN		1	/* digital call */
#define CALL_MODEM		2	/* analog call */

/* call_state definitions */
#define CALL_NEUTRAL		1	/* no call active on this channel */
#define CALL_INBOUND		2	/* active inbound call */
#define CALL_OUTBOUND		3	/* active outbound call */
#define CALL_BUSIED_OUT		4	/* no call and busied out */
#define CALL_INBOUND_BUSIED_OUT	5	/* active inbound call and busied out*/
#define CALL_OUTBOUND_BUSIED_OUT 6	/* active outbound call and busied out*/

/*
 * GET_CALL_STATUS and GET_ALL_CALL_STATUS response data structure
 */
typedef struct
{
	dxb_uint32	call_state;
	dxb_uint32	call_type;
	dxb_uint32	index;		/* channel for serial/modem or bchan */
	dxb_uint32	timeslot;	/* physical timeslot of call */
} call_status_t;

/************************************************************************/
/*									*/
/*	MODEM LEVEL							*/
/*									*/
/************************************************************************/

/*
 * Modem Level Data Structures and defines
 */
/*
 * (S|G)ET_MODEM_CONFIG data structure and defines
 */
/* clid_enable */
#define	CLID_NO		1
#define	CLID_YES	2
#define	MODEM_CLID_ON	CLID_YES
#define	MODEM_CLID_OFF	CLID_NO
/* hangup */
#define MODEM_HANGUP	1
/* reset */
#define	MODEM_RESET_COLD	1	/* equivalent to power cycle */
#define	MODEM_RESET_WARM	2	/* equivalent to ATZ */
#define	MODEM_RESET_DEFAULT	3	/* equivalent to &F */

#define MGMT_META_VALUE	0x80000000	/* OR answer_rings with this to send 0*/

typedef struct 
{
	dxb_uint32	answer_rings ;	/* equivalent to S0 */
	dxb_uint32	clid_enable ;
	dxb_uint32	max_rate ;	/* refuse calls above this rate (eg 33600) */
	dxb_uint32	min_rate ;	/* refuse calls below this rate (eg 19200) */
	dxb_uint32	hangup ;	/* force modem to terminate the call */
	dxb_uint32	reset ;		/* force the modem to reset itself */
} modem_config_t ;

/*
 * GET_MODEM_STATUS response data structure and defines
 */
/* mode */
#define MODEM_IDLE		1
#define MODEM_INBOUND		2
#define MODEM_OUTBOUND		3

/* modulation */
#define MODEM_103		1
#define MODEM_212A		2
#define MODEM_V21		3
#define MODEM_V22		4
#define MODEM_V22BIS		5
#define MODEM_V23		6
#define MODEM_V32		8
#define MODEM_V32BIS		9
#define MODEM_V34		10
#define MODEM_V34BIS		11
#define MODEM_K56FLEX		12
#define MODEM_V90		13

#define MODEM_V17		32
#define MODEM_V21CH2		33
#define MODEM_V27TER		34
#define MODEM_V29		35
#define MODEM_V33		36
#define MODEM_V34FAX		37

/* compression */
#define MODEM_NO_COMP		1
#define MODEM_MNP5		4
#define MODEM_V42BIS		5
#define MODEM_V24BIS		7     /* Is this real? */

#define MODEM_T4_1D		32
#define MODEM_T4_2D		33
#define MODEM_T4_2D_UNCOMP	34
#define MODEM_T6		35

/* error_correction */
#define MODEM_NO_EC		1
#define MODEM_LAPM		2
#define MODEM_MNP2		3
#define MODEM_MNP3		4
#define MODEM_MNP4		5
#define MODEM_V42		6

#define MODEM_FAXECM64		32
#define MODEM_FAXECM256		33

/* last disconnect modem reason codes */

/* overall modem controller failures */
#define MODEM_REASON_OMC_NORMAL_LOCAL		0x00000001 
	/* locally initiated disconnect, e.g. ATH */
#define MODEM_REASON_OMC_NORMAL_REMOTE		0x00000002 
	/* remotely initiated disconnect */
#define MODEM_REASON_OMC_INACTIVITY		0x00000003 
	/* inactivity timeout (S30?) */
#define MODEM_REASON_OMC_CIRCUIT_LOSS		0x00000004 
	/* circuit lost during connection, e.g. POTS phase reversal, 
		e.g. (may not be in our hardware) */
#define MODEM_REASON_OMC_HALTED			0x00000005 
	/* abnormal locally initiated disconnect ??? */
#define MODEM_REASON_OMC_DM_TIMEOUT		0x00000006 
	/* data modulation connect timeout */
#define MODEM_REASON_OMC_DP_TIMEOUT		0x00000007 
	/* data protocol connect timeout */
#define MODEM_REASON_OMC_IMPROPER_CONTROL	0x00000008 
	/* an illegal state occured, this shouldn't happen */
#define MODEM_REASON_OMC_FAX_DETECTED		0x00000009 
	/* fax detected while fax not enabled */
#define MODEM_REASON_OMC_DM_CLEARDOWN		0x0000000A 
	/* remote unexpectedly disconnected at data modulation layer */
#define MODEM_REASON_OMC_CALL_FUNC_UNSUPP	0x0000000B 
	/* no common V.8/V.8bis call functions negotiable */
#define MODEM_REASON_OMC_T30_SESSION		0x0000000C 
	/* T.30 session initiated and terminated */
		/* subreason applicable here ??? */

/* data modulation failures */
#define MODEM_REASON_DM_CARRIER_LOSS		0x00000044 
	/* carrier loss detected after call established */
#define MODEM_REASON_DM_NEG_REQ_FAIL		0x00000045 
	/* required feature could not be negotiated */ 
#define MODEM_REASON_DM_GEN_REQ_FAIL		0x00000046 
	/* required charcteristic not obtainable/maintainable, 
		e.g. minumum error-free throughput rate */
#define MODEM_REASON_DM_PROTOCOL_FAIL		0x00000047 
	/* nonrecoverable protocol violation */
#define MODEM_REASON_DM_GENERAL			0x00000048 
	/* generic protocol disconnect */

/* data protocol failures */
#define MODEM_REASON_DP_NEG_REQ_FAIL		0x00000084 
	/* required feature could not be negotiated */
#define MODEM_REASON_DP_GEN_REQ_FAIL		0x00000085 
	/* required charcteristic not obtainable/maintainable, 
		e.g. minumum error-free throughput rate */
#define MODEM_REASON_DP_PROTOCOL_FAIL		0x00000086 
	/* nonrecoverable protocol violation */
#define MODEM_REASON_DP_COMP_PROTOCOL_FAIL	0x00000087 
	/* nonrecoverable V.42bis protocol violation */
#define MODEM_REASON_DP_GENERAL			0x00000088 
	/* generic protocol disconnect */
#define MODEM_REASON_DP_NO_RESPONSE		0x00000089 
	/* remote protocol not responding */
#define MODEM_REASON_DP_STARTUP_FAIL		0x0000008A 
	/* data protocol failed to start */
#define MODEM_REASON_DP_TIMEOUT			0x0000008B 
	/* data protocol start-up timeout */

/* following are the usual "AT" class reasons */
#define MODEM_REASON_DIAL_NO_DIALTONE		0x000000c0
#define MODEM_REASON_DIAL_BUSY			0x000000c1
#define MODEM_REASON_DIAL_NO_ANSWER		0x000000c2
#define MODEM_REASON_DIAL_DELAYED		0x000000c3
#define MODEM_REASON_DIAL_BLACKLISTED		0x000000c4
#define MODEM_REASON_DIAL_NO_CARRIER		0x000000c5

/* Notice that the below symbols are redefined as above symbols */

#define MODEM_REASON_DP_INACTIVITY		MODEM_REASON_OMC_INACTIVITY

/* maximum caller id charcters */
#define CLID_MAX		64

typedef struct 
{
	dxb_uint32	mode ;		/* operational mode */
	dxb_uint32	dte_tx_rate ;	/* measured data throughput rate */
	dxb_uint32	dte_rx_rate ;	/* measured data throughput rate */

	/*
	 * Following block valid for current call,
	 * or previous call if idle.
	 */
	dxb_uint32	port ;			/* physical port of call */
	dxb_uint32	index ;			/* logical channel of call */
	dxb_uint32	connect_time ;		/* elapsed connect time */
	dxb_uint32	initial_tx_rate ;	/* initial line rate (eg 33600) */
	dxb_uint32	initial_rx_rate ;	/* initial line rate (eg 33600) */
	dxb_uint32	current_tx_rate ;	/* current line rate (eg 33600) */
	dxb_uint32	current_rx_rate ;	/* current line rate (eg 33600) */
	dxb_uint32	modulation ;
	dxb_uint32	compression ;
	dxb_uint32	error_correction ;

	dxb_uint32	page_number ;		/* current fax page */

	dxb_uint32	last_disconnect ;	/* cause code for last disconnect */

	dxb_uint8	clid[CLID_MAX] ;	/* caller ID data */

	dxb_uint8	local_dn[DN_MAX] ;	/* the modem's phone number */
	dxb_uint8	remote_dn[DN_MAX] ;	/* the called (outbound) or */
						/* calling (inbound) number */
} modem_status_t ;

/*
 * (S|G)ET_MODEM_EXT_CONFIG data structure and defines
 */
/* busy_out */
#define BUSY_OUT_DISABLE	1
#define BUSY_OUT_ENABLE_IMMED	2	/* terminates call and busy outs channel */
#define BUSY_OUT_ENABLE_DELAYED	3	/* busy outs channel after call terminates */
/* leased_line */
#define MODEM_SWITCHED	1
#define	MODEM_LEASED	2
#define	MODEM_LEASED_MULTITECH	3

typedef struct 
{
	dxb_uint32	busy_out ;		/* immediate terminates current call */
	dxb_uint32	leased_line ;		/* equivalent to &L1 */
	dxb_uint32	audio_level_tx ;
	dxb_uint32	audio_level_rx ;
} modem_ext_config_t ;

/*
 * GET_MODEM_EXT_STATUS response data structure
 */

typedef struct 
{
	dxb_uint32	tx_symbol_rate ; /* rate in symbols per second */
	dxb_uint32	rx_symbol_rate ; /* rate in symbols per second */
	dxb_uint32	estimated_snr ; /* singal/noise ratio in dB */
	dxb_uint32	estimated_rtt ; /* round trip time in ms */
	dxb_uint32	tx_signal_level ; /* signal level in dBm */
	dxb_uint32	rx_signal_level ; /* signal level in dBm */
	dxb_uint32	local_retrains ; /* count of retrains */
	dxb_uint32	remote_retrains ; /* count of retrains */
	dxb_uint32	manual_retrains ; /* count of retrains from overrides */
	dxb_uint32	local_renegotiations ; /* count of renegotiations */
	dxb_uint32	remote_renegotiations ; /* count of renegotiations */
	dxb_uint32	tx_frames ; /* count of all link layer frames */
	dxb_uint32	rx_frames ; /* count of all link layer frames */
	dxb_uint32	rx_frame_errors ; /* count of all rx frame errors */
	dxb_uint32	tx_data_frames ; /* count of data frames */
	dxb_uint32	tx_data_frame_retransmits ; /* count of data frames */
	dxb_uint32	rx_data_frames ; /* count of data frames */
	dxb_uint32	rx_data_frame_errors ; /* count of data frame errors */
	dxb_uint32	tx_data_bytes ; /* count of data bytes */
	dxb_uint32	rx_data_bytes ; /* count of data bytes */
	dxb_uint32	tx_compressed_data_bytes ; /* count after compression */
	dxb_uint32	rx_compressed_data_bytes ; /* count after compression */
	dxb_uint32	line_quality ; /* relative value (mean_square_error) */
	dxb_uint32	rbs_pattern ; /* robbed bit signalling pattern */
	dxb_uint32	data_rate_dropped ; /* loss in Kbs from rbs/dgtl pad */
	dxb_uint32	digital_pad ; /* digital pad in dB */
	dxb_uint32	dictionary_size ; /* size of compression dictionary */
	dxb_uint32	max_string_length ; /* compression string length */
} modem_ext_status_t ;


/************************************************************************/
/*									*/
/*	D CHAN LEVEL							*/
/*									*/
/************************************************************************/

/*
 * D Chan Level Data Structures and Defines
 */
/*
 * (S|G)ET_DCHAN_EXT_CONFIG data structure and defines
 */
/* mode */
#define DCHAN_NORMAL		1	/* S/T as TE, U as NT */
#define DCHAN_LOOPBACK_TE	2	/* S/T as TE, U as NT */
#define DCHAN_LOOPBACK_NT	3	/* S/T as NT, U as LT */
/* address_type */
#define DCHAN_ADDRESS_TYPE_UNKNOWN	1
#define DCHAN_ADDRESS_TYPE_INTL		2
#define DCHAN_ADDRESS_TYPE_NATIONAL	3
#define DCHAN_ADDRESS_TYPE_NETWORK	4
#define DCHAN_ADDRESS_TYPE_SUBSCR	5
#define DCHAN_ADDRESS_TYPE_ABBREV	6
/* numbering_plan */
#define DCHAN_NUMBERING_PLAN_UNKNOWN	1
#define DCHAN_NUMBERING_PLAN_ISDN	2
#define DCHAN_NUMBERING_PLAN_DATA	3
#define DCHAN_NUMBERING_PLAN_TELEX	4
#define DCHAN_NUMBERING_PLAN_NATIONAL	5
#define DCHAN_NUMBERING_PLAN_PRIVATE	6
/* subaddress_type */
#define DCHAN_SUBADDRESS_TYPE_NSAP	1
#define DCHAN_SUBADDRESS_TYPE_USER	2

typedef struct 
{
	dxb_uint32	mode ; 
	dxb_uint32	address_type ;		/* default address type */
	dxb_uint32	numbering_plan ;	/* default numbering plan */
	dxb_uint32	subaddress_type ;	/* default subaddress type */
} dchan_ext_config_t ;

/*
 * (S|G)ET_DCHAN_CONFIG data structure and defines
 */
/* auto_setup_ack */
#define	DCHAN_AUTOSETUPACK_OFF		0x00000001
#define	DCHAN_AUTOSETUPACK_ON		0x00000002

typedef struct
{
	dxb_uint32	auto_setup_ack ;	/* 1 - NO, 2 - YES */
} dchan_config_t ;

/*
 * Hybrid Command for IBM
 */
#define	SET_BRI_AND_DCHAN_EXT_CONFIG	(SERIALIZE(BRI_AND_DCHAN_EXT_CONFIG))

typedef struct {
	dxb_uint32		port;       /* Port */
	bri_config_t		b_config;   /* Same as SET_BRI_CONFIG */
	dchan_ext_config_t	d_config;   /* Same as SET_DCHAN_EXT_CONFIG */
	dxb_uint32		replumb;    /* 1-NO, 2-YES */
	dxb_uint32		reserved1;  /* Rsvd for future use */
	dxb_uint32		reserved2;  /* Rsvd for future use */
	dxb_uint32		reserved3;  /* Rsvd for future use */
	dxb_uint32		reserved4;  /* Rsvd for future use */
} set_bri_and_dchan_ext_config_request_t;

/* replumb can be set to one of the following two values (or 0 to ignore it) */
#define REPLUMB_NO	1	/* Don't replumb stack after changing config */
#define REPLUMB_YES	2	/* Replumb ISDN stack after changing config */


/*
 * Included by reference, in dchan_ext_status_t and bchan_ext_status_t is:
 *
 * do we need tx_aborts ?
 */
typedef struct 
{
	dxb_uint32	tx_bytes ;
	dxb_uint32	rx_bytes ;
	dxb_uint32	tx_frames ;
	dxb_uint32	rx_frames ;
	dxb_uint32	rx_bad_frames ;
	dxb_uint32	rx_short_frames ;
	dxb_uint32	rx_long_frames ;
	dxb_uint32	rx_aborts ;
	dxb_uint32	rx_overruns ;
	dxb_uint32	rx_crc_errors ;
	dxb_uint32	rx_buffer_overflows ;
	dxb_uint32	tx_underruns ;
} hdlc_status_t ;

/*
 * Included by reference, in dchan_ext_status_t is:
 */
typedef struct
{
	dxb_uint32 RR_rx_cmd;	/* Receive Ready command received count */
	dxb_uint32 RR_rx_rsp;	/* Receive Ready response received count */
	dxb_uint32 RR_tx_cmd;	/* Receive Ready command transmitted count */
	dxb_uint32 RR_tx_rsp;	/* Receive Ready response transmitted count */
	dxb_uint32 RR_tx_cmd_p;	/* Receive Ready command with poll transmitted count */
	dxb_uint32 RNR_rx_cmd;	/* Receive Not Ready command received count */
	dxb_uint32 RNR_rx_rsp;	/* Receive Not Ready response received count */
	dxb_uint32 RNR_tx_cmd;	/* Receive Not Ready command transmitted count */
	dxb_uint32 RNR_tx_rsp;	/* Receive Not Ready response transmitted count */
	dxb_uint32 RNR_tx_cmd_p;	/* Receive Not Ready command with poll transmitted count */
	dxb_uint32 REJ_rx_cmd;	/* Reject command received count */
	dxb_uint32 REJ_rx_rsp;	/* Reject response received count */
	dxb_uint32 REJ_tx_cmd;	/* Reject command transmitted count */
	dxb_uint32 REJ_tx_rsp;	/* Reject response transmitted count */
	dxb_uint32 REJ_tx_cmd_p;	/* Reject command transmitted with poll count */
	dxb_uint32 I_tx_cmd;	/* Information frames transmitted count */
	dxb_uint32 I_rx_cmd;	/* Information frames received count */
	dxb_uint32 SABME_rx_cmd;	/* Set Asynchronous Balanced Mode Extended command received count */
	dxb_uint32 SABME_tx_cmd;	/* Set Asynchronous Balanced Mode Extended command transmitted count */
	dxb_uint32 DISC_rx_cmd;	/* Disconnect command received count */
	dxb_uint32 DISC_tx_cmd;	/* Disconnect command transmitted count */
	dxb_uint32 UA_rx_rsp;	/* Unnumbered Acknowledge response received count */
	dxb_uint32 UA_tx_rsp;	/* Unnumbered Acknowledge response transmitted count */
	dxb_uint32 DM_rx_rsp;	/* Disconnected Mode response received count */
	dxb_uint32 DM_tx_rsp;	/* Disconnected Mode response transmitted count */
	dxb_uint32 UI_rx_cmd;	/* Unnumbered Information command received count */
	dxb_uint32 UI_tx_cmd;	/* Unnumbered Information command transmitted count */
	dxb_uint32 FRMR_rx_rsp;	/* Frame Reject response received count */
	dxb_uint32 FRMR_tx_rsp;	/* Frame Reject response transmitted count */
	dxb_uint32 XID_rx_cmd;	/* Exchange Identification command received count */
	dxb_uint32 XID_rx_rsp;	/* Exchange Identification response received count */
	dxb_uint32 XID_tx_cmd;	/* Exchange Identification command transmitted count */
	dxb_uint32 XID_tx_rsp;	/* Exchange Identification response transmitted count */
	dxb_uint32 rx_badlen;	/* bad length frame received count */
	dxb_uint32 rx_unknown;	/* unknown frame received count */
	dxb_uint32 rx_bad;		/* erroneous frame received count */
	dxb_uint32 rx_dud;		/* invalid and discarded frame received count */
	dxb_uint32 rx_ign;		/* out of state and ignored frame received count */
	dxb_uint32 tx_rtr;		/* frame retransmitted count */
	dxb_uint32 tx_ign;		/* ignored frame not transmitted count */
	dxb_uint32 T200_exp;	/* T200 timer expiry count */
	dxb_uint32 T200_N200_exp;	/* T200 timer expiry exceeding N200 limit count */
	dxb_uint32 rx_mgmt_dud;	/* invalid and discarded management frame received count */
	dxb_uint32 rx_mgmt_badlen;	/* bad length frame management frame received count */
	dxb_uint32 rx_mgmt_ign;	/* out of state and ignored management frame received count */
	dxb_uint32 rx_mgmt_unknown;	/* unknown management frame received count */
	dxb_uint32 rx_tei_assigned;	/* Terminal Endpoint Identifier assignment message received count */
	dxb_uint32 rx_tei_denied;	/* Terminal Endpoint Identifier denied message received count */
	dxb_uint32 rx_tei_check;	/* Terminal Endpoint Identifier check message received count */
	dxb_uint32 rx_tei_remove;	/* Terminal Endpoint Identifier remove message received count */
} lapd_status_t;

/*
 * (S|G)ET_DCHAN_EXT_STATUS response data structure and defines
 */
/* tei_state (terminal endpoint identifier) */
#define DCHAN_TEI_OFF			1	/* TEI disabled */
#define DCHAN_TEI_UNASSIGNED		2	/* TEI unassigned */
#define DCHAN_TEI_AWAITING_ASS		3	/* Awaiting TEI assignment */
#define DCHAN_TEI_AWAITING_EST 		4	/* Awaiting TEI assignment,
						   then establish MF mode */
#define DCHAN_TEI_ASSIGNED		5	/* TEI assigned */
#define DCHAN_MULTIFRAME_AWAITING_EST	6	/* Awaiting establishment of
						   MF mode (SABME sent) */
#define DCHAN_MULTIFRAME_EST		7	/* Multiframe established */
#define DCHAN_MULTIFRAME_AWAITING_REL	8	/* Awaiting release from MF
						   mode (DISC sent) */
#define DCHAN_MULTIFRAME_TIMER_REC	9	/* Timer recovery procedures
						   executing */


typedef struct 
{
	dxb_uint32	tei_count ;	/* the number of configured ties 0 - 2 */
	dxb_uint32	tei_state[BRI_MAX_TEIS] ; /* tei states */
	lapd_status_t	lapd ;		/* dchan lapd stats */
	hdlc_status_t	hdlc ;		/* dchan hdlc controller stats */
} dchan_ext_status_t ;


/************************************************************************/
/*									*/
/*	B CHAN LEVEL							*/
/*									*/
/************************************************************************/

/*
 * BChan Level Data Structures and Defines
 */
/* mode */
#define BCHAN_IDLE	1
#define BCHAN_INBOUND	2
#define BCHAN_OUTBOUND	3
/* compression */
#define BCHAN_NO_COMP	1
#define BCHAN_STAC	2

/*
 * GET_BCHAN_STATUS response data structure
 */
typedef struct 
{
	dxb_uint32	mode ;		/* operational mode */
	dxb_uint32	dte_tx_rate ;	/* measured data throughput rate */
	dxb_uint32	dte_rx_rate ;	/* measured data throughput rate */

	/*
	 * Following block valid for current call,
	 * or previous call if idle.
	 */
	dxb_uint32	port ;		/* physical port of call */
	dxb_uint32	index ;		/* logical channel of call */
	dxb_uint32	connect_time ;	/* elapsed connect time */
	dxb_uint32	channel_rate ;	/* current channel rate (eg 64000) */
	dxb_uint32	compression ;

	dxb_uint32	last_disconnect ;/* cause code for last disconnect */

	dxb_uint8	local_dn[DN_MAX] ; /* the channel's phone number */
	dxb_uint8	remote_dn[DN_MAX] ; /* the called (outbound) or the */
					/* calling (inbound) number */
} bchan_status_t ;

/*
 * (S|G)ET_BCHAN_EXT_CONFIG data structure
 */


#define BCHAN_HANGUP    1

/*
   Supply an ISDN cause code in cause_code. 
   If cause_code is 0, normal call clearing is used.
*/

typedef struct 
{
	dxb_uint32	hangup ;	/* terminate call */
	dxb_uint32	cause_code ;	/* cause code to send with DISCONNECT */
} bchan_ext_config_t ;

/*
 * GET_BCHAN_EXT_STATUS data structure
 */
typedef struct 
{
	hdlc_status_t	hdlc ;	/* hdlc stats for current or last call */
} bchan_ext_status_t ;


/************************************************************************/
/*									*/
/*	PAYLOAD DEFINITIONS						*/
/*									*/
/************************************************************************/

#ifndef SWIG
#ifndef NO_MGMT_RR_TYPES

/************************************************************************/
/*									*/
/*	ADAPTER LEVEL PAYLOAD DEFINITIONS						*/
/*									*/
/************************************************************************/

/*
 * get adapter info payload. looks a lot like get_adapter_info_t.
 */
typedef struct
{
	adapter_info_t info ;
} get_adapter_info_response_t ;

/*
 * get adapter state payload.  looks a lot like get_adapter_state_t.
 */
typedef struct
{
	adapter_state_t state ;
} get_adapter_state_response_t ;

/*
 * get/set modem nationality
 */
typedef struct
{
	dxb_uint32	country_code ;
} get_modem_nationality_response_t, set_modem_nationality_request_t ;

/*
 * get/set nvram config (enable/disable)
 */
typedef struct
{
	dxb_uint32	config;
} get_nvram_config_response_t, set_nvram_config_request_t ;


/*
 * get management protocol version response payload
 */
typedef struct
{
	dxb_uint32		mgmt_protocol_version ;
} get_mgmt_protocol_ver_response_t ;

/************************************************************************/
/*									*/
/*	PORT LEVEL PAYLOAD DEFINITIONS						*/
/*									*/
/************************************************************************/

/*
 * note that port and snid (ISDN API) are equivalent
 */

/*
 * get ds1 config request and response payloads
 */
typedef struct
{
	dxb_uint32	port ;
} get_ds1_config_request_t ;

typedef struct
{
	ds1_config_t 	config;
} get_ds1_config_response_t ;

/*
 * set ds1 config
 */
typedef struct
{
	dxb_uint32	port ;
	ds1_config_t 	config;
} set_ds1_config_request_t ;

/*
 * trace ds1 config request payload
 */
typedef set_ds1_config_request_t trc_ds1_config_request_t;

/*
 * get ds1 status request and response payloads
 */
typedef struct
{
	dxb_uint32	port ;
} get_ds1_status_request_t ;

typedef struct
{
	ds1_status_t 	status ;
} get_ds1_status_response_t ;

typedef struct
{
	dxb_uint32	port ;
	ds1_status_t 	status ;
} trc_ds1_status_request_t;

/*
 * get ds1 ext config request and response payloads
 */
typedef struct
{
	dxb_uint32	port ;
} get_ds1_ext_config_request_t ;

typedef struct
{
	ds1_ext_config_t config ;
} get_ds1_ext_config_response_t ;

/*
 * set ds1 ext config request payload
 */
typedef struct
{
	dxb_uint32		port ;
	ds1_ext_config_t 	config ;
} set_ds1_ext_config_request_t ;

/*
 * trace ds1 ext config request payload
 */
typedef set_ds1_ext_config_request_t trc_ds1_ext_config_request_t;

/*
 * get ds1 ext status request and response payloads
 */
typedef struct
{
	dxb_uint32		port ;
} get_ds1_ext_status_request_t ;

typedef struct
{
	ds1_ext_status_t 	status ;
} get_ds1_ext_status_response_t ;

typedef struct
{
	dxb_uint32		port ;
	ds1_ext_status_t 	status ;
} trc_ds1_ext_status_request_t;

/*
 * get ds1 all ct1 sig status request and response payloads
 */
typedef struct
{
	dxb_uint32	port ;
} get_all_ds1_ct1_sig_status_request_t ;

typedef struct
{
	ds1_all_ct1_sig_status_t	signals ;
} get_all_ds1_ct1_sig_status_response_t ;

/*
 * get ds1 e1r2 config request and response payloads
 */
typedef struct
{
	dxb_uint32	port ;
} get_ds1_e1r2_config_request_t ;

typedef struct
{
	ds1_e1r2_config_t 	config;
} get_ds1_e1r2_config_response_t ;

/*
 * set ds1 e1r2 config
 */
typedef struct
{
	dxb_uint32	port ;
	ds1_e1r2_config_t 	config;
} set_ds1_e1r2_config_request_t ;

/*
 * trace ds1 e1r2 config request payload
 */
typedef set_ds1_e1r2_config_request_t trc_ds1_e1r2_config_request_t;


/*
 * get bri config request and response payloads
 */
typedef struct
{
	dxb_uint32		port ;
} get_bri_config_request_t ;

typedef struct
{
	bri_config_t 		config;
} get_bri_config_response_t ;

/*
 * set bri config request payload
 */
typedef struct
{
	dxb_uint32		port ;
	bri_config_t 		config;
} set_bri_config_request_t ;

/*
 * trace bri config request payload
 */
typedef set_bri_config_request_t trc_bri_config_request_t;

/*
 * get bri status request and response payloads
 */
typedef struct
{
	dxb_uint32		port ;
} get_bri_status_request_t ;

typedef struct
{
	bri_status_t 		status ;
} get_bri_status_response_t ;

typedef struct
{
	dxb_uint32		port ;
	bri_status_t 		status ;
} trc_bri_status_request_t ;

/*
 * get dchan config request and response payloads
 */
typedef struct
{
	dxb_uint32	port ;
} get_dchan_config_request_t ;

typedef struct
{
	dchan_config_t 	config;
} get_dchan_config_response_t ;

/*
 * set dchan config request payload (no response payload)
 */
typedef struct
{
	dxb_uint32		port ;
	dchan_config_t 	config;
} set_dchan_config_request_t ;

/*
 * get dchan extended config request and response payloads
 */
typedef struct
{
	dxb_uint32	port ;
} get_dchan_ext_config_request_t ;

typedef struct
{
	dchan_ext_config_t 	config;
} get_dchan_ext_config_response_t ;

/*
 * set dchan extended config request payload (no response payload)
 */
typedef struct
{
	dxb_uint32		port ;
	dchan_ext_config_t 	config;
} set_dchan_ext_config_request_t ;

/*
 * trace dchan ext config request payload
 */
typedef set_dchan_ext_config_request_t trc_dchan_ext_config_request_t;

/*
 * get dchan extended status request and respones payloads
 */
typedef struct
{
	dxb_uint32	port ;
} get_dchan_ext_status_request_t ;

typedef struct
{
	dchan_ext_status_t status ;
} get_dchan_ext_status_response_t ;

typedef struct
{
	dxb_uint32	port ;
	dchan_ext_status_t status ;
} trc_dchan_ext_status_request_t ;

/*
 * get all call status request and response payloads
 */
typedef struct
{
	dxb_uint32	port ;
} get_all_call_status_request_t ;

typedef struct
{
	dxb_uint32	count ; /* valid structures returned: 2, 23, 24 or 30 */ 
	call_status_t 	status[30] ;
} get_all_call_status_response_t ;

/************************************************************************/
/*									*/
/*	CHANNEL LEVEL PAYLOAD DEFINITIONS						*/
/*									*/
/************************************************************************/

/*
 * get serial config request and response payloads
 */
typedef struct
{
	dxb_uint32	channel ; /* S/DXB port # :0-7,0-45,0-47,0-59 */
} get_serial_config_request_t;

typedef struct
{
	serial_config_t config;
} get_serial_config_response_t;

/*
 * set serial config request payloads  (no response payload)
 */
typedef struct						      
{
	dxb_uint32	channel ; /* S/DXB port # :0-7,0-45,0-47,0-59 */
	serial_config_t config;
} set_serial_config_request_t;

/*
 * trace serial config request payload
 */
typedef set_serial_config_request_t trc_serial_config_request_t;

/*
 * get serial status request and response payloads
 */
typedef struct
{
	dxb_uint32	channel ; /* S/DXB port # :0-7,0-45,0-47,0-59 */
} get_serial_status_request_t;

typedef struct
{
	serial_status_t status;
} get_serial_status_response_t;

typedef struct
{
	dxb_uint32	channel ; /* S/DXB port # :0-7,0-45,0-47,0-59 */
	serial_status_t status;
} trc_serial_status_request_t;

/*
 * get serial extended config request and response payloads
 */
typedef struct
{
	dxb_uint32	channel ; /* S/DXB port # :0-7,0-45,0-47,0-59 */
} get_serial_ext_config_request_t;

typedef struct
{
	serial_ext_config_t config;
} get_serial_ext_config_response_t;

/*
 * set serial extended config request payloads  (no response payload)
 */
typedef struct
{
	dxb_uint32	channel ; /* S/DXB port # :0-7,0-45,0-47,0-59 */
	serial_ext_config_t config;
} set_serial_ext_config_request_t;

/*
 * trace serial ext config request payload
 */
typedef set_serial_ext_config_request_t trc_serial_ext_config_request_t;

/*
 * get serial extended status request and response payloads
 */
typedef struct
{
	dxb_uint32	channel ; /* S/DXB port # :0-7,0-45,0-47,0-59 */
} get_serial_ext_status_request_t;

typedef struct
{
	serial_ext_status_t status;
} get_serial_ext_status_response_t;

typedef struct
{
	dxb_uint32	channel ; /* S/DXB port # :0-7,0-45,0-47,0-59 */
	serial_ext_status_t status;
} trc_serial_ext_status_request_t;

/*
 * get modem config request and response payloads
 */
typedef struct
{
	dxb_uint32	channel ; /* S/DXB port # :0-7,0-45,0-47,0-59 */
} get_modem_config_request_t ;

typedef struct
{
	modem_config_t 	config ;
} get_modem_config_response_t ;

/*
 * set modem config request payload
 */
typedef struct
{
	dxb_uint32	channel ; /* S/DXB port # :0-7,0-45,0-47,0-59 */
	modem_config_t 	config ;
} set_modem_config_request_t ;

/* 
 * trace modem config request payload
 */
typedef set_modem_config_request_t trc_modem_config_request_t;

/*
 * get modem status request and response payload
 */
typedef struct
{
	dxb_uint32	channel ; /* S/DXB port # :0-7,0-45,0-47,0-59 */
} get_modem_status_request_t ;

typedef struct
{
	modem_status_t 	status ;
} get_modem_status_response_t ;

typedef struct
{
	dxb_uint32	channel ; /* S/DXB port # :0-7,0-45,0-47,0-59 */
	modem_status_t 	status ;
} trc_modem_status_request_t ;

/*
 * get modem extended config request and respones payloads
 */
typedef struct
{
	dxb_uint32	channel ; /* S/DXB port # :0-7,0-45,0-47,0-59 */
} get_modem_ext_config_request_t ;

typedef struct
{
	modem_ext_config_t 	config ;
} get_modem_ext_config_response_t ;

/*
 * set modem extended config request payload
 */
typedef struct
{
	dxb_uint32	channel ; /* S/DXB port # :0-7,0-45,0-47,0-59 */
	modem_ext_config_t 	config ;
} set_modem_ext_config_request_t ;

/* 
 * trace modem config request payload
 */
typedef set_modem_ext_config_request_t trc_modem_ext_config_request_t;

/*
 * get modem extended status request and response payloadss
 */
typedef struct
{
	dxb_uint32	channel ; /* S/DXB port # :0-7,0-45,0-47,0-59 */
} get_modem_ext_status_request_t ;

typedef struct
{
	modem_ext_status_t 	status ;
} get_modem_ext_status_response_t ;

typedef struct
{
	dxb_uint32	channel ; /* S/DXB port # :0-7,0-45,0-47,0-59 */
	modem_ext_status_t 	status ;
} trc_modem_ext_status_request_t ;

/*
 * get bchan status request and response payloads
 */
typedef struct
{
	dxb_uint32	channel ; /* logical channel:0-7,0-45,0-47,0-59 */
} get_bchan_status_request_t ;

typedef struct
{
	bchan_status_t status ;
} get_bchan_status_response_t ;

/*
 * trace bchan status request payload
 */ 
typedef struct
{
	dxb_uint32	channel ; /* logical channel:0-7,0-45,0-47,0-59 */
	bchan_status_t status ;
} trc_bchan_status_request_t;


/*
 * get bchan extended config request and response payloads
 */
typedef struct
{
	dxb_uint32	channel ; /* logical channel:0-7,0-45,0-47,0-59 */
} get_bchan_ext_config_request_t ;

typedef struct
{
	bchan_ext_config_t config ;
} get_bchan_ext_config_response_t ;

/*
 * set bchan extended config request payload
 */
typedef struct
{
	dxb_uint32	channel ; /* logical channel:0-7,0-45,0-47,0-59 */
	bchan_ext_config_t config ;
} set_bchan_ext_config_request_t ;

/*
 * trace bchan extended config request payload
 */
typedef set_bchan_ext_config_request_t trc_bchan_ext_config_request_t;

/*
 * get bchan extended status request and response payloads
 */
typedef struct
{
	dxb_uint32	channel ; /* logical channel:0-7,0-45,0-47,0-59 */
} get_bchan_ext_status_request_t ;

typedef struct
{
	bchan_ext_status_t status;
} get_bchan_ext_status_response_t ;

typedef struct
{
	dxb_uint32	channel ; /* logical channel:0-7,0-45,0-47,0-59 */
	bchan_ext_status_t status;
} trc_bchan_ext_status_request_t ;

/************************************************************************/
/*									*/
/*	PORT/CHANNEL LEVEL PAYLOAD DEFINITIONS						*/
/*									*/
/************************************************************************/

/*
 * get ds1 ct1 sig status request and response payloads
 */
typedef struct
{
	dxb_uint32	port ;
	dxb_uint32	channel ; /* physical channel: 1-24 */
} get_ds1_ct1_sig_status_request_t ;

typedef struct
{
	ds1_ct1_sig_status_t	signal ;
} get_ds1_ct1_sig_status_response_t ;

/*
 * get call status request and response payloads
 */
typedef struct
{
	dxb_uint32	port ;
	dxb_uint32	channel ; /* logical channels: 1-2, 1-23, 1-24 or 1-30 */
} get_call_status_request_t ;

typedef struct
{
	call_status_t 	status ;
} get_call_status_response_t ;

typedef struct
{
	dxb_uint32	port ;
	dxb_uint32	channel ; /* logical channels: 1-2, 1-23, 1-24 or 1-30 */
	call_status_t 	status ;
} trc_call_status_request_t ;

/************************************************************************/
/*									*/
/*	TRACE PAYLOAD DEFINITIONS						*/
/*									*/
/************************************************************************/

/*
 * Raw data trace data structures.
 *
 * If the trace command is tracing port level data use the
 * xxx_port_data_trc_xxx types.
 *
 * If the trace command is tracing channel level data use the
 * xxx_channel_data_trc_xxx_t types.
 *
 * The value used for channel is sensitive to the context of the
 * xxx_channel_data_trc_xxx_t type.
 */

typedef struct
{
	dxb_uint32	port ;
	dxb_uint32	trace_on ;	/* 1 turns the trace on.  0 turns it off. */
} set_port_data_trc_request_t ;

typedef struct
{
	dxb_uint32	port ;
} get_port_data_trc_request_t ;

typedef struct
{
	dxb_uint32	trace_on ;	/* 1 is trace on.  0 is off. */
} get_port_data_trc_response_t ;

typedef struct
{
	dxb_uint32	channel ;
	dxb_uint32	trace_on ;	/* 1 turns the trace on.  0 turns it off. */
} set_channel_data_trc_request_t ;

typedef struct
{
	dxb_uint32	channel ;
} get_channel_data_trc_request_t ;

typedef struct
{
	dxb_uint32	trace_on ;	/* 1 trace on.  0 is off. */
} get_channel_data_trc_response_t ;


typedef struct {
	dxb_uint32	channel_select;	/* Can be a DSP mask or logical chan. */
	dxb_uint32	event_mask;	/* Digi Implementation Dependent */
	dxb_uint32	trace;		/* 0=OFF, 1=ON */
	dxb_uint32	mask_action;	/* 1=set global channel_mask=0
				 2=set global event_mask=0
				 4=Add channel to global channel_mask
				 (default is to set global channel_mask
				  to whatever channel_select indicates).
				 8=OR event_mask with global event_mask
				 16=Interpret channel_select as DSP mask
				 (default is to interpret it as logical 
				  channel number). */
	dxb_uint32	reserved1;	/* Reserved */
	dxb_uint32	reserved2;	/* Reserved */
} set_blackbox_data_trc_request_t;

#define MASK_ACTION_CLEAR_CHANNEL_MASK		0x01
#define MASK_ACTION_CLEAR_EVENT_MASK		0x02
#define MASK_ACTION_ADD_CHANNEL			0x04
#define MASK_ACTION_OR_EVENT_MASK		0x08
#define MASK_ACTION_VIEW_AS_DSP_MASK		0x10
#define MASK_ACTION_REMOVE_CHANNEL		0x20
#define MASK_ACTION_LAST			MASK_ACTION_REMOVE_CHANNEL
#define MASK_ACTION_MAX				((MASK_ACTION_LAST << 1) - 1)



#endif /* NO_MGMT_RR_TYPES */
#endif /* SWIG */

#define MGMTHLC_H_DEFINED
#endif
