
/*
 Copyright 1999-2000 by Digi International (www.digi.com)

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2, or (at your option)
 any later version.
 
 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY, EXPRESS OR IMPLIED; without even the 
 implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
 PURPOSE.  See the GNU General Public License for more details.
 
 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

/*
 * mgmtdflt.h
 *
 * 
 * Version history
 *
 * xx.xx.98	Initial Rev.
 * 	4.14.98 Modified by Tom S.
 *			Changes -	Added enums for internal use.
 *	4.24.98 Modified by Tom S.
 *			Added some additional error codes.
 *      6.01.98 Modified by Tom S.
 *  			Reserved a Command enum for spartacus.
 *	8.14.98 Modified by Tom S.
 *			Added the MGMT_SHIM_ERROR_BOARD_NON_FUNCTIONAL
 *	11.20.98 Modified by Tom S.
 *			Standardized the error code names.
 *			Fixed duplicate error code numbers.
 *			Defined the legacy error code names.
 *
 */

#ifndef MGMTDFLT_H_INCLUDED

/*
 * Defines used to determine the actual enum.
 */
#define DATA_TYPE_MASK    	(0xfff)
#define GET_DATA_TYPE(x)    	(x & DATA_TYPE_MASK)
#define RESERVED_BIT		(0x4000)	/* this bit indicates that the
						 * command is a request to the
						 * MGMT shim and not the MGMT
						 * channel.
						 */

/*
 * Hints - occupy the top 4 bits of any command
 * (Used with defined enums to create commands)
 */
#define GET_HINT     		(0x0000)
#define SET_HINT      		(0x1000)
#define TRACE_HINT		(0x2000)
#define SNOOP_HINT   		(0x8000)
#define SERIALIZE_HINT   	(SNOOP_HINT | SET_HINT)
#define TRACE_GET_HINT 		(TRACE_HINT)
#define TRACE_SET_HINT		(SNOOP_HINT | TRACE_HINT)
#define HINT_MASK     		(0xf000)
#define SHIM_HINT	 	(RESERVED_BIT)


/*
 * Macro's to check the hints
 */
#define IS_SNOOP_BIT_SET(x) 	((x & SNOOP_HINT) == SNOOP_HINT)
#define IS_TRACE_SET_COMMAND(x)	((x & HINT_MASK) == TRACE_SET_HINT)
#define IS_TRACE_GET_COMMAND(x)	((x & HINT_MASK) == TRACE_GET_HINT)
#define NEED_TO_SERIALIZE(x) 	((x & HINT_MASK) == SERIALIZE_HINT)
#define IS_MGMT_SHIM_COMMAND(x) ((x & SHIM_HINT) == SHIM_HINT)


/* 
 * Macros to build commands from data types 
 */
#define MGMT_GET(x)    		(GET_HINT | (x & DATA_TYPE_MASK))
#define MGMT_SET(x)    		(SET_HINT | (x & DATA_TYPE_MASK))
#define SERIALIZE(x)  		(SERIALIZE_HINT | (x & DATA_TYPE_MASK))
#define GET_TRACE(x) 		(TRACE_GET_HINT | (x & DATA_TYPE_MASK))
#define SET_TRACE(x)		(TRACE_SET_HINT | (x & DATA_TYPE_MASK))
#define SHIM(x)			(SHIM_HINT | (x & DATA_TYPE_MASK))

/*
 * MGMT IOCTL error codes
 */
#define MGMT_OK									0x0000
#define MGMT_SHIM_ERROR_BAD_COMMAND				0x0001
#define MGMT_SHIM_ERROR_BAD_DFC					0x0002
#define MGMT_SHIM_ERROR_BAD_PARAMETER			0x0003
#define	MGMT_SHIM_ERROR_BAD_DEVICE				0x0004
#define MGMT_SHIM_ERROR_OUT_OF_MEMORY			0x0005
#define MGMT_SHIM_ERROR_UNKNOWN    				0x0006
#define MGMT_SHIM_ERROR_BAD_PACKET_SIZE 		0x0007
#define MGMT_SHIM_ERROR_NO_BOARDS   			0x0008
#define MGMT_SHIM_ERROR_NOT_INITIALIZED			0x0009
#define MGMT_SHIM_ERROR_OPERATION_TIMEOUT		0x000a
#define MGMT_SHIM_ERROR_INTERNAL    			0x000b
#define MGMT_SHIM_ERROR_SERIALIZE_FAIL  		0x000c
#define MGMT_SHIM_ERROR_BOARD_NON_FUNCTIONAL	0x000d
#define MGMT_SHIM_ERROR_NO_MGMT_CHAN			0x000e		/* mgmt shim has no mgmt channel open */
#define MGMT_SHIM_ERROR_REPLY_ORUN				0x000f		/* mgmt reply is larger than reply buffer */
#define MGMT_SHIM_ERROR_NO_SUCH_BOARD			0x0010		/* board referenced does not exist */
#define MGMT_SHIM_ERROR_NO_SUCH_TRACE			0x0011		/* a trace command is referenced that does not exist */
#define MGMT_SHIM_ERROR_DUPLICATE_TRACE_HANDLE	0x0012		/* a trace is attempted with an existing handle */
#define MGMT_SHIM_ERROR_CANNOT_OPEN_TRACE_CHAN	0x0013		/* unable to open a mgmt channel for the trace */

/*
 * MGMT legacy error names
 */
#define NO_MGMT_CHAN				MGMT_SHIM_ERROR_NO_MGMT_CHAN
#define REPLY_ORUN					MGMT_SHIM_ERROR_REPLY_ORUN
#define NO_SUCH_BOARD				MGMT_SHIM_ERROR_NO_SUCH_BOARD
#define NO_SUCH_TRACE				MGMT_SHIM_ERROR_NO_SUCH_TRACE
#define DUPLICATE_TRACE_HANDLE		MGMT_SHIM_ERROR_DUPLICATE_TRACE_HANDLE
#define CANNOT_OPEN_TRACE_CHAN		MGMT_SHIM_ERROR_CANNOT_OPEN_TRACE_CHAN
#define BAD_COMMAND					MGMT_SHIM_ERROR_BAD_COMMAND
#define BAD_DFC	   					MGMT_SHIM_ERROR_BAD_DFC
#define BAD_PARAMETER				MGMT_SHIM_ERROR_BAD_PARAMETER
#define	BAD_DEVICE	 				MGMT_SHIM_ERROR_BAD_DEVICE
#define OUT_OF_MEMORY				MGMT_SHIM_ERROR_OUT_OF_MEMORY

/*
 * Reserved Command Enums (DO NOT USE)
 */
#define	INTERNAL1			0x100
#define	INTERNAL2			0x101
#define	INTERNAL3			0x102
#define	INTERNAL4			0x103
#define	INTERNAL5			0x104
#define	INTERNAL6			0x105
#define	INTERNAL7			0x106
#define	INTERNAL8			0x107
#define	INTERNAL9			0x108
#define	INTERNAL10			0x109
#define	INTERNAL11			0x10A
#define	INTERNAL12			0x10B
#define	INTERNAL13			0x10C
#define	INTERNAL14			0x10D
#define	INTERNAL15			0x10E
#define	INTERNAL16			0x10F

#define SPARTACUS_INTERNAL              0xFFF

/*
 * Some common types.
 */
typedef struct 
{
	dxb_uint32 seconds;
	dxb_uint32 mseconds;
} timestamp_t ;

#define MGMTDFLT_H_INCLUDED
#endif
