
/*
 Copyright 1999 by Digi International (www.digi.com)

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2, or (at your option)
 any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY, EXPRESS OR IMPLIED; without even the
 implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
 PURPOSE.  See the GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

/*
 * mgmcmds.h
 *
 *
 * $Header: /cvs_tick/linux_dgap/include/dxb/include/mgmtcmds.h,v 1.1 2003/06/25 23:05:54 scottk Exp $
 *
 */
#ifndef _MGMTCMDS_H_

#define _MGMTCMDS_H_

/*
 * Enumerated data types, used as a base for set, get, trace commands
 *
 * Note : Occupies the lower 12 bits
 */

/*
 * Adapter Level enums
 */
#define ADAPTER_INFO			0x001
#define ADAPTER_STATE			0x002
#define MODEM_NATIONALITY		0x004
#define MGMT_PROTOCOL_VERSION		0x005
#define NVRAM_CONFIG			0x006
#define ADAPTER_EXT_INFO		0x007
#define ADAPTER_EXT_STATE		0x008

#define BLACKBOX_DATA_TRC		0x00e8
#define SET_BLACKBOX_DATA_TRC		(SET_TRACE(BLACKBOX_DATA_TRC))

/*
 * Ds1 level enums
 */
#define DS1_CONFIG			0x021
#define DS1_EXT_CONFIG			0x022
#define DS1_STATUS			0x023
#define DS1_EXT_STATUS			0x024
#define DS1_CT1_SIG_STATUS		0x025
#define DS1_ALL_CT1_SIG_STATUS		0x026
#define DS1_E1R2_CONFIG			0x027

/*
 * General enums that don't neatly fit into a given category
 */
#define BRI_AND_DCHAN_EXT_CONFIG	0x031


/*
 * Bri level enums
 */
#define BRI_CONFIG			0x041
#define BRI_STATUS			0x042

/*
 * Call status
 */
#define CALL_STATUS			0x061
#define ALL_CALL_STATUS			0x062

/*
 * Modem level enums
 */
#define MODEM_CONFIG			0x081
#define MODEM_STATUS			0x082
#define MODEM_EXT_CONFIG		0x083
#define MODEM_EXT_STATUS		0x084
#define MODEM_TX_DATA			0x085 /* doesn't really exist */
#define MODEM_RX_DATA			0x086 /* doesn't really exist */

/*
 * D Chan level enums
 */
#define DCHAN_EXT_CONFIG		0x0a1
#define DCHAN_EXT_STATUS		0x0a2
#define DCHAN_TX_DATA			0x0a3
#define DCHAN_RX_DATA			0x0a4
#define DCHAN_RXTX_DATA			0x0a5
#define DCHAN_CONFIG			0x0a6

/*
 * B Chan level enums
 */
#define BCHAN_STATUS			0x0c1
#define BCHAN_EXT_CONFIG		0x0c2
#define BCHAN_EXT_STATUS		0x0c3
#define BCHAN_TX_DATA			0x0c4
#define BCHAN_RX_DATA			0x0c5
#define BCHAN_RXTX_DATA			0x0c6

/*
 * Serial level enums
 */
#define SERIAL_STATUS			0x0e1
#define SERIAL_EXT_CONFIG		0x0e2
#define SERIAL_EXT_STATUS		0x0e3
#define SERIAL_TX_DATA			0x0e4
#define SERIAL_RX_DATA			0x0e5
#define SERIAL_CONFIG			0x0e6
#define SERIAL_RXTX_DATA		0x0e7
/* 0x0e8 was already owned by BLACKBOX_DATA_TRC */
#define SERIAL_CONNECTOR_INFO		0x0e9
#define SERIAL_DXB_CONFIG		0x0ea
#define SERIAL_CHANNEL_MODE		0x0eb
#define SERIAL_TEST_CONFIG		0x0ec
#define SERIAL_TEST_STATUS		0x0ed
#define SERIAL_TEST_EXT_CONFIG		0x0ee
#define SERIAL_DEFAULT_CONFIG		0x0ef
#define SERIAL_DEFAULT_STATUS		0x0f0
#define SERIAL_DEFAULT_DXB_CONFIG	0x0f1
#define SERIAL_CHANNEL_MANUAL_MODE	0x0f2
#define SERIAL_RS485_CONFIG		0x0f3

/* board id enum */
#define BOARDID                         0x0ff

/*
 * Adapter Level Commands
 */
#define GET_MGMT_PROTOCOL_VERSION	(MGMT_GET(MGMT_PROTOCOL_VERSION))
#define GET_ADAPTER_INFO		(MGMT_GET(ADAPTER_INFO))
#define GET_ADAPTER_STATE		(MGMT_GET(ADAPTER_STATE))
#define GET_MODEM_NATIONALITY		(MGMT_GET(MODEM_NATIONALITY))
#define SET_MODEM_NATIONALITY		(SERIALIZE(MODEM_NATIONALITY))
#define SET_NVRAM_CONFIG		(MGMT_SET(NVRAM_CONFIG))
#define GET_NVRAM_CONFIG		(MGMT_GET(NVRAM_CONFIG))
#define GET_ADAPTER_EXT_INFO		(MGMT_GET(ADAPTER_EXT_INFO))
#define GET_ADAPTER_EXT_STATE		(MGMT_GET(ADAPTER_EXT_STATE))

/*
 * DS1 Level Commands
 */
#define GET_DS1_CONFIG			(MGMT_GET(DS1_CONFIG))
#define SET_DS1_CONFIG			(SERIALIZE(DS1_CONFIG))
/* Serialize assumes a set */
#define SET_DS1_CONFIG_TRC		(SET_TRACE(DS1_CONFIG))
#define GET_DS1_CONFIG_TRC		(GET_TRACE(DS1_CONFIG))

#define GET_DS1_EXT_CONFIG		(MGMT_GET(DS1_EXT_CONFIG))
#define SET_DS1_EXT_CONFIG		(MGMT_SET(DS1_EXT_CONFIG))
#define SET_DS1_EXT_CONFIG_TRC		(SET_TRACE(DS1_EXT_CONFIG))
#define GET_DS1_EXT_CONFIG_TRC		(GET_TRACE(DS1_EXT_CONFIG))

#define GET_DS1_STATUS			(MGMT_GET(DS1_STATUS))
#define SET_DS1_STATUS_TRC		(SET_TRACE(DS1_STATUS))
#define GET_DS1_STATUS_TRC		(GET_TRACE(DS1_STATUS))

#define GET_DS1_EXT_STATUS		(MGMT_GET(DS1_EXT_STATUS))
#define SET_DS1_EXT_STATUS_TRC		(SET_TRACE(DS1_EXT_STATUS))
#define GET_DS1_EXT_STATUS_TRC		(GET_TRACE(DS1_EXT_STATUS))

#define GET_DS1_CT1_SIG_STATUS		(MGMT_GET(DS1_CT1_SIG_STATUS))
#define GET_DS1_ALL_CT1_SIG_STATUS	(MGMT_GET(DS1_ALL_CT1_SIG_STATUS))

#define GET_DS1_E1R2_CONFIG		(MGMT_GET(DS1_E1R2_CONFIG))
#define SET_DS1_E1R2_CONFIG		(SERIALIZE(DS1_E1R2_CONFIG))
/* Serialize assumes a set */
#define SET_DS1_E1R2_CONFIG_TRC		(SET_TRACE(DS1_E1R2_CONFIG))
#define GET_DS1_E1R2_CONFIG_TRC		(GET_TRACE(DS1_E1R2_CONFIG))

/*
 * Bri level commands
 */
#define GET_BRI_CONFIG			(MGMT_GET(BRI_CONFIG))
#define SET_BRI_CONFIG			(SERIALIZE(BRI_CONFIG))
#define GET_BRI_STATUS			(MGMT_GET(BRI_STATUS))
#define GET_BRI_CONFIG_TRC		(GET_TRACE(BRI_CONFIG))
#define SET_BRI_CONFIG_TRC		(SET_TRACE(BRI_CONFIG))
#define GET_BRI_STATUS_TRC		(GET_TRACE(BRI_STATUS))
#define SET_BRI_STATUS_TRC		(SET_TRACE(BRI_STATUS))

/*
 * Serial level commands
 */
#define GET_SERIAL_CONFIG		(MGMT_GET(SERIAL_CONFIG))
#define SET_SERIAL_CONFIG		(SERIALIZE(SERIAL_CONFIG))
#define GET_SERIAL_STATUS		(MGMT_GET(SERIAL_STATUS))
#define GET_SERIAL_EXT_CONFIG		(MGMT_GET(SERIAL_EXT_CONFIG))
#define SET_SERIAL_EXT_CONFIG		(MGMT_SET(SERIAL_EXT_CONFIG))
#define GET_SERIAL_EXT_STATUS		(MGMT_GET(SERIAL_EXT_STATUS))

#define GET_SERIAL_CONNECTOR_INFO	(MGMT_GET(SERIAL_CONNECTOR_INFO))
#define SET_SERIAL_CONNECTOR_INFO	(MGMT_SET(SERIAL_CONNECTOR_INFO))
#define GET_SERIAL_DXB_CONFIG		(MGMT_GET(SERIAL_DXB_CONFIG))
#define SET_SERIAL_DXB_CONFIG		(MGMT_SET(SERIAL_DXB_CONFIG))
#define GET_SERIAL_CHANNEL_MODE		(MGMT_GET(SERIAL_CHANNEL_MODE))
#define SET_SERIAL_CHANNEL_MODE		(MGMT_SET(SERIAL_CHANNEL_MODE))
#define GET_SERIAL_TEST_RESULTS		(MGMT_GET(SERIAL_CHANNEL_MODE))
#define SET_SERIAL_CHANNEL_MANUAL_MODE	(MGMT_SET(SERIAL_CHANNEL_MANUAL_MODE))

#define GET_SERIAL_TEST_CONFIG		(MGMT_GET(SERIAL_TEST_CONFIG))
#define SET_SERIAL_TEST_CONFIG		(MGMT_SET(SERIAL_TEST_CONFIG))
#define GET_SERIAL_TEST_STATUS		(MGMT_GET(SERIAL_TEST_STATUS))
#define SET_SERIAL_TEST_STATUS		(MGMT_SET(SERIAL_TEST_STATUS))
#define GET_SERIAL_TEST_EXT_CONFIG	(MGMT_GET(SERIAL_TEST_EXT_CONFIG))
#define SET_SERIAL_TEST_EXT_CONFIG	(MGMT_SET(SERIAL_TEST_EXT_CONFIG))

#define GET_SERIAL_DEFAULT_CONFIG	(MGMT_GET(SERIAL_DEFAULT_CONFIG))
#define SET_SERIAL_DEFAULT_CONFIG	(MGMT_SET(SERIAL_DEFAULT_CONFIG))
#define GET_SERIAL_DEFAULT_STATUS	(MGMT_GET(SERIAL_DEFAULT_STATUS))
#define SET_SERIAL_DEFAULT_STATUS	(MGMT_SET(SERIAL_DEFAULT_STATUS))
#define GET_SERIAL_DEFAULT_DXB_CONFIG	(MGMT_GET(SERIAL_DEFAULT_DXB_CONFIG))
#define SET_SERIAL_DEFAULT_DXB_CONFIG	(MGMT_SET(SERIAL_DEFAULT_DXB_CONFIG))

#define GET_SERIAL_CONFIG_TRC		(GET_TRACE(SERIAL_CONFIG))
#define SET_SERIAL_CONFIG_TRC		(SET_TRACE(SERIAL_CONFIG))
#define GET_SERIAL_STATUS_TRC		(GET_TRACE(SERIAL_STATUS))
#define SET_SERIAL_STATUS_TRC		(SET_TRACE(SERIAL_STATUS))
#define GET_SERIAL_EXT_CONFIG_TRC	(GET_TRACE(SERIAL_EXT_CONFIG))
#define SET_SERIAL_EXT_CONFIG_TRC	(SET_TRACE(SERIAL_EXT_CONFIG))
#define GET_SERIAL_EXT_STATUS_TRC	(GET_TRACE(SERIAL_EXT_STATUS))
#define SET_SERIAL_EXT_STATUS_TRC	(SET_TRACE(SERIAL_EXT_STATUS))

#define GET_SERIAL_TX_DATA_TRC		(GET_TRACE(SERIAL_TX_DATA))
#define SET_SERIAL_TX_DATA_TRC		(SET_TRACE(SERIAL_TX_DATA))
#define GET_SERIAL_RX_DATA_TRC		(GET_TRACE(SERIAL_RX_DATA))
#define SET_SERIAL_RX_DATA_TRC		(SET_TRACE(SERIAL_RX_DATA))
#define SET_SERIAL_RXTX_DATA_TRC	(SET_TRACE(SERIAL_RXTX_DATA))

#define GET_SERIAL_RS485_CONFIG		(MGMT_GET(SERIAL_RS485_CONFIG))
#define SET_SERIAL_RS485_CONFIG		(MGMT_SET(SERIAL_RS485_CONFIG))

/*
 * Call status command
 */
#define GET_CALL_STATUS			(MGMT_GET(CALL_STATUS))
#define GET_CALL_STATUS_TRC		(GET_TRACE(CALL_STATUS))
#define SET_CALL_STATUS_TRC		(SET_TRACE(CALL_STATUS))

#define GET_ALL_CALL_STATUS		(MGMT_GET(ALL_CALL_STATUS))

/*
 * Modem level commands
 */
#define GET_MODEM_CONFIG		(MGMT_GET(MODEM_CONFIG))
#define SET_MODEM_CONFIG		(MGMT_SET(MODEM_CONFIG))
#define GET_MODEM_CONFIG_TRC		(GET_TRACE(MODEM_CONFIG))
#define SET_MODEM_CONFIG_TRC		(SET_TRACE(MODEM_CONFIG))

#define GET_MODEM_STATUS		(MGMT_GET(MODEM_STATUS))
#define GET_MODEM_STATUS_TRC		(GET_TRACE(MODEM_STATUS))
#define SET_MODEM_STATUS_TRC		(SET_TRACE(MODEM_STATUS))

#define GET_MODEM_EXT_CONFIG		(MGMT_GET(MODEM_EXT_CONFIG))
#define SET_MODEM_EXT_CONFIG		(MGMT_SET(MODEM_EXT_CONFIG))
#define GET_MODEM_EXT_CONFIG_TRC	(GET_TRACE(MODEM_EXT_CONFIG))
#define SET_MODEM_EXT_CONFIG_TRC	(SET_TRACE(MODEM_EXT_CONFIG))

#define GET_MODEM_EXT_STATUS		(MGMT_GET(MODEM_EXT_STATUS))
#define GET_MODEM_EXT_STATUS_TRC	(GET_TRACE(MODEM_EXT_STATUS))
#define SET_MODEM_EXT_STATUS_TRC	(SET_TRACE(MODEM_EXT_STATUS))

/*
 * D Chan level commands
 */
#define GET_DCHAN_CONFIG		(MGMT_GET(DCHAN_CONFIG))
#define SET_DCHAN_CONFIG		(SERIALIZE(DCHAN_CONFIG))
#define GET_DCHAN_EXT_CONFIG		(MGMT_GET(DCHAN_EXT_CONFIG))
#define SET_DCHAN_EXT_CONFIG		(SERIALIZE(DCHAN_EXT_CONFIG))
#define GET_DCHAN_EXT_CONFIG_TRC	(GET_TRACE(DCHAN_EXT_CONFIG))
#define SET_DCHAN_EXT_CONFIG_TRC	(SET_TRACE(DCHAN_EXT_CONFIG))

#define GET_DCHAN_EXT_STATUS		(MGMT_GET(DCHAN_EXT_STATUS))
#define GET_DCHAN_EXT_STATUS_TRC	(GET_TRACE(DCHAN_EXT_STATUS))
#define SET_DCHAN_EXT_STATUS_TRC	(SET_TRACE(DCHAN_EXT_STATUS))

#define GET_DCHAN_DATA_TRC		(GET_TRACE(DCHAN_RXTX_DATA))
#define SET_DCHAN_DATA_TRC		(SET_TRACE(DCHAN_RXTX_DATA))
#define GET_DCHAN_TX_DATA_TRC		(GET_TRACE(DCHAN_TX_DATA))
#define SET_DCHAN_TX_DATA_TRC		(SET_TRACE(DCHAN_TX_DATA))
#define GET_DCHAN_RX_DATA_TRC		(GET_TRACE(DCHAN_RX_DATA))
#define SET_DCHAN_RX_DATA_TRC		(SET_TRACE(DCHAN_RX_DATA))

/*
 * B Chan Level Commands
 */
#define GET_BCHAN_STATUS		(MGMT_GET(BCHAN_STATUS))
#define GET_BCHAN_STATUS_TRC		(GET_TRACE(BCHAN_STATUS))
#define SET_BCHAN_STATUS_TRC		(SET_TRACE(BCHAN_STATUS))

#define GET_BCHAN_EXT_CONFIG		(MGMT_GET(BCHAN_EXT_CONFIG))
#define SET_BCHAN_EXT_CONFIG		(MGMT_SET(BCHAN_EXT_CONFIG))
#define GET_BCHAN_EXT_CONFIG_TRC	(GET_TRACE(BCHAN_EXT_CONFIG))
#define SET_BCHAN_EXT_CONFIG_TRC	(SET_TRACE(BCHAN_EXT_CONFIG))

#define GET_BCHAN_EXT_STATUS		(MGMT_GET(BCHAN_EXT_STATUS))
#define GET_BCHAN_EXT_STATUS_TRC	(GET_TRACE(BCHAN_EXT_STATUS))
#define SET_BCHAN_EXT_STATUS_TRC	(SET_TRACE(BCHAN_EXT_STATUS))

#define GET_BCHAN_TX_DATA_TRC		(GET_TRACE(BCHAN_TX_DATA))
#define SET_BCHAN_TX_DATA_TRC		(SET_TRACE(BCHAN_TX_DATA))
#define GET_BCHAN_RX_DATA_TRC		(GET_TRACE(BCHAN_RX_DATA))
#define SET_BCHAN_RX_DATA_TRC		(SET_TRACE(BCHAN_RX_DATA))
#define SET_BCHAN_RXTX_DATA_TRC		(SET_TRACE(BCHAN_RXTX_DATA))

/*
 * Board ID Level Command
 */
#define SET_BOARDID                     (MGMT_SET(BOARDID))
#endif

/* TODO: MPI CHANGES Any new commands needed for controlling MPI? */
