
/*
 Copyright 1999-2000 by Digi International (www.digi.com)

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2, or (at your option)
 any later version.
 
 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY, EXPRESS OR IMPLIED; without even the 
 implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
 PURPOSE.  See the GNU General Public License for more details.
 
 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

/*
 * mgmtcc.h
 *
 */
/*
 * GET_MODEM_NATIONALITY and SET_MODEM_NATIONALITY defines
 *
 * ISO 3166 Country Codes
 *
 * $Id: mgmtcc.h,v 1.1 2003/06/25 23:05:54 scottk Exp $
 */
#ifndef MGMTCC_H_DEFINED
#define MGMTCC_H_DEFINED

#define MAKE_COUNTRY_CODE(c1, c2)		((c1 << 8) | c2)

#define COUNTRY_CODE_AFGHANISTAN                     MAKE_COUNTRY_CODE('A', 'F')
#define COUNTRY_CODE_ALBANIA                         MAKE_COUNTRY_CODE('A', 'L')
#define COUNTRY_CODE_ALGERIA                         MAKE_COUNTRY_CODE('D', 'Z')
#define COUNTRY_CODE_AMERICAN_SAMOA                  MAKE_COUNTRY_CODE('A', 'S')
#define COUNTRY_CODE_ANDORRA                         MAKE_COUNTRY_CODE('A', 'D')
#define COUNTRY_CODE_ANGOLA                          MAKE_COUNTRY_CODE('A', 'O')
#define COUNTRY_CODE_ANGUILLA                        MAKE_COUNTRY_CODE('A', 'I')
#define COUNTRY_CODE_ANTARCTICA                      MAKE_COUNTRY_CODE('A', 'Q')
#define COUNTRY_CODE_ANTIGUA_AND_BARBUDA             MAKE_COUNTRY_CODE('A', 'G')
#define COUNTRY_CODE_ARGENTINA                       MAKE_COUNTRY_CODE('A', 'R')
#define COUNTRY_CODE_ARMENIA                         MAKE_COUNTRY_CODE('A', 'M')
#define COUNTRY_CODE_ARUBA                           MAKE_COUNTRY_CODE('A', 'W')
#define COUNTRY_CODE_AUSTRALIA                       MAKE_COUNTRY_CODE('A', 'U')
#define COUNTRY_CODE_AUSTRIA                         MAKE_COUNTRY_CODE('A', 'T')
#define COUNTRY_CODE_AZERBAIJAN                      MAKE_COUNTRY_CODE('A', 'Z')
#define COUNTRY_CODE_BAHAMAS                         MAKE_COUNTRY_CODE('B', 'S')
#define COUNTRY_CODE_BAHRAIN                         MAKE_COUNTRY_CODE('B', 'H')
#define COUNTRY_CODE_BANGLADESH                      MAKE_COUNTRY_CODE('B', 'D')
#define COUNTRY_CODE_BARBADOS                        MAKE_COUNTRY_CODE('B', 'B')
#define COUNTRY_CODE_BELARUS                         MAKE_COUNTRY_CODE('B', 'Y')
#define COUNTRY_CODE_BELGIUM                         MAKE_COUNTRY_CODE('B', 'E')
#define COUNTRY_CODE_BELIZE                          MAKE_COUNTRY_CODE('B', 'Z')
#define COUNTRY_CODE_BENIN                           MAKE_COUNTRY_CODE('B', 'J')
#define COUNTRY_CODE_BERMUDA                         MAKE_COUNTRY_CODE('B', 'M')
#define COUNTRY_CODE_BHUTAN                          MAKE_COUNTRY_CODE('B', 'T')
#define COUNTRY_CODE_BOLIVIA                         MAKE_COUNTRY_CODE('B', 'O')
#define COUNTRY_CODE_BOSNIA_AND_HERZEGOWINA          MAKE_COUNTRY_CODE('B', 'A')
#define COUNTRY_CODE_BOTSWANA                        MAKE_COUNTRY_CODE('B', 'W')
#define COUNTRY_CODE_BOUVET_ISLAND                   MAKE_COUNTRY_CODE('B', 'V')
#define COUNTRY_CODE_BRAZIL                          MAKE_COUNTRY_CODE('B', 'R')
#define COUNTRY_CODE_BRITISH_INDIAN_OCEAN_TERRITORY  MAKE_COUNTRY_CODE('I', 'O')
#define COUNTRY_CODE_BRUNEI_DARUSSALAM               MAKE_COUNTRY_CODE('B', 'N')
#define COUNTRY_CODE_BULGARIA                        MAKE_COUNTRY_CODE('B', 'G')
#define COUNTRY_CODE_BURKINA_FASO                    MAKE_COUNTRY_CODE('B', 'F')
#define COUNTRY_CODE_BURUNDI                         MAKE_COUNTRY_CODE('B', 'I')
#define COUNTRY_CODE_CAMBODIA                        MAKE_COUNTRY_CODE('K', 'H')
#define COUNTRY_CODE_CAMEROON                        MAKE_COUNTRY_CODE('C', 'M')
#define COUNTRY_CODE_CANADA                          MAKE_COUNTRY_CODE('C', 'A')
#define COUNTRY_CODE_CAPE_VERDE                      MAKE_COUNTRY_CODE('C', 'V')
#define COUNTRY_CODE_CAYMAN_ISLANDS                  MAKE_COUNTRY_CODE('K', 'Y')
#define COUNTRY_CODE_CENTRAL_AFRICAN_REPUBLIC        MAKE_COUNTRY_CODE('C', 'F')
#define COUNTRY_CODE_CHAD                            MAKE_COUNTRY_CODE('T', 'D')
#define COUNTRY_CODE_CHILE                           MAKE_COUNTRY_CODE('C', 'L')
#define COUNTRY_CODE_CHINA                           MAKE_COUNTRY_CODE('C', 'N')
#define COUNTRY_CODE_CHRISTMAS_ISLAND                MAKE_COUNTRY_CODE('C', 'X')
#define COUNTRY_CODE_COCOS_ISLANDS                   MAKE_COUNTRY_CODE('C', 'C') /* KEELING */
#define COUNTRY_CODE_COLOMBIA                        MAKE_COUNTRY_CODE('C', 'O')
#define COUNTRY_CODE_COMOROS                         MAKE_COUNTRY_CODE('K', 'M')
#define COUNTRY_CODE_CONGO                           MAKE_COUNTRY_CODE('C', 'G')
#define COUNTRY_CODE_CONGO_DEMOCRATIC_REPUBLIC_OF    MAKE_COUNTRY_CODE('C', 'D') /* THE DEMOCRATIC REPUBLIC OF THE */
#define COUNTRY_CODE_COOK_ISLANDS                    MAKE_COUNTRY_CODE('C', 'K')
#define COUNTRY_CODE_COSTA_RICA                      MAKE_COUNTRY_CODE('C', 'R')
#define COUNTRY_CODE_COTE_D_IVOIRE                   MAKE_COUNTRY_CODE('C', 'I')
#define COUNTRY_CODE_CROATIA                         MAKE_COUNTRY_CODE('H', 'R') /* (local name: Hrvatska) */
#define COUNTRY_CODE_CUBA                            MAKE_COUNTRY_CODE('C', 'U')
#define COUNTRY_CODE_CYPRUS                          MAKE_COUNTRY_CODE('C', 'Y')
#define COUNTRY_CODE_CZECH_REPUBLIC                  MAKE_COUNTRY_CODE('C', 'Z')
#define COUNTRY_CODE_DENMARK                         MAKE_COUNTRY_CODE('D', 'K')
#define COUNTRY_CODE_DJIBOUTI                        MAKE_COUNTRY_CODE('D', 'J')
#define COUNTRY_CODE_DOMINICA                        MAKE_COUNTRY_CODE('D', 'M')
#define COUNTRY_CODE_DOMINICAN_REPUBLIC              MAKE_COUNTRY_CODE('D', 'O')
#define COUNTRY_CODE_EAST_TIMOR                      MAKE_COUNTRY_CODE('T', 'P')
#define COUNTRY_CODE_ECUADOR                         MAKE_COUNTRY_CODE('E', 'C')
#define COUNTRY_CODE_EGYPT                           MAKE_COUNTRY_CODE('E', 'G')
#define COUNTRY_CODE_EL_SALVADOR                     MAKE_COUNTRY_CODE('S', 'V')
#define COUNTRY_CODE_EQUATORIAL_GUINEA               MAKE_COUNTRY_CODE('G', 'Q')
#define COUNTRY_CODE_ERITREA                         MAKE_COUNTRY_CODE('E', 'R')
#define COUNTRY_CODE_ESTONIA                         MAKE_COUNTRY_CODE('E', 'E')
#define COUNTRY_CODE_ETHIOPIA                        MAKE_COUNTRY_CODE('E', 'T')
#define COUNTRY_CODE_FALKLAND_ISLANDS                MAKE_COUNTRY_CODE('F', 'K') /* (MALVINAS) */
#define COUNTRY_CODE_FAROE_ISLANDS                   MAKE_COUNTRY_CODE('F', 'O')
#define COUNTRY_CODE_FIJI                            MAKE_COUNTRY_CODE('F', 'J')
#define COUNTRY_CODE_FINLAND                         MAKE_COUNTRY_CODE('F', 'I')
#define COUNTRY_CODE_FRANCE                          MAKE_COUNTRY_CODE('F', 'R')
#define COUNTRY_CODE_FRENCH_GUIANA                   MAKE_COUNTRY_CODE('G', 'F')
#define COUNTRY_CODE_FRENCH_POLYNESIA                MAKE_COUNTRY_CODE('P', 'F')
#define COUNTRY_CODE_FRENCH_SOUTHERN_TERRITORIES     MAKE_COUNTRY_CODE('T', 'F')
#define COUNTRY_CODE_GABON                           MAKE_COUNTRY_CODE('G', 'A')
#define COUNTRY_CODE_GAMBIA                          MAKE_COUNTRY_CODE('G', 'M')
#define COUNTRY_CODE_GEORGIA                         MAKE_COUNTRY_CODE('G', 'E')
#define COUNTRY_CODE_GERMANY                         MAKE_COUNTRY_CODE('D', 'E')
#define COUNTRY_CODE_GHANA                           MAKE_COUNTRY_CODE('G', 'H')
#define COUNTRY_CODE_GIBRALTAR                       MAKE_COUNTRY_CODE('G', 'I')
#define COUNTRY_CODE_GREECE                          MAKE_COUNTRY_CODE('G', 'R')
#define COUNTRY_CODE_GREENLAND                       MAKE_COUNTRY_CODE('G', 'L')
#define COUNTRY_CODE_GRENADA                         MAKE_COUNTRY_CODE('G', 'D')
#define COUNTRY_CODE_GUADELOUPE                      MAKE_COUNTRY_CODE('G', 'P')
#define COUNTRY_CODE_GUAM                            MAKE_COUNTRY_CODE('G', 'U')
#define COUNTRY_CODE_GUATEMALA                       MAKE_COUNTRY_CODE('G', 'T')
#define COUNTRY_CODE_GUINEA                          MAKE_COUNTRY_CODE('G', 'N')
#define COUNTRY_CODE_GUINEA_BISSAU                   MAKE_COUNTRY_CODE('G', 'W')
#define COUNTRY_CODE_GUYANA                          MAKE_COUNTRY_CODE('G', 'Y')
#define COUNTRY_CODE_HAITI                           MAKE_COUNTRY_CODE('H', 'T')
#define COUNTRY_CODE_HEARD_AND_MCDONALD_ISLANDS      MAKE_COUNTRY_CODE('H', 'M')
#define COUNTRY_CODE_HOLY_SEE                        MAKE_COUNTRY_CODE('V', 'A') /* (VATICAN CITY STATE) */
#define COUNTRY_CODE_HONDURAS                        MAKE_COUNTRY_CODE('H', 'N')
#define COUNTRY_CODE_HONG_KONG                       MAKE_COUNTRY_CODE('H', 'K')
#define COUNTRY_CODE_HUNGARY                         MAKE_COUNTRY_CODE('H', 'U')
#define COUNTRY_CODE_ICELAND                         MAKE_COUNTRY_CODE('I', 'S')
#define COUNTRY_CODE_INDIA                           MAKE_COUNTRY_CODE('I', 'N')
#define COUNTRY_CODE_INDONESIA                       MAKE_COUNTRY_CODE('I', 'D')
#define COUNTRY_CODE_IRAN                            MAKE_COUNTRY_CODE('I', 'R') /* (ISLAMIC REPUBLIC OF) */
#define COUNTRY_CODE_IRAQ                            MAKE_COUNTRY_CODE('I', 'Q')
#define COUNTRY_CODE_IRELAND                         MAKE_COUNTRY_CODE('I', 'E')
#define COUNTRY_CODE_ISRAEL                          MAKE_COUNTRY_CODE('I', 'L')
#define COUNTRY_CODE_ITALY                           MAKE_COUNTRY_CODE('I', 'T')
#define COUNTRY_CODE_JAMAICA                         MAKE_COUNTRY_CODE('J', 'M')
#define COUNTRY_CODE_JAPAN                           MAKE_COUNTRY_CODE('J', 'P')
#define COUNTRY_CODE_JORDAN                          MAKE_COUNTRY_CODE('J', 'O')
#define COUNTRY_CODE_KAZAKHSTAN                      MAKE_COUNTRY_CODE('K', 'Z')
#define COUNTRY_CODE_KENYA                           MAKE_COUNTRY_CODE('K', 'E')
#define COUNTRY_CODE_KIRIBATI                        MAKE_COUNTRY_CODE('K', 'I')
#define COUNTRY_CODE_KOREA_DEMOCRATIC_PEOPLES_REPUBLIC_OF  MAKE_COUNTRY_CODE('K', 'P')
#define COUNTRY_CODE_KOREA_REPUBLIC_OF               MAKE_COUNTRY_CODE('K', 'R')
#define COUNTRY_CODE_KUWAIT                          MAKE_COUNTRY_CODE('K', 'W')
#define COUNTRY_CODE_KYRGYZSTAN                      MAKE_COUNTRY_CODE('K', 'G')
#define COUNTRY_CODE_LAO_PEOPLES_DEMOCRATIC_REPUBLIC MAKE_COUNTRY_CODE('L', 'A')
#define COUNTRY_CODE_LATVIA                          MAKE_COUNTRY_CODE('L', 'V')
#define COUNTRY_CODE_LEBANON                         MAKE_COUNTRY_CODE('L', 'B')
#define COUNTRY_CODE_LESOTHO                         MAKE_COUNTRY_CODE('L', 'S')
#define COUNTRY_CODE_LIBERIA                         MAKE_COUNTRY_CODE('L', 'R')
#define COUNTRY_CODE_LIBYAN_ARAB_JAMAHIRIYA          MAKE_COUNTRY_CODE('L', 'Y')
#define COUNTRY_CODE_LIECHTENSTEIN                   MAKE_COUNTRY_CODE('L', 'I')
#define COUNTRY_CODE_LITHUANIA                       MAKE_COUNTRY_CODE('L', 'T')
#define COUNTRY_CODE_LUXEMBOURG                      MAKE_COUNTRY_CODE('L', 'U')
#define COUNTRY_CODE_MACAU                           MAKE_COUNTRY_CODE('M', 'O')
#define COUNTRY_CODE_MACEDONIA_THE_FORMER_YUGOSLAV_REPUBLIC_OF  MAKE_COUNTRY_CODE('M', 'K')
#define COUNTRY_CODE_MADAGASCAR                      MAKE_COUNTRY_CODE('M', 'G')
#define COUNTRY_CODE_MALAWI                          MAKE_COUNTRY_CODE('M', 'W')
#define COUNTRY_CODE_MALAYSIA                        MAKE_COUNTRY_CODE('M', 'Y')
#define COUNTRY_CODE_MALDIVES                        MAKE_COUNTRY_CODE('M', 'V')
#define COUNTRY_CODE_MALI                            MAKE_COUNTRY_CODE('M', 'L')
#define COUNTRY_CODE_MALTA                           MAKE_COUNTRY_CODE('M', 'T')
#define COUNTRY_CODE_MARSHALL_ISLANDS                MAKE_COUNTRY_CODE('M', 'H')
#define COUNTRY_CODE_MARTINIQUE                      MAKE_COUNTRY_CODE('M', 'Q')
#define COUNTRY_CODE_MAURITANIA                      MAKE_COUNTRY_CODE('M', 'R')
#define COUNTRY_CODE_MAURITIUS                       MAKE_COUNTRY_CODE('M', 'U')
#define COUNTRY_CODE_MAYOTTE                         MAKE_COUNTRY_CODE('Y', 'T')
#define COUNTRY_CODE_MEXICO                          MAKE_COUNTRY_CODE('M', 'X')
#define COUNTRY_CODE_MICRONESIA_FEDERATED_STATES_OF  MAKE_COUNTRY_CODE('F', 'M')
#define COUNTRY_CODE_MOLDOVA_REPUBLIC_OF             MAKE_COUNTRY_CODE('M', 'D')
#define COUNTRY_CODE_MONACO                          MAKE_COUNTRY_CODE('M', 'C')
#define COUNTRY_CODE_MONGOLIA                        MAKE_COUNTRY_CODE('M', 'N')
#define COUNTRY_CODE_MONTSERRAT                      MAKE_COUNTRY_CODE('M', 'S')
#define COUNTRY_CODE_MOROCCO                         MAKE_COUNTRY_CODE('M', 'A')
#define COUNTRY_CODE_MOZAMBIQUE                      MAKE_COUNTRY_CODE('M', 'Z')
#define COUNTRY_CODE_MYANMAR                         MAKE_COUNTRY_CODE('M', 'M')
#define COUNTRY_CODE_NAMIBIA                         MAKE_COUNTRY_CODE('N', 'A')
#define COUNTRY_CODE_NAURU                           MAKE_COUNTRY_CODE('N', 'R')
#define COUNTRY_CODE_NEPAL                           MAKE_COUNTRY_CODE('N', 'P')
#define COUNTRY_CODE_NETHERLANDS                     MAKE_COUNTRY_CODE('N', 'L')
#define COUNTRY_CODE_NETHERLANDS_ANTILLES            MAKE_COUNTRY_CODE('A', 'N')
#define COUNTRY_CODE_NEW_CALEDONIA                   MAKE_COUNTRY_CODE('N', 'C')
#define COUNTRY_CODE_NEW_ZEALAND                     MAKE_COUNTRY_CODE('N', 'Z')
#define COUNTRY_CODE_NICARAGUA                       MAKE_COUNTRY_CODE('N', 'I')
#define COUNTRY_CODE_NIGER                           MAKE_COUNTRY_CODE('N', 'E')
#define COUNTRY_CODE_NIGERIA                         MAKE_COUNTRY_CODE('N', 'G')
#define COUNTRY_CODE_NIUE                            MAKE_COUNTRY_CODE('N', 'U')
#define COUNTRY_CODE_NORFOLK_ISLAND                  MAKE_COUNTRY_CODE('N', 'F')
#define COUNTRY_CODE_NORTHERN_MARIANA_ISLANDS        MAKE_COUNTRY_CODE('M', 'P')
#define COUNTRY_CODE_NORWAY                          MAKE_COUNTRY_CODE('N', 'O')
#define COUNTRY_CODE_OMAN                            MAKE_COUNTRY_CODE('O', 'M')
#define COUNTRY_CODE_PAKISTAN                        MAKE_COUNTRY_CODE('P', 'K')
#define COUNTRY_CODE_PALAU                           MAKE_COUNTRY_CODE('P', 'W')
#define COUNTRY_CODE_PANAMA                          MAKE_COUNTRY_CODE('P', 'A')
#define COUNTRY_CODE_PAPUA_NEW_GUINEA                MAKE_COUNTRY_CODE('P', 'G')
#define COUNTRY_CODE_PARAGUAY                        MAKE_COUNTRY_CODE('P', 'Y')
#define COUNTRY_CODE_PERU                            MAKE_COUNTRY_CODE('P', 'E')
#define COUNTRY_CODE_PHILIPPINES                     MAKE_COUNTRY_CODE('P', 'H')
#define COUNTRY_CODE_PITCAIRN                        MAKE_COUNTRY_CODE('P', 'N')
#define COUNTRY_CODE_POLAND                          MAKE_COUNTRY_CODE('P', 'L')
#define COUNTRY_CODE_PORTUGAL                        MAKE_COUNTRY_CODE('P', 'T')
#define COUNTRY_CODE_PUERTO_RICO                     MAKE_COUNTRY_CODE('P', 'R')
#define COUNTRY_CODE_QATAR                           MAKE_COUNTRY_CODE('Q', 'A')
#define COUNTRY_CODE_REUNION                         MAKE_COUNTRY_CODE('R', 'E')
#define COUNTRY_CODE_ROMANIA                         MAKE_COUNTRY_CODE('R', 'O')
#define COUNTRY_CODE_RUSSIAN_FEDERATION              MAKE_COUNTRY_CODE('R', 'U')
#define COUNTRY_CODE_RWANDA                          MAKE_COUNTRY_CODE('R', 'W')
#define COUNTRY_CODE_SAINT_HELENA                    MAKE_COUNTRY_CODE('S', 'H')
#define COUNTRY_CODE_SAINT_KITTS_AND_NEVIS           MAKE_COUNTRY_CODE('K', 'N')
#define COUNTRY_CODE_SAINT_LUCIA                     MAKE_COUNTRY_CODE('L', 'C')
#define COUNTRY_CODE_SAINT_PIERRE_AND_MIQUELON       MAKE_COUNTRY_CODE('P', 'M')
#define COUNTRY_CODE_SAINT_VINCENT_AND_THE_GRENADINES  MAKE_COUNTRY_CODE('V', 'C')
#define COUNTRY_CODE_SAMOA                           MAKE_COUNTRY_CODE('W', 'S')
#define COUNTRY_CODE_SAN_MARINO                      MAKE_COUNTRY_CODE('S', 'M')
#define COUNTRY_CODE_SAO_TOME_AND_PRINCIPE           MAKE_COUNTRY_CODE('S', 'T')
#define COUNTRY_CODE_SAUDI_ARABIA                    MAKE_COUNTRY_CODE('S', 'A')
#define COUNTRY_CODE_SENEGAL                         MAKE_COUNTRY_CODE('S', 'N')
#define COUNTRY_CODE_SEYCHELLES                      MAKE_COUNTRY_CODE('S', 'C')
#define COUNTRY_CODE_SIERRA_LEONE                    MAKE_COUNTRY_CODE('S', 'L')
#define COUNTRY_CODE_SINGAPORE                       MAKE_COUNTRY_CODE('S', 'G')
#define COUNTRY_CODE_SLOVAKIA                        MAKE_COUNTRY_CODE('S', 'K') /* (Slovak Republic) */
#define COUNTRY_CODE_SLOVENIA                        MAKE_COUNTRY_CODE('S', 'I')
#define COUNTRY_CODE_SOLOMON_ISLANDS                 MAKE_COUNTRY_CODE('S', 'B')
#define COUNTRY_CODE_SOMALIA                         MAKE_COUNTRY_CODE('S', 'O')
#define COUNTRY_CODE_SOUTH_AFRICA                    MAKE_COUNTRY_CODE('Z', 'A')
#define COUNTRY_CODE_SOUTH_GEORGIA_AND_THE_SOUTH_SANDWICH_ISLANDS  MAKE_COUNTRY_CODE('G', 'S')
#define COUNTRY_CODE_SPAIN                           MAKE_COUNTRY_CODE('E', 'S')
#define COUNTRY_CODE_SRI_LANKA                       MAKE_COUNTRY_CODE('L', 'K')
#define COUNTRY_CODE_SUDAN                           MAKE_COUNTRY_CODE('S', 'D')
#define COUNTRY_CODE_SURINAME                        MAKE_COUNTRY_CODE('S', 'R')
#define COUNTRY_CODE_SVALBARD_AND_JAN_MAYEN_ISLANDS  MAKE_COUNTRY_CODE('S', 'J')
#define COUNTRY_CODE_SWAZILAND                       MAKE_COUNTRY_CODE('S', 'Z')
#define COUNTRY_CODE_SWEDEN                          MAKE_COUNTRY_CODE('S', 'E')
#define COUNTRY_CODE_SWITZERLAND                     MAKE_COUNTRY_CODE('C', 'H')
#define COUNTRY_CODE_SYRIAN_ARAB_REPUBLIC            MAKE_COUNTRY_CODE('S', 'Y')
#define COUNTRY_CODE_TAIWAN_PROVINCE_OF_CHINA        MAKE_COUNTRY_CODE('T', 'W')
#define COUNTRY_CODE_TAJIKISTAN                      MAKE_COUNTRY_CODE('T', 'J')
#define COUNTRY_CODE_TANZANIA_UNITED_REPUBLIC_OF     MAKE_COUNTRY_CODE('T', 'Z')
#define COUNTRY_CODE_THAILAND                        MAKE_COUNTRY_CODE('T', 'H')
#define COUNTRY_CODE_TOGO                            MAKE_COUNTRY_CODE('T', 'G')
#define COUNTRY_CODE_TOKELAU                         MAKE_COUNTRY_CODE('T', 'K')
#define COUNTRY_CODE_TONGA                           MAKE_COUNTRY_CODE('T', 'O')
#define COUNTRY_CODE_TRINIDAD_AND_TOBAGO             MAKE_COUNTRY_CODE('T', 'T')
#define COUNTRY_CODE_TUNISIA                         MAKE_COUNTRY_CODE('T', 'N')
#define COUNTRY_CODE_TURKEY                          MAKE_COUNTRY_CODE('T', 'R')
#define COUNTRY_CODE_TURKMENISTAN                    MAKE_COUNTRY_CODE('T', 'M')
#define COUNTRY_CODE_TURKS_AND_CAICOS_ISLANDS        MAKE_COUNTRY_CODE('T', 'C')
#define COUNTRY_CODE_TUVALU                          MAKE_COUNTRY_CODE('T', 'V')
#define COUNTRY_CODE_UGANDA                          MAKE_COUNTRY_CODE('U', 'G')
#define COUNTRY_CODE_UKRAINE                         MAKE_COUNTRY_CODE('U', 'A')
#define COUNTRY_CODE_UNITED_ARAB_EMIRATES            MAKE_COUNTRY_CODE('A', 'E')
#define COUNTRY_CODE_UNITED_KINGDOM                  MAKE_COUNTRY_CODE('G', 'B')
#define COUNTRY_CODE_UNITED_STATES                   MAKE_COUNTRY_CODE('U', 'S')
#define COUNTRY_CODE_UNITED_STATES_MINOR_OUTLYING_ISLANDS  MAKE_COUNTRY_CODE('U', 'M')
#define COUNTRY_CODE_URUGUAY                         MAKE_COUNTRY_CODE('U', 'Y')
#define COUNTRY_CODE_UZBEKISTAN                      MAKE_COUNTRY_CODE('U', 'Z')
#define COUNTRY_CODE_VANUATU                         MAKE_COUNTRY_CODE('V', 'U')
#define COUNTRY_CODE_VENEZUELA                       MAKE_COUNTRY_CODE('V', 'E')
#define COUNTRY_CODE_VIET_NAM                        MAKE_COUNTRY_CODE('V', 'N')
#define COUNTRY_CODE_VIRGIN_ISLANDS_BRITISH          MAKE_COUNTRY_CODE('V', 'G')
#define COUNTRY_CODE_VIRGIN_ISLANDS_US               MAKE_COUNTRY_CODE('V', 'I')
#define COUNTRY_CODE_WALLIS_AND_FUTUNA_ISLANDS       MAKE_COUNTRY_CODE('W', 'F')
#define COUNTRY_CODE_WESTERN_SAHARA                  MAKE_COUNTRY_CODE('E', 'H')
#define COUNTRY_CODE_YEMEN                           MAKE_COUNTRY_CODE('Y', 'E')
#define COUNTRY_CODE_YUGOSLAVIA                      MAKE_COUNTRY_CODE('Y', 'U')
#define COUNTRY_CODE_ZAMBIA                          MAKE_COUNTRY_CODE('Z', 'M')
#define COUNTRY_CODE_ZIMBABWE                        MAKE_COUNTRY_CODE('Z', 'W')

/*
 * Local defines for different Chaska board types
 */
#define TYPE_CHASKA_DAA0	0
#define TYPE_CHASKA_DAA1	1
#define TYPE_CHASKA_DAA2	2
#define TYPE_CHASKA_DAA3	3

/*
 * Local storage for country code list initializers for firmware.
 *
 * Usage:
 *    uint32 array_of_country_codes[] = xxxx_CC_LIST_INIT;
 *
 */

#define CC_LIST_INIT(l) { l }

#define HOUSTON_T1_CC_LIST             COUNTRY_CODE_CANADA, \
                                       COUNTRY_CODE_JAPAN, \
                                       COUNTRY_CODE_UNITED_STATES
#define HOUSTON_T1_CC_LIST_INIT     CC_LIST_INIT(HOUSTON_T1_CC_LIST)
                                       
#define HOUSTON_E1_CC_LIST             COUNTRY_CODE_ARGENTINA, \
                                       COUNTRY_CODE_AUSTRALIA, \
                                       COUNTRY_CODE_AUSTRIA, \
                                       COUNTRY_CODE_BAHRAIN, \
                                       COUNTRY_CODE_BELGIUM, \
                                       COUNTRY_CODE_BRAZIL, \
                                       COUNTRY_CODE_CHILE, \
                                       COUNTRY_CODE_CHINA, \
									   COUNTRY_CODE_COLOMBIA, \
									   COUNTRY_CODE_CROATIA, \
									   COUNTRY_CODE_CYPRUS, \
                                       COUNTRY_CODE_CZECH_REPUBLIC, \
                                       COUNTRY_CODE_DENMARK, \
                                       COUNTRY_CODE_FINLAND, \
                                       COUNTRY_CODE_FRANCE, \
                                       COUNTRY_CODE_GERMANY, \
                                       COUNTRY_CODE_GREECE, \
                                       COUNTRY_CODE_HONG_KONG, \
                                       COUNTRY_CODE_HUNGARY, \
                                       COUNTRY_CODE_INDONESIA, \
                                       COUNTRY_CODE_IRELAND, \
                                       COUNTRY_CODE_ISRAEL, \
                                       COUNTRY_CODE_ITALY, \
                                       COUNTRY_CODE_JAPAN, \
                                       COUNTRY_CODE_KOREA_REPUBLIC_OF, \
                                       COUNTRY_CODE_LUXEMBOURG, \
                                       COUNTRY_CODE_MALAYSIA, \
                                       COUNTRY_CODE_NETHERLANDS, \
                                       COUNTRY_CODE_NEW_ZEALAND, \
                                       COUNTRY_CODE_NORWAY, \
									   COUNTRY_CODE_POLAND, \
                                       COUNTRY_CODE_PORTUGAL, \
                                       COUNTRY_CODE_RUSSIAN_FEDERATION, \
                                       COUNTRY_CODE_SINGAPORE, \
									   COUNTRY_CODE_SLOVENIA, \
                                       COUNTRY_CODE_SOUTH_AFRICA, \
                                       COUNTRY_CODE_SPAIN, \
                                       COUNTRY_CODE_SWEDEN, \
                                       COUNTRY_CODE_SWITZERLAND, \
                                       COUNTRY_CODE_TAIWAN_PROVINCE_OF_CHINA, \
                                       COUNTRY_CODE_THAILAND, \
                                       COUNTRY_CODE_UNITED_KINGDOM
#define HOUSTON_E1_CC_LIST_INIT     CC_LIST_INIT(HOUSTON_E1_CC_LIST)
                                       
#define LONDON_U_CC_LIST               COUNTRY_CODE_CANADA, \
                                       COUNTRY_CODE_SINGAPORE, \
                                       COUNTRY_CODE_UNITED_STATES
#define LONDON_U_CC_LIST_INIT       CC_LIST_INIT(LONDON_U_CC_LIST)
                                       
#define LONDON_ST_CC_LIST              COUNTRY_CODE_ARGENTINA, \
                                       COUNTRY_CODE_AUSTRALIA, \
                                       COUNTRY_CODE_AUSTRIA, \
                                       COUNTRY_CODE_BAHRAIN, \
                                       COUNTRY_CODE_BELGIUM, \
                                       COUNTRY_CODE_BRAZIL, \
                                       COUNTRY_CODE_CANADA, \
                                       COUNTRY_CODE_CHILE, \
                                       COUNTRY_CODE_CHINA, \
									   COUNTRY_CODE_COLOMBIA, \
									   COUNTRY_CODE_CROATIA, \
									   COUNTRY_CODE_CYPRUS, \
                                       COUNTRY_CODE_CZECH_REPUBLIC, \
                                       COUNTRY_CODE_DENMARK, \
                                       COUNTRY_CODE_FINLAND, \
                                       COUNTRY_CODE_FRANCE, \
                                       COUNTRY_CODE_GERMANY, \
                                       COUNTRY_CODE_GREECE, \
                                       COUNTRY_CODE_HONG_KONG, \
                                       COUNTRY_CODE_HUNGARY, \
                                       COUNTRY_CODE_INDONESIA, \
                                       COUNTRY_CODE_IRELAND, \
                                       COUNTRY_CODE_ISRAEL, \
                                       COUNTRY_CODE_ITALY, \
                                       COUNTRY_CODE_JAPAN, \
                                       COUNTRY_CODE_KOREA_REPUBLIC_OF, \
                                       COUNTRY_CODE_LUXEMBOURG, \
                                       COUNTRY_CODE_MALAYSIA, \
                                       COUNTRY_CODE_NETHERLANDS, \
                                       COUNTRY_CODE_NEW_ZEALAND, \
                                       COUNTRY_CODE_NORWAY, \
                                       COUNTRY_CODE_PORTUGAL, \
                                       COUNTRY_CODE_RUSSIAN_FEDERATION, \
                                       COUNTRY_CODE_SINGAPORE, \
                                       COUNTRY_CODE_SOUTH_AFRICA, \
                                       COUNTRY_CODE_SPAIN, \
                                       COUNTRY_CODE_SWEDEN, \
                                       COUNTRY_CODE_SWITZERLAND, \
                                       COUNTRY_CODE_TAIWAN_PROVINCE_OF_CHINA, \
                                       COUNTRY_CODE_THAILAND, \
                                       COUNTRY_CODE_UNITED_KINGDOM, \
                                       COUNTRY_CODE_UNITED_STATES
#define LONDON_ST_CC_LIST_INIT      CC_LIST_INIT(LONDON_ST_CC_LIST)
                                       
#define CHASKA_DAA0_CC_LIST            COUNTRY_CODE_ARGENTINA, \
									   COUNTRY_CODE_ARUBA, \
									   COUNTRY_CODE_BAHRAIN, \
									   COUNTRY_CODE_BRAZIL, \
									   COUNTRY_CODE_BRUNEI_DARUSSALAM, \
									   COUNTRY_CODE_CANADA, \
									   COUNTRY_CODE_CAYMAN_ISLANDS, \
									   COUNTRY_CODE_CHILE, \
									   COUNTRY_CODE_CHINA, \
									   COUNTRY_CODE_COLOMBIA, \
									   COUNTRY_CODE_COSTA_RICA, \
									   COUNTRY_CODE_CYPRUS, \
									   COUNTRY_CODE_ECUADOR, \
									   COUNTRY_CODE_EGYPT, \
									   COUNTRY_CODE_GUATEMALA, \
									   COUNTRY_CODE_HONG_KONG, \
									   COUNTRY_CODE_HUNGARY, \
									   COUNTRY_CODE_INDIA, \
									   COUNTRY_CODE_INDONESIA, \
									   COUNTRY_CODE_ISRAEL, \
									   COUNTRY_CODE_JAMAICA, \
									   COUNTRY_CODE_JAPAN, \
									   COUNTRY_CODE_KOREA_REPUBLIC_OF, \
									   COUNTRY_CODE_MACAU, \
									   COUNTRY_CODE_MALAYSIA, \
									   COUNTRY_CODE_MEXICO, \
									   COUNTRY_CODE_NETHERLANDS_ANTILLES, \
									   COUNTRY_CODE_PAKISTAN, \
									   COUNTRY_CODE_PANAMA, \
									   COUNTRY_CODE_PERU, \
									   COUNTRY_CODE_PHILIPPINES, \
									   COUNTRY_CODE_QATAR, \
									   COUNTRY_CODE_ROMANIA, \
									   COUNTRY_CODE_RUSSIAN_FEDERATION, \
									   COUNTRY_CODE_SAUDI_ARABIA, \
									   COUNTRY_CODE_SINGAPORE, \
									   COUNTRY_CODE_SLOVAKIA, \
									   COUNTRY_CODE_SLOVENIA, \
									   COUNTRY_CODE_SRI_LANKA, \
									   COUNTRY_CODE_TAIWAN_PROVINCE_OF_CHINA, \
									   COUNTRY_CODE_THAILAND, \
									   COUNTRY_CODE_TRINIDAD_AND_TOBAGO, \
									   COUNTRY_CODE_TURKEY, \
									   COUNTRY_CODE_UKRAINE, \
									   COUNTRY_CODE_URUGUAY, \
									   COUNTRY_CODE_UNITED_ARAB_EMIRATES, \
									   COUNTRY_CODE_UNITED_STATES, \
									   COUNTRY_CODE_VENEZUELA, \
									   COUNTRY_CODE_VIET_NAM
#define CHASKA_DAA0_CC_LIST_INIT    CC_LIST_INIT(CHASKA_DAA0_CC_LIST)
                                       
#define CHASKA_DAA1_CC_LIST            COUNTRY_CODE_AUSTRIA, \
									   COUNTRY_CODE_BELGIUM, \
									   COUNTRY_CODE_CROATIA, \
									   COUNTRY_CODE_CZECH_REPUBLIC, \
                                       COUNTRY_CODE_DENMARK, \
                                       COUNTRY_CODE_FINLAND, \
                                       COUNTRY_CODE_FRANCE, \
									   COUNTRY_CODE_GREECE, \
									   COUNTRY_CODE_ICELAND, \
									   COUNTRY_CODE_IRELAND, \
                                       COUNTRY_CODE_ITALY, \
									   COUNTRY_CODE_LUXEMBOURG, \
									   COUNTRY_CODE_MOROCCO, \
                                       COUNTRY_CODE_NETHERLANDS, \
                                       COUNTRY_CODE_NORWAY, \
									   COUNTRY_CODE_POLAND, \
									   COUNTRY_CODE_PORTUGAL, \
									   COUNTRY_CODE_SPAIN, \
                                       COUNTRY_CODE_SWEDEN, \
                                       COUNTRY_CODE_UNITED_KINGDOM
#define CHASKA_DAA1_CC_LIST_INIT    CC_LIST_INIT(CHASKA_DAA1_CC_LIST)
                                       
#define CHASKA_DAA2_CC_LIST            COUNTRY_CODE_GERMANY, \
									   COUNTRY_CODE_SOUTH_AFRICA
#define CHASKA_DAA2_CC_LIST_INIT    CC_LIST_INIT(CHASKA_DAA2_CC_LIST)
                                       
#define CHASKA_DAA3_CC_LIST            COUNTRY_CODE_AUSTRALIA, \
									   COUNTRY_CODE_NEW_ZEALAND, \
                                       COUNTRY_CODE_SWITZERLAND
#define CHASKA_DAA3_CC_LIST_INIT    CC_LIST_INIT(CHASKA_DAA3_CC_LIST)

/*
 * Local storage for country code list initializers for drivers.
 * The firmware supports all countries the hardware will operate in.
 * The drivers should only expose the countries we are certified to operate in.
 *
 * Usage:
 *    uint32 array_of_country_codes[] = xxxx_CC_LIST_INIT;
 *
 */

#define DRV_CC_LIST_INIT(l) { l }

#define HOUSTON_T1_DRV_CC_LIST         COUNTRY_CODE_CANADA, \
                                       COUNTRY_CODE_JAPAN, \
                                       COUNTRY_CODE_UNITED_STATES
#define HOUSTON_T1_DRV_CC_LIST_INIT    DRV_CC_LIST_INIT(HOUSTON_T1_DRV_CC_LIST)
                                       
#define HOUSTON_E1_DRV_CC_LIST         COUNTRY_CODE_AUSTRALIA, \
                                       COUNTRY_CODE_AUSTRIA, \
                                       COUNTRY_CODE_BELGIUM, \
                                       COUNTRY_CODE_BRAZIL, \
                                       COUNTRY_CODE_CHINA, \
                                       COUNTRY_CODE_DENMARK, \
                                       COUNTRY_CODE_FINLAND, \
                                       COUNTRY_CODE_FRANCE, \
                                       COUNTRY_CODE_GERMANY, \
                                       COUNTRY_CODE_GREECE, \
                                       COUNTRY_CODE_HONG_KONG, \
                                       COUNTRY_CODE_INDONESIA, \
                                       COUNTRY_CODE_IRELAND, \
                                       COUNTRY_CODE_ITALY, \
                                       COUNTRY_CODE_KOREA_REPUBLIC_OF, \
                                       COUNTRY_CODE_LUXEMBOURG, \
                                       COUNTRY_CODE_MALAYSIA, \
                                       COUNTRY_CODE_NETHERLANDS, \
                                       COUNTRY_CODE_NEW_ZEALAND, \
                                       COUNTRY_CODE_NORWAY, \
                                       COUNTRY_CODE_PORTUGAL, \
                                       COUNTRY_CODE_SINGAPORE, \
                                       COUNTRY_CODE_SOUTH_AFRICA, \
                                       COUNTRY_CODE_SPAIN, \
                                       COUNTRY_CODE_SWEDEN, \
                                       COUNTRY_CODE_SWITZERLAND, \
                                       COUNTRY_CODE_TAIWAN_PROVINCE_OF_CHINA, \
                                       COUNTRY_CODE_THAILAND, \
                                       COUNTRY_CODE_UNITED_KINGDOM
#define HOUSTON_E1_DRV_CC_LIST_INIT    DRV_CC_LIST_INIT(HOUSTON_E1_DRV_CC_LIST)
                                       
#define LONDON_U_DRV_CC_LIST           COUNTRY_CODE_CANADA, \
                                       COUNTRY_CODE_SINGAPORE, \
                                       COUNTRY_CODE_UNITED_STATES
#define LONDON_U_DRV_CC_LIST_INIT      DRV_CC_LIST_INIT(LONDON_U_DRV_CC_LIST)
                                       
#define LONDON_ST_DRV_CC_LIST          COUNTRY_CODE_AUSTRALIA, \
                                       COUNTRY_CODE_AUSTRIA, \
                                       COUNTRY_CODE_BELGIUM, \
                                       COUNTRY_CODE_BRAZIL, \
                                       COUNTRY_CODE_CANADA, \
                                       COUNTRY_CODE_CHINA, \
                                       COUNTRY_CODE_DENMARK, \
                                       COUNTRY_CODE_FINLAND, \
                                       COUNTRY_CODE_FRANCE, \
                                       COUNTRY_CODE_GERMANY, \
                                       COUNTRY_CODE_GREECE, \
                                       COUNTRY_CODE_HONG_KONG, \
                                       COUNTRY_CODE_INDONESIA, \
                                       COUNTRY_CODE_IRELAND, \
                                       COUNTRY_CODE_ITALY, \
                                       COUNTRY_CODE_JAPAN, \
                                       COUNTRY_CODE_KOREA_REPUBLIC_OF, \
                                       COUNTRY_CODE_LUXEMBOURG, \
                                       COUNTRY_CODE_MALAYSIA, \
                                       COUNTRY_CODE_NETHERLANDS, \
                                       COUNTRY_CODE_NEW_ZEALAND, \
                                       COUNTRY_CODE_NORWAY, \
                                       COUNTRY_CODE_PORTUGAL, \
                                       COUNTRY_CODE_SINGAPORE, \
                                       COUNTRY_CODE_SOUTH_AFRICA, \
                                       COUNTRY_CODE_SPAIN, \
                                       COUNTRY_CODE_SWEDEN, \
                                       COUNTRY_CODE_SWITZERLAND, \
                                       COUNTRY_CODE_TAIWAN_PROVINCE_OF_CHINA, \
                                       COUNTRY_CODE_THAILAND, \
                                       COUNTRY_CODE_UNITED_KINGDOM, \
                                       COUNTRY_CODE_UNITED_STATES
#define LONDON_ST_DRV_CC_LIST_INIT     DRV_CC_LIST_INIT(LONDON_ST_DRV_CC_LIST)
                                       
#define CHASKA_DAA0_DRV_CC_LIST		COUNTRY_CODE_ARGENTINA, \
					COUNTRY_CODE_BRAZIL, \
				 	COUNTRY_CODE_CANADA, \
					COUNTRY_CODE_CHILE, \
					COUNTRY_CODE_CHINA, \
					COUNTRY_CODE_HONG_KONG, \
					COUNTRY_CODE_HUNGARY, \
					COUNTRY_CODE_INDIA, \
					COUNTRY_CODE_INDONESIA, \
					COUNTRY_CODE_ISRAEL, \
					COUNTRY_CODE_JAPAN, \
					COUNTRY_CODE_KOREA_REPUBLIC_OF, \
					COUNTRY_CODE_MALAYSIA, \
					COUNTRY_CODE_MEXICO, \
					COUNTRY_CODE_PHILIPPINES, \
					COUNTRY_CODE_RUSSIAN_FEDERATION, \
					COUNTRY_CODE_SINGAPORE, \
					COUNTRY_CODE_TAIWAN_PROVINCE_OF_CHINA, \
					COUNTRY_CODE_THAILAND, \
					COUNTRY_CODE_UNITED_STATES

#define CHASKA_DAA0_DRV_CC_LIST_INIT   DRV_CC_LIST_INIT(CHASKA_DAA0_DRV_CC_LIST)
                                       
#define CHASKA_DAA1_DRV_CC_LIST		COUNTRY_CODE_AUSTRIA, \
					COUNTRY_CODE_BELGIUM, \
					COUNTRY_CODE_DENMARK, \
					COUNTRY_CODE_FINLAND, \
					COUNTRY_CODE_FRANCE, \
					COUNTRY_CODE_GREECE, \
					COUNTRY_CODE_ICELAND, \
					COUNTRY_CODE_IRELAND, \
					COUNTRY_CODE_ITALY, \
					COUNTRY_CODE_LUXEMBOURG, \
					COUNTRY_CODE_NETHERLANDS, \
					COUNTRY_CODE_NORWAY, \
					COUNTRY_CODE_PORTUGAL, \
					COUNTRY_CODE_SPAIN, \
					COUNTRY_CODE_SWEDEN, \
					COUNTRY_CODE_UNITED_KINGDOM

#define CHASKA_DAA1_DRV_CC_LIST_INIT   DRV_CC_LIST_INIT(CHASKA_DAA1_DRV_CC_LIST)
                                       
#define CHASKA_DAA2_DRV_CC_LIST        COUNTRY_CODE_GERMANY, \
									   COUNTRY_CODE_SOUTH_AFRICA
#define CHASKA_DAA2_DRV_CC_LIST_INIT   DRV_CC_LIST_INIT(CHASKA_DAA2_DRV_CC_LIST)
                                       
#define CHASKA_DAA3_DRV_CC_LIST        COUNTRY_CODE_AUSTRALIA, \
									   COUNTRY_CODE_NEW_ZEALAND, \
                                       COUNTRY_CODE_SWITZERLAND
#define CHASKA_DAA3_DRV_CC_LIST_INIT   DRV_CC_LIST_INIT(CHASKA_DAA3_DRV_CC_LIST)

#endif

