/* -*- linux-c -*- (Autoset linux indent style when using emacs) */

/*
 * Copyright 1999 by Digi International (www.digi.com)
 *    Jeff Randall <Jeff_Randall@digi.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY, EXPRESS OR IMPLIED; without even the 
 * implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
 * PURPOSE.  See the GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#if !defined(DXBTYPES_H)
#define DXBTYPES_H

#if defined(__KERNEL__)
# include <linux/string.h>
#endif

#include <linux/types.h>


#define	DXB_HOST	1	/* Host-side only */

/*
 *	We can handle inlines with GCC...
 */
#define DXB_HAS_INLINE	1

#if !defined (TRUE)
# define	TRUE		1
#endif

#if !defined (FALSE)
# define	FALSE		0
#endif

#if !defined(NULL)
# define	NULL		0
#endif

/*
 *	Additional types needed by header files
 */
typedef	char			int8;
typedef	short			int16;
typedef	int			int32;
typedef	long long		int64;

typedef unsigned char		uint8;
typedef unsigned short		uint16;
typedef unsigned int		uint32;
typedef unsigned long long	uint64;

typedef unsigned char		uchar;

typedef volatile uint32		shared_uint32;
typedef volatile uint32		shared_uint32_le;
typedef volatile uint16		shared_uint16;
typedef volatile uint16		shared_uint16_le;
typedef volatile uint8		shared_uint8;
typedef volatile uint8		shared_uint8_le;
typedef volatile uint8		shared_uchar;

typedef volatile const uint32	board_uint32;
typedef volatile const uint32	board_uint32_le;
typedef volatile const uint16	board_uint16;
typedef volatile const uint16	board_uint16_le;
typedef volatile const uint8	board_uint8;
typedef volatile const uint8	board_uint8_le;
typedef volatile uchar		board_uchar;

typedef uint32			host_uint32;
typedef uint32			host_uint32_le;
typedef uint16			host_uint16;
typedef uint16			host_uint16_le;
typedef uint8			host_uint8;
typedef uint8			host_uint8_le;
typedef uint8			host_uchar;

typedef uint32			dxb_uint32;
typedef uint16			dxb_uint16;
typedef uint8			dxb_uint8;

typedef uint32			UINT32;
typedef uint16			UINT16;
typedef uint8			UINT8;

typedef	uint8			BYTE;
typedef	int8			INT8;

typedef	uint16			eshort;
typedef	uint16			WORD;
typedef	int16			INT16;

typedef	uint32			elong;
typedef	int32			LONG;
typedef	int32			DWORD;
typedef	int32			INT32;
typedef uint32			pad_32;

#endif
