/**********************************************************************
 ***  Module ID assignments.
 ***
 ***  @(#) mid.h	3.6  11/14/95
 **********************************************************************/

#define	MID_NONE	0	/* [dev#] Module not present */

#if ARNET
# define MID_CD1400_DB25 7	/* Cirrus Device DB-25 UART Module */
# define MID_SIGGIE	 8	/* SmartPort Plus Compatibility Bridge */
# define MID_CD1400_RJ45 9	/* Cirrus Device RJ-45 UART Module */
# define MID_CDUSCC	10	/* Signetics CMOS DUSCC Module */
# define MID_CD1190	11	/* Cirrus Parallel Module */

#else /* ARNET */

#define	MID_UART	0x01	/* 000001 Regular UART module (16em) */
#define	MID_SUART	0x03	/* 000011 Slow UART module (16m) */

#define	MID_UART_OK	0x05	/* 000101 UART mod. w/data ready working */
#define	MID_SUART_OK	0x7f	/* 000111 Same as above, but (16m) (unused) */

#define	MID_8UART1P	0x04	/* 000100 8 serial, 1 parallel */
#define	MID_8UART	0x06	/* 000110 8 serial */

#define	MID_8UART1P_OK	0x0C	/* 001100 8 serial, 1 para, data ready ok */
#define	MID_8UART_OK	0x0E	/* 001110 8 serial, data ready ok*/

#define	MID_IUART	0x02	/* 000010 Intelligent Cirrus 16-port UARTs */

#define	MID_4UARTx	0x07	/* 4-port PC/xr */
#define	MID_8UARTx	0x08	/* 8-port PC/xr */
#define	MID_4UARTx_CMS	0x0A	/* 4-port PC/xr Communciation Mode Selectable */
#define	MID_8UARTx_CMS	0x0B	/* 8-port PC/xr Communciation Mode Selectable */

#define MID_4UART_RAM	0x10	/* 4 PORT RAM Based Chip Set Multi Modem ID 
				   Device Register is 0x40.  The last two
				   bits are the rev and are shifted out to
				   produce the module ID bit. Modem/4em */
#define MID_8UART_RAM	0x14	/* 8 PORT RAM Based Chip Set Multi Modem ID 
				   Device Register is 0x50 Modem/8em */
#define MID_4UART_ROM	0x18	/* 4 PORT ROM Based Chip Set Multi Modem ID 
				   Device Register is 0x60 Modem/4em */
#define MID_8UART_ROM	0x1c	/* 8 PORT ROM Based Chip Set Multi Modem ID 
				   Device Register is 0x70 Modem/8em */
#endif
