/*
 * FEPFLAGS.H:  Not all UNIX vendors use the same positioning for their
 *              tty flags (thanks a heap, guys).  These constants define
 *              the position of the various tty flags on the FEP itself.
 *              Use these definitions when dealing with the FEP.  DO NOT
 *              USE THE HOST TTY FLAG DEFINITIONS!
 */

#ident	"$Id: fepflags.h,v 1.2 1995/07/24 07:51:05 steveb Exp $"

/* input flags */
#define	HW_IGNBRK	0000001
#define	HW_BRKINT	0000002
#define	HW_IGNPAR	0000004
#define	HW_PARMRK	0000010
#define	HW_INPCK	0000020
#define	HW_ISTRIP	0000040
#define	HW_INLCR	0000100
#define	HW_IGNCR	0000200
#define HW_ALTPIN	0000200
#define	HW_ICRNL	0000400
#define	HW_IUCLC	0001000
#define	HW_IXON		0002000
#define	HW_IXANY	0004000
#define	HW_IXOFF	0010000
#define HW_IMAXBEL	0020000		/* (Reserved for future use) */
#define HW_DOSMODE	0100000

/* output flags */
#define	HW_OPOST	0000001
#define	HW_OLCUC	0000002
#define	HW_ONLCR	0000004
#define	HW_OCRNL	0000010
#define	HW_ONOCR	0000020
#define	HW_ONLRET	0000040
#define	HW_OFILL	0000100
#define	HW_OFDEL	0000200
#define	HW_NLDLY	0000400
#define	HW_NL0		0
#define	HW_NL1		0000400
#define	HW_CRDLY	0003000
#define	HW_CR0		0
#define	HW_CR1		0001000
#define	HW_CR2		0002000
#define	HW_CR3		0003000
#define	HW_TABDLY	0014000
#define	HW_TAB0		0
#define	HW_TAB1		0004000
#define	HW_TAB2		0010000
#define	HW_TAB3		0014000
#define	HW_BSDLY	0020000
#define	HW_BS0		0
#define	HW_BS1		0020000
#define	HW_VTDLY	0040000
#define	HW_VT0		0
#define	HW_VT1		0040000
#define	HW_FFDLY	0100000
#define	HW_FF0		0
#define	HW_FF1		0100000

/* control flags */
#define	HW_CBAUD	0000017
#define	HW_B0		0
#define	HW_B50		0000001
#define	HW_B75		0000002
#define	HW_B110		0000003
#define	HW_B134		0000004
#define	HW_B150		0000005
#define	HW_B200		0000006
#define	HW_B300		0000007
#define	HW_B600		0000010
#define	HW_B1200	0000011
#define	HW_B1800	0000012
#define	HW_B2400	0000013
#define	HW_B4800	0000014
#define	HW_B9600	0000015
#define	HW_B19200	0000016
#define HW_EXTA		0000016
#define	HW_B38400	0000017
#define HW_EXTB		0000017
#define	HW_CSIZE	0000060
#define	HW_CS5		0
#define	HW_CS6		0000020
#define	HW_CS7		0000040
#define	HW_CS8		0000060
#define	HW_CSTOPB	0000100
#define	HW_CREAD	0000200
#define	HW_PARENB	0000400
#define	HW_PARODD	0001000
#define	HW_HUPCL	0002000
#define	HW_CLOCAL	0004000
#define HW_RCV1EN	0010000
#define	HW_XMT1EN	0020000
#define	HW_LOBLK	0040000
#define	HW_XCLUDE	0100000		/* *V7* exclusive use coming fron XENIX */

/* lflags */
#define	HW_ISIG		0000001
#define	HW_ICANON	0000002
#define	HW_XCASE	0000004
#define	HW_ECHO		0000010
#define	HW_ECHOE	0000020
#define	HW_ECHOK	0000040
#define	HW_ECHONL	0000100
#define	HW_NOFLSH	0000200

