/************************************************************************
 ***	FEP Version 5 dependent definitions
 ************************************************************************/

#if !defined(lint)
static char fep5h_id[]="$Id: dpa_fep.h,v 1.2 1996/07/31 21:54:21 robertl Exp $";
#endif

/*
 * Copyright (c) 1988-91 Digi International Inc., All Rights Reserved.
 */

/************************************************************************
 *	FEP memory offsets
 ************************************************************************/
#define START		0x0004L		/* Execution start address	*/

#define CMDBUF		0x0d10L		/* Command (cm_t) structure offset */
#define CMDSTART	0x0400L		/* Start of command buffer	*/
#define CMDMAX		0x0800L		/* End of command buffer	*/

#define EVBUF		0x0d18L		/* Event (ev_t) structure	*/
#define EVSTART		0x0800L		/* Start of event buffer	*/
#define EVMAX		0x0c00L		/* End of event buffer		*/

#if	defined(CX) || defined(EPC)
#define FEPSTAT		POSTAREA	/* OS here when FEP comes up	*/
#define NCHAN		0x0C02L		/* number of ports FEP sees	*/
#define PANIC		0x0C10L		/* PANIC area for FEP		*/
#define KMEMEM		0x0C30L		/* Memory for KME use		*/
#define CONFIG		0x0CD0L		/* Concentrator configuration info */
#define CONFIGSIZE	0x0030		/* configuration info size	*/
#define DOWNREQ		0x0D00		/* Download request buffer pointer */
#else
#define FEPSTAT		0x0d20L		/* OK here when FEP comes up	*/
#define	DATABUF		0x4000L		/* Rx and Tx data buffer area	*/
#endif

#define CHANBUF		0x1000L		/* Async channel (bs_t) structs	*/
#define FEPOSSIZE	0x1FFF		/* 8K FEPOS			*/


/************************************************************************
 * Command structure definition.
 ************************************************************************/
struct cm_struct {
	unsigned short cm_head;		/* Command buffer head offset	*/
	unsigned short cm_tail;		/* Command buffer tail offset	*/
	unsigned short cm_start;	/* start offset of buffer	*/
	unsigned short cm_max;		/* last offset of buffer	*/
};

/************************************************************************
 * Event structure definition.
 ************************************************************************/
struct ev_struct {
	unsigned short ev_head;		/* Command buffer head offset	*/
	unsigned short ev_tail;		/* Command buffer tail offset	*/
	unsigned short ev_start;	/* start offset of buffer	*/
	unsigned short ev_max;		/* last offset of buffer	*/
};

#if	defined(CX) || defined (EPC)
/************************************************************************
 * Image of the panic crash area.
 ************************************************************************/
struct pn_struct {
	ushort	pn_req;
	ushort	pn_ip;
	ushort	pn_p1;
	ushort	pn_p2;
	ushort	pn_ax;
	ushort	pn_bx;
	ushort	pn_cx;
	ushort	pn_dx;
	ushort	pn_si;
	ushort	pn_di;
	ushort	pn_bp;
	ushort	pn_sp;
	ushort	pn_cs;
	ushort	pn_ds;
	ushort	pn_ss;
	ushort	pn_es;
};

/************************************************************************
 * Download buffer structure.
 ************************************************************************/
struct dl_struct {
	uchar_t	dl_type;		/* Header			*/
	uchar_t	dl_seq;			/* Download sequence		*/
	ushort	dl_srev;		/* Software revision number	*/
	ushort	dl_lrev;		/* Low revision number		*/
	ushort	dl_hrev;		/* High revision number		*/
	ushort	dl_seg;			/* Start segment address	*/
	ushort	dl_size;		/* Number of bytes to download	*/
	uchar_t	dl_data[1024];		/* Download data		*/
};
#endif

/************************************************************************
 * Per channel buffer structure
 ************************************************************************
 *		Base Structure Entries Usage Meanings to Host		*
 *									*
 *	  W = read write        R = read only				*
 *	  C = changed by commands only					*
 *	  U = unknown (may be changed w/o notice)			*
 ************************************************************************/
struct bs_struct {
	struct bs_struct *ch_next;	/* U  Next Evaluation pointer   */
	int	        (*ch_tjmp)();	/* U  Transmit entry pointer    */

	unsigned short	tx_seg;		/* W  Tx segment		*/
	unsigned short	tx_head;	/* W  Tx buffer head offset	*/
	unsigned short	tx_tail;	/* R  Tx buffer tail offset	*/
	unsigned short	tx_max;		/* W  Tx buffer size - 1	*/

	unsigned short	rx_seg;		/* W  Rx segment		*/
	unsigned short	rx_head;	/* W  Rx buffer head offset	*/
	unsigned short	rx_tail;	/* R  Rx buffer tail offset	*/
	unsigned short	rx_max;		/* W  Rx buffer size - 1	*/

	unsigned short	tx_lw;		/* W  Tx buffer low water mark	*/
	unsigned short	rx_lw;		/* W  Rx buffer low water mark	*/
	unsigned short	rx_hw;		/* W  Rx buffer high water mark	*/
	unsigned short	ch_bsize;	/* U? Remote receive buffer size*/

	unsigned short	ch_etime;	/* U  Last exception time    	*/
	unsigned short	edelay;		/* W  Exception delay           */
	unsigned char	*ch_dev;	/* U? Device address            */

	unsigned short	iflag;		/* C  UNIX input flags		*/
	unsigned short	oflag;		/* C  UNIX output flags		*/
	unsigned short	cflag;		/* C  UNIX control flags	*/
	unsigned short	ch_pflag;	/* U  parameter change flags    */

	struct bs_struct *ch_snext;	/* U  Next slow channel         */
	int	        (*ch_sjmp)();	/* U  Slow poll entry point     */

	unsigned char   *ch_rbuf;	/* U  Receive buffer origin     */
	unsigned char   *ch_tbuf;	/* U  Transmit buffer origin    */
	long		ch_tcost;	/* U  Transmit cost             */
	long		ch_ttime;	/* U  Transmit time             */

	unsigned char	num;		/* U  Channel number		*/
	unsigned char	ch_xmask;	/* U  Transmit ready mask    	*/
	unsigned char	ch_xval;	/* U  Transmit ready value      */
	unsigned char	tbusy;		/* W  Transmit busy		*/
	unsigned char	iempty;		/* W  Transmit empty event enable */
	unsigned char	ilow;		/* W  Transmit low-water event enable */
	unsigned char	idata;		/* W  Receive data interrupt enable */
	unsigned char	eflag;		/* U  Host event flags		*/

	unsigned short	ch_flags;	/* R  General channel flags     */
	unsigned short	ch_tflush;	/* U  Transmit flush point	*/
	unsigned char	m_stat;		/* RC Modem status bits		*/
	unsigned char	ch_rflush;	/* U  Receive flush sequence  	*/
	unsigned char	m_int;		/* W  Modem interrupt enable bits */
	unsigned char	m_last;		/* U  Last modem status		*/

	unsigned char	mtran;		/* C   Unreported modem trans	*/
	unsigned char	orun;		/* C   Buffer overrun occurred	*/
	unsigned char	astartc;	/* W   Auxiliary Xon char	*/
	unsigned char	astopc;		/* W   Auxiliary Xoff char	*/
	unsigned char	startc;		/* W   Xon character		*/
	unsigned char	stopc;		/* W   Xoff character		*/
	unsigned char	vnextc;		/* W   Vnext character		*/
	unsigned char	hflow;		/* C   Hardware flow control	*/

	unsigned char	fillc;		/* U   Delay Fill character	*/
	unsigned char	ch_otmp;	/* U   Output temporary		*/
	unsigned char	omask;		/* U   Output character mask	*/

	unsigned char	ch_ocol;	/* U   Output column number	*/
	unsigned char	ch_aflag;	/* U   Action flags    		*/
	unsigned char	ch_mod;		/* U   Associated channel mod	*/
	unsigned char	ch_rdata;	/* U   Receive active  		*/
	unsigned char	ch_tdata;	/* U   Transmitter active	*/

	unsigned char	ch_mout;	/* U   Modem output requested	*/
	unsigned char	ch_hsend;	/* U   Hardware send flags	*/
	unsigned short	ch_imask;	/* U   Input character mask	*/
	unsigned long	ch_brtime;	/* U   Break time		*/

	unsigned short	ch_70;		/* U   Receive entry point	*/
	unsigned short	ch_ptime;	/* U   Last position report time*/
	int	        (*ch_ojmp)();	/* U   Cooked mode output proc  */

	unsigned short	ch_tseq;	/* U   Transmit send sequence	*/
	unsigned short	ch_tpos;	/* U   Transmit positio		*/
	unsigned short	ch_rseq;	/* U   Receive send sequence	*/
	unsigned short	ch_rpos;	/* U   Receive position		*/
};	

/*
 * Bits used in ch_flags to identify device type
 */

#define	f_nodev		0x0000		/* No device present */
#define	f_serial	0x0010		/* Is a serial port */
#define	f_parallel	0x0020		/* Is a parallel port */
#define	f_unused	0x0030		/* Reserved for future use */

/************************************************************************
 * FEP supported functions
 ************************************************************************/
#define	SRLOW		0xe0		/* Set receive low water	*/
#define	SRHIGH		0xe1		/* Set receive high water	*/
#define FLUSHTX		0xe2		/* Flush transmit buffer	*/
#define PAUSETX		0xe3		/* Pause data transmission	*/
#define RESUMETX	0xe4		/* Resume data transmission	*/
#define	SMINT		0xe5		/* Set Modem Interrupt		*/
#define	SAFLOWC		0xe6		/* Set Aux. flow control chars	*/
#define SBREAK		0xe8		/* Send break			*/
#define SMODEM		0xe9		/* Set 8530 modem control lines */
#define SIFLAG		0xea		/* Set UNIX iflags		*/
#define	SFLOWC		0xeb		/* Set flow control characters	*/
#define	STLOW		0xec		/* Set transmit low water mark	*/
#define	RPAUSE		0xee		/* Pause recieve		*/
#define	RRESUME		0xef		/* Resume receive		*/
#define	BUFSETALL	0xf2		/* Set Tx & Rx buffer size avail */
#define SOFLAG		0xf3		/* Set UNIX oflags		*/
#define SHFLOW		0xf4		/* Set hardware handshake	*/
#define	SCFLAG		0xf5		/* Set UNIX cflags		*/
#define	SVNEXT		0xf6		/* Set VNEXT character		*/

/************************************************************************
 *	Event flags.
 ************************************************************************/
#define	IFBREAK		0x01		/* Break received		*/
#define IFTLW		0x02		/* Transmit low water		*/
#define	IFTEM		0x04		/* Transmitter empty		*/
#define IFDATA		0x08		/* Receive data present		*/
#define	IFMODEM		0x20		/* Modem status change		*/

#if COMXI
/************************************************************************
 *	Data type flags.
 ************************************************************************/
#define	STOP2		0x08		/* Two stop bits		*/
#define	PEVEN		0x20		/* Even parity			*/
#define	PODD		0x10		/* Odd parity			*/
#define STRIP7		0x40		/* Strip input to 7 bits	*/
#endif

/************************************************************************
 *	Modem flags
 ************************************************************************/
#if defined(CX) || defined(COMXI2) || defined(EPC)
#	define	DM_RTS		0x02	/* Request to send		*/
#	define	DM_CD		0x80	/* Carrier detect		*/
#	define	DM_DSR		0x20	/* Data set ready		*/
#	define	DM_CTS		0x10	/* Clear to send		*/
#	define	DM_RI		0x40	/* Ring indicator		*/
#	define	DM_DTR		0x01	/* Data terminal ready		*/
#else
#	define	DM_RTS		0x02	/* Request to send		*/
#	define	DM_CD		0x08	/* Carrier detect		*/
#	define	DM_DSR		0x10	/* Data set ready		*/
#	define	DM_CTS		0x20	/* Clear to send		*/
#	define	DM_RI		0x40	/* Ring indicator		*/
#	define	DM_DTR		0x80	/* Data terminal ready		*/
#endif

