/* ex:se ts=4 sw=4 sm: */
#include <errno.h>

#if !defined(LINUX)
#include <sys/termio.h>
#endif

#if !defined(lint)
static char dpah_id[]="$Id: dpa.h,v 1.38 1999/11/04 21:58:36 randall Exp $";
#endif

#define ctrl(x) ((x) & 0x1f)
#define CS_OKAY 	0x7 
#define TIMEOUT		5 	/* 5 tenths of a second (500 milliseconds) */
#define MAX_EPCEBI		3	/* max # EBIs per EPC/con */
#define MAX_LINECONCS	8	/* max # concs per sync line */
#define MAX_ADPTCONCS	16	/* max # concs per adapter */
#define MAX_ADPT		16	/* max # adapters */
#define MAX_MODEMS		256	/* max # modems for entire system */
#define MAX_REVS		8	/* max # em/Modem Flash ROM binaries */
#define NONMODEM		1	/* used to calculate minor number */
#define STRSIZ			80	/* length for various strings */

/*
*  em/Modem print_flashl() call parameters (Also used as an index!)
*/
#define EM_SYS			0	/* Load all em/Modems on the whole system */
#define EM_ADPT			1	/* Load all em/Modems on this adapter */
#define EM_MOD			2	/* Load all em/Modems on this conc/module */
#define EM_PORT			3	/* Load this em/Modem */

/*
*  em/Modem state during loop back testing
*/
#define MM_INIT			0	/* Modem settings unchanged */
#define MM_FACT			1	/* Change to factory settings sent */
#define MM_ACT			2	/* Modem has accepted our AT commands */

#ifndef const
#define const
#endif

#define Strcat(x,y)		strcat((char *) (x), (const char *) (y))
#define Strcmp(x,y)		strcmp((const char *) (x), (const char *) (y))
#define Strncmp(x,y,z)	strncmp((char *) (x), (const char *) (y), (z))
#define Strcpy(x,y)		strcpy((char *) (x), (const char *) (y))
#define Strncpy(x,y,z)  strncpy((char *) (x), (const char *) (y), (z))

#define BLACK	COLOR_BLACK
#define RED		COLOR_RED
#define GREEN	COLOR_GREEN
#define YELLOW	COLOR_YELLOW
#define BLUE	COLOR_BLUE
#define MAGENTA	COLOR_MAGENTA
#define CYAN	COLOR_CYAN
#define WHITE	COLOR_WHITE

#define	ESC		'\033'
#define	RETURN	'\015'

/************** GLOBALS *****************/
int afd;			/* Adapter File Descriptor			*/
int pcxxfd;			/* /dev/pcxxdl Adapter File Desc.	*/
int epcafd;			/* /dev/epcadl Adapter  File Desc.	*/
#ifndef MRGDRV
int pcxrfd;			/* /dev/pcxrdl Adapter File Desc.	*/
int aspxfd;			/* /dev/aspxdl Adapter File Desc.	*/
#endif
#ifdef DXB
int dxbfd;			/* /dev/dxbdl Adapter File Desc.	*/
#endif
int debug = 0;		/* write out to debug file			*/
int resetport = 0;	/* TRUE if -r command line opt used */
FILE *dfp;			/* debug file pointer			*/
char logfile[256];	/* Log File name				*/
struct utsname os_info; /* For the uname system call */

/*
 * the next strings are for the key line strings, this  tries
 * to be intelligent about the key options which are displayed
 * to the user
 */
char helpstr[STRSIZ];		/* "help" key line string		*/
char lrudstr[STRSIZ];		/* left/right/up/dn help string	*/
char updnstr[STRSIZ];		/* up/down key line string		*/
char pgdnstr[STRSIZ];		/* page down key line string	*/
char pgupstr[STRSIZ];		/* page up key line string		*/

rw_t rw;				/* kme read/write structure 		*/
ushort lb_rxstatus;		/* Loop Back status 1=Pass, 0=Fail	*/
ushort lb_rxhead;		/* Value of head pointer after LB test  */
ushort	XDM_RTS;		/* Value of Adapt RTS bit		*/
ushort	XDM_CD;			/* Value of Adapt CD bit		*/
ushort	XDM_DSR;		/* Value of Adapt DSR bit		*/
ushort	XDM_CTS;		/* Value of Adapt CTS bit		*/
ushort	XDM_RI;			/* Value of Adapt RI bit		*/
ushort	XDM_DTR;		/* Value of Adapt DTR bit		*/
#ifdef DXB
ushort	XDM_IN_FLOW;	/* Value of input flow 			*/
ushort	XDM_OUT_FLOW;	/* Value of output flow			*/
#endif

uchar_t config_list[MAX_ADPT][STRSIZ]; /* Detailed config strings*/

int adpt_line=0;        /* Adapter line selected 0 = 1, 1 = 2   */
int selected_conc=0;	/* Concentrator selected by user        */
int slot=0;         	/* Slot selected 				*/
int conc=0;         	/* Concentrator selected 		*/
int channel=0;      	/* Channel selected 			*/
int a_line=1;       	/* Adapter line number 			*/

int total_boards;		/* Total number of DigiBoards seen		*/
int num_boards1;		/* # of boards seen by xall driver		*/
int num_boards2;		/* # of boards seen by epc,cx,xem driver*/
int num_boards3;		/* # of boards seen by pcxr driver		*/
int num_boards4;		/* # of boards seen by aspx driver		*/
int num_boards5;		/* # of boards seen by dxb driver		*/

long host_transmit=0;		/* Num of packets transmitted by host   */
long host_receive=0; 		/* Num of packets received by host   	*/
long host_rec_old=0;		/* Temp. storage.			*/
long host_trans_old=0;		/* Temp. storage.			*/
int sync_trans_index=0;		/* Propeller index.			*/
int sync_rec_index=0;		/* Propeller index.			*/

char cons_tbl[MAX_ADPT][3]; /* Concentrator status table
							   AC = Active
							   DN = Configured but down
							   NA = Adapter not configured for conc */

/* 
 * # of times we received an interrupt from the 8530 chip and there 
 * was no packets received. 
 */
long err_rec = 0;

/*
 * # of times the 8530 received interrupt and there was one packet received.
 */
long err_rec1 = 0;

/*
 * # of times the 8530 received interrupt and there was two packets received.
 */
long err_rec2 = 0;

/*
 * # of times the 8530 received interrupt and there was three packets received.
 */
long err_rec3 = 0;

/*
 * # of times the 8530 recieved interrupt and there was four packets received.
 */
long err_rec4 = 0;

/*
 * # of times the 8530 recieved interrupt and there was five packets received.
 */
long err_rec5 = 0;

/*
 * # of times the host desired to transmit a message, but had to delay
 * it because the transmitter was busy. 
 */
long err_relay = 0;

/*
 * # of times the host desired to transmit a message but was delayed
 * because there were no available transmit buffers. 
 */
long err_tbuf = 0;

/*
 * 8530 Framing error occurred. Com error.
 */
long err_uframe = 0;

/*
 * 8530 Frame status FIFO overflow occured.
 */
long err_fifo = 0;

/*
 * 8530 overrun occured.
 */
long err_orun = 0;

/*
 * An incomplete packet was received.
 */
long err_inc = 0;

/*
 * A packet was received with a CRC error.
 */
long err_crc = 0;

/*
 * 8530 abort status interrupt was processed. Hardware has detect an 
 * error with the packet.
 */
long err_abstat = 0;

/*
 * 8530 abort on receive was detected.
 */
long err_abrec = 0;

/*
 * 8530 transmit under run occured. The DMA did not complete the transfer
 * of the entire message. This caused the 8530 to send an incomplete packet.
 */
long err_urun = 0;

/*
 * A sync line status message was received with a bad check code.
 */
long err_check = 0;

/*
 * Sync line receive message queue overflow.
 */
long err_ritem = 0;

/*
 * Sync line message received with an address for a concentrator number 
 * larger than that configured.
 */
long err_addr = 0;

/*
 * Sync line message received with a bad message type field. 
 */
long err_mtype = 0;

/*
 * Sync line message was received with a bad length.
 */
long err_msize = 0;

/*
 * Sync line message was received with an out of sequence message ID.
 */
long err_rid = 0;

/*
 * Sync line transmit sequence number is out of sequence, reset 
 * communication link.
 */
long err_tid = 0;

/*
 * Error found in data portion of received message.
 */
long err_data = 0;

/*
 * The host received a sync line PING message when we weren't in PING mode.
 */
long err_host = 0;

/* The host received a message we sent to a concentrator. That concentrator 
 * must be down.
 */
long err_conc = 0;

/*
 * The host received a NACK for one of it's messages.
 */
long err_nack = 0;

/*
 * Variables to create the effect of clearing the FEP counters on
 * the status screen 
 */
long err_rec1_save = 0;
long err_rec2_save = 0;
long err_rec3_save = 0;
long err_rec4_save = 0;
long err_rec5_save = 0;
long host_transmit_save = 0;
long err_uframe_save = 0;
long err_abstat_save = 0;
long err_inc_save = 0;
long err_crc_save = 0;
long err_data_save = 0;
long err_nack_save = 0;
long err_tbuf_save = 0;
long err_fifo_save = 0;
long err_orun_save = 0;
long err_relay_save = 0;
long err_ritem_save = 0;
long err_rec_save = 0;
long err_addr_save = 0;
long err_mtype_save = 0;
long err_msize_save = 0;
long err_rid_save = 0;
long err_tid_save = 0;
long err_host_save = 0;
long err_abrec_save = 0;
long err_urun_save = 0;
long err_conc_save = 0;
long err_check_save = 0;

struct digi_info dinfo[MAX_ADPT]; /* Board information structure	*/
struct termio tbuf;		/* Terminal Structure			*/
struct termio sbuf;		/* Saved Terminal Structure		*/
struct bs_struct bs;    /* Board structure for each channel 	*/
static char beepc = '\007';     /* Beep at operator.			*/

static char *propeller[] =
{
	"|",
	"/",
	"-",
	"\\",
	"DOWN"
};

static char *table[] =
{
   	"Speed = 115K,  8-wire internal clock, Direct Connect",
   	"Speed = 230K,  4-wire self clocked, Direct Connect",
   	"Speed = 460K,  4-wire self clocked, Direct Connect",
   	"Speed = 2400,  8-wire internal clock, Direct Connect",
   	"Speed = 4800,  8-wire internal clock, Direct Connect",
   	"Speed = 9600,  8-wire internal clock, Direct Connect",
   	"Speed = 19.2K, 8-wire internal clock, Direct Connect",
   	"Speed = 38.4K, 8-wire internal clock, Direct Connect",
   	"Speed = 57.6K, 8-wire internal clock, Direct Connect",
   	"Speed = 76.8K, 8-wire internal clock, Direct Connect",
   	"Speed = 115K,  8-wire internal clock, Direct Connect",
   	"Speed = 230K,  8-wire internal clock, Direct Connect",
   	"Speed = 460K,  8-wire internal clock, Direct Connect",
   	"Speed = 920K,  8-wire internal clock, Direct Connect",
   	"Speed = 1.2M,  8-wire internal clock, Direct Connect",
   	"Speed = 2400,  8-wire ext clock RS-422, Sync Connect",
   	"Speed = 4800,  8-wire ext clock RS-422, Sync Connect",
   	"Speed = 9600,  8-wire ext clock RS-422, Sync Connect",
   	"Speed = 19.2K, 8-wire ext clock RS-422, Sync Connect",
   	"Speed = 38.4K, 8-wire ext clock RS-422, Sync Connect",
   	"Speed = 57.6K, 8-wire ext clock RS-422, Sync Connect",
   	"Speed = 76.8K, 8-wire ext clock RS-422, Sync Connect",
   	"Speed = 115K,  8-wire ext clock RS-422, Sync Connect",
   	"Speed = 230K,  8-wire ext clock RS-422, Sync Connect",
   	"Speed = 460K,  8-wire ext clock RS-422, Sync Connect",
   	"Speed = 920K,  8-wire ext clock RS-422, Sync Connect",
   	"Speed = 1.2M,  8-wire ext clock RS-422, Sync Connect",
   	"Reserved",
   	"Reserved",
   	"Reserved",
   	"Reserved",
   	"Reserved",
   	"Reserved",
   	"Speed = 14.4K, 8-wire ext clock RS-422, Sync Connect",
   	"Reserved",
   	"Speed = 2400,  8-wire ext clock RS-232, Sync Connect",
   	"Speed = 4800,  8-wire ext clock RS-232, Sync Connect",
   	"Speed = 9600,  8-wire ext clock RS-232, Sync Connect",
   	"Speed = 14.4K, 8-wire ext clock RS-232, Sync Connect",
   	"Speed = 19.2K, 8-wire ext clock RS-232, Sync Connect",
   	"Speed = 38.4K, 8-wire ext clock RS-232, Sync Connect",
   	"Speed = 57.6K, 8-wire ext clock RS-232, Sync Connect",
   	"Speed = 64K,   8-wire ext clock RS-232, Sync Connect",
   	"Speed = 76.8K, 8-wire ext clock RS-232, Sync Connect",
   	"Reserved",
   	"Reserved",
   	"Reserved",
   	"Reserved",
   	"Reserved",
   	"Reserved",
   	"Reserved",
   	"Reserved",
   	"Reserved",
   	"Reserved",
   	"Reserved",
   	"Reserved",
   	"Reserved",
   	"Reserved",
   	"Reserved",
   	"Reserved",
   	"Speed = 115K,  4-wire self clocked, Direct Connect",
   	"Speed = 115K,  4-wire self clocked, Direct Connect",
   	"Speed = 230K,  4-wire self clocked, Direct Connect",
   	"Speed = 230K,  4-wire self clocked, Direct Connect",
   	"Speed = 460K,  4-wire self clocked, Direct Connect",
   	"Speed = 460K,  4-wire self clocked, Direct Connect",
   	"Speed = 921K,  4-wire self clocked, Direct Connect",
   	"Speed = 921K,  4-wire self clocked, Direct Connect",
   	"Speed = 1.843M,  4-wire self clocked, Direct Connect",
   	"Speed = 1.843M,  4-wire self clocked, Direct Connect",
   	"Speed = 1.843M,  8-wire internal clock, Direct Connect",
   	"Speed = 2.458M,  8-wire internal clock, Direct Connect",
   	"Speed = 3.686M,  8-wire internal clock, Direct Connect",
   	"Speed = 7.373M,  8-wire internal clock, Direct Connect",
   	"Speed = 10M,  8-wire internal clock, Direct Connect"
};

#define UNKN_BD		0	/* Unknown board */
#define XEM_BD		1	/* Xem , Xr, Xr plus board */
#define CX_BD		2
#define EPC_BD		3
#define PCXX_BD		4
#define DXB_BD		5 	/* AccelePort RAS/Xr, DataFire RAS */
						/* 6 is unused, formerly ClusterPort */
#define AVXX_BD		7

struct adt_info {
	char print_type[25];
	char bd_state[10];
	char modtype[4][5];		/* Only for Xem adapter */
	unsigned short  nmodules;	/* Only for Xem adapter */
	unsigned long	ioport;		
	unsigned long	physaddr;
	unsigned long	physsize;
	unsigned long	memsize;
	unsigned short	bdtype;		/* Adapter board type */
	unsigned short  modem_table;

		/* Config string for display	*/
	uchar_t display_config[(CONFIGSIZE + 1) * 2]; 

	int line1conc;    		/* Number of Concentrators on line 1 	*/
	int line2conc;    		/* Number of Concentrators on line 2 	*/

	/*
	*  port information for this adapter
	*/

	unsigned short	nports;		/* total nbr of ports on this adapter */

		/* nports_conc [n] [0] used for concs & modules directly
		   connected to an adapter.  nports_conc [n] [1 - 3] used for
		   em modules attached to EPC/Con's on EPC/X adapters.
		*/

	unsigned char nports_conc[MAX_ADPTCONCS] [4]; /* nbr of ports */

	unsigned short port_addr[MAX_ADPTCONCS];	/* port address */

	/*
	*  em/Modem information for this adapter
	*/

	short emm_adpt;				/* 0 => no em/Modem on adapter
								   1 => em/Modem on adapter */

	unsigned char emm_conc[MAX_ADPTCONCS]; /* em/Modem location on conc */
};

/* emm_conc values: */

#define EMM_XEM		1	/* em/Modem on an Xem adapter */
#define EMM_EPC1	2	/* em/Modem 1st in chain on EPC/Con on EPC/X */
#define EMM_EPC2	4	/* em/Modem 2nd in chain on EPC/Con on EPC/X */
#define EMM_EPC3	8	/* em/Modem 3rd in chain on EPC/Con on EPC/X */

/*
*  em_modem = 0 => no em/Modems on this system
*  em_modem = 1 => em/Modems on this system
*/

int em_modem = 0;

struct adt_info adapt_info[MAX_ADPT]; /* Info converted to display format.	*/ 
struct digi_dinfo ddi; 		/* Device Driver information 		*/
struct digi_info  di;		/* Device Driver Board information	*/
uchar_t tmp[2];
uchar_t cfg_buf[50];
int   found_ebi=0;

