/* ex:se ts=4 sw=4 sm: */

#if !defined(lint)
static char dpac_id[] = "$Id: dpa.c,v 2.137 2003/06/25 22:00:51 scottk Exp $";
#endif /* !defined(lint) */

/* 
 * This software contains proprietary and confidential information of Digi
 * International Inc.  By accepting transfer of this copy, Recipient agrees
 * to retain this software in confidence, to prevent disclosure to others, and
 * to make no use of this software other than that for which it was delivered.
 * This is an unpublished copyright work Digi International Inc.  Except as
 * permitted by federal law, 17 USC 117, copying is strictly prohibited.
 *
 * Digi International Inc. CONFIDENTIAL - (Digi International Inc. Confidential
 * when combined with the aggregated modules for this product)
 * OBJECT CODE ONLY SOURCE MATERIALS
 * (C) COPYRIGHT Digi International Inc. 1993-1994
 * All Rights Reserved
 *
 * US Government Users Restricted Rights - Use, duplication or disclosure
 * restricted by GSA ADP Schedule Contract with Digi International Inc.
 */
/* DBI - 40000940 */

#if defined(HPUX)
	/*
	 *  In HP-UX, need to define the following to prevent 
	 *  some namespace collisions.  Must be defined _before_
	 *  including the curses headers.
	 */
#	define _TERM_INCLUDED
#endif /* HPUX */


#include <curses.h>

#if defined(SOLARIS)
#  define _POSIX_C_SOURCE 0
#  include <unistd.h>
#  undef _POSIX_C_SOURCE
#else /* !defined(SOLARIS) */
#  include <unistd.h>
#endif /* !defined(SOLARIS) */

#include <stdarg.h>
#include <string.h>
#include <stdlib.h>
#include <fcntl.h>
#include <ctype.h>

#ifdef USE_DIGI_PANEL
#include <digi_panel.h>
#else
#include <panel.h>
#endif

#include <sys/utsname.h>
#include <sys/stat.h>
#include <sys/uio.h>

#ifdef SCO
   /* SCO */
#  include <sys/sysmacros.h>
#elif (!defined(LINUX) && !defined(HPUX))
   /* not SCO, not LINUX */
#  include <sys/mkdev.h>
#endif

#include <libgen.h>
#include "mid.h"		   /* Used for smart card module id's */
#include <sys/types.h>

#if defined(LINUX)
#ifndef makedev

#include <sys/sysmacros.h>

#endif
#endif


#ifndef HAVE__GETMAXX
#	define  GetBegX(w)  ((w)->_begx)
#	define  GetBegY(w)  ((w)->_begy)
#	define  GetMaxX(w)  ((w)->_maxx)
#	define  GetMaxY(w)  ((w)->_maxy)
#else
#	define  GetBegX(w)  (__getbegx(w))
#	define  GetBegY(w)  (__getbegy(w))
#	define  GetMaxX(w)  (__getmaxx(w))
#	define  GetMaxY(w)  (__getmaxy(w))
#endif


#ifndef SOLARIS
#  ifdef SVR4
     /* SVR4, but not Solaris */
#    include "stdigi.h"
#  elif defined(LINUX)
     /* Linux */
#    include <termio.h>
#    include "rascon.h"
     typedef unsigned char	major_t;
     typedef unsigned char	minor_t;
     typedef unsigned char	uchar_t;
#    define NODEV			-1

#  elif defined(HPUX)
     /* HPUX */
     typedef unsigned char	uchar_t;
#    ifndef uchar
       typedef unsigned char	uchar;
#    endif
#    define ENDIANS_DIFFER 1
#    include <termio.h>
#    include "digi.h"
#    ifndef T_AVXX
#      define T_AVXX 9999
#    endif

#  else
#    include "digi.h"
#  endif /* SVR4 */
#else /* SOLARIS */
   /* We only set ENDIANS_DIFFER when the board differs from the host */
#  if defined(PCI)&&defined(SPARC)
#    define ENDIANS_DIFFER 1 /* FIXME */
#  endif
#  include "stdigi.h"
#endif /* SOLARIS */


#include "fepflags.h"
#include "dpa_fep.h"
#include "dpa.h"

#include <signal.h>

#ifdef SOLARIS
#  include <stropts.h>
#endif

#ifdef DXB
#  ifdef UNKNOWN
#    undef UNKNOWN
#  endif

#  if defined(LINUX)
#    include	"dxbtypes.h"
#    define	DXB_DLDEV	"/dev/dg/dgdm/dxbdl"
#    define	DXB_MGMT0DEV	"/dev/dg/dgdm/print%d"
#    define	DXB_MGMT5DEV	"/dev/dg/dgdm/mgmt%d"
#   if defined(DGAP_LINUX)
#    define	EPCA_DLDEV	"/dev/dg/dgap/mgmt"
#   else
#    define	EPCA_DLDEV	"/dev/dg/epca/epcadl"
#   endif

#  elif defined(UW7)
#    include	"dgtypes.h"
#    define	DXB_DLDEV	"/dev/dxb%drasmon1"
#    define	EPCA_DLDEV	"/dev/epcadl"

#  elif defined(SOLARIS)
#    include	"dgtypes.h"
#    define	DXB_DLDEV	"/dev/DIGIras/dgdxb_mgmt0"
#    define	DXB_MGMT5DEV	"/dev/DIGIras/dgdxb_mgmt%d"
#    define     DXB_MGMT0DEV    "/dev/DIGIras/dgdxb_mgmt%d"
#    if defined(i386)
#        define EPCA_DLDEV	"/dev/epcadl"
#    else
#        define EPCA_DLDEV	"/dev/epcdl"
#    endif
	/* New define for debugging dpa */
#    define	SOL_DEBUG	0x0

#    if defined(DXB)
#      include  "solshim.h"
#   
#    endif

#  elif defined(HPUX)
#    define	DGDXB_MISC_H
#    include	"dxbtypes.h"
#    include	"trace_os_dep.h"
#    define	DXB_DLDEV	"/dev/dgdxb/dl" 
#    define	EPCA_DLDEV	"/dev/dl"

#  elif defined(SCO)
#    include	"dxbtypes.h"
#    include	"trace_os_dep.h"
#    define	DXB_DLDEV	"/dev/dxbdl"
#    define	EPCA_DLDEV	"/dev/epcadl"

#  else
#    include	"dgtypes.h"
#    define	DXB_DLDEV	"/dev/dxbdl"
#    define	DXB_MGMT0DEV	"/dev/dxb%dmgmt0"
#    define	DXB_MGMT5DEV	"/dev/dxb%dmgmt5"
#    define	EPCA_DLDEV	"/dev/epcadl"
#  endif

#    include "mgmtioc1.h"

/* New defined for debugging DIGI_GETSTAT command */
#  define	DIGI_GETSTAT_DEBUG 0x0
/* New defined for debugging GET_SERIAL_STATUS command */
#  define	GET_SERIAL_STATUS_DEBUG 0x0
/* New defined for debugging GET_SERIAL_CONFIG command */
#  define	GET_SERIAL_CONFIG_DEBUG 0x0

/* functions for debugging dpa: */
void print_serial_config(const serial_config_t * const s);
void print_serial_status(const serial_status_t * const status);
void print_digi_getstat(const struct digi_stat * digistat);

#endif /* defined(DXB) */

#if defined(LINUX)
char *copylist(const char *filenm, off_t *szptr);
#endif

WINDOW *AdptWin;
WINDOW *ChanWin;
WINDOW *ConfigWin;
WINDOW *CRWin;
WINDOW *ErrorWin;
WINDOW *HeadWin;
WINDOW *IdentWin;
WINDOW *LBWin;
WINDOW *MainWin;
WINDOW *XemWin;
WINDOW *FLWin;

PANEL *AdptPanel;
PANEL *ChanPanel;
PANEL *ConfigPanel;
PANEL *CRPanel;
PANEL *ErrorPanel;
PANEL *HeadPanel;
PANEL *IdentPanel;
PANEL *LBPanel;
PANEL *MainPanel;
PANEL *XemPanel;
PANEL *FLPanel;

char *PGM = (char *) 0;
char *InstHdr = " Digi Port Authority ";

static char rev_info[]="$Revision: 2.137 $";

int FeatureRelease = 4;			/* increase when it is a new feature release */
int SCCS_level = 99;			/* the level when the feature level increased */
/*
 * char *VERSION = "Release.1.Level";  / * now created in release_number() * /
 */
char VERSION[10];
char **config_str;
#ifdef OSF
char *help_dir = "/etc/digi/";
#elif LINUX
char *help_dir = HELPDIR"/";
#else
char *help_dir = "/etc/digi/text/info/";
#endif
char *modem_dir = "/etc/digi/em_modem/";
char *report_file = "em_result";

char clbuf[81];

int USE_CURSES = FALSE;
int Chan_usage = 0;
int copyright_msg = TRUE;
int KEY_LINE;

int	ISSVR3;

#ifdef DXB
unsigned int dxb_port_speed = 0;
int save_tx_head = 0;
int save_rx_head = 0;
int save_channel = 0;
#endif

/*
*  em/Modem Flash ROM Load Globals
*/
char *emm_binary;
long  emm_binarysz;
char *emm_loader;
long  emm_loadersz;
int   emm_rptcnt;
FILE *emm_rptfd;
char scrn2_msg[STRSIZ];
char loader_n [MAX_REVS] [80];
char flashrom_n [MAX_REVS] [80];
char flashrom_r [MAX_REVS] [80];
int  flashrom_i;
int  flashrom_c;
char flashrom_loader[] = "flashrom.loader";

/*
*  slowbaud/fastbaud tables
*
*  These tables MUST match the fbaud_ tables found in ditty.c
*
*  slowbaud table indexed by [bs.cflag]
*  fastbaud tables indexed by [adapt_info[].bdtype] [bs.cflag]
*/

static char *slowbaud[16] =
{
	": 0 Baud",			/* 0x00 */
	": 50 Baud",		/* 0x01 */
	": 75 Baud",		/* 0x02 */
	": 110 Baud",		/* 0x03 */
	": 134 Baud",		/* 0x04 */
	": 150 Baud",		/* 0x05 */
	": 200 Baud",		/* 0x06 */
	": 300 Baud",		/* 0x07 */
	": 600 Baud",		/* 0x08 */
	": 1200 Baud",		/* 0x09 */
	": 1800 Baud",		/* 0x0A */
	": 2400 Baud",		/* 0x0B */
	": 4800 Baud",		/* 0x0C */
	": 9600 Baud",		/* 0x0D */
	": 19.2 K Baud",	/* 0x0E */
	": 38.4 K Baud"		/* 0x0F */
};

static char *fastbaud[8] [16] =
{
	{
		/*
		*  Unknown board
		*/

		": 0 Baud",			/* 0x00 */
		": 50 Baud",		/* 0x01 */
		": 75 Baud",		/* 0x02 */
		": 110 Baud",		/* 0x03 */
		": 134 Baud",		/* 0x04 */
		": 150 Baud",		/* 0x05 */
		": 200 Baud",		/* 0x06 */
		": 300 Baud",		/* 0x07 */
		": 600 Baud",		/* 0x08 */
		": 1200 Baud",		/* 0x09 */
		": 1800 Baud",		/* 0x0A */
		": 2400 Baud",		/* 0x0B */
		": 4800 Baud",		/* 0x0C */
		": 9600 Baud",		/* 0x0D */
		": 19.2 K Baud",	/* 0x0E */
		": 38.4 K Baud"		/* 0x0F */
	},
	{
		/*
		*  Xem, Xr or Xr plus board
		*/

		": 9600 Baud",		/* 0x00 */
		": 57.6 K Baud",	/* 0x01 */
		": 76.8 K Baud",	/* 0x02 */
		": 115.2 K Baud",	/* 0x03 */
		": 14.4 K Baud",	/* 0x04 */
		": 57.6 K Baud",	/* 0x05 */
		": 230.4 K Baud",	/* 0x06 */
		": 76.8 K Baud",	/* 0x07 */
		": 115.2 K Baud",	/* 0x08 */
		": 230.4 K Baud",	/* 0x09 */
		": 28.8 K Baud",	/* 0x0A */
		": 460.8 K Baud",	/* 0x0B */
		": 920.6 K Baud",	/* 0x0C */
		": 9600 Baud",		/* 0x0D */
		": 19.2 K Baud",	/* 0x0E */
		": 38.4 K Baud"		/* 0x0F */
	},
	{
		/*
		*  C/X board
		*/

		": 9600 Baud",		/* 0x00 */
		": 57.6 K Baud",	/* 0x01 */
		": 75 Baud",		/* 0x02 */
		": 115.2 K Baud",	/* 0x03 */
		": 14.4 K Baud",	/* 0x04 */
		": 57.6 K Baud",	/* 0x05 */
		": 200 Baud",		/* 0x06 */
		": 300 Baud",		/* 0x07 */
		": 115.2 K Baud",	/* 0x08 */
		": 1200 Baud",		/* 0x09 */
		": 28.8 K Baud",	/* 0x0A */
		": 2400 Baud",		/* 0x0B */
		": 4800 Baud",		/* 0x0C */
		": 9600 Baud",		/* 0x0D */
		": 19.2 K Baud",	/* 0x0E */
		": 38.4 K Baud"		/* 0x0F */
	},
	{
		/*
		*  EPC/X board
		*/

		": 9600 Baud",		/* 0x00 */
		": 57.6 K Baud",	/* 0x01 */
		": 76.8 K Baud",	/* 0x02 */
		": 115.2 K Baud",	/* 0x03 */
		": 14.4 K Baud",	/* 0x04 */
		": 57.6 K Baud",	/* 0x05 */
		": 230.4 K Baud",	/* 0x06 */
		": 76.8 K Baud",	/* 0x07 */
		": 115.2 K Baud",	/* 0x08 */
		": 230.4 K Baud",	/* 0x09 */
		": 28.8 K Baud",	/* 0x0A */
		": 2400 Baud",		/* 0x0B */
		": 4800 Baud",		/* 0x0C */
		": 9600 Baud",		/* 0x0D */
		": 19.2 K Baud",	/* 0x0E */
		": 38.4 K Baud"		/* 0x0F */
	},
	{
		/*
		*  PCXX/MCXX board
		*/

		": 9600 Baud",		/* 0x00 */
		": 57.6 K Baud",	/* 0x01 */
		": 76.8 K Baud",	/* 0x02 */
		": 115.2 K Baud",	/* 0x03 */
		": 14.4 K Baud",	/* 0x04 */
		": 28.8 K Baud",	/* 0x05 */
		": 200 Baud",		/* 0x06 */
		": 300 Baud",		/* 0x07 */
		": 600 Baud",		/* 0x08 */
		": 1200 Baud",		/* 0x09 */
		": 1800 Baud",		/* 0x0A */
		": 2400 Baud",		/* 0x0B */
		": 4800 Baud",		/* 0x0C */
		": 9600 Baud",		/* 0x0D */
		": 19.2 K Baud",	/* 0x0E */
		": 38.4 K Baud"		/* 0x0F */
	},
	{
		/*
		*  HERCULES OSR5 Implementation
		*/

		": 9600 Baud",		/* 0x00 */
		": 57.6 K Baud",	/* 0x01 */
		": 76.8 K Baud",	/* 0x02 */
		": 115.2 K Baud",	/* 0x03 */
		": 230.4 K Baud",	/* 0x04 */
		": 460.8 K Baud",	/* 0x05 */
		": 921.6 K Baud",	/* 0x06 */
		": 76.8 K Baud",	/* 0x07 */
		": 115.2 K Baud",	/* 0x08 */
		": 230.4 K Baud",	/* 0x09 */
		": 28.8 K Baud",	/* 0x0A */
		": 460.8 K Baud",	/* 0x0B */
		": 920.6 K Baud",	/* 0x0C */
		": 9600 Baud",		/* 0x0D */
		": 19.2 K Baud",	/* 0x0E */
		": 38.4 K Baud"		/* 0x0F */
	},
	{
		/*
		*  Unknown board (formerly ClusterPort)
		*/

		": 0 Baud",			/* 0x00 */
		": 50 Baud",		/* 0x01 */
		": 75 Baud",		/* 0x02 */
		": 110 Baud",		/* 0x03 */
		": 134 Baud",		/* 0x04 */
		": 150 Baud",		/* 0x05 */
		": 200 Baud",		/* 0x06 */
		": 300 Baud",		/* 0x07 */
		": 600 Baud",		/* 0x08 */
		": 1200 Baud",		/* 0x09 */
		": 1800 Baud",		/* 0x0A */
		": 2400 Baud",		/* 0x0B */
		": 4800 Baud",		/* 0x0C */
		": 9600 Baud",		/* 0x0D */
		": 19.2 K Baud",	/* 0x0E */
		": 38.4 K Baud"		/* 0x0F */
	},
	{
		/*
		*  Xr 2000 board
		*/

		": 9600 Baud",		/* 0x00 */
		": 57.6 K Baud",	/* 0x01 */
		": 76.8 K Baud",	/* 0x02 */
		": 115.2 K Baud",	/* 0x03 */
		": 14.4 K Baud",	/* 0x04 */
		": 57.6 K Baud",	/* 0x05 */
		": 230.4 K Baud",	/* 0x06 */
		": 76.8 K Baud",	/* 0x07 */
		": 115.2 K Baud",	/* 0x08 */
		": 230.4 K Baud",	/* 0x09 */
		": 28.8 K Baud",	/* 0x0A */
		": 460.8 K Baud",	/* 0x0B */
		": 920.6 K Baud",	/* 0x0C */
		": 9600 Baud",		/* 0x0D */
		": 19.2 K Baud",	/* 0x0E */
		": 38.4 K Baud"		/* 0x0F */
	}
};

extern long HasAttr;
ushort old_tx_head = 0;

/* 
 * Prototypes.
 */
ushort SHORT (ushort x);
int INT (int x);

ushort GET_LE_SHORT (void *addr);
ushort GET_BE_SHORT (void *addr);
int GET_LE_INT (void *addr);
int GET_BE_INT (void *addr);

void release_number (void);
void erase_win (WINDOW *);
void TermDepSetup (void);
void StartCurses (void);
void EndCurses (int exitval);
void ShowMsg (char *);
int AskYN (char *);
void acsbox (WINDOW *);
int commandline (char *s, ...);
void topbox (WINDOW *);
void solidbox (WINDOW *);
void fillwin (WINDOW *, int);
int center (WINDOW *, int);
void refresh_screen (void);
void ShowCopyright (void);
void info_screen (char *, char *);
void Open_Devs (void);
void usage (void);
void change_term (int, int);
void restore_term (void);
int hex2int (char *);
char *line1conf (int, char *);
char *line2conf (int, char *);
int parse_cx (int, char line[][3]);
int parse_epc (int, char line[][3], int, int);
void get_config (int, int);
void screen_print (WINDOW *, FILE *);
void screen_save (WINDOW *, char *);
void print_errcounts (void);
PANEL *CreateConcPanel (int *);
void print_config (int);
void print_c_adptconf (int);
void print_adptconf (int);
void print_Xemconf (void);
void print_identify (void);
void get_errors (void);
void get_channel (int, struct bs_struct *);
void get_status (int);
void get_lbkey (void);
void loop_back (void);
void loop_back_modem (void);
int  test_busy (struct bs_struct *, int, char *);
int  test_send (struct bs_struct *, int, char *, int);
int  test_recv (struct bs_struct *, int, unsigned short, char *, int, int);
int  get_em_resp(int, int, int, char *, char *, int);
void reset_port (void);
int compare_revs (char *first, char *second);


/*
 *  The following declarations are for modem Xem operations, and are
 *  supported only under certain operating systems.
 */
#ifndef NO_MODEM_OPTS

	void loop_back_modem (void);
	int  get_em_resp(int, int, int, char *, char *, int);

	/* Flash ROM Load Prototypes */

	int  load_modem_flash (int, int, int);
	void print_flashl (int, int);
	void do_flashl_adpts (int, int);
	int  get_flr_name (void);
	int  em_get_device (int, int, int, char *);

#endif /* !NO_MODEM_OPTS */

void print_channel (void);
void DisplayHeader (void);
void CreateWins (void);
void DeleteWins (void);

#if ENDIANS_DIFFER
int endians_differ = 1;
#else
int endians_differ = 0;
#endif


/**********************************************************************
*
*  Routine Name:	SHORT, INT
*
*  Function:	Compensate for endian differences between adapters
*				and the host.  If a host has adapters with two
*				differerent endians, endians_differ can be toggled
*				as needed.  Otherwise it can be left alone, since
*				it should default to the correct value.
*
**********************************************************************/

ushort 
SHORT (ushort x)
{
	unsigned char *c;

	if (endians_differ)
	{
		c = (unsigned char *) &x;

		return ((*(c + 1) << 8) | *c);
	}
	else
		return (x);
}

int 
INT (int x)
{
	unsigned char *c;

	if (endians_differ)
	{
		c = (unsigned char *) &x;

		return ((*(c + 3) << 24) | (*(c + 2) << 16) | (*(c + 1) << 8) | *c);
	}
	else
		return (x);
}

/**********************************************************************
*
*  Routine Name:	GET_LE_SHORT, GET_LE_INT,
*                       GET_BE_SHORT, GET_BE_INT
*
*  Function:   Compensate for endian differences between adapters
*              and the host.  These functions take a pointer to
*              an arbitrary memory location and interprets the bytes found
*              there as a (little endian/big endian) (short/int).
*
**********************************************************************/

ushort 
GET_LE_SHORT (void *addr)
{
	unsigned char *c = addr;

	return ((*(c + 1) << 8) | *c);
}

ushort 
GET_BE_SHORT (void *addr)
{
	unsigned char *c = addr;

	return ((*c << 8) | *(c + 1));
}

int 
GET_LE_INT (void *addr)
{
	unsigned char *c = addr;

	return ((*(c + 3) << 24) | (*(c + 2) << 16) | (*(c + 1) << 8) | *c);
}

int 
GET_BE_INT (void *addr)
{
	unsigned char *c = addr;

	return ((*c << 24) | (*(c + 1) << 16) | (*(c + 2) << 8) | *(c + 3));
}



/**********************************************************************
*
*  Routine Name:	release_number
*
*  Function:	Create the correct release number
*
**********************************************************************/

void 
release_number ()
{
	char tmp[10];
	int Release;
	int Level;

	Release = atoi(strchr(rev_info, ' ') + 1);
	Level = atoi(strchr(rev_info, '.') + 1);
	sprintf (VERSION, "%d", Release);
	sprintf (tmp, ".%d.%d", FeatureRelease, Level - SCCS_level);
	Strcat (VERSION, tmp);
}



/**********************************************************************
*
*  Routine Name:	erase_win
*
*  Function:	Overwrites all chars on the panel (not the border)
*
**********************************************************************/

void 
erase_win (w)
	WINDOW *w;
{
	register int y, x, lines, cols;

	lines = GetMaxY(w);
	cols = GetMaxX(w);

	for (y = 1; y < lines - 1; y++)
		for (x = 1; x < cols - 1; x++)
			mvwaddstr (w, y, x, " ");
}



/**********************************************************************
*
*  Routine Name:	TermDepSetup
*
*  Function:	
*
**********************************************************************/

void
TermDepSetup ()
{
	char *termtype = getenv ("TERM");

	/*
	 * when the term type is one of the following, we do not want to
	 * tell the user to use keys that are probably not mapped correctly
	 */
	if (!strncmp (termtype, "xterm", 5) ||
		!strncmp (termtype, "vt100", 5) || 
#if 0
		!strncmp (termtype, "sun", 3) || 
#endif
		!strncmp (termtype, "wy", 2))
	{
		strcpy (helpstr, "?=Help");
		strcpy (lrudstr, "h/j/k/l=Move");
		strcpy (updnstr, "j/k=Move");
		strcpy (pgdnstr, "N=Next Page");
		strcpy (pgupstr, "P=Previous Page");
	}
	else
	{
		strcpy (helpstr, "F1=Help");
		strcpy (lrudstr, "Arrows=Move");
		strcpy (updnstr, "Arrows=Move");
		strcpy (pgdnstr, "<Page Down>=Next Page");
		strcpy (pgupstr, "<Page Up>=Previous Page");
	}

	if (debug)
	{
		fprintf (dfp, "\n***** TermDepSetup *****\n");
		fprintf (dfp, "TERM = %s\n", termtype);
		fprintf (dfp, "Help String = %s\n", helpstr);
		fprintf (dfp, "L/R/U/D Arrows = %s\n", lrudstr);
		fprintf (dfp, "U/D Arrows = %s\n", updnstr);
		fprintf (dfp, "Page Down = %s\n", pgdnstr);
		fprintf (dfp, "Page Up = %s\n", pgupstr);
		fflush (dfp);
	}
}



/**********************************************************************
*
*  Routine Name:	StartCurses
*
*  Function:	Start curses
*
**********************************************************************/

void 
StartCurses ()
{
	struct termio tio;
	int i = 0;

	USE_CURSES = TRUE;
	initscr ();
	nonl ();

	if (ioctl (0, TCGETA, &tio) < 0)
	{
		EndCurses (-1);			   /* die horribly */
	}

	tio.c_cc[VMIN] = 1;
	tio.c_cc[VTIME] = 0;
	tio.c_lflag &= ~(ISIG | ICANON | ECHO | ECHOE | ECHOK | ECHONL);

	if (ioctl (0, TCSETA, &tio) < 0)
	{
		EndCurses (-2);			   /* die horribly */
	}

	noecho ();
	cbreak ();
	signal (SIGINT, SIG_IGN);
	keypad (stdscr, TRUE);
	start_color ();

	if ((int)(tigetstr ("smul")) > 0)
		HasAttr |= A_UNDERLINE;
	if ((int)(tigetstr ("rev")) > 0)
		HasAttr |= A_REVERSE;
	if ((int)(tigetstr ("bold")) > 0)
		HasAttr |= A_BOLD;

	for (i = 0; i < 16; i++)
		Strncpy (cons_tbl[i], "NA", 2);

	KEY_LINE = (LINES >= 24) ? LINES - 1 : 23;
}



/**********************************************************************
*
*  Routine Name:	EndCurses
*
*  Function:	End curses
*
**********************************************************************/

void 
EndCurses (int exitval)
{
	if (USE_CURSES)
	{
		USE_CURSES = FALSE;
		/*
		 * FixMe - This should really only do closes, and then
		 * some other stuff if CreateWins () has been called
		 */
		DeleteWins ();
		if(debug)
			fprintf(dfp, "dpa - exiting abnomally #1 - %d\n", exitval);
		exit (exitval);
	}
}



/**********************************************************************
*
*  Routine Name:	AskYN
*
*  Function:	Prompts a user for a Yes/No answer to the given question
*
**********************************************************************/

int
AskYN (question)
	char *question;
{
	int length = strlen (question);
	int x, y, startx, starty;
	int spaces = 4;
	int rval = 0;
	int done = FALSE;

	WINDOW *AskWin;
	PANEL *AskPanel;

	x = length + spaces * 2;
	y = 5;
	startx = (COLS - x) / 2;
	starty = (LINES - y) / 2;

	AskWin = newwin (y, x, starty, startx);
	AskPanel = new_panel (AskWin);

	wattrset (AskWin, make_attr (A_NORMAL, CYAN, BLACK));
	box (AskWin, 0, 0);
	wattroff (AskWin, make_attr (A_NORMAL, CYAN, BLACK));

	wattrset (AskWin, make_attr (A_BOLD, WHITE, RED));
	mvwprintw (AskWin, 0, center (AskWin, strlen (" User Input ")),
			   " User Input ");
	wattroff (AskWin, make_attr (A_BOLD, WHITE, RED));

	mvwprintw (AskWin, 2, 4, question);

	show_panel (AskPanel);
	update_panels ();
	doupdate ();
	wrefresh (AskWin);
	flushinp ();
	while (!done)
	{
		switch (toupper (wgetch (AskWin)))
		{
			case 'Y':
				rval = TRUE;
				done = TRUE;
				waddch (AskWin, 'Y');
				wrefresh (AskWin);
				break;
			case 'N':
				rval = FALSE;
				done = TRUE;
				waddch (AskWin, 'N');
				wrefresh (AskWin);
				break;
		}
	}

	if (debug)
	{
		fprintf (dfp, "***** Debug info from AskYN *****\n");
		fprintf (dfp, "Question: %s\n", question);
		fprintf (dfp, "Answer: %s\n", (rval) ? "TRUE" : "FALSE");
		fflush (dfp);
	}

	wrefresh (AskWin);
	sleep (1);
	hide_panel (AskPanel);
	wrefresh (AskWin);
	update_panels ();
	doupdate ();
	del_panel (AskPanel);
	delwin (AskWin);
	flushinp ();

	return rval;
}



/**********************************************************************
*
*  Routine Name:	ShowMsg
*
*  Function:	Displays a message in a window
*
**********************************************************************/

void 
ShowMsg (err)
	char *err;
{
	int str_len = strlen (err);
	int x, y, startx, starty;
	int newx;
	int spaces = 4;

	WINDOW *ShowMsgWin;
	PANEL *ShowMsgPanel;

	x = str_len + spaces * 2;
	y = 6;

	startx = (GetMaxX(MainWin) / 2) - x / 2;
	starty = (GetMaxY(MainWin) / 2) - y / 2;

	ShowMsgPanel = new_panel (newwin (y, x, starty, startx));
	ShowMsgWin = panel_window (ShowMsgPanel);
	wattrset (ShowMsgWin, make_attr (A_NORMAL, CYAN, BLACK));

	box (ShowMsgWin, 0, 0);

	wattroff (ShowMsgWin, make_attr (A_NORMAL, CYAN, BLACK));

	wattrset (ShowMsgWin, make_attr (A_BOLD, WHITE, RED));
	mvwprintw (ShowMsgWin, 0, center (ShowMsgWin, strlen (" Message ")),
			   " Message ");
	wattroff (ShowMsgWin, make_attr (A_BOLD, WHITE, RED));

	mvwprintw (ShowMsgWin, 2, 4, err);
	newx = ((int) (GetMaxX(ShowMsgWin)) / 2)
		- ((int) (strlen ("Press ANY key to continue")) / 2);
	wattrset (ShowMsgWin, make_attr (A_STANDOUT | A_BOLD, WHITE, BLUE));
	mvwprintw (ShowMsgWin, y - 2, newx, "Press ANY key to continue");
	wattroff (ShowMsgWin, make_attr (A_STANDOUT | A_BOLD, WHITE, BLUE));

	if (debug)
	{
		fprintf (dfp, "***** Debug info from ShowMsg *****\n");
		fprintf (dfp, "Error message: %s\n", err);
		fprintf (dfp, "LINES: %d, COLUMNS: %d\n", LINES, COLS);
		fprintf (dfp, "startx: %d, starty: %d\n", startx, starty);
		fprintf (dfp, "height: %d, width: %d\n", y, x);
		fflush (dfp);
	}

	show_panel (ShowMsgPanel);
	change_term (1, 0);
	wgetch (ShowMsgWin);
	change_term (0, TIMEOUT);
	hide_panel (ShowMsgPanel);
	update_panels ();
	doupdate ();
	wrefresh (ShowMsgWin);
	del_panel (ShowMsgPanel);
	delwin (ShowMsgWin);
}



/**********************************************************************
*
*  Routine Name:	
*
*  Function:	
*
**********************************************************************/

void 
acsbox (w)						/* places a double line box around the window */
	WINDOW *w;
{
	register int y, x;

	wattrset (w, make_attr (A_NORMAL, WHITE, BLACK));
	for (x = 1; x < GetMaxX(w) - 1; x++)
	{
		mvwaddch (w, 0, x, ACS_HLINE);
		mvwaddch (w, GetMaxY(w) - 1, x, ACS_HLINE);
	}

	for (y = 1; y < GetMaxY(w) - 1; y++)
	{
		mvwaddch (w, y, 0, ACS_VLINE);
		mvwaddch (w, y, GetMaxX(w) - 1, ACS_VLINE);
	}

	mvwaddch (w, 0, 0, ACS_ULCORNER);

	mvwaddch (w, 0, GetMaxX(w) - 1, ACS_URCORNER);
	mvwaddch (w, GetMaxY(w) - 1, 0, ACS_LLCORNER);
	mvwaddch (w, GetMaxY(w) - 1, GetMaxX(w) - 1, ACS_LRCORNER);

	wattroff (w, make_attr (A_NORMAL, WHITE, BLACK));
}



/**********************************************************************
*
*  Routine Name:	
*
*  Function:	
*
**********************************************************************/

int
commandline (char *s,...)
{
	int i = 1, j = 0;
	int total_len = 0, num_args = 0;
	int remain = 0;				/* remaining spaces, not even distribution */
	int spaces = 0, leading = 0, trailing = 0;
	int err = 0;
	int diff = 0;
	int one_option = FALSE;
	va_list strings;
	char *p;
	char **args;
	char space_str[40] = "\0";
	char lspace_str[40] = "\0";
	char tspace_str[40] = "\0";

	/* erase previous contents */
	memset (clbuf, '\0', strlen (clbuf));
	memset (space_str, '\0', strlen (space_str));
	memset (lspace_str, '\0', strlen (lspace_str));
	memset (tspace_str, '\0', strlen (tspace_str));

	/* copy first string */
	va_start (strings, s);
	if ((p = va_arg (strings, char *)) == NULL)
	{
		err = -1;
		return (err);
	}
	else
	{
		args = (char **) malloc (sizeof (char *));

		args[0] = (char *) malloc (strlen (p) + 1);
		Strcpy (args[0], p);
		total_len = strlen (p);
	}

	/* append others */
	while ((p = va_arg (strings, char *)) != NULL)
	{
	  if ((args = (char **) realloc (args, i * sizeof (char *) + 1)) == NULL) {
		  if(debug) {
			  fprintf(dfp, "dpa - exiting abnomally #2\n");
		  }
		  exit (1);
	  }

		args[i] = (char *) malloc (strlen (p) + 1);
		total_len += strlen (p);
		if (total_len > 80)
		{
			err = -1;
			return (err);
		}
		Strcpy (args[i], p);
		i++;
	}
	va_end (strings);
	num_args = i;

	/*
	 * test for sufficient spacing, minimum of no leading or trailing
	 * spaces, just 2 spaces between the choices
	 */

	if (num_args >= 2)
	{
		spaces = (80 - total_len) / (num_args - 1);
		remain = (80 - total_len) % (num_args - 1);
	}
	else
	{
		spaces = 0;
		one_option = TRUE;
		remain = (80 - total_len);
	}
	leading = remain / 2 + remain % 2;
	trailing = remain / 2;

	if ((spaces >= 2) || (one_option))
	{
		/*
		 * check for possible equal leading and trailing spaces, if we were 
		 * either one or 2 spaces short, take them from the beginning, and/or
		 * the end of the line
		 */
		if (!one_option)
		{
			spaces = (80 - total_len) / (num_args + 1);
			remain = (80 - total_len) % (num_args + 1);
			leading = spaces;
			trailing = spaces;
		}

		if (remain == num_args)
		{
			leading += 1;
			spaces += 1;
		}
		else if (remain == num_args - 1)
		{
			spaces += 1;
		}
		else if (!one_option)
		{
			diff = num_args - 1 - remain;
			leading -= diff / 2;
			trailing -= (diff / 2 + diff % 2);
			spaces += 1;

			if (leading < 0)
			{
				spaces -= 1;
				leading = spaces;
			}

			if (trailing < 0)
			{
				spaces -= 1;
				trailing = spaces;
			}
		}

		if (leading > 0)
		{
			Strcpy (lspace_str, " ");
			for (i = 1; i < leading; i++)
				Strcat (lspace_str, " ");
		}

		if (trailing > 0)
		{
			Strcpy (tspace_str, " ");
			for (i = 1; i < trailing; i++)
				Strcat (tspace_str, " ");
		}

		if (spaces > 0)
		{
			Strcpy (space_str, " ");
			for (i = 1; i < spaces; i++)
				Strcat (space_str, " ");
		}

		/*
		 * make the key line string
		 */
		Strcpy (s, lspace_str);
		for (i = 0; i < num_args; i++)
		{
			Strcat (s, args[i]);
			if (i < (num_args - 1))
				Strcat (s, space_str);
		}
		Strcat (s, tspace_str);
	}
	else
	{
		sprintf (s, "Option list is too long, need %d fewer characters",
				 total_len + (2 * (num_args - 1)) - 80);
	}

	/*
	 * free the malloc'ed space
	 */

	for (j = 0; j < i; j++)
		free (args[j]);
	free (args);

	return (err);
}



/**********************************************************************
*
*  Routine Name:	
*
*  Function:	
*
**********************************************************************/

void 
topbox (w)
	WINDOW *w;
{
	register int y, x;

	wattron (w, make_attr (A_ALTCHARSET, WHITE, RED));
	for (x = 1; x < GetMaxX(w) - 1; x++)
	{
		mvwaddch (w, 0, x, 0xc4);
		mvwaddch (w, GetMaxY(w) - 1, x, 0xc4);
	}
 
	for (y = 1; y < GetMaxY(w) - 1; y++)
	{
		mvwaddch (w, y, 0, 0xb3);
		mvwaddch (w, y, GetMaxX(w) - 1, 0xb3);
	}

	mvwaddch (w, 0, 0, 0xc9);
	mvwaddch (w, 0, GetMaxX(w) - 1, 0xbb);
	mvwaddch (w, GetMaxY(w) - 1, 0, 0xc8);
	mvwaddch (w, GetMaxY(w) - 1, GetMaxX(w) - 1, 0xbc);
	wattroff (w, make_attr (A_ALTCHARSET, WHITE, RED));
}



/**********************************************************************
*
*  Routine Name:	
*
*  Function:	
*
**********************************************************************/

void 
solidbox (w)
	WINDOW *w;
{
	register int y, x;

	wattron (w, make_attr (A_STANDOUT, BLACK, BLUE));
	for (x = 0; x < GetMaxX(w); x++)
	{
		mvwaddch (w, 0, x, ' ');
		mvwaddch (w, GetMaxY(w) - 1, x, ' ');
	}
	for (y = 0; y < GetMaxY(w); y++)
	{
		mvwaddch (w, y, 0, ' ');
		mvwaddch (w, y, GetMaxX(w) - 1, ' ');
	}

	wattroff (w, make_attr (A_STANDOUT, BLACK, BLUE));
}



/**********************************************************************
*
*  Routine Name:	
*
*  Function:	
*
**********************************************************************/

void 
fillwin (w, i)
	WINDOW *w;
	int i;
{
	register int y, x, lines, cols;

	lines = GetMaxY(w);
	cols = GetMaxX(w);

	for (y = 0; y < lines; y++)
		for (x = 0; x < cols; x++)
			mvwaddch (w, y, x, i);
}



/**********************************************************************
*
*  Routine Name:	
*
*  Function:	
*
**********************************************************************/

int 
center (win, str_width)
	WINDOW *win;
	int str_width;
{
	int i;

	int win_width = GetMaxX(win);

	i = (win_width / 2) - ((str_width + 1) / 2);
	if (i < 0)
		i = 0;

	return i;
}



/**********************************************************************
*
*  Routine Name:	
*
*  Function:	
*
**********************************************************************/

void
refresh_screen ()
{
	touchwin (curscr);
	wrefresh (curscr);
}



/**********************************************************************
*
*  Routine Name:	
*
*  Function:	
*
**********************************************************************/

void 
ShowCopyright ()
{
	wattrset (CRWin, make_attr (A_NORMAL, GREEN, BLACK));
	mvwprintw (CRWin, 2, 18, "RESTRICTED RIGHTS LEGEND");
	mvwprintw (CRWin, 4, 4,
	 "Use, duplication, or disclosure by the Government is");
	mvwprintw (CRWin, 5, 4,
	 "subject to restrictions as set forth in subparagraph");
	mvwprintw (CRWin, 6, 4,
	 "(c)(1)(ii) of the Rights in Technical Data and");
	mvwprintw (CRWin, 7, 4,
	 "Computer Software clause at DFARS 252.227-7013.");
	mvwprintw (CRWin, 9, 17, "Digi International Inc.");
	mvwprintw (CRWin, 10, 17, "11001 Bren Road E.");
	mvwprintw (CRWin, 11, 17, "Minnetonka, MN 55343");

	wattrset (CRWin, make_attr (A_STANDOUT | A_BOLD, WHITE, BLUE));
	mvwprintw (CRWin, 15, 15, " Press ANY key to continue ");
	wattroff (CRWin, make_attr (A_STANDOUT | A_BOLD, WHITE, BLUE));
	touchwin (CRWin);
	keypad (CRWin, TRUE);
	show_panel (MainPanel);
	show_panel (CRPanel);
	update_panels ();
	doupdate ();
	wrefresh (MainWin);
	wrefresh (CRWin);
	wgetch (CRWin);
	hide_panel (CRPanel);
	update_panels ();
	doupdate ();
	wrefresh (CRWin);
}




/**********************************************************************
*
*  Routine Name:	
*
*  Function:	
*
**********************************************************************/

/* 
 *    info_screen -   This routine will read in a text file then put the text 
 *                  into an adjusted window.  Use this for online help.
 */
void
info_screen (in, caller_txt)
	char *in;
	char *caller_txt;
{
	WINDOW *HelpWin;
	PANEL *HelpPanel;
	FILE *fp;
	char buf[80];
	char path[256];
	char err[256];
	int line = 1, limit = 16;
	int option = EOF;
	int startline = 1, endline = 0;
	int change = TRUE;
	int one_page = FALSE;


	sprintf (path, "%s%s", help_dir, in);
	if (!(fp = fopen (path, "r")))
	{
		sprintf (err, "Error: File: %s does not exist", path);
		ShowMsg (err);
		return;
	}
	/* count total lines */
	while (fgets (buf, sizeof (buf), fp) != NULL)
		++endline;
	rewind (fp);

	if ((HelpPanel = new_panel (newwin (18, 78, 5, 1))))
	{
		HelpWin = panel_window (HelpPanel);
		keypad (HelpWin, 1);
		wattrset (HelpWin, make_attr (A_NORMAL, BLACK, CYAN));
		box (HelpWin, 0, 0);
		mvwprintw (HelpWin, 17, (73 - strlen (path)), "[%s]", path);
		wattroff (HelpWin, make_attr (A_NORMAL, BLACK, CYAN));
	}
	else
	{
		ShowMsg ("Error creating a new window/panel");
		EndCurses (-3);
	}

	wattrset (HelpWin, make_attr (A_BOLD | A_STANDOUT, WHITE, RED));

	if (caller_txt == NULL)
	{
		mvwprintw (HelpWin, 0, center (HelpWin, strlen (" DPA HELP ")),
		 " DPA HELP ");
	}
	else
	{
		mvwprintw (HelpWin, 0, center (HelpWin, strlen (caller_txt)),
		 "%s", caller_txt);
	}

	wattroff (HelpWin, make_attr (A_BOLD | A_STANDOUT, WHITE, RED));

	/* this will not time-out */
	change_term (1, 0);
	while ((option != 'Q') && (option != 'q') && (option != ESC))
	{
		/* Only do this if a new page is desired */
		if (change)
		{
			wattrset (HelpWin, make_attr (A_NORMAL, BLACK, CYAN));
			erase_win (HelpWin);
			change = FALSE;
			line = 1;

			while (fgets (buf, sizeof (buf), fp) != NULL)
			{
				buf[strlen (buf) - 1] = '\0';
				mvwprintw (HelpWin, line, 2, "%s", buf);
				if (line++ >= limit)
					break;
			}
			wattroff (HelpWin, make_attr (A_NORMAL, BLACK, CYAN));
			wmove (MainWin, KEY_LINE, 0);
			wrefresh (MainWin);
		}

		wattrset (MainWin, make_attr (A_NORMAL, WHITE, BLUE));
		if (startline == 1)
		{
			if (endline <= limit)  /* only one page */
			{
				one_page = TRUE;
				commandline (clbuf, "Press ANY key to continue.", NULL);
				mvwprintw (MainWin, KEY_LINE, 0, clbuf);
			}
			else
				/* first page */
			{
				commandline (clbuf, "ESC=Continue", pgdnstr, NULL);
				mvwprintw (MainWin, KEY_LINE, 0, clbuf);
			}
		}
		else if (endline - startline < limit)	/* last page */
		{
			commandline (clbuf, "ESC=Continue", pgupstr, NULL);
			mvwprintw (MainWin, KEY_LINE, 0, clbuf);
		}
		else
			/* a middle page */
		{
			commandline (clbuf, "ESC=Continue", pgdnstr,
						 pgupstr, NULL);
			mvwprintw (MainWin, KEY_LINE, 0, clbuf);
		}

		wattroff (MainWin, make_attr (A_NORMAL, WHITE, BLUE));
		wrefresh (MainWin);

		switch (option = wgetch (HelpWin))
		{
		case EOF:
			break;
		case ctrl ('L'):
			refresh_screen ();
			break;
#ifdef KEY_UP
		case KEY_PPAGE:
#endif
		case 'P':
		case 'p':
			if (startline > 1)
			{
				startline -= limit;
				/* reset file pointer */
				rewind (fp);
				/* move to desired position */
				for (line = 1; line < startline; line++)
					fgets (buf, sizeof (buf), fp);
				change = TRUE;
			}
			break;
#ifdef KEY_DOWN
		case KEY_NPAGE:
#endif
		case 'N':
		case 'n':
			if (endline >= startline + limit)
			{
				startline += limit;
				change = TRUE;
			}
			break;
		case 'Q':
		case 'q':
		case ESC:
			option = 'Q';
			break;
		default:
			if (one_page)
				option = 'Q';
			break;
		}						   /* Switch */
	}							   /* End While Loop */

	change_term (0, TIMEOUT);
	fclose (fp);
	hide_panel (HelpPanel);
	update_panels ();
	doupdate ();
	del_panel (HelpPanel);
	delwin (HelpWin);
}


/**********************************************************************
*
*  Routine Name:	
*
*  Function:	
*
**********************************************************************/

void
check_svr3()
{
/*
 * check if we're running Interactive Unix SVR3
 */ 
	uname(&os_info);
	if(!strcmp("unix", os_info.sysname) &&
	   !strcmp("3.2", os_info.release) &&
	   !strcmp("2", os_info.version)) 
	   ISSVR3 = TRUE;
	else
	   ISSVR3 = FALSE;
}


/**********************************************************************
*
*  Routine Name:	
*
*  Function:	
*
**********************************************************************/

void 
Open_Devs ()
{
	char msg[256];

#if UW7
	char device[80];
	int		i;
	int		j;
#endif

#ifndef MRGDRV
	if (ISSVR3)
		pcxrfd = -1;
	else
		pcxrfd = open ("/dev/pcxrdl", O_RDWR | O_NONBLOCK);

	aspxfd = open ("/dev/aspxdl", O_RDWR | O_NONBLOCK);
#endif
	pcxxfd = open ("/dev/pcxxdl", O_RDWR | O_NONBLOCK);

	epcafd = open (EPCA_DLDEV, O_RDWR | O_NONBLOCK);

#ifdef DXB

#  ifndef UW7

	dxbfd = open(DXB_DLDEV, O_RDWR | O_NONBLOCK);

#  else
	/* UnixWare 7 */
	for (i=0; i < 8; i++ ) { // For dxb0 to dxb7
		for (j=1; j < 7; j++ ) { // For rasmon1 to rasmon6

			sprintf(device, "/dev/dxb%drasmon%d", i,j);
#    if DBUG
			if (debug)
				fprintf (dfp, "Open_Devs: Try to open( %s,) "
				              "for i=%d, j=%d\n", 
			                      device, i, j);
#    endif
			if (!access (device, F_OK))	   /* File Exists */
			{
				// Can we open it?
				if ((dxbfd = open(device,
				     O_RDWR | O_NONBLOCK) ) > 0) {
#    if DBUG
					if (debug)
						fprintf (dfp, "OK call open( %s,"
					              "fd=%d )\n",
					              device, dxbfd);
#    endif
					i = 1000; // break out from the j loop
					break;
				}
#    if DBUG
				if (debug)
					fprintf (dfp, "Failed to open( %s,fd=%d) "
				              "for (i,j)=(%d,j=%d)\n",
				              device, dxbfd, i,j);
#    endif
			} 
		} // for j
	} // for i

#  endif /* defined(UW7) */

#endif /* defined(DXB) */

	/*
	 * if in debug mode, open debug file
	 */
	if (debug && !(dfp))
	{
		ShowMsg ("Error opening debug file (/tmp/dpadebug)");
	}

#ifdef MRGDRV
#	ifdef DXB
	if ((pcxxfd < 0) && (epcafd < 0) && (dxbfd < 0))
#	else
	if ((pcxxfd < 0) && (epcafd < 0))
#	endif
#else
	if ((pcxxfd < 0) && (epcafd < 0) && (pcxrfd < 0) && (aspxfd < 0))
#endif
	{
		WINDOW *OpenDevWin;
		PANEL *OpenDevPanel;

		OpenDevPanel = new_panel (newwin (12, 60, 7, 10));
		OpenDevWin = panel_window (OpenDevPanel);
		wattrset (OpenDevWin, make_attr (A_NORMAL, WHITE, BLUE));
		fillwin (OpenDevWin, ' ');
		box (OpenDevWin, 0, 0);

		wattrset (OpenDevWin, make_attr (A_BOLD, WHITE, RED));
		Strcpy (msg, " Download Device Error ");
		mvwprintw (OpenDevWin, 0, center (OpenDevWin, strlen (msg)), msg);

		wattrset (OpenDevWin, make_attr (A_NORMAL, WHITE, BLUE));
		mvwprintw (OpenDevWin, 2, 2, "Cannot open the download device.");
		mvwprintw (OpenDevWin, 3, 2, "Possible causes:");
		sprintf (msg, "  1) Digi drivers are not installed.");
		mvwprintw (OpenDevWin, 5, 2, msg);
		sprintf (msg, "  2) Need to reboot after installing drivers.");
		mvwprintw (OpenDevWin, 6, 2, msg);
		wattrset (OpenDevWin, make_attr (A_BOLD, WHITE, BLUE));
		sprintf (msg, "Press ANY key to continue");
		mvwprintw (OpenDevWin, 9, center (OpenDevWin, strlen (msg)), msg);

		wrefresh (OpenDevWin);
		wgetch (OpenDevWin);

		hide_panel (OpenDevPanel);
		update_panels ();
		doupdate ();
		del_panel (OpenDevPanel);
		delwin (OpenDevWin);

		EndCurses (-4);
	}
}



/**********************************************************************
*
*  Routine Name:	
*
*  Function:	
*
**********************************************************************/

void 
usage ()
{
	printf ("  usage: dpa -f logfile \n");
	if(debug)
		fprintf(dfp, "dpa - exiting abnomally #3\n");
	exit (1);
}



/**********************************************************************
*
*  Routine Name:	
*
*  Function:	
*
**********************************************************************/

void 
change_term (vmin, vtime)
	int vmin;
	int vtime;
{
	(void) ioctl (0, TCGETA, &tbuf);
	(void) ioctl (0, TCGETA, &sbuf);
	tbuf.c_cc[VMIN] = vmin;
	tbuf.c_cc[VTIME] = vtime;
	(void) ioctl (0, TCSETAW, &tbuf);
}



/**********************************************************************
*
*  Routine Name:	
*
*  Function:	
*
**********************************************************************/

void 
restore_term ()
{
	(void) ioctl (0, TCSETAW, &sbuf);
}



/**********************************************************************
*
*  Routine Name:	
*
*  Function:	
*
**********************************************************************/

int
hex2int (str_in)
	char *str_in;
{
	long value;

	/* Valid ranges for config string is 0-9 for MSB. */
	if ((str_in[0] >= '0') && (str_in[0] <= '9'))
		value = (str_in[0] - 48) * 16;
	else
		return 0;

	/* Valid ranges for config string is 0-9,a-f for LSB. */
	if ((str_in[1] >= '0') && (str_in[1] <= '9'))
		value = value + (str_in[1] - '0');
	else if ((str_in[1] >= 'a') && (str_in[1] <= 'f'))
		value = value + (str_in[1] - 87);
	else
		return 0;

	return value;
}



/**********************************************************************
*
*  Routine Name:	
*
*  Function:	
*
**********************************************************************/

char *
line1conf (bd, confstring)
	int	bd;
	char *confstring;
{
	char *s;
	char *mvp;
	int cnt = 0;

	/* Make a local copy of the config string */

	s = (char *)malloc ((strlen (confstring) + 1) * sizeof (char));
	strcpy (s, confstring);

	/*  Skip the adapter field */

	s += 2;
	mvp = s;

	/* Find the trailing "00" */

	while (*mvp != 0x00)
	{
		if ((*mvp == '0') && (*(mvp+1) == '0'))
			break;
		
		mvp += 2;
	}

	/* terminate the line 1 config string */

	*mvp = 0x00;

	/* Scan the sting looking for concentrators, ignore 1st speed */

	mvp = s + 2;

	while (*mvp != 0x00)
	{
		if (*mvp == '9')
		{
			/* This is an EPC/Con 16 w/ ebi modules */

			adapt_info[bd].nports_conc[cnt++] [0] = 16;

			/* "8x" or "9x" => ebi follows, skip till done */

			while ((*mvp == '9') || (*mvp == '8'))
				mvp += 2;
			
			/* Now skip last ebi and line speed field */

			mvp += 4;
		}
		else
		{
			/* just a concentrator, figure out how many ports */

			switch(*(mvp+1))
			{
			case '0':
				adapt_info[bd].nports_conc[cnt++] [0] = 16;
				break;

			case '4':
				adapt_info[bd].nports_conc[cnt++] [0] = 4;
				break;

			case '8':
				if (*mvp == '1') 
				{
					adapt_info[bd].nports_conc[cnt++] [0] = 31;
				} 
				else
				{
					adapt_info[bd].nports_conc[cnt++] [0] = 8;
				}
				break;

			case '9':
				adapt_info[bd].nports_conc[cnt++] [0] = 9;
				break;

			case 'f':
			case 'F':
				adapt_info[bd].nports_conc[cnt++] [0] = 31;
				break;

			default:
				adapt_info[bd].nports_conc[cnt++] [0] = 16;
				break;
			}

			/* Skip this concetrator field and following speed field */

			mvp += 4;

		} /* else */
	} /* while (*mvp != 0x00) */

	/* done setting up port numbers */

	adapt_info[bd].line1conc = cnt;

	if (debug)
	{
		fprintf (dfp, "***** Debug info for line1conf *****\n");
		fprintf (dfp, "line1config string: %s\n", s);
		for (cnt = 0; cnt < adapt_info[bd].line1conc; ++cnt)
			fprintf (dfp, "nports_conc[%d] [0] = %d\n", cnt,
			 adapt_info[bd].nports_conc[cnt] [0]);
		fflush (dfp);
	}


	return (s);
}



/**********************************************************************
*
*  Routine Name:	
*
*  Function:	
*
**********************************************************************/

char *
line2conf (bd, confstring)
	int	bd;
	char *confstring;
{
	char *s;
	char *mvp;
	int cnt = 0;

	mvp = confstring;

	/* start reading past the beginning of the initial "00" string */

	mvp += 2;

	while (*mvp != 0x00)
	{
		/* Find the 2nd "00" string, the start of line 2 */

		if ((*mvp == '0') && (*(mvp+1) == '0'))
			break;

		mvp += 2;
	}

	/* Skip the "00" string we found */

	mvp += 2;

	/* Get a local copy of the line 2 portion of the string */

	s = (char *)malloc ((strlen (mvp) + 1) * sizeof (char));
	strcpy (s, mvp);

	/* Don't look at the line speed field */

	mvp = s + 2;

	/* Set our index to the nbr of conc's found by line1conf() */

	cnt = adapt_info[bd].line1conc;

	while (*mvp != '\0')
	{
		if ((*mvp == '9') || (*mvp == '8'))
		{
			/* This is an EPC/CON 16 w/ ebi modules */

			adapt_info[bd].nports_conc[cnt++] [0] = 16;

			/* "8x" or "9x" => ebi follows, skip till done */

			while ((*mvp == '9') || (*mvp == '8'))
				mvp += 2;

			/* Now skip last ebi and the line speed field */

			mvp += 4;
		}
		else
		{
			/* Just a concetrator, figure out how many ports */

			switch(*(mvp+1)) {
			case '0':
				adapt_info[bd].nports_conc[cnt++] [0] = 16;
				break;

			case '4':
				adapt_info[bd].nports_conc[cnt++] [0] = 4;
				break;

			case '8':
				if (*mvp == '1') 
				{
					adapt_info[bd].nports_conc[cnt++] [0] = 31;
				} 
				else
				{
					adapt_info[bd].nports_conc[cnt++] [0] = 8;
				}
				break;

			case '9':
				adapt_info[bd].nports_conc[cnt++] [0] = 9;
				break;

			case 'f':
			case 'F':
				adapt_info[bd].nports_conc[cnt++] [0] = 31;
				break;

			default:
				adapt_info[bd].nports_conc[cnt++] [0] = 16;
				break;
			}
			/* Skip this concetrator and the following speed field */

			mvp += 4;
		} /* else */
	} /* while (*mvp != 0x00) */

	/* done setting up port numbers */

	adapt_info[bd].line2conc = cnt - adapt_info[bd].line1conc;

	if (debug)
	{
		fprintf (dfp, "***** Debug info for line2conf *****\n");
		fprintf (dfp, "line2config string: %s\n", s);
		for (cnt = 0; cnt < adapt_info[bd].line2conc; ++cnt)
			fprintf (dfp, "nports_conc[%d] [0] = %d\n",
			 cnt + adapt_info[bd].line1conc,
			 adapt_info[bd].nports_conc[cnt + adapt_info[bd].line1conc][0]);
		fflush (dfp);
	}


	return (s);
}



/**********************************************************************
*
*  Routine Name:	
*
*  Function:	
*
**********************************************************************/

void
get_config (bd, bdtype)
	int bd;
	int bdtype;
{

	int i, j;
	int index1 = 0, index2 = 0;
	char *line1str, *line2str;
	char string[3];
	char line1array[20][3];
	char line2array[20][3];
	char tmp[3];
	char cstr[STRSIZ];
	char *s;

	/*
	 * If we're using adapter file descriptor 2 (/dev/epcadl) then
	 * subtract out the number of boards from pcxxfd (/dev/pcxxdl).
	 * Do the same thing for pcxrfd (/dev/pcxrdl).
	 */
	if (afd == epcafd)
		rw.rw_board = bd - num_boards1;
#ifndef MRGDRV
	else if (afd == pcxrfd)
		rw.rw_board = bd - (num_boards1 + num_boards2);
	else if (afd == aspxfd)
		rw.rw_board = bd - (num_boards1 + num_boards2 + num_boards3);
#endif
#ifdef DXB
	else if (afd == dxbfd)
		rw.rw_board = bd - (num_boards1 + num_boards2 + num_boards3 + num_boards4);
#endif
	else
		rw.rw_board = bd;

	rw.rw_conc = 0;
	rw.rw_req = RW_READ;
	rw.rw_addr = CONFIG;
	rw.rw_size = CONFIGSIZE;

	for (i = 0; i < CONFIGSIZE + 1; ++i)
	{
		adapt_info[bd].display_config[i * 2] = 0x00;
		adapt_info[bd].display_config[(i * 2) + 1] = 0x00;
		rw.rw_data[i] = 0x00;
	}

#if defined(SOLARIS)
	if (sol_ioctl (afd, DIGI_KME, &rw, sizeof(rw)) != 0)
#else
	if (ioctl (afd, DIGI_KME, &rw) != 0)
#endif
	{
		for (i = 0; i < MAX_ADPT; ++i)
			Strcpy (cons_tbl[i], "**");

		return;
	}

	for (i=0; i < CONFIGSIZE; i++)
	{
		if (rw.rw_data[i] == 0xff)
			break;

		sprintf ((char *) tmp, (const char *) "%02x", rw.rw_data[i]);
		Strcat (adapt_info[bd].display_config, tmp);
	}

	strcpy (cstr, (char *) adapt_info[bd].display_config);
	strcat ((char *) adapt_info[bd].display_config, "ff");

	/* the order of these two calls is important */

	line1str = line1conf (bd, cstr);
	line2str = line2conf (bd, cstr);

	if (debug)
	{
		fprintf (dfp, "***** Debug info for get_config *****\n");
		fprintf (dfp, "line1config string: %s\n", line1str);
		fprintf (dfp, "line2config string: %s\n", line2str);
		fprintf (dfp, "display_config: %s\n", adapt_info[bd].display_config);
		fflush (dfp);
	}
/*
 ***********************************************
 */

	s = line1str;
	memset (line1array, '\0', sizeof (line1array));
	index1 = 0;
	while (*s != '\0')
	{
		string[0] = *s++;
		string[1] = *s++;
		string[2] = '\0';
		strcpy (line1array[index1++], string);
	}

	s = line2str;
	memset (line2array, '\0', sizeof (line2array));
	index2 = 0;
	while (*s != '\0')
	{
		string[0] = *s++;
		string[1] = *s++;
		string[2] = '\0';
		strcpy (line2array[index2++], string);
	}

	adapt_info[bd].line1conc = 0;
	adapt_info[bd].line2conc = 0;
	if (bdtype == T_EPC)
	{
		adapt_info[bd].line1conc = parse_epc (bd, line1array, index1, 0);
		adapt_info[bd].line2conc = parse_epc (bd, line2array, index2,
		 adapt_info[bd].line1conc+1);
	}
	else
	{
		adapt_info[bd].line1conc = parse_cx (bd, line1array);
		adapt_info[bd].line2conc = parse_cx (bd, line2array);
	}

	/* Test EPC/X boards for em/Modems */

	if (bdtype == T_EPC)
	{

		/* first find out who's up and who's down */

		get_status (bd);

		/*
		*  Check EPC/CON 16's for em/Modems
		*
		*
		*  If we're using adapter file descriptor 2 (/dev/epcadl) then
		*  subtract out the number of boards from pcxxfd (/dev/pcxxdl).
		*  Do the same thing for pcxrfd (/dev/pcxrdl).
		*/

		if (afd == epcafd)
			rw.rw_board = bd - num_boards1;
#ifndef MRGDRV
		else if (afd == pcxrfd)
			rw.rw_board = bd - (num_boards1 + num_boards2);
		else if (afd == aspxfd)
			rw.rw_board = bd - (num_boards1 + num_boards2 + num_boards3);
#endif
#ifdef DXB
		else if (afd == dxbfd)
			rw.rw_board = bd - (num_boards1 + num_boards2 + num_boards3 + num_boards4);
#endif
		else
			rw.rw_board = bd;

		rw.rw_req = RW_READ;
		rw.rw_addr = 0x13c;
		rw.rw_size = 4;

		for (i = 0;
		 i < adapt_info[bd].line1conc + adapt_info[bd].line2conc; ++i)
		{
			/* do "up" concentrators only */

			if (strcmp (cons_tbl[i], "AC") != 0)
				continue;

			/* EPC/CON 16's only */

			if (adapt_info[bd].nports_conc[i] [0] != 16)
				continue;

			if (adapt_info[bd].nports_conc[i] [1] == 4)
			{
				/* all 4 line EBI modules are em/Modems */

				adapt_info[bd].emm_adpt = 1;
				em_modem = 1;
				adapt_info[bd].emm_conc[i] |= EMM_EPC1;
			}

			if (adapt_info[bd].nports_conc[i] [2] == 4)
			{
				/* all 4 line EBI modules are em/Modems */
	
				adapt_info[bd].emm_adpt = 1;
				em_modem = 1;
				adapt_info[bd].emm_conc[i] |= EMM_EPC2;
			}

			if (adapt_info[bd].nports_conc[i] [3] == 4)
			{
				/* all 4 line EBI modules are em/Modems */

				adapt_info[bd].emm_adpt = 1;
				em_modem = 1;
				adapt_info[bd].emm_conc[i] |= EMM_EPC3;
			}

			/* All 4 port modules tested, now do all 8's */

			if ((adapt_info[bd].nports_conc[i] [1] != 8) &&
			 (adapt_info[bd].nports_conc[i] [2] != 8) &&
			 (adapt_info[bd].nports_conc[i] [3] != 8))
				continue;

			rw.rw_conc = i + 1;

			for (j = 0; j < 4; ++j)
				rw.rw_data[j] = 0x00;

#if defined(SOLARIS)
	#if OLD_SOLARIS
			if (sol_ioctl (afd, DIGI_KME, &rw, sizeof(rw)) != 0)
	#else
			if (ioctl (afd, DIGI_KME, &rw) != 0)
	#endif

#else
			if (ioctl (afd, DIGI_KME, &rw) != 0)
#endif
			{
				if (debug)
				{
					fprintf (dfp, "***** Debug from get_config *****\n");
					fprintf (dfp, "Board=%d, conc=%d, ioctl failed\n",
					 bd, i);
					fflush (dfp);
				}

				continue;
			}

			if (((rw.rw_data[1] >> 2) == MID_4UART_RAM) ||
			 ((rw.rw_data[1] >> 2) == MID_4UART_ROM) ||
			 ((rw.rw_data[1] >> 2) == MID_8UART_RAM) ||
			 ((rw.rw_data[1] >> 2) == MID_8UART_ROM))
			{
				adapt_info[bd].emm_adpt = 1;
				em_modem = 1;
				adapt_info[bd].emm_conc[i] |= EMM_EPC1;
			}

			if (((rw.rw_data[2] >> 2) == MID_4UART_RAM) ||
			 ((rw.rw_data[2] >> 2) == MID_4UART_ROM) ||
			 ((rw.rw_data[2] >> 2) == MID_8UART_RAM) ||
			 ((rw.rw_data[2] >> 2) == MID_8UART_ROM))
			{
				adapt_info[bd].emm_adpt = 1;
				em_modem = 1;
				adapt_info[bd].emm_conc[i] |= EMM_EPC2;
			}

			if (((rw.rw_data[3] >> 2) == MID_4UART_RAM) ||
			 ((rw.rw_data[3] >> 2) == MID_4UART_ROM) ||
			 ((rw.rw_data[3] >> 2) == MID_8UART_RAM) ||
			 ((rw.rw_data[3] >> 2) == MID_8UART_ROM))
			{
				adapt_info[bd].emm_adpt = 1;
				em_modem = 1;
				adapt_info[bd].emm_conc[i] |= EMM_EPC3;
			}

			if (debug)
			{
				fprintf (dfp, "***** Debug from get_config *****\n");
				fprintf (dfp, "Board=%d, emm_conc[%d]=%d\n",
				 bd, i, adapt_info[bd].emm_conc[i]);
				fflush (dfp);
			}
		} /* if (bdtype == T_EPC) */
	}

	/*
	*  Calculate starting port address for all concentrators
	*  and modules
	*/

	for (i = 1; i < adapt_info[bd].line1conc + adapt_info[bd].line2conc; ++i)
		adapt_info[bd].port_addr[i] =
		 adapt_info[bd].port_addr[i - 1] +
		 adapt_info[bd].nports_conc[i - 1] [0] +
		 adapt_info[bd].nports_conc[i - 1] [1] +
		 adapt_info[bd].nports_conc[i - 1] [2] +
		 adapt_info[bd].nports_conc[i - 1] [3];

	if (debug)
	{
		fprintf (dfp, "Adapter slot: %d\n", bd);
		fprintf (dfp, "line1conc: %d, line2conc: %d\n",
		 adapt_info[bd].line1conc, adapt_info[bd].line2conc);
		fprintf (dfp, "board type used for config: %s\n", (bdtype == T_EPC) ?
			"EPC" : "C/X");

	for (i = 0;
	 i < adapt_info[bd].line1conc + adapt_info[bd].line2conc; ++i)
		fprintf (dfp, "Conc %d start address is %d\n", i,
		 adapt_info[bd].port_addr[i]);
		fflush (dfp);
	}
}



/**********************************************************************
*
*  Routine Name:	
*
*  Function:	
*
**********************************************************************/

int
parse_epc (bd, line, index, k)
	int bd;
	char line[][3];
	int index;
	int k;
{
	int j=0;
	int conc_index = -1;
	int num_concs = 0;
	int first_pass = TRUE;
	int next_conc = FALSE;
	int ebi_found = FALSE, ebi_cnt = 0;
	int	indexed = FALSE;
	char speed[3];

	while (j < index)
	{
		first_pass = TRUE;
		next_conc = FALSE;
		ebi_found = FALSE;
		indexed = FALSE;

		strcpy (speed, line[j++]);
		Strcpy (config_list[k++], table[ hex2int (speed) ]);

		while ( (j < index) && (!next_conc) )
		{
			if (!strcmp ("90", line[j]))
			{
				if (!first_pass)
				{
					adapt_info[bd].nports_conc[conc_index + adapt_info[bd].line1conc] [ebi_cnt + 1] = 16;
					++ebi_cnt;
					j++;
					ebi_found = TRUE;
				}
				else
				{
					if (!indexed) {
						indexed = TRUE;
						ebi_cnt = 0;
						conc_index++;
						num_concs++;
					}
					first_pass = FALSE;
					j++;
					ebi_found = TRUE;
				}
			}
			else if (!strcmp ("10", line[j])
				|| (!strcmp ("18", line[j])) 
				|| (!strcmp ("1f", line[j])))
			{
				if ((strcmp ("10", line[j+1])) 
				&& (strcmp ("90", line[j+1])) 
				&& (strcmp ("08", line[j+1])) 
				&& (strcmp ("88", line[j+1])) 
				&& (strcmp ("84", line[j+1])) 
				&& (strcmp ("04", line[j+1])) 
				&& (strcmp ("09", line[j+1])) 
				&& (strcmp ("18", line[j+1])) 
				&& (strcmp ("1f", line[j+1])) 
				&& (strcmp ("89", line[j+1])) 
				&& ebi_found)
				{
					adapt_info[bd].nports_conc[conc_index + adapt_info[bd].line1conc] [ebi_cnt + 1] = 16;
					++ebi_cnt;
					ebi_found = FALSE;
				}
				else
				{
				if (!indexed) {
					indexed = TRUE;
					ebi_cnt = 0;
					num_concs++;
					conc_index++;
					}
				}

				j++;
				next_conc = TRUE;
				if (j == index) {
					num_concs--;
					conc_index--;
				}
			}
			else if (!strcmp ("08", line[j]))
			{
				if (first_pass) {  /* if first pass, then this is C/CON-8 */
					if (!indexed) {
						indexed = TRUE;
						ebi_cnt = 0;
						conc_index++;
						num_concs++;
					}
					j++;
					next_conc = TRUE;
					if (j == index) {
						num_concs--;
						conc_index--;
					}
				} else { /* this is PORTS/8em */
					adapt_info[bd].nports_conc[conc_index + adapt_info[bd].line1conc] [ebi_cnt + 1] = 8;
					++ebi_cnt;
					j++;
					next_conc = TRUE;
					ebi_found = TRUE;
					if (!indexed) {
						indexed = TRUE;
						ebi_cnt = 0;
						conc_index++;
						num_concs++;
					}
				}
			}
			else if (!strcmp ("84", line[j]))
			{
				adapt_info[bd].nports_conc[conc_index + adapt_info[bd].line1conc] [ebi_cnt + 1] = 4;
				++ebi_cnt;
				j++;
				ebi_found = TRUE;
			}
			else if (!strcmp ("88", line[j]))
			{
				adapt_info[bd].nports_conc[conc_index + adapt_info[bd].line1conc] [ebi_cnt + 1] = 8;
				++ebi_cnt;
				j++;
				ebi_found = TRUE;
			}
			else if (!strcmp ("04", line[j]))
			{
				adapt_info[bd].nports_conc[conc_index + adapt_info[bd].line1conc] [ebi_cnt + 1] = 4;
				++ebi_cnt;
				j++;
				next_conc = TRUE;
				ebi_found = TRUE;
				if (!indexed) {
					indexed = TRUE;
					ebi_cnt = 0;
					conc_index++;
					num_concs++;
				}
			}
			else if (!strcmp ("09", line[j]))
			{
				adapt_info[bd].nports_conc[conc_index + adapt_info[bd].line1conc] [ebi_cnt + 1] = 9;
				++ebi_cnt;
				j++;
				next_conc = TRUE;
				ebi_found = TRUE;
				if (!indexed) {
					indexed = TRUE;
					ebi_cnt = 0;
					conc_index++;
					num_concs++;
				}
			}
			else if (!strcmp ("89", line[j]))
			{
				adapt_info[bd].nports_conc[conc_index + adapt_info[bd].line1conc] [ebi_cnt + 1] = 9;
				++ebi_cnt;
				j++;
				ebi_found = TRUE;
			}
			else
			{
				printf ("unknown junk here: %s\n", line[j]);
				j++;
			}

		}
	}

	return (num_concs);
}


/**********************************************************************
*
*  Routine Name:	
*
*  Function:	
*
**********************************************************************/

int
parse_cx (bd, line)
	int	bd;
	char line[][3];
{
	int num_concs = 0;
	int j=0;
	int	first = TRUE;
	int k = adapt_info[bd].line1conc;
	char speed[3];

	/*
	** Make config_list look like it does for parse_epc.
	** If this is the first entry for the second line,
	** skip an entry in the config_list table.
	*/
	if (k && first) {
		first = FALSE;
		k++;
	}
	while (strcmp (line[j], "\0") && strcmp (line[j+1], "\0"))
	{
		strcpy (speed, line[j]);
		Strcpy (config_list[k++], table[ hex2int (speed) ]);
		j += 2;
		num_concs++;
	}
	strcpy (speed, line[j]);
	Strcpy (config_list[k++], table[ hex2int (speed) ]);

	return (num_concs);
}



/**********************************************************************
*
*  Routine Name:	
*
*  Function:	
*
**********************************************************************/

void 
screen_print (win, fp)
	WINDOW *win;
	FILE *fp;
{
	chtype c;
	register int x, y;
	char str[80] = "\0";

	for (x = 0; x < GetBegX(win); x++)
		Strcat (str, " ");

	/* try to simulate relative position on the screen */
	for (y = 0; y < GetBegY(win) - 4; y++)
		fputc ('\n', fp);

	for (y = 0; y < GetMaxY(win); y++)
	{
		fputs (str, fp);

		for (x = 0; x < GetMaxX(win); x++)
		{
			c = mvwinch (win, y, x);

			if (c != (c & ~A_ALTCHARSET))
			{
				c &= 0xffff;

				switch (c)
				{
					/* ansi term values */
				case 90:		   /* ULCORNER */
				case 63:		   /* URCORNER */
				case 64:		   /* LLCORNER */
				case 89:		   /* LRCORNER */
					c = '+';
					break;
				case 68:		   /* HLINE */
					c = '-';
					break;
				case 51:		   /* VLINE */
				case 67:		   /* LTEE */
				case 52:		   /* RTEE */
					c = '|';
					break;

					/* non-ansi term values */
				case 108:		   /* ULCORNER */
				case 107:		   /* URCORNER */
				case 109:		   /* LLCORNER */
				case 106:		   /* LRCORNER */
					c = '+';
					break;
				case 113:		   /* HLINE */
					c = '-';
					break;
				case 120:		   /* VLINE */
				case 116:		   /* LTEE */
				case 117:		   /* RTEE */
					c = '|';
					break;
				}
			}
			fputc (c, fp);
		}
		fputc ('\n', fp);
	}

	if (win != HeadWin)
	{
		fputc ('\n', fp);
		fputc ('\n', fp);
	}
}



/**********************************************************************
*
*  Routine Name:	
*
*  Function:	
*
**********************************************************************/

void 
screen_save (win, file)
	WINDOW *win;
	char *file;
{
	WINDOW *wps_win;
	PANEL *wps_panel;
	FILE *fp;
	char msg[256];
	char fmode[3] = "w";
	int quit = FALSE;
	int path_len = strlen (file);
	int x, startx;
	int valid_choice = FALSE;


	change_term (1, 0);

	if (!access (file, F_OK))	   /* File Exists */
	{
		x = path_len + 20;
		if (x < 26)
			x = 26;

		startx = (GetMaxX(MainWin) / 2) - x / 2;
		if ((wps_panel = new_panel (newwin (10, x, 9, startx))))
		{
			wps_win = panel_window (wps_panel);
			keypad (wps_win, 1);
		}
		else
		{
			ShowMsg ("Error creating a new window/panel");
			EndCurses (-5);
		}

		while (!valid_choice)
		{
			wattrset (wps_win, make_attr (A_NORMAL, BLACK, CYAN));
			fillwin (wps_win, ' ');
			box (wps_win, 0, 0);
			startx = x / 2 - 10;
			sprintf (msg, "File %s exists,", file);
			mvwprintw (wps_win, 2, 3, msg);
			mvwprintw (wps_win, 3, 3, "Choose Option:");
			mvwprintw (wps_win, 5, startx, "'A' = Append To File");
			mvwprintw (wps_win, 6, startx, "'O' = Overwrite File");
			mvwprintw (wps_win, 7, startx, "'Q' = Quit");
			wattroff (wps_win, make_attr (A_NORMAL, BLACK, CYAN));

			switch (wgetch (wps_win))
			{
			case 'A':
			case 'a':
				sprintf ((char *) fmode, (const char *) "a");
				valid_choice = TRUE;
				break;
			case 'O':
			case 'o':
				sprintf ((char *) fmode, (const char *) "w");
				valid_choice = TRUE;
				break;
			case 'Q':
			case 'q':
				quit = TRUE;
				valid_choice = TRUE;
				change_term (0, TIMEOUT);
				break;

			}					   /* End Switch */
		}
		hide_panel (wps_panel);
		del_panel (wps_panel);
		delwin (wps_win);

		if (quit)
		{
			update_panels ();
			doupdate ();
			return;
		}
	}							   /* End If */

	if (!(fp = fopen (file, fmode)))
	{
		sprintf ((char *) msg, (const char *) "Error opening file %s", file);
		ShowMsg (msg);
		return;
	}
	screen_print (HeadWin, fp);
	screen_print (win, fp);

	sprintf ((char *) msg, (const char *) "Screen saved to %s", file);
	ShowMsg (msg);
	fclose (fp);
	change_term (0, TIMEOUT);
}



/**********************************************************************
*
*  Routine Name:	
*
*  Function:	
*
**********************************************************************/

void 
print_errcounts ()
{
	int option = EOF;
	int first = TRUE;
	int i = 0;

	show_panel (ErrorPanel);
	update_panels ();
	doupdate ();
	wrefresh (ErrorWin);

	wmove (ErrorWin, 2, 1);
	wattrset (ErrorWin, make_attr (A_ALTCHARSET, CYAN, BLACK));
	for (i = 0; i < 77; i++)
		waddch (ErrorWin, ACS_HLINE);

	mvwaddch (ErrorWin, 2, 0, ACS_LTEE);
	mvwaddch (ErrorWin, 2, 77, ACS_RTEE);
	wattroff (ErrorWin, make_attr (A_ALTCHARSET, CYAN, BLACK));
	wrefresh (ErrorWin);

	while (option != 'Q')
	{
		get_channel (channel, &bs);
		get_errors ();

		wattrset (ErrorWin, make_attr (A_BOLD, WHITE, BLUE));
		mvwprintw (ErrorWin, 1, 32, " HOST STATUS ");

		wattrset (ErrorWin, make_attr (A_NORMAL, WHITE, BLUE));
		mvwprintw (ErrorWin, 3, 1, "Activity Counters:");
		mvwprintw (ErrorWin, 6, 1, "Sync Counters:");
		mvwprintw (ErrorWin, 9, 1, "Saturation Counters:");
		mvwprintw (ErrorWin, 12, 1, "FEP/OS:");
		mvwprintw (ErrorWin, 15, 1, "Hardware Counters:");

		wattrset (ErrorWin, make_attr (A_BOLD, WHITE, BLACK));
		mvwprintw (ErrorWin, 3, 19,
			" RECEIVE1  RECEIVE2  RECEIVE3  RECEIVE4 RECEIVE5  TRANSMIT");
		mvwprintw (ErrorWin, 6, 15,
			" ERR_UFRAM  ERR_ABSTAT   ERR_INC   ERR_CRC  ERR_DATA  ERR_NACK");
		mvwprintw (ErrorWin, 9, 21,
			" ERR_TBUF   ERR_FIFO   ERR_ORUN   ERR_TBUSY    ERR_RITEM");
		mvwprintw (ErrorWin, 12, 8,
			" ERR_REC0  ERR_ADDR  ERR_MTYPE  ERR_MSIZE  ERR_RID  ERR_TID  ERR_PING");
		mvwprintw (ErrorWin, 15, 19,
			" ERR_ABREC    ERR_URUN    ERR_CONC    ERR_CHECK");


		wattrset (ErrorWin, make_attr (A_NORMAL, GREEN, BLACK));

		mvwprintw (ErrorWin, 4, 19, " %8d  %8d  %8d  %8d  %7d  %8d",
			(err_rec1 - err_rec1_save), (err_rec2 - err_rec2_save),
			(err_rec3 - err_rec3_save), (err_rec4 - err_rec4_save),
			(err_rec5 - err_rec5_save), (host_transmit - host_transmit_save));

		mvwprintw (ErrorWin, 7, 15, "  %8d   %9d  %8d  %8d  %8d  %8d",
			(err_uframe - err_uframe_save), (err_abstat - err_abstat_save),
			(err_inc - err_inc_save), (err_crc - err_crc_save),
			(err_data - err_data_save), (err_nack - err_nack_save));

		mvwprintw (ErrorWin, 10, 21, "%9d  %9d  %9d    %8d     %8d",
			(err_tbuf - err_tbuf_save), (err_fifo - err_fifo_save),
			(err_orun - err_orun_save), (err_relay - err_relay_save),
			(err_ritem - err_ritem_save));

		mvwprintw (ErrorWin, 13, 8, " %8d  %8d   %8d   %8d %8d %8d  %8d",
			(err_rec - err_rec_save), (err_addr - err_addr_save),
			(err_mtype - err_mtype_save), (err_msize - err_msize_save),
			(err_rid - err_rid_save), (err_tid - err_tid_save),
			(err_host - err_host_save));

		mvwprintw (ErrorWin, 16, 20, " %8d    %8d    %8d     %8d",
			(err_abrec - err_abrec_save), (err_urun - err_urun_save),
			(err_conc - err_conc_save), (err_check - err_check_save));

		/*
		 * any numbers that are non-zero will be displayed as red
		 * this will be done by first writing the number in green, 
		 * and if non-zero, then will re-print the numbers in red.
		 */

		wattrset (ErrorWin, make_attr (A_BOLD, RED, BLACK));

		/*
		 * If the receive counter doesn't increment, the    
		 * sync line is down!
		 */
		if (host_rec_old == host_receive)
			mvwprintw (ErrorWin, 4, 20, "%8d", (err_rec1 - err_rec1_save));

		/*
		 * Sync counters section
		 */

		if (err_uframe - err_uframe_save)
			mvwprintw (ErrorWin, 7, 17, "%8d", (err_uframe - err_uframe_save));
		if (err_abstat - err_abstat_save)
			mvwprintw (ErrorWin, 7, 28, "%9d", (err_abstat - err_abstat_save));
		if (err_inc - err_inc_save)
			mvwprintw (ErrorWin, 7, 39, "%8d", (err_inc - err_inc_save));
		if (err_crc - err_crc_save)
			mvwprintw (ErrorWin, 7, 49, "%8d", (err_crc - err_crc_save));
		if (err_data - err_data_save)
			mvwprintw (ErrorWin, 7, 59, "%8d", (err_data - err_data_save));
		if (err_nack - err_nack_save)
			mvwprintw (ErrorWin, 7, 69, "%8d", (err_nack - err_nack_save));

		/*
		 * Saturation counters section
		 */

		if (err_tbuf - err_tbuf_save)
			mvwprintw (ErrorWin, 10, 21, "%9d", (err_tbuf - err_tbuf_save));
		if (err_fifo - err_fifo_save)
			mvwprintw (ErrorWin, 10, 32, "%9d", (err_fifo - err_fifo_save));
		if (err_orun - err_orun_save)
			mvwprintw (ErrorWin, 10, 43, "%9d", (err_orun - err_orun_save));
		if (err_relay - err_relay_save)
			mvwprintw (ErrorWin, 10, 56, "%8d", (err_relay - err_relay_save));
		if (err_ritem - err_ritem_save)
			mvwprintw (ErrorWin, 10, 69, "%8d", (err_ritem - err_ritem_save));

		/*
		 * FEP/OS counters section
		 */

		if (err_rec - err_rec_save)
			mvwprintw (ErrorWin, 13, 9, "%8d", (err_rec - err_rec_save));
		if (err_addr - err_addr_save)
			mvwprintw (ErrorWin, 13, 19, "%8d", (err_addr - err_addr_save));
		if (err_mtype - err_mtype_save)
			mvwprintw (ErrorWin, 13, 30, "%8d", (err_mtype - err_mtype_save));
		if (err_msize - err_msize_save)
			mvwprintw (ErrorWin, 13, 41, "%8d", (err_msize - err_msize_save));
		if (err_rid - err_rid_save)
			mvwprintw (ErrorWin, 13, 50, "%8d", (err_rid - err_rid_save));
		if (err_tid - err_tid_save)
			mvwprintw (ErrorWin, 13, 59, "%8d", (err_tid - err_tid_save));
		if (err_host - err_host_save)
			mvwprintw (ErrorWin, 13, 69, "%8d", (err_host - err_host_save));

		/*
		 * Hardware counters section
		 */

		if (err_abrec - err_abrec_save)
			mvwprintw (ErrorWin, 16, 21, "%8d", (err_abrec - err_abrec_save));
		if (err_urun - err_urun_save)
			mvwprintw (ErrorWin, 16, 33, "%8d", (err_urun - err_urun_save));
		if (err_conc - err_conc_save)
			mvwprintw (ErrorWin, 16, 45, "%8d", (err_conc - err_conc_save));
		if (err_check - err_check_save)
			mvwprintw (ErrorWin, 16, 58, "%8d", (err_check - err_check_save));


		wattroff (ErrorWin, make_attr (A_BOLD, RED, BLACK));
		wrefresh (ErrorWin);

		if (first)
		{
			first = FALSE;
			wattrset (MainWin, make_attr (A_NORMAL, WHITE, BLUE));
			commandline (clbuf, helpstr, "ESC=Quit", "Z=Zero Counters",
				"^P=Print", NULL);
			mvwprintw (MainWin, KEY_LINE, 0, clbuf);
			wattroff (MainWin, make_attr (A_NORMAL, WHITE, BLUE));
			wrefresh (MainWin);
		}

		change_term (0, 4 * TIMEOUT);

		switch (wgetch (ErrorWin))
		{
		case EOF:
			break;
		case ctrl ('L'):
			refresh_screen ();
			break;
#ifdef KEY_PRINT
		case KEY_PRINT:
#endif
		case ctrl ('P'):
			screen_save (ErrorWin, logfile);
			touchwin (ErrorWin);
			update_panels ();
			doupdate ();
			break;
		case 'Q':
		case 'q':
		case ESC:
			hide_panel (ErrorPanel);
			erase_win (ErrorWin);
			update_panels ();
			doupdate ();
			wrefresh (ErrorWin);
			option = 'Q';
			break;
		case KEY_F (1):		   /*  Help info  */
		case '?':
			info_screen ("dpa_info7", NULL);
			wattrset (MainWin, make_attr (A_NORMAL, WHITE, BLUE));
			commandline (clbuf, helpstr, "ESC=Quit", "Z=Zero Counters",
				"^P=Print", NULL);
			mvwprintw (MainWin, KEY_LINE, 0, clbuf);
			wattroff (MainWin, make_attr (A_NORMAL, WHITE, BLUE));
			wrefresh (MainWin);
			update_panels ();
			doupdate ();
			break;
		/*
		 * Save the current counter values, then subtract them from the
		 * real values, this makes it appear that the counters have been
		 * reset to the user only
		 */
		case 'Z':
		case 'z':
			err_rec1_save = err_rec1;
			err_rec2_save = err_rec2;
			err_rec3_save = err_rec3;
			err_rec4_save = err_rec4;
			err_rec5_save = err_rec5;
			host_transmit_save = host_transmit;
			err_uframe_save = err_uframe;
			err_abstat_save = err_abstat;
			err_inc_save = err_inc;
			err_crc_save = err_crc;
			err_data_save = err_data;
			err_nack_save = err_nack;
			err_tbuf_save = err_tbuf;
			err_fifo_save = err_fifo;
			err_orun_save = err_orun;
			err_relay_save = err_relay;
			err_ritem_save = err_ritem;
			err_rec_save = err_rec;
			err_addr_save = err_addr;
			err_mtype_save = err_mtype;
			err_msize_save = err_msize;
			err_rid_save = err_rid;
			err_tid_save = err_tid;
			err_host_save = err_host;
			err_abrec_save = err_abrec;
			err_urun_save = err_urun;
			err_conc_save = err_conc;
			err_check_save = err_check;
			break;
		default:
			break;
		}

	}							   /* End While */
}



/**********************************************************************
*
*  Routine Name:	
*
*  Function:	
*
**********************************************************************/

PANEL *
CreateConcPanel (condense)
	int	*condense;
{
	PANEL	*pan;
	WINDOW	*win;
	int win_lines;
	int lines_needed;
	int ans = TRUE;
	char msg[80];

	if ((adapt_info[slot].line1conc + adapt_info[slot].line2conc) > 14)
	{
		sprintf ((char *) msg, 
			"You have %d concentrators configured, the maximum allowed is 14",
		 (adapt_info[slot].line1conc + adapt_info[slot].line2conc));

		ShowMsg (msg);
		return (NULL);	
	}

	/*
	 * We want to make the window the correct size.  If the screen is
	 * large enough we make it the correct size
	 */

	/*
	 * 8 is the number of conc independant lines needed
	 * 6 is the number of lines for other stuff (header win, keyline)
	 * 2 is the number of lines for the window border
	 */
	lines_needed =
	 adapt_info[slot].line1conc + adapt_info[slot].line2conc +
	 8 + 6 + 2;
	if (lines_needed > LINES)
	{
		sprintf ((char *)msg, 
		"Sorry, we need %d lines to display the information", lines_needed);
		ShowMsg (msg);
		ans = AskYN ("Would you like to use a condensed mode? [Y/N] ");
		if (!ans)
		{
			*condense = FALSE;
			return (NULL);
		}
		*condense = TRUE;
	}

	win_lines = lines_needed - 6;
	/*
	 * If there is no conc on one line, we need to add a line to be
	 * able to say the config for that line is "None."
	 */
	if ((adapt_info[slot].line1conc == 0) ||
	 (adapt_info[slot].line2conc == 0))
		win_lines++;

	if ((win_lines < 18) || *condense)
		win_lines = 18;

	pan = new_panel (newwin (win_lines, 78, 5, 1));
	win = panel_window (pan);
	wattrset (win, make_attr (A_NORMAL, CYAN, BLACK));
	box (win, 0, 0);
	wattroff (win, make_attr (A_NORMAL, CYAN, BLACK));
	keypad (win, TRUE);

	if (debug)
	{
		fprintf (dfp, "***** Debug info from CreateConcPanel *****\n");
		fprintf (dfp, "lines_needed: %d\n", lines_needed);
		fprintf (dfp, "win_lines: %d\n", win_lines);
		fprintf (dfp, "condense: %s\n", (*condense) ? "TRUE" : "FALSE");
		fprintf (dfp, "panel creation: %s\n", (pan == NULL) ? 
			"FAILED!!!" : "SUCCESSFUL");
		fflush (dfp);
	}

	return (pan);
}



/**********************************************************************
*
*  Routine Name:	
*
*  Function:	
*
**********************************************************************/

void
print_config (bdtype)
	int bdtype;
{
	int i, option = EOF;
	int normal = FALSE;

	get_config (slot, bdtype);

	show_panel (ConfigPanel);
	update_panels ();
	doupdate ();

	wattrset (ConfigWin, make_attr (A_BOLD, WHITE, BLUE));
	mvwprintw (ConfigWin, 1, 26, "  Adapter Configuration  ");
	wattroff (ConfigWin, make_attr (A_BOLD, WHITE, BLUE));
	mvwprintw (ConfigWin, 4, 2, "Config=%s", adapt_info[slot].display_config);

	wattrset (ConfigWin, make_attr (A_BOLD, WHITE, BLACK));
	mvwprintw (ConfigWin, 5, 2, "Line 1 Config:");
	wattroff (ConfigWin, make_attr (A_BOLD, WHITE, BLACK));

	normal =
	 ((adapt_info[slot].line1conc + adapt_info[slot].line2conc) <= 8) ?
	 TRUE : FALSE;
	if (normal && (adapt_info[slot].line1conc > 0))
		mvwprintw (ConfigWin, 6, 4, " Adapt to Node 1   %s", config_list[0]);
	else
		mvwprintw (ConfigWin, 6, 4, " None.");

	if (normal)
	{
		for (i = 0; i < adapt_info[slot].line1conc - 1; i++)
			mvwprintw (ConfigWin, 7 + i, 3, " Node %d to Node %d   %s", 
					(i + 1), (i + 2), config_list[i + 1]);
	}

	wattrset (ConfigWin, make_attr (A_BOLD, WHITE, BLACK));
	if (normal)
		mvwprintw (ConfigWin, 7 + adapt_info[slot].line1conc, 2,
		 "Line 2 Config:");
	else
		mvwprintw (ConfigWin, 8, 2, "Line 2 Config:");
	wattroff (ConfigWin, make_attr (A_BOLD, WHITE, BLACK));
	if (normal && (adapt_info[slot].line2conc > 0))
		mvwprintw (ConfigWin, 8 + adapt_info[slot].line1conc, 4,
		 " Adapt to Node 1   %s",
		   config_list[adapt_info[slot].line1conc + 1]);
	else if (normal)
		mvwprintw (ConfigWin, 8 + adapt_info[slot].line1conc, 4, " None.");
	else
		mvwprintw (ConfigWin, 9, 4, " None.");

	if (normal)
	{
		for (i = 0; i < adapt_info[slot].line2conc - 1; i++)
			mvwprintw (ConfigWin, 9 + adapt_info[slot].line1conc + i, 3, 
				" Node %d to Node %d   %s", (i + 1), (i + 2), 
				config_list[i + adapt_info[slot].line1conc + 2]);
	}

	wmove (ConfigWin, 2, 1);
	wattrset (ConfigWin, make_attr (A_ALTCHARSET, CYAN, BLACK));
	for (i = 0; i < 77; i++)
		waddch (ConfigWin, ACS_HLINE);
	mvwaddch (ConfigWin, 2, 0, ACS_LTEE);
	mvwaddch (ConfigWin, 2, 77, ACS_RTEE);
	wattroff (ConfigWin, make_attr (A_ALTCHARSET, CYAN, BLACK));

	wattrset (MainWin, make_attr (A_NORMAL, WHITE, BLUE));
	commandline (clbuf, helpstr, "ESC=Quit", "^P=Print", NULL);
	mvwprintw (MainWin, KEY_LINE, 0, clbuf);
	wattroff (MainWin, make_attr (A_NORMAL, WHITE, BLUE));

	wrefresh (ConfigWin);
	wrefresh (MainWin);

	change_term (1, 0);

	while (option != 'Q' && option != 'q' && option != ESC)
	{
		switch (option = getch ())
		{
		case EOF:
			break;
		case ctrl ('L'):
			refresh_screen ();
			break;
#ifdef KEY_PRINT
		case KEY_PRINT:
#endif
		case ctrl ('P'):
			screen_save (ConfigWin, logfile);
			touchwin (ConfigWin);
			update_panels ();
			doupdate ();
			break;
		case ESC:
		case 'Q':
		case 'q':
			hide_panel (ConfigPanel);
			update_panels ();
			doupdate ();
			wrefresh (ConfigWin);
			option = 'Q';
			break;
		case KEY_F (1):		   /*  Help info  */
		case '?':
			info_screen ("dpa_info3", NULL);
			wattrset (MainWin, make_attr (A_NORMAL, WHITE, BLUE));
			commandline (clbuf, helpstr, "ESC=Quit", "^P=Print",
						 NULL);
			mvwprintw (MainWin, KEY_LINE, 0, clbuf);
			wattroff (MainWin, make_attr (A_NORMAL, WHITE, BLUE));
			update_panels ();
			doupdate ();
			option = EOF;
			break;
		default:
			mvwprintw (ConfigWin, 16, 60, "Invalid key");
			wrefresh (ConfigWin);
			sleep (1);
			mvwprintw (ConfigWin, 16, 60, "           ");
			wrefresh (ConfigWin);
			wrefresh (MainWin);
			break;
		}
	}
}



/**********************************************************************
*
*  Routine Name:	
*
*  Function:	
*
**********************************************************************/

void
print_c_adptconf (bdtype)
	int bdtype;
{
	int i, j, x = -1;			/* x is the fudge factor */
	int y, rel_conc;
	int option = EOF;
	int first = TRUE;

	wattrset (MainWin, make_attr (A_NORMAL, WHITE, BLUE));

	if (adapt_info[slot].emm_adpt)
		commandline (clbuf, helpstr, "ESC=Quit", "RETURN=Accept",
		 "M=LoadModem", lrudstr, "S=Status", "^P=Print", NULL);
	else
		commandline (clbuf, helpstr, "ESC=Quit", "RETURN=Accept",
		 lrudstr, "S=Status", "^P=Print", NULL);

	mvwprintw (MainWin, KEY_LINE, 0, clbuf);
	wattroff (MainWin, make_attr (A_NORMAL, WHITE, BLUE));

	wrefresh (MainWin);
	wrefresh (HeadWin);
	wrefresh (AdptWin);

	while ((option != 'Q') && (option != 'q') && (option != ESC))
	{
		get_status (slot);
		/*
		 * +-------------+
		 * |Adapt Line 1 |
		 * +-------------+
		 */
		wattrset (AdptWin, make_attr (A_ALTCHARSET, WHITE, BLACK));
		mvwaddch (AdptWin, 1, 2, ACS_VLINE);

		if (!selected_conc && !adpt_line)
		{
			wattrset (AdptWin, make_attr (A_STANDOUT|A_BLINK, WHITE, BLUE));
		}
		else
			wattrset (AdptWin, make_attr (A_NORMAL, GREEN, BLACK));
		mvwprintw (AdptWin, 1, 3, "Adapt Line 1");

		wattrset (AdptWin, make_attr (A_ALTCHARSET, WHITE, BLACK));
		mvwaddch (AdptWin, 1, 16, (adapt_info[slot].line1conc > 0) ? ACS_LTEE : ACS_VLINE);

		/* Now show the concentrators -[AC]- etc... */
		for (i = 0; i < adapt_info[slot].line1conc; i++)
		{
			wattrset (AdptWin, make_attr (A_ALTCHARSET, WHITE, BLACK));
			for (j = 0; j < 4; j++)
				mvwaddch (AdptWin, 1, 17 + (7 * i) + j, ACS_HLINE);
			mvwaddch (AdptWin, 1, 20 + (7 * i), ACS_RTEE);

			wattrset (AdptWin, make_attr (A_NORMAL, GREEN, BLACK));
			if (!Strcmp (cons_tbl[i], "AC"))
			{
				/* if a line 0 conc is selected */
				if ((selected_conc == (i + 1)) && !adpt_line)
				{
					if ((selected_conc - 1) == i)	/* if it is selected */
					{
						wattrset (AdptWin, make_attr (A_STANDOUT|A_BLINK, WHITE, BLUE));
					}
				}
			}
			/* if the conc is not "AC" */
			else
			{
				/* if a line 0 conc is selected */
				wattrset (AdptWin, make_attr (A_NORMAL, BLACK, RED));
				if ((selected_conc == (i + 1)) && !adpt_line)
				{
					if ((selected_conc - 1) == i)	/* if it is selected */
					{
						wattron (AdptWin, make_attr (A_STANDOUT|A_BLINK, BLACK, RED));
					}
				}
			}

			mvwaddstr (AdptWin, 1, 21 + (7 * i), cons_tbl[i]);
			/*
			 * Show any PORTS/Xem modules connected
			 * If there are any ports attached, it will write over the AC
			 */
			if (adapt_info[slot].nports_conc[i] [1] ||
			 adapt_info[slot].nports_conc[i] [2] ||
			 adapt_info[slot].nports_conc[i] [3])
				mvwprintw (AdptWin, 1, 20 + (7 * i), "%02d", 
				 adapt_info[slot].nports_conc[i] [0] +
				 adapt_info[slot].nports_conc[i] [1] +
				 adapt_info[slot].nports_conc[i] [2] +
				 adapt_info[slot].nports_conc[i] [3]);

			wattrset (AdptWin, make_attr (A_ALTCHARSET, WHITE, BLACK));
			mvwaddch (AdptWin, 1, 23 + (7 * i), 
				(i < adapt_info[slot].line1conc - 1) ? ACS_LTEE : ACS_VLINE);

			wattroff (AdptWin, make_attr (A_ALTCHARSET, WHITE, BLACK));

		}

		wattrset (AdptWin, make_attr (A_NORMAL, WHITE, BLACK));
		if (adapt_info[slot].line1conc > 0)
			mvwprintw (AdptWin, 2, 4, "Adapt to Node 1    %s", config_list[0]);
		else
			mvwprintw (AdptWin, 2, 4, "None.");

		y = 3;
		for (i = 0; i < adapt_info[slot].line1conc - 1; i++)
			mvwprintw (AdptWin, y + i, 3, "Node %d to Node %d    %s",
				(i + 1), (i + 2), config_list[i + 1]);

		/*
		 * +-------------+
		 * |Adapt Line 2 |
		 * +-------------+
		 */
		wattrset (AdptWin, make_attr (A_ALTCHARSET, WHITE, BLACK));

		mvwaddch (AdptWin, x + y + adapt_info[slot].line1conc, 2, ACS_VLINE);
		wattroff (AdptWin, make_attr (A_ALTCHARSET, WHITE, BLACK));

		if (!selected_conc && adpt_line)
			wattrset (AdptWin, make_attr (A_STANDOUT|A_BLINK, WHITE, BLUE));
		else
			wattrset (AdptWin, make_attr (A_NORMAL, GREEN, BLACK));
		mvwprintw (AdptWin, x + y + adapt_info[slot].line1conc, 3, "Adapt Line 2");

		wattrset (AdptWin, make_attr (A_ALTCHARSET, WHITE, BLACK));
		mvwaddch (AdptWin, x + y + adapt_info[slot].line1conc, 16, 
			(adapt_info[slot].line2conc > 0) ? ACS_LTEE : ACS_VLINE);

		/* Now show the concentrators -[AC]- etc... */
		for (i = 0; i < adapt_info[slot].line2conc; i++)
		{
			wattrset (AdptWin, make_attr (A_ALTCHARSET, WHITE, BLACK));
			for (j = 0; j < 4; j++)
				mvwaddch (AdptWin, x + y + adapt_info[slot].line1conc, 17 + (7 * i) + j, 
					ACS_HLINE);
			mvwaddch (AdptWin, x + y + adapt_info[slot].line1conc, 20 + (7 * i), ACS_RTEE);

			wattrset (AdptWin, make_attr (A_NORMAL, GREEN, BLACK));
			if (!Strcmp (cons_tbl[i + adapt_info[slot].line1conc], "AC"))
			{
				if ((selected_conc == (i + 1)) && adpt_line)
				{
					if ((selected_conc - 1) == i)
					{
						wattrset (AdptWin, make_attr (A_STANDOUT|A_BLINK, WHITE, BLUE));
					}
				}
			}
			else
				/* if the conc is not "all clear" */
			{
				wattrset (AdptWin, make_attr (A_NORMAL, BLACK, RED));
				if ((selected_conc == (i + 1)) && adpt_line)
				{
					if ((selected_conc - 1) == i)	/* if it is selected */
					{
						wattron (AdptWin, make_attr (A_STANDOUT|A_BLINK, BLACK, RED));
					}
				}
			}

			mvwaddstr (AdptWin, x + y + adapt_info[slot].line1conc, 21 + (7 * i), cons_tbl[i + adapt_info[slot].line1conc]);
			/* Show any PORTS/Xem modules connected */
			if (adapt_info[slot].nports_conc[i + adapt_info[slot].line1conc] [1] ||
			 adapt_info[slot].nports_conc[i + adapt_info[slot].line1conc] [2] ||
			 adapt_info[slot].nports_conc[i + adapt_info[slot].line1conc] [3])
				mvwprintw (AdptWin, x + y + adapt_info[slot].line1conc, 20 + (7 * i), "%02d",
				 adapt_info[slot].nports_conc[i + adapt_info[slot].line1conc] [0] +
				 adapt_info[slot].nports_conc[i + adapt_info[slot].line1conc] [1] +
				 adapt_info[slot].nports_conc[i + adapt_info[slot].line1conc] [2] +
				 adapt_info[slot].nports_conc[i + adapt_info[slot].line1conc] [3]);

			wattrset (AdptWin, make_attr (A_ALTCHARSET, WHITE, BLACK));
			mvwaddch (AdptWin, x + y + adapt_info[slot].line1conc, 23 + (7 * i), 
				(i < adapt_info[slot].line2conc - 1) ? ACS_LTEE : ACS_VLINE);

			wattroff (AdptWin, make_attr (A_ALTCHARSET, WHITE, BLACK));


		}						   /* end For loop */

		y++;
		wattrset (AdptWin, make_attr (A_NORMAL, WHITE, BLACK));
		if (adapt_info[slot].line2conc > 0)
			mvwprintw (AdptWin, x + y + adapt_info[slot].line1conc, 4, "Adapt to Node 1    %s",
					   config_list[adapt_info[slot].line1conc + 1]);
		else
			mvwprintw (AdptWin, x + y + adapt_info[slot].line1conc, 4, "None.");

		y++;
		for (i = 0; i < adapt_info[slot].line2conc - 1; i++)
			mvwprintw (AdptWin, x + y + adapt_info[slot].line1conc + i, 3,
				"Node %d to Node %d    %s",
				(i + 1), (i + 2), config_list[i + adapt_info[slot].line1conc + 2]);

		change_term (0, TIMEOUT);

		if (debug && first)
		{
			fprintf (dfp, "***** Debug info from print_adptconf *****\n");
			fprintf (dfp, "line1conc: %d\n", adapt_info[slot].line1conc);
			fprintf (dfp, "line2conc: %d\n", adapt_info[slot].line2conc);

			for (i = 0;
			 i < adapt_info[slot].line1conc + adapt_info[slot].line2conc;
			 ++i)
				fprintf (dfp, "nports_conc[%d]: %d %d %d %d\n", i,
				 adapt_info[slot].nports_conc[i] [0],
				 adapt_info[slot].nports_conc[i] [1],
				 adapt_info[slot].nports_conc[i] [2],
				 adapt_info[slot].nports_conc[i] [3]);

			fflush (dfp);
		}

		if (first)
		{
			first = FALSE;
			wrefresh (MainWin);
			wrefresh (HeadWin);
		}

		wrefresh (AdptWin);

		switch (option = getch ())
		{
		case EOF:
			break;
		case ctrl ('L'):
			refresh_screen ();
			break;
#ifdef KEY_LEFT
		case KEY_LEFT:
#endif
		case 'h':
			/* Line 2 selected */
			if (adpt_line)
			{
				if (selected_conc)
					selected_conc--;
				else
					selected_conc = adapt_info[slot].line2conc;
			}
			/* Line 1 selected */
			else
			{
				if (selected_conc)
					selected_conc--;
				else
					selected_conc = adapt_info[slot].line1conc;
			}
			break;
#ifdef KEY_RIGHT
		case KEY_RIGHT:
#endif
		case 'l':
			/* Line 2 selected */
			if (adpt_line)
			{
				if (selected_conc < adapt_info[slot].line2conc)
					selected_conc++;
				else
					selected_conc = 0;
			}
			/* Line 1 selected */
			else
			{
				if (selected_conc < adapt_info[slot].line1conc)
					selected_conc++;
				else
					selected_conc = 0;
			}
			break;
#ifdef KEY_UP
		case KEY_UP:
#endif
#ifdef KEY_DOWN
		case KEY_DOWN:
#endif
		case 'j':
		case 'k':
			if (adpt_line)
			{
				adpt_line = 0;
				if (adapt_info[slot].line1conc < selected_conc)
					selected_conc = adapt_info[slot].line1conc;
			}
			else
			{
				adpt_line = 1;
				if (adapt_info[slot].line2conc < selected_conc)
					selected_conc = adapt_info[slot].line2conc;
			}
			break;
		case 'Q':
		case 'q':
		case ESC:
			hide_panel (AdptPanel);
			update_panels ();
			doupdate ();
			wrefresh (AdptWin);
			del_panel (AdptPanel);
			delwin (AdptWin);
			break;
		case RETURN:
			hide_panel (AdptPanel);
			update_panels ();
			doupdate ();
			wrefresh (AdptWin);

			if (selected_conc)
			{
				conc = selected_conc - 1;
				a_line = adpt_line + 1;
				print_channel ();
			}
			else
			{
				conc = 0;
				print_config (bdtype);
			}

			show_panel (AdptPanel);
			update_panels ();
			doupdate ();
			wrefresh (AdptWin);
			break;
#ifdef KEY_PRINT
		case KEY_PRINT:
#endif
		case ctrl ('P'):
			screen_save (AdptWin, logfile);
			touchwin (AdptWin);
			update_panels ();
			doupdate ();
			break;
		case KEY_F (1):		   /*  Help info  */
		case '?':
			info_screen ("dpa_info2", NULL);
			touchwin (AdptWin);
			wrefresh (AdptWin);
			update_panels ();
			doupdate ();
			break;
		case 'S':
		case 's':
			hide_panel (AdptPanel);
			update_panels ();
			doupdate ();

			print_errcounts ();

			show_panel (AdptPanel);
			update_panels ();
			doupdate ();
			wrefresh (AdptWin);
			break;

#ifndef NO_MODEM_OPTS
		case 'm':
		case 'M':
			/*
			*  Load em Modem flash ROM selected, if
			*  not em Modem, invalid key
			*/

			if (adpt_line)
				rel_conc =
				 adapt_info[slot].line1conc + selected_conc - 1;
			else
				rel_conc = selected_conc - 1;

			if (selected_conc && adapt_info[slot].emm_conc[rel_conc])
			{
				print_flashl (EM_MOD, rel_conc);
			}
			else if (!selected_conc && adapt_info[slot].emm_adpt)
				print_flashl (EM_ADPT, 0);
			else
			{
				wattrset (AdptWin, make_attr (A_NORMAL, WHITE, BLACK));
				mvwprintw (AdptWin, 16, 60, "Invalid key");
				wrefresh (AdptWin);
				sleep (1);
				mvwprintw (AdptWin, 16, 60, "           ");
				wrefresh (AdptWin);
			}
#endif /* !NO_MODEM_OPTS */

		default:
			mvwprintw (AdptWin, 16, 60, "Invalid key");
			wrefresh (AdptWin);
			sleep (1);
			mvwprintw (AdptWin, 16, 60, "           ");
			wrefresh (AdptWin);
			break;
		}						   /* End Case */
	
		wattrset (MainWin, make_attr (A_NORMAL, WHITE, BLUE));

		if (adpt_line)
			rel_conc = adapt_info[slot].line1conc + selected_conc - 1;
		else
			rel_conc = selected_conc - 1;

		if (selected_conc)
		{
			if (adapt_info[slot].emm_conc[rel_conc])
				commandline (clbuf, helpstr, "ESC=Quit",
				 "RETURN=Accept", "M=LoadModem",
				 lrudstr, "S=Status", "^P=Print", NULL);
			else
				commandline (clbuf, helpstr, "ESC=Quit",
				 "RETURN=Accept", lrudstr, "S=Status",
				 "^P=Print", NULL);
		}
		else
		{
			if (adapt_info[slot].emm_adpt)
				commandline (clbuf, helpstr, "ESC=Quit",
				 "RETURN=Accept", "M=LoadModem", lrudstr, "S=Status",
				 "^P=Print", NULL);
			else
				commandline (clbuf, helpstr, "ESC=Quit",
				 "RETURN=Accept", lrudstr, "S=Status", "^P=Print",
				 NULL);
		}
						 
		mvwprintw (MainWin, KEY_LINE, 0, clbuf);
		wattroff (MainWin, make_attr (A_NORMAL, WHITE, BLUE));
		wrefresh (MainWin);
	}							   /* End Loop */
}



/**********************************************************************
*
*  Routine Name:	
*
*  Function:	
*
**********************************************************************/

void
print_adptconf (bdtype)
	int bdtype;
{
	int i, j, x = -1;			/* x is the fudge factor */
	int option = EOF, rel_conc;
	int first = TRUE;
	int condense = FALSE;

	get_config (slot, bdtype);

	if ((AdptPanel = CreateConcPanel (&condense)) == NULL)
		return;
	AdptWin = panel_window (AdptPanel);

	/*
	 * Check the fudge factor for the conc spacing
	 */
	if ((adapt_info[slot].line1conc + adapt_info[slot].line2conc) < 8)
	{
		if (!condense)
			x = 0;
	}
	else if (condense)
	{
		print_c_adptconf (bdtype);
		return;
	}

	wattrset (MainWin, make_attr (A_NORMAL, WHITE, BLUE));

	if (adapt_info[slot].emm_adpt)
		commandline (clbuf, helpstr, "ESC=Quit", "RETURN=Accept",
		 "M=LoadModem", lrudstr, "S=Status", "^P=Print", NULL);
	else
		commandline (clbuf, helpstr, "ESC=Quit", "RETURN=Accept",
		 lrudstr, "S=Status", "^P=Print", NULL);
	
	mvwprintw (MainWin, KEY_LINE, 0, clbuf);
	wattroff (MainWin, make_attr (A_NORMAL, WHITE, BLUE));

	wrefresh (MainWin);
	wrefresh (HeadWin);
	wrefresh (AdptWin);

	while ((option != 'Q') && (option != 'q') && (option != ESC))
	{
		get_status (slot);
		/*
		 * +-------------+
		 * |Adapt Line 1 |
		 * +-------------+
		 */
		wattrset (AdptWin, make_attr (A_ALTCHARSET, WHITE, BLACK));
		mvwaddch (AdptWin, 1, 2, ACS_ULCORNER);
		for (i = 1; i < 14; i++)
			mvwaddch (AdptWin, 1, i + 2, ACS_HLINE);

		mvwaddch (AdptWin, 1, 16, ACS_URCORNER);
		mvwaddch (AdptWin, 2, 2, ACS_VLINE);
		wattroff (AdptWin, make_attr (A_ALTCHARSET, WHITE, BLACK));
		if (!selected_conc && !adpt_line)
		{
			wattrset (AdptWin, make_attr (A_STANDOUT|A_BLINK, WHITE, BLUE));
			mvwprintw (AdptWin, 2, 3, "Adapt Line 1");
			wattroff (AdptWin, make_attr (A_STANDOUT|A_BLINK, WHITE, BLUE));
		}
		else
		{
			wattrset (AdptWin, make_attr (A_NORMAL, GREEN, BLACK));
			mvwprintw (AdptWin, 2, 3, "Adapt Line 1");
			wattroff (AdptWin, make_attr (A_NORMAL, GREEN, BLACK));
		}
		wattrset (AdptWin, make_attr (A_ALTCHARSET, WHITE, BLACK));
		if (adapt_info[slot].line1conc > 0)
			mvwaddch (AdptWin, 2, 16, ACS_LTEE);
		else
			mvwaddch (AdptWin, 2, 16, ACS_VLINE);
		mvwaddch (AdptWin, 3, 2, ACS_LLCORNER);
		mvwaddch (AdptWin, 3, 16, ACS_LRCORNER);

		for (i = 1; i < 14; i++)
			mvwaddch (AdptWin, 3, i + 2, ACS_HLINE);

		/* Now show the concentrators -[AC]- etc... */
		for (i = 0; i < adapt_info[slot].line1conc; i++)
		{
			wattrset (AdptWin, make_attr (A_ALTCHARSET, WHITE, BLACK));
			for (j = 0; j < 4; j++)
				mvwaddch (AdptWin, 2, 17 + (7 * i) + j, ACS_HLINE);
			mvwaddch (AdptWin, 1, 20 + (7 * i), ACS_ULCORNER);
			mvwaddch (AdptWin, 2, 20 + (7 * i), ACS_RTEE);
			mvwaddch (AdptWin, 3, 20 + (7 * i), ACS_LLCORNER);
			wattroff (AdptWin, make_attr (A_ALTCHARSET, WHITE, BLACK));

			wattrset (AdptWin, make_attr (A_NORMAL, GREEN, BLACK));
			if (!Strcmp (cons_tbl[i], "AC"))
			{
				/* if a line 0 conc is selected */
				if ((selected_conc == (i + 1)) && !adpt_line)
				{
					if ((selected_conc - 1) == i)	/* if it is selected */
					{
						wattrset (AdptWin, make_attr (A_STANDOUT|A_BLINK, WHITE, BLUE));
					}
				}
			}
			else
				/* if the conc is not "all clear" */
			{
				/* if a line 0 conc is selected */
				wattrset (AdptWin, make_attr (A_NORMAL, BLACK, RED));
				if ((selected_conc == (i + 1)) && !adpt_line)
				{
					if ((selected_conc - 1) == i)	/* if it is selected */
					{
						wattron (AdptWin, make_attr (A_STANDOUT|A_BLINK, BLACK, RED));
					}
				}
			}

			mvwaddstr (AdptWin, 2, 21 + (7 * i), cons_tbl[i]);

			wattrset (AdptWin, make_attr (A_ALTCHARSET, WHITE, BLACK));
			mvwaddch (AdptWin, 1, 23 + (7 * i), ACS_URCORNER);

			if (i < adapt_info[slot].line1conc - 1)
				mvwaddch (AdptWin, 2, 23 + (7 * i), ACS_LTEE);
			else
				mvwaddch (AdptWin, 2, 23 + (7 * i), ACS_VLINE);
			mvwaddch (AdptWin, 3, 23 + (7 * i), ACS_LRCORNER);
			wattroff (AdptWin, make_attr (A_ALTCHARSET, WHITE, BLACK));

			/* Show any PORTS/Xem modules connected */

			mvwprintw (AdptWin, 4, 20 + (7 * i), "[%02d]", 
			 adapt_info[slot].nports_conc[i] [0] +
			 adapt_info[slot].nports_conc[i] [1] +
			 adapt_info[slot].nports_conc[i] [2] +
			 adapt_info[slot].nports_conc[i] [3]);
		}

		wattrset (AdptWin, make_attr (A_BOLD, WHITE, BLACK));
		mvwprintw (AdptWin, 4, 2, "Line 1 Config:");
		wattroff (AdptWin, make_attr (A_BOLD, WHITE, BLACK));
		if (adapt_info[slot].line1conc > 0)
			mvwprintw (AdptWin, 5, 4, "Adapt to Node 1    %s", config_list[0]);
		else
			mvwprintw (AdptWin, 5, 4, "None.");

		for (i = 0; i < adapt_info[slot].line1conc - 1; i++)
			mvwprintw (AdptWin, 6 + i, 3, "Node %d to Node %d    %s",
					   (i + 1), (i + 2), config_list[i + 1]);

		/*
		 * +-------------+
		 * |Adapt Line 2 |
		 * +-------------+
		 */
		wattrset (AdptWin, make_attr (A_ALTCHARSET, WHITE, BLACK));
		mvwaddch (AdptWin, x + 6 + adapt_info[slot].line1conc, 2, ACS_ULCORNER);
		for (i = 1; i < 14; i++)
			mvwaddch (AdptWin, x + 6 + adapt_info[slot].line1conc, i + 2, ACS_HLINE);

		mvwaddch (AdptWin, x + 7 + adapt_info[slot].line1conc, 2, ACS_VLINE);
		wattroff (AdptWin, make_attr (A_ALTCHARSET, WHITE, BLACK));

		if (!selected_conc && adpt_line)
		{
			wattrset (AdptWin, make_attr (A_STANDOUT|A_BLINK, WHITE, BLUE));
			mvwprintw (AdptWin, x + 7 + adapt_info[slot].line1conc, 3, "Adapt Line 2");
			wattroff (AdptWin, make_attr (A_STANDOUT|A_BLINK, WHITE, BLUE));
		}
		else
		{
			wattrset (AdptWin, make_attr (A_NORMAL, GREEN, BLACK));
			mvwprintw (AdptWin, x + 7 + adapt_info[slot].line1conc, 3, "Adapt Line 2");
			wattroff (AdptWin, make_attr (A_NORMAL, GREEN, BLACK));
		}

		wattrset (AdptWin, make_attr (A_ALTCHARSET, WHITE, BLACK));
		mvwaddch (AdptWin, x + 6 + adapt_info[slot].line1conc, 16, ACS_URCORNER);
		if (adapt_info[slot].line2conc > 0)
			mvwaddch (AdptWin, x + 7 + adapt_info[slot].line1conc, 16, ACS_LTEE);
		else
			mvwaddch (AdptWin, x + 7 + adapt_info[slot].line1conc, 16, ACS_VLINE);
		mvwaddch (AdptWin, x + 8 + adapt_info[slot].line1conc, 16, ACS_LRCORNER);

		mvwaddch (AdptWin, x + 8 + adapt_info[slot].line1conc, 2, ACS_LLCORNER);
		for (i = 1; i < 14; i++)
			mvwaddch (AdptWin, x + 8 + adapt_info[slot].line1conc, i + 2, ACS_HLINE);

		/* Now show the concentrators -[AC]- etc... */
		for (i = 0; i < adapt_info[slot].line2conc; i++)
		{
			wattrset (AdptWin, make_attr (A_ALTCHARSET, WHITE, BLACK));
			for (j = 0; j < 4; j++)
				mvwaddch (AdptWin, x + 7 + adapt_info[slot].line1conc, 17 + (7 * i) + j, ACS_HLINE);
			mvwaddch (AdptWin, x + 6 + adapt_info[slot].line1conc, 20 + (7 * i), ACS_ULCORNER);
			mvwaddch (AdptWin, x + 7 + adapt_info[slot].line1conc, 20 + (7 * i), ACS_RTEE);
			mvwaddch (AdptWin, x + 8 + adapt_info[slot].line1conc, 20 + (7 * i), ACS_LLCORNER);

			wattrset (AdptWin, make_attr (A_NORMAL, GREEN, BLACK));
			if (!Strcmp (cons_tbl[i + adapt_info[slot].line1conc], "AC"))
			{
				if ((selected_conc == (i + 1)) && adpt_line)
				{
					if ((selected_conc - 1) == i)
					{
						wattrset (AdptWin, make_attr (A_STANDOUT|A_BLINK, WHITE, BLUE));
					}
				}
			}
			else
				/* if the conc is not "all clear" */
			{
				wattrset (AdptWin, make_attr (A_NORMAL, BLACK, RED));
				if ((selected_conc == (i + 1)) && adpt_line)
				{
					if ((selected_conc - 1) == i)	/* if it is selected */
					{
						wattron (AdptWin, make_attr (A_STANDOUT|A_BLINK, BLACK, RED));
					}
				}
			}

			mvwaddstr (AdptWin, x + 7 + adapt_info[slot].line1conc, 21 + (7 * i), cons_tbl[i + adapt_info[slot].line1conc]);

			wattrset (AdptWin, make_attr (A_ALTCHARSET, WHITE, BLACK));
			mvwaddch (AdptWin, x + 6 + adapt_info[slot].line1conc, 23 + (7 * i), ACS_URCORNER);

			if (i < adapt_info[slot].line2conc - 1)
				mvwaddch (AdptWin, x + 7 + adapt_info[slot].line1conc, 23 + (7 * i), ACS_LTEE);
			else
				mvwaddch (AdptWin, x + 7 + adapt_info[slot].line1conc, 23 + (7 * i), ACS_VLINE);

			mvwaddch (AdptWin, x + 8 + adapt_info[slot].line1conc, 23 + (7 * i), ACS_LRCORNER);
			wattroff (AdptWin, make_attr (A_ALTCHARSET, WHITE, BLACK));

			/* Show any PORTS/Xem modules connected */
			mvwprintw (AdptWin, x + 9 + adapt_info[slot].line1conc, 20 + (7 * i), "[%02d]",
			 adapt_info[slot].nports_conc[i + adapt_info[slot].line1conc] [0] +
			 adapt_info[slot].nports_conc[i + adapt_info[slot].line1conc] [1] +
			 adapt_info[slot].nports_conc[i + adapt_info[slot].line1conc] [2] +
			 adapt_info[slot].nports_conc[i + adapt_info[slot].line1conc] [3]);

		}						   /* end For loop */

		wattrset (AdptWin, make_attr (A_BOLD, WHITE, BLACK));
		mvwprintw (AdptWin, x + 9 + adapt_info[slot].line1conc, 2, "Line 2 Config:");
		wattrset (AdptWin, make_attr (A_NORMAL, WHITE, BLACK));
		if (adapt_info[slot].line2conc > 0)
			mvwprintw (AdptWin, x + 10 + adapt_info[slot].line1conc, 4, "Adapt to Node 1    %s",
					   config_list[adapt_info[slot].line1conc + 1]);
		else
			mvwprintw (AdptWin, x + 10 + adapt_info[slot].line1conc, 4, "None.");

		for (i = 0; i < adapt_info[slot].line2conc - 1; i++)
			mvwprintw (AdptWin, x + 11 + adapt_info[slot].line1conc + i, 3,
						"Node %d to Node %d    %s",
					   (i + 1), (i + 2), config_list[i + adapt_info[slot].line1conc + 2]);

		change_term (0, TIMEOUT);

		if (debug && first)
		{
			fprintf (dfp, "***** Debug info from print_adptconf *****\n");
			fprintf (dfp, "line1conc: %d\n", adapt_info[slot].line1conc);
			fprintf (dfp, "line2conc: %d\n", adapt_info[slot].line2conc);

			for (i = 0;
			 i < adapt_info[slot].line1conc + adapt_info[slot].line2conc;
			 ++i)
				fprintf (dfp, "nports_conc[%d]: %d %d %d %d\n", i,
				 adapt_info[slot].nports_conc[i] [0],
				 adapt_info[slot].nports_conc[i] [1],
				 adapt_info[slot].nports_conc[i] [2],
				 adapt_info[slot].nports_conc[i] [3]);

			fflush (dfp);
		}

		if (first)
		{
			first = FALSE;
			wrefresh (MainWin);
			wrefresh (HeadWin);
		}

		wrefresh (AdptWin);

		switch (option = getch ())
		{
		case EOF:
			break;
		case ctrl ('L'):
			refresh_screen ();
			break;
#ifdef KEY_LEFT
		case KEY_LEFT:
#endif
		case 'h':
			/* Line 2 selected */
			if (adpt_line)
			{
				if (selected_conc)
					selected_conc--;
				else
					selected_conc = adapt_info[slot].line2conc;
			}
			/* Line 1 selected */
			else
			{
				if (selected_conc)
					selected_conc--;
				else
					selected_conc = adapt_info[slot].line1conc;
			}
			break;
#ifdef KEY_RIGHT
		case KEY_RIGHT:
#endif
		case 'l':
			/* Line 2 selected */
			if (adpt_line)
			{
				if (selected_conc < adapt_info[slot].line2conc)
					selected_conc++;
				else
					selected_conc = 0;
			}
			/* Line 1 selected */
			else
			{
				if (selected_conc < adapt_info[slot].line1conc)
					selected_conc++;
				else
					selected_conc = 0;
			}
			break;
#ifdef KEY_UP
		case KEY_UP:
#endif
#ifdef KEY_DOWN
		case KEY_DOWN:
#endif
		case 'j':
		case 'k':
			if (adpt_line)
			{
				adpt_line = 0;
				if (adapt_info[slot].line1conc < selected_conc)
					selected_conc = adapt_info[slot].line1conc;
			}
			else
			{
				adpt_line = 1;
				if (adapt_info[slot].line2conc < selected_conc)
					selected_conc = adapt_info[slot].line2conc;
			}
			break;
		case 'Q':
		case 'q':
		case ESC:
			hide_panel (AdptPanel);
			update_panels ();
			doupdate ();
			wrefresh (AdptWin);
			del_panel (AdptPanel);
			delwin (AdptWin);
			break;
		case RETURN:
			hide_panel (AdptPanel);
			update_panels ();
			doupdate ();
			wrefresh (AdptWin);

			if (selected_conc)
			{
				conc = selected_conc - 1;
				a_line = adpt_line + 1;
				print_channel ();
			}
			else
			{
				conc = 0;
				print_config (bdtype);
			}

			show_panel (AdptPanel);
			update_panels ();
			doupdate ();
			wrefresh (AdptWin);
			break;
#ifdef KEY_PRINT
		case KEY_PRINT:
#endif
		case ctrl ('P'):
			screen_save (AdptWin, logfile);
			touchwin (AdptWin);
			update_panels ();
			doupdate ();
			break;
		case KEY_F (1):		   /*  Help info  */
		case '?':
			info_screen ("dpa_info2", NULL);
			touchwin (AdptWin);
			wrefresh (AdptWin);
			update_panels ();
			doupdate ();
			break;
		case 'S':
		case 's':
			hide_panel (AdptPanel);
			update_panels ();
			doupdate ();

			print_errcounts ();

			show_panel (AdptPanel);
			update_panels ();
			doupdate ();
			wrefresh (AdptWin);
			break;

#ifndef NO_MODEM_OPTS
		case 'm':
		case 'M':
			/*
			*  Load em Modem flash ROM selected, if
			*  not em Modem, invalid key
			*/

			if (adpt_line)
				rel_conc =
				 adapt_info[slot].line1conc + selected_conc - 1;
			else
				rel_conc = selected_conc - 1;

			if (selected_conc && adapt_info[slot].emm_conc[rel_conc])
			{
				print_flashl (EM_MOD, rel_conc);
			}
			else if (!selected_conc && adapt_info[slot].emm_adpt)
				print_flashl (EM_ADPT, 0);
			else
			{
				wattrset (AdptWin, make_attr (A_NORMAL, WHITE, BLACK));
				mvwprintw (AdptWin, 16, 60, "Invalid key");
				wrefresh (AdptWin);
				sleep (1);
				mvwprintw (AdptWin, 16, 60, "           ");
				wrefresh (AdptWin);
			}
#endif /* !NO_MODEM_OPTS */

		default:
			mvwprintw (AdptWin, 16, 60, "Invalid key");
			wrefresh (AdptWin);
			sleep (1);
			mvwprintw (AdptWin, 16, 60, "           ");
			wrefresh (AdptWin);
			break;
		}						   /* End Case */
	
		wattrset (MainWin, make_attr (A_NORMAL, WHITE, BLUE));

		if (adpt_line)
			rel_conc = adapt_info[slot].line1conc + selected_conc - 1;
		else
			rel_conc = selected_conc - 1;

		if (selected_conc)
		{
			if (adapt_info[slot].emm_conc[rel_conc])
				commandline (clbuf, helpstr, "ESC=Quit",
				 "RETURN=Accept", "M=LoadModem",
				 lrudstr, "S=Status", "^P=Print", NULL);
			else
				commandline (clbuf, helpstr, "ESC=Quit",
				 "RETURN=Accept", lrudstr, "S=Status",
				 "^P=Print", NULL);
		}
		else
		{
			if (adapt_info[slot].emm_adpt)
				commandline (clbuf, helpstr, "ESC=Quit",
				 "RETURN=Accept", "M=LoadModem", lrudstr, "S=Status",
				 "^P=Print", NULL);
			else
				commandline (clbuf, helpstr, "ESC=Quit",
				 "RETURN=Accept", lrudstr, "S=Status", "^P=Print",
				 NULL);
		}
						 
		mvwprintw (MainWin, KEY_LINE, 0, clbuf);
		wattroff (MainWin, make_attr (A_NORMAL, WHITE, BLUE));
		wrefresh (MainWin);
	}							   /* End Loop */
}



/**********************************************************************
*
*  Routine Name:	
*
*  Function:	
*
**********************************************************************/

void 
print_Xemconf ()
{
	int i, j, x;
	int option = EOF;
	int first = TRUE;

	show_panel (XemPanel);
	update_panels ();
	doupdate ();

	/*
	 * +--------------+
	 * |Adapt EBI Line|---[EBI] ....etc
	 * +--------------+
	 */
	wattrset (XemWin, make_attr (A_ALTCHARSET, WHITE, BLACK));

	for (i = 1; i < 16; i++)
	{
		mvwaddch (XemWin, 3, i + 3, ACS_HLINE);
		mvwaddch (XemWin, 5, i + 3, ACS_HLINE);
	}

	mvwaddch (XemWin, 3, 3, ACS_ULCORNER);
	mvwaddch (XemWin, 3, 19, ACS_URCORNER);
	mvwaddch (XemWin, 4, 3, ACS_VLINE);
	mvwaddch (XemWin, 4, 19, ACS_LTEE);
	mvwaddch (XemWin, 5, 3, ACS_LLCORNER);
	mvwaddch (XemWin, 5, 19, ACS_LRCORNER);

	wattrset (MainWin, make_attr (A_NORMAL, WHITE, BLUE));

	if (adapt_info[slot].emm_adpt)
		commandline (clbuf, helpstr, "ESC=Quit",
		 "M=LoadModem", lrudstr, "^P=Print", NULL);
	else
		commandline (clbuf, helpstr, "ESC=Quit",
		 lrudstr, "^P=Print", NULL);

	mvwprintw (MainWin, KEY_LINE, 0, clbuf);
	wattroff (MainWin, make_attr (A_NORMAL, WHITE, BLUE));
	wrefresh (MainWin);

	while ((option != 'Q') && (option != 'q') && (option != ESC))
	{

		if (!selected_conc && !adpt_line)
			wattrset (XemWin, make_attr (A_STANDOUT|A_BLINK, WHITE, BLUE));
		else
			wattrset (XemWin, make_attr (A_NORMAL, GREEN, BLACK));
		mvwprintw (XemWin, 4, 4, "Adapt EBI Line");

		for (i = 0; i < (int) adapt_info[slot].nmodules; i++)
		{
			wattrset (XemWin, make_attr (A_ALTCHARSET, WHITE, BLACK));

			for (j = 0; j < 2; j++)
				mvwaddch (XemWin, 4, 20 + (8 * i) + j, ACS_HLINE);

			/* -[EBI]-....etc */
			mvwaddch (XemWin, 3, 22 + (8 * i), ACS_ULCORNER);
			mvwaddch (XemWin, 4, 22 + (8 * i), ACS_RTEE);
			mvwaddch (XemWin, 5, 22 + (8 * i), ACS_LLCORNER);
			wattroff (XemWin, make_attr (A_ALTCHARSET, WHITE, BLACK));

			if ((selected_conc == (i + 1)) && !adpt_line)
			{
				if ((selected_conc - 1) == i)
					wattrset (XemWin, make_attr (A_STANDOUT|A_BLINK, WHITE, BLUE));
			}
			else
				wattrset (XemWin, make_attr (A_NORMAL, GREEN, BLACK));

			mvwprintw (XemWin, 4, 23 + (8 * i), "%s", 
				adapt_info[slot].modtype[i]);

			wattrset (XemWin, make_attr (A_ALTCHARSET, WHITE, BLACK));
			mvwaddch (XemWin, 3, 27 + (8 * i), ACS_URCORNER);
			if (i < (int) adapt_info[slot].nmodules - 1)
				mvwaddch (XemWin, 4, 27 + (8 * i), ACS_LTEE);
			else
				mvwaddch (XemWin, 4, 27 + (8 * i), ACS_VLINE);
			mvwaddch (XemWin, 5, 27 + (8 * i), ACS_LRCORNER);
		}

		wattrset (XemWin, make_attr (A_NORMAL, WHITE, BLACK));

		if (debug && first)
		{
			fprintf (dfp, "***** Debug info from print_Xemconf *****\n");
			fprintf (dfp, "slot: %d\n", slot);

			for (x = 0; x < (int) adapt_info[slot].nmodules; x++)
			{
				fprintf (dfp, "Module type[%d]: %s\n", x,
					adapt_info[slot].modtype[x]);
			}
			fflush (dfp);
		}

		if (first)
		{
			first = FALSE;
			update_panels ();
			doupdate ();
			wrefresh (MainWin);
			wrefresh (HeadWin);
		}
		wrefresh (XemWin);

		change_term (1, 0);

		switch (option = getch ())
		{
		case EOF:
			break;
		case ctrl ('L'):
			refresh_screen ();
			break;
#ifdef KEY_LEFT
		case KEY_LEFT:
#endif
		case 'h':
			if (selected_conc)
				selected_conc--;
			else
				selected_conc = adapt_info[slot].nmodules;
			break;
#ifdef KEY_RIGHT
		case KEY_RIGHT:
#endif
		case 'l':
			if (selected_conc < (int) adapt_info[slot].nmodules)
				selected_conc++;
			else
				selected_conc = 0;
			break;
		case 'Q':
		case 'q':
		case ESC:
			hide_panel (XemPanel);
			erase_win (XemWin);
			update_panels ();
			doupdate ();
			wrefresh (XemWin);
			break;
		case RETURN:
			if (selected_conc)
			{
				conc = selected_conc - 1;
				a_line = adpt_line + 1;

				hide_panel (XemPanel);
				update_panels ();
				doupdate ();

				print_channel ();
				show_panel (XemPanel);
				update_panels ();
				doupdate ();
				wrefresh (XemWin);
			}
			else
			{
				mvwprintw (XemWin, 16, 60, "Invalid key");
				wrefresh (XemWin);
				sleep (1);
				mvwprintw (XemWin, 16, 60, "           ");
				wrefresh (XemWin);
			}
			break;
#ifdef KEY_PRINT
		case KEY_PRINT:
#endif
		case ctrl ('P'):
			screen_save (XemWin, logfile);
			touchwin (XemWin);
			wrefresh (XemWin);
			update_panels ();
			doupdate ();
			break;

#ifndef NO_MODEM_OPTS
		case 'm':
		case 'M':
			/*
			*  Load em Modem flash ROM selected, if
			*  not em Modem, invalid key
			*/

			if (selected_conc &&
			 adapt_info[slot].emm_conc[selected_conc - 1])
				print_flashl (EM_MOD, selected_conc - 1);
			else if (!selected_conc && adapt_info[slot].emm_adpt)
				print_flashl (EM_ADPT, 0);
			else
			{
				wattrset (XemWin, make_attr (A_NORMAL, WHITE, BLACK));
				mvwprintw (XemWin, 16, 60, "Invalid key");
				wrefresh (XemWin);
				sleep (1);
				mvwprintw (XemWin, 16, 60, "           ");
				wrefresh (XemWin);
			}

			break;
#endif /* !NO_MODEM_OPTS */

		case KEY_F (1):		   /*  Help info  */
		case '?':
			info_screen ("dpa_info6", NULL);
			break;
		default:
			wattrset (XemWin, make_attr (A_NORMAL, WHITE, BLACK));
			mvwprintw (XemWin, 16, 60, "Invalid key");
			wrefresh (XemWin);
			sleep (1);
			mvwprintw (XemWin, 16, 60, "           ");
			wrefresh (XemWin);
			break;
		}						   /* End Case */

		if (option != EOF)
		{
			wattrset (MainWin, make_attr (A_NORMAL, WHITE, BLUE));

			if (selected_conc)
			{
				if (adapt_info[slot].emm_conc[selected_conc - 1])
					commandline (clbuf, helpstr, "ESC=Quit",
					 "RETURN=Accept", "M=LoadModem", lrudstr,
					 "^P=Print", NULL);
				else
					commandline (clbuf, helpstr, "ESC=Quit",
					 "RETURN=Accept", lrudstr,
					 "^P=Print", NULL);
			}
			else
			{
				if (adapt_info[slot].emm_adpt)
					commandline (clbuf, helpstr, "ESC=Quit",
					 "M=LoadModem", lrudstr, "^P=Print", NULL);
				else
					commandline (clbuf, helpstr, "ESC=Quit",
					 lrudstr, "^P=Print", NULL);
			}
						 
			mvwprintw (MainWin, KEY_LINE, 0, clbuf);
			wattroff (MainWin, make_attr (A_NORMAL, WHITE, BLUE));
			wrefresh (MainWin);
			wrefresh (XemWin);
		}
	}							   /* End While Loop */
}



/**********************************************************************
*
*  Routine Name:	
*
*  Function:	
*
**********************************************************************/

void 
print_identify ()
{
	int i, k;
	int option = EOF;
	static int first = TRUE;
	char print_type[25];
	char bd_state[11];

	memset (config_list, '\0', sizeof (config_list));
	memset (print_type, '\0', sizeof (print_type));
	memset (bd_state, '\0', sizeof (bd_state));

	wattrset (IdentWin, make_attr (A_BOLD, WHITE, BLUE));
	mvwprintw (IdentWin, 1, 1,
"         Type                  State   I/O Addr   Mem Addr  Mem Size  #Ports");
/*
"                                                                            "
*/

	wattrset (IdentWin, make_attr (A_ALTCHARSET, CYAN, BLACK));
	for (i = 0; i < 77; i++)
		mvwaddch (IdentWin, 2, i, ACS_HLINE);
	mvwaddch (IdentWin, 2, 0, ACS_LTEE);
	mvwaddch (IdentWin, 2, 77, ACS_RTEE);

	wattrset (MainWin, make_attr (A_NORMAL, WHITE, BLUE));
	commandline (clbuf, helpstr, "ESC=Quit", "RETURN=Accept",
		updnstr, "^P=Print", NULL);
	mvwprintw (MainWin, KEY_LINE, 0, clbuf);
	wattroff (MainWin, make_attr (A_NORMAL, WHITE, BLUE));

	show_panel (IdentPanel);
	update_panels ();
	doupdate ();
	wrefresh (MainWin);
	wrefresh (HeadWin);
	wrefresh (IdentWin);

	while ((option != 'Q') && (option != 'q') && (option != ESC))
	{
		selected_conc = 0;
		adpt_line = 0;
		em_modem = 0;

		for (i = 0; i < MAX_ADPT; ++i)
		{
			adapt_info[i].emm_adpt = 0;
			memset (&adapt_info[i].emm_conc [0], 0x00,
			 MAX_ADPTCONCS);
			memset (&adapt_info[i].nports_conc [0] [0], 0x00,
			 MAX_ADPTCONCS * 4);
			memset (&adapt_info[i].port_addr [0], 0x00,
			 MAX_ADPTCONCS * sizeof(short));
			adapt_info[i].line1conc = 0;
			adapt_info[i].line2conc = 0;
		}

		if (pcxxfd >= 0)
		{
			if (ioctl (pcxxfd, DIGI_GETDD, &ddi) != 0)
				num_boards1 = 0;
			else
				num_boards1 = ddi.dinfo_nboards;
		}

		if (epcafd >= 0)
		{
			num_boards2 = 0; /* zero it out from previous rounds */
			if (ioctl (epcafd, DIGI_GETDD, &ddi) != 0)
				num_boards2 = 0;
			else 	
				num_boards2 = ddi.dinfo_nboards;
		}
#ifndef MRGDRV
		if (pcxrfd >= 0)
		{
			num_boards3 = 0; /* zero it out from previous rounds */
			if (ioctl (pcxrfd, DIGI_GETDD, &ddi) != 0)
				num_boards3 = 0;
			else
				num_boards3 = ddi.dinfo_nboards;
		}

		if (aspxfd >= 0)
		{
			if (ioctl (aspxfd, DIGI_GETDD, &ddi) != 0)
				num_boards4 = 0;
			else
				num_boards4 = ddi.dinfo_nboards;
		}
#endif
#ifdef DXB
		if (dxbfd >= 0)
		{
			if (ioctl (dxbfd, DIGI_GETDD, &ddi) != 0)
				num_boards5 = 0;
			else
				num_boards5 = ddi.dinfo_nboards;
		}
		total_boards = num_boards1 + num_boards2 + num_boards3 + num_boards4 + num_boards5;
#else
		total_boards = num_boards1 + num_boards2 + num_boards3 + num_boards4;
#endif
		if(debug) {
			fprintf(dfp, "total %d\tnb1 %d\tnb2 %d\tnb3 %d\tnb4 %d\tnb5 %d\n",
				total_boards, num_boards1, num_boards2, num_boards3, 
				num_boards4, num_boards5);
		}
		if (total_boards == 0)
		{
			EndCurses (-6);
			/* FIXME: This code will not be executed as 
			   EndCurses() calls exit(). */
			fprintf (stderr, "The drivers installed DO NOT suppport DPA.\n");
			exit (-2);
		}

		for (i = 0; i < total_boards; i++)
		{
			/*
			 * If boards are found on Xall driver then
			 * get the info for them from /dev/pcxxdl (pcxxfd)
			 * else if boards are found on EPC-C/X-Xem
			 * driver then get the info for them from
			 * /dev/epcadl (epcafd).
			 */
			if ((num_boards1) && (i < num_boards1))
			{
				di.info_bdnum = i;
				afd = pcxxfd;
			}
			else if ((num_boards2) && (i - num_boards1 < num_boards2))
			{
				di.info_bdnum = i - num_boards1;
				afd = epcafd;
			}
#ifndef MRGDRV
			else if ((num_boards3) && (i - (num_boards1 + num_boards2) < num_boards3))
			{
				di.info_bdnum = i - (num_boards1 + num_boards2);
				if(!strcmp("unix", os_info.sysname) &&
				   !strcmp("3.2", os_info.release) &&
				   !strcmp("2", os_info.version))
			/* if we're running Interactive Unix SVR3 we now */
			/* need to make sure that we're not looking at the */
			/* same boards that epcafd looked at */
					di.info_bdnum += num_boards2;
				afd = pcxrfd;
			}
			else if ((num_boards4) && (i - (num_boards1 + num_boards2 + num_boards3) < num_boards4))
			{
				di.info_bdnum = i - (num_boards1 + num_boards2 + num_boards3);
				afd = aspxfd;
			}
#endif
#ifdef DXB
			else if ((num_boards5) && (i - (num_boards1 + num_boards2 + num_boards3 + num_boards4) < num_boards5))
			{
				di.info_bdnum = i - (num_boards1 + num_boards2 + num_boards3 + num_boards4);
				afd = dxbfd;
			} 
#endif


			{
#if defined(SOLARIS)

  #if OLD_SOLARIS
			if (sol_ioctl (afd, DIGI_GETBD, &di, sizeof(di)) != 0)
  #else
			if (ioctl (afd, DIGI_GETBD, &di, sizeof(di)) != 0)
  #endif

#else
			if (ioctl (afd, DIGI_GETBD, &di) != 0)
#endif
			{
				if (debug)
					fprintf (dfp, "DIGI_GETBD ioctl failed!\n"); 

				continue; 
			}
			}

			if (debug)
				fprintf (dfp, "DIGI_GETBD bdtype = %o\n", di.info_bdtype); 

#if defined(LINUX)
                        /* 
			 * Under the Linux FEP5 driver, we allow DPA to open
			 * the download device even though the boards may
			 * not be initialized yet. So, lets give the card
			 * a "Default" name, so that when DIGI_KME tries
			 * to get the board type (and of course fails),
			 * we don't blow up.
			 */
			strcpy(print_type, "Uninitialized");
#endif
			/* Get board type */
			if ((di.info_bdtype & FAMILY) == T_PCXX)
			{
				/* Get subtype type */
				if ((di.info_bdtype & BUSTYPE) == T_MCBUS)
				{
					if ((di.info_bdtype & SUBTYPE) == T_PCXE)	/* 8K */
#ifdef MRGDRV
						Strcpy (print_type, "AccelePort XE");
#else
						Strcpy (print_type, "XE");
#endif
					else
#ifdef MRGDRV
						Strcpy (print_type, "AccelePort X?");
#else
						Strcpy (print_type, "X?");
#endif
				}
				else
				{
					if ((di.info_bdtype & SUBTYPE) == T_PCXE)
#ifdef MRGDRV
						Strcpy (print_type, "AccelePort XE");
#else
						Strcpy (print_type, "XE");
#endif
					else
#ifdef MRGDRV
						Strcpy (print_type, "AccelePort X?");
#else
						Strcpy (print_type, "X?");
#endif
				}
				adapt_info[i].modem_table = 2;
				adapt_info[i].bdtype = PCXX_BD;
			}
			else if ((di.info_bdtype & FAMILY) == T_CX)
			{
#ifdef MRGDRV
				Strcpy (print_type, "AccelePort C/X ");
#else
				Strcpy (print_type, "C/X ");
#endif
				adapt_info[i].bdtype = CX_BD;
				adapt_info[i].modem_table = 1;
				get_config(i, T_CX);
			}
			else if ((di.info_bdtype & FAMILY) == T_EPC)
			{
#ifdef MRGDRV
				Strcpy (print_type, "AccelePort EPC/X ");
#else
				Strcpy (print_type, "EPC/X ");
#endif
				adapt_info[i].bdtype = EPC_BD;
				adapt_info[i].modem_table = 1;
				get_config(i, T_EPC);
			}
			else if ((di.info_bdtype & FAMILY) == T_PCLITE)
			{
				if ((di.info_bdtype & SUBTYPE) == T_PCXR)
#ifdef MRGDRV
					{
						/* 
						 * Check if this board supports 920K
						 */
			            rw.rw_board = di.info_bdnum;
							rw.rw_conc = 0;
						rw.rw_req = RW_READ;
						rw.rw_addr = 0xc24;     /* Type of uart on the board */
						rw.rw_size = 1;
		 
						if (ioctl (epcafd, DIGI_KME, &rw) != 0)
							Strcat (print_type, " ");
						else if (rw.rw_data[0] == 1)
							sprintf (print_type, "AccelePort Xr 920 ");
						else
							sprintf (print_type, "AccelePort Xr ");
					}
#else
					sprintf (print_type, "Xr ");
#endif
				else
#ifdef MRGDRV
					Strcpy (print_type, "AccelePort Xem ");
#else
					Strcpy (print_type, "Xem ");
#endif
				adapt_info[i].bdtype = XEM_BD;
				adapt_info[i].modem_table = 1;
			}

			else if ((di.info_bdtype & FAMILY) == T_AVXX)
			{
				/*
				 * It's FEP looks like EPC, but the HW looks PCXX
				 */
				Strcpy (print_type, "Avanstar");
				adapt_info[i].bdtype = AVXX_BD;
				adapt_info[i].modem_table = 1;
				adapt_info[i].nmodules = 1;
				adapt_info[i].line1conc = 1;
				adapt_info[i].nports = di.info_nports;
				Strcpy (adapt_info[i].modtype[i], "    ");
				adapt_info[i].modtype[i][4] = '\0';
			}
#ifdef DXB
			else if ((di.info_bdtype & FAMILY) == T_DXB)
			{
				/* Get subtype type */
				if ((di.info_bdtype & SUBTYPE) == T_HERC)	
					Strcpy (print_type, "AccelePort Xp ");
				else if ((di.info_bdtype & SUBTYPE) == T_CHA)	
					Strcpy (print_type, "AccelePort RAS ");
				else if (((di.info_bdtype & SUBTYPE) == T_HOU) ||
						  (di.info_bdtype & SUBTYPE) == T_LON) 
					Strcpy (print_type, "DataFire RAS ");
				else
					Strcpy (print_type, "T_DXB:UNKNOWN ");

				adapt_info[i].modem_table = 2;
				adapt_info[i].bdtype = DXB_BD;
			}
#endif

			else
			{
				Strcpy (print_type, "Unknown");
				adapt_info[i].bdtype = UNKN_BD;
			}

			/* Get Bus type */

			if ((di.info_bdtype & BUSTYPE) == T_ISABUS) {
				if (adapt_info[i].bdtype != UNKN_BD)
					Strcat (print_type, "(ISA)");
			}
			else if ((di.info_bdtype & BUSTYPE) == T_PCIBUS)
				Strcat (print_type, "(PCI)");
			else if ((di.info_bdtype & BUSTYPE) == T_MCBUS)
				Strcat (print_type, "(MC)");
			else if ((di.info_bdtype & BUSTYPE) == T_EISABUS)
				Strcat (print_type, "(EISA)");
#if SPARC
			else if ((di.info_bdtype & BUSTYPE) == T_SBUS)
				Strcat (print_type, "(SBUS)");
#endif
			else
				Strcpy (print_type, "UNKNOWN");

			if (di.info_bdstate == BD_RUNNING)
				Strcpy (bd_state, "OK");
#ifdef UW7
			else if (di.info_bdstate & 0x000000ff == BRD_RUNNING)
				Strcpy (bd_state, "OK");
#endif
			else if ((di.info_bdstate & BD_REASON) == BD_NOTFOUND)
				Strcpy (bd_state, "NOT FOUND");
			else if ((di.info_bdstate & BD_REASON) == BD_NOIOPORT)
				Strcpy (bd_state, "  NO IO  ");
			else if ((di.info_bdstate & BD_REASON) == BD_NOMEM)
				Strcpy (bd_state, "NO MEMORY");
			else if ((di.info_bdstate & BD_REASON) == BD_NOBIOS)
				Strcpy (bd_state, " NO BIOS ");
			else if ((di.info_bdstate & BD_REASON) == BD_NOFEP)
				Strcpy (bd_state, "NO FEP/OS");
			else if ((di.info_bdstate & BD_REASON) == BD_FAILED)
				Strcpy (bd_state, "HD/W FAIL");
			else
				Strcpy (bd_state, " UNKNOWN ");

			/* 
			 * On the Xem board the fep will zero out memory
			 * if the bios reports 0 ports physically found.
			 * Therefore I put this check here so that this
			 * condition is reported to the user. This is only
			 * valid for the Xem.
			 */
			if ((di.info_bdtype & FAMILY) == T_PCLITE &&
				!((di.info_bdtype & SUBTYPE) == T_PCXR))
			{
				/* 
				 * If we're using adapter file descriptor 
				 * 2 (/dev/epcadl) then subtract out the 
				 * number of boards from pcxxfd (/dev/pcxxdl).
				 */
				rw.rw_board = i - num_boards1;
				rw.rw_conc = 0;
				rw.rw_req = RW_READ;
				rw.rw_addr = 0xc02;		/* NCHAN */
				rw.rw_size = 1;

				if (ioctl (epcafd, DIGI_KME, &rw) != 0)
					Strcpy (bd_state, " FEP FAIL");
				else if (rw.rw_data[0] == 0)
					Strcpy (bd_state, " NO PORTS");

				/* Set things to null */
				adapt_info[i].nmodules = 0;
				Strcpy (adapt_info[i].modtype[0], "    ");
				Strcpy (adapt_info[i].modtype[1], "    ");
				Strcpy (adapt_info[i].modtype[2], "    ");
				Strcpy (adapt_info[i].modtype[3], "    ");

				/* Get the module types (mid's). 
				 * 0x1ac is the start of four bytes that identifies
				 * the module id's. 0xff is a non-exist module.
				 */
				rw.rw_addr = 0x1ac;
				rw.rw_size = 4;
				rw.rw_data[0] = '\0';
				rw.rw_data[1] = '\0';
				rw.rw_data[2] = '\0';
				rw.rw_data[3] = '\0';

				if (ioctl (afd, DIGI_KME, &rw) != 0)
				{
					adapt_info[i].nmodules = 0;
					Strcpy (adapt_info[i].modtype[0], "BAD ");
					Strcpy (adapt_info[i].modtype[1], "BAD ");
					Strcpy (adapt_info[i].modtype[2], "BAD ");
					Strcpy (adapt_info[i].modtype[3], "BAD ");
				}
				else
				{
					for (k = 0; k < 4; k++)
					{
						if (rw.rw_data[k] == 0xff)
						{
							Strcpy (adapt_info[i].modtype[k], "0xff");
						}
						else if (((rw.rw_data[k] >> 2) == MID_4UART_RAM) ||
						 ((rw.rw_data[k] >> 2) == MID_4UART_ROM))
						{
							Strcpy (adapt_info[i].modtype[k], "M4em");
							adapt_info[i].nmodules++;
							adapt_info[i].line1conc =
							 adapt_info[i].nmodules;
							adapt_info[i].nports_conc[k] [0] = 4;
							adapt_info[i].emm_conc [k] = EMM_XEM;
							adapt_info[i].emm_adpt = 1;
							em_modem = 1;
						}
						else if (((rw.rw_data[k] >> 2) == MID_8UART_RAM) ||
						 ((rw.rw_data[k] >> 2) == MID_8UART_ROM))
						{
							Strcpy (adapt_info[i].modtype[k], "M8em");
							adapt_info[i].nmodules++;
							adapt_info[i].line1conc =
							 adapt_info[i].nmodules;
							adapt_info[i].nports_conc[k] [0] = 8;
							adapt_info[i].emm_conc [k] = EMM_XEM;
							adapt_info[i].emm_adpt = 1;
							em_modem = 1;
						}
						else if (((rw.rw_data[k] >> 2) == MID_UART) || 
							((rw.rw_data[k] >> 2) == 0x09))
						{
							Strcpy (adapt_info[i].modtype[k], "16em");
							adapt_info[i].nmodules++;
							adapt_info[i].line1conc =
							 adapt_info[i].nmodules;
							adapt_info[i].nports_conc[k] [0] = 16;
						}
						else if ((rw.rw_data[k] >> 2) == MID_SUART)
						{
							Strcpy (adapt_info[i].modtype[k], "16em");
							adapt_info[i].nmodules++;
							adapt_info[i].line1conc =
							 adapt_info[i].nmodules;
							adapt_info[i].nports_conc[k] [0] = 16;
						}
						else if ((rw.rw_data[k] >> 2) == MID_8UART1P)
						{
							Strcpy (adapt_info[i].modtype[k], "8emp");
							adapt_info[i].nmodules++;
							adapt_info[i].line1conc =
							 adapt_info[i].nmodules;
							adapt_info[i].nports_conc[k] [0] = 9;
						}
						else if ((rw.rw_data[k] >> 2) == MID_8UART)
						{
							Strcpy (adapt_info[i].modtype[k], "8em ");
							adapt_info[i].nmodules++;
							adapt_info[i].line1conc =
							 adapt_info[i].nmodules;
							adapt_info[i].nports_conc[k] [0] = 8;
						}
						else
							Strcpy (adapt_info[i].modtype[k], "????");

						/*
						*  Calculate starting port address
						*  for this module
						*/

						if (k != 0)
							adapt_info[i].port_addr[k] =
							 adapt_info[i].port_addr[k - 1] +
							 adapt_info[i].nports_conc[k - 1] [0];

					}			   /* End For Loop */
				}				   /* End If */
			}					   /* End If */


			if (i == slot)
			{
				wattrset (IdentWin, make_attr (A_STANDOUT, WHITE, BLUE));
				mvwprintw (IdentWin, 3 + i, 1,
"                                                                            ");
			}
			else
			{
				wattrset (IdentWin, make_attr (A_NORMAL, GREEN, BLACK));
				mvwprintw (IdentWin, 3 + i, 1,
"                                                                            ");
			}

			mvwprintw (IdentWin, 3 + i, 3, "%d", i + 1);
			mvwprintw (IdentWin, 3 + i, 5, "%s", print_type);

			/*
			 * if not "OK" change to black on red for message
			 */
			if (strncmp (bd_state, "OK", 2))
			{
				wattrset (IdentWin, make_attr (A_STANDOUT, BLACK, RED));
/*xxxxx*/
				mvwprintw (IdentWin, 3 + i, 30, "%s", bd_state);
				wattroff (IdentWin, make_attr (A_STANDOUT, BLACK, RED));
			}
			else
			{
				wattrset (IdentWin, make_attr (A_NORMAL, GREEN, BLACK));
				mvwprintw (IdentWin, 3 + i, 33, "%s", bd_state);
				wattroff (IdentWin, make_attr (A_NORMAL, GREEN, BLACK));
			}

			if (i == slot)
				wattrset (IdentWin, make_attr (A_NORMAL, WHITE, BLUE));
			else
				wattrset (IdentWin, make_attr (A_NORMAL, GREEN, BLACK));

			mvwprintw (IdentWin, 3 + i, 34+7, "%5X", di.info_ioport);
			mvwprintw (IdentWin, 3 + i, 47+4, "%5X", di.info_physaddr);
			/*
			 * 2 Meg should be the max mem size, if more than this it is
			 * probably wrong, so display 0
			 * (NOTE: Adapters running under DXB can have up to 8 Meg.)
			 */
#ifdef DXB
			if (((di.info_physsize / 1024) > 2048) &&
				((di.info_bdtype & FAMILY) != T_DXB))
#else
			if (((di.info_physsize / 1024) > 2048))
#endif
				mvwprintw (IdentWin, 3 + i, 58+5, "%3dK", 0);
			else
				mvwprintw (IdentWin, 3 + i, 58+5, "%3dK", di.info_physsize/1024);
			mvwprintw (IdentWin, 3 + i, 70+1, "%3d", di.info_nports);
			wattrset (IdentWin, make_attr (A_NORMAL, WHITE, BLACK));

			/* Save the values for later use */
			sprintf (adapt_info[i].print_type, "%s", print_type);
			sprintf (adapt_info[i].bd_state, "%s", bd_state);
			adapt_info[i].ioport = di.info_ioport;
			adapt_info[i].physaddr = di.info_physaddr;
			adapt_info[i].physsize = di.info_physsize;
			adapt_info[i].nports = di.info_nports;
		}

		if (first && debug)
		{
			fprintf (dfp, "***** Debug info from print_identify *****\n");
			fprintf (dfp, "num_boards1 (/dev/pcxxdl): %d\n", num_boards1);
			fprintf (dfp, "num_boards2 ("EPCA_DLDEV"): %d\n", num_boards2);
			if (!ISSVR3)
				fprintf (dfp, "num_boards3 (/dev/pcxrdl): %d\n", num_boards3);
			fprintf (dfp, "num_boards4 (/dev/aspxdl): %d\n", num_boards4);
#ifdef DXB
			fprintf (dfp, "num_boards5 ("DXB_DLDEV"): %d\n", num_boards5);
#endif
			/*
			 * Board info for all boards found
			 */
			for (i = 0; i < total_boards; i++)
			{
				for (k = 0; k < 4; k++)
				{
					fprintf (dfp, "adapt_info[%d].modtype[%d]: %s\n",
						i, k, adapt_info[i].modtype[k]);
					fprintf (dfp, "adapt_info[%d].nmodules: %d\n",
						i, adapt_info[i].nmodules);
				}

				fprintf (dfp, "adapt_info[%d].print_type: %s\n", i, 
					adapt_info[i].print_type);
				fprintf (dfp, "adapt_info[%d].bd_state: %s\n", i,
					adapt_info[i].bd_state);
				fprintf (dfp, "adapt_info[%d].ioport: %X\n", i,
					adapt_info[i].ioport);
				fprintf (dfp, "adapt_info[%d].physaddr: %X\n", i,
					adapt_info[i].physaddr);
				fprintf (dfp, "adapt_info[%d].physsize: %dK\n", i,
					adapt_info[i].physsize / 1024);
				fprintf (dfp, "adapt_info[%d].nports: %d\n", i,
					adapt_info[i].nports);
			}
			fflush (dfp);
		}


		if (em_modem)
		{
			wattrset (MainWin, make_attr (A_NORMAL, WHITE, BLUE));

			commandline (clbuf, helpstr, "ESC=Quit",
			 "RETURN=Accept", "M=LoadModem", updnstr,
			 "^P=Print", NULL);

			mvwprintw (MainWin, KEY_LINE, 0, clbuf);
			wattroff (MainWin, make_attr (A_NORMAL, WHITE, BLUE));
			wrefresh (MainWin);
		}
		else if (first)
			wrefresh (MainWin);
		
		first = FALSE;

		wrefresh (IdentWin);

		change_term (0, TIMEOUT);

		switch (option = getch ())
		{
		case EOF:
			break;
		case ctrl ('L'):
			refresh_screen ();
			break;
#ifdef KEY_UP
		case KEY_UP:
#endif
		case 'k':
			if (slot)
				slot--;
			else
				slot = total_boards - 1;
			break;
#ifdef KEY_DOWN
		case KEY_DOWN:
#endif
		case 'j':
			if (slot < total_boards - 1)
				slot++;
			else
				slot = 0;
			break;
		case 'Q':
		case 'q':
		case ESC:
			hide_panel (IdentPanel);
			break;
		case RETURN:
			if (strncmp (adapt_info[slot].bd_state, "OK", 2))
			{
				beep ();
				mvwprintw (IdentWin, 16, 55, "Adapter Failure.");
				wrefresh (IdentWin);
				sleep (1);
				mvwprintw (IdentWin, 16, 55, "                ");
				wrefresh (IdentWin);
			}
			else if (adapt_info[slot].bdtype == PCXX_BD)
			{
				afd = pcxxfd;		   /* pcxxdl device */
				hide_panel (IdentPanel);
				print_channel ();
				show_panel (IdentPanel);
                                update_panels();
                                doupdate();
			}
#ifdef DXB
			else if (adapt_info[slot].bdtype == DXB_BD)
			{
				afd = dxbfd;		   /* dxbdl device */
				hide_panel (IdentPanel);
				save_channel = 0xff;
				print_channel ();
				show_panel (IdentPanel);
				update_panels ();
				doupdate ();
			}
#endif
			else if (adapt_info[slot].bdtype == XEM_BD 
				|| adapt_info[slot].bdtype == AVXX_BD)
			{
				adapt_info[slot].line1conc = adapt_info[slot].nmodules;
				adapt_info[slot].line2conc = 0;
				a_line = 1;
				hide_panel (IdentPanel);

				/*
				 * Kludge so that a PCXR board will not go to the
				 * module screen, even though it is classified as a
				 * XEM_BD...         TDJ  05.26.94
				 */
				if (strstr (adapt_info[slot].print_type, "Xr "))
				{
					/*
					 * Digi Xr runs under the epca driver
					 * in OSF/1.     GSP  12.01.94
					 */
#if OSF || MRGDRV
					afd = epcafd;
#else
					/*
					 * Digi Xr runs under the epca driver
					 * in SVR3
					 */
					if (ISSVR3)
						afd = epcafd;
					else
						afd = pcxrfd;
#endif
					print_channel ();
				}
				else if (strstr (adapt_info[slot].print_type, "Avanstar"))
				{
					afd = epcafd;
					print_channel ();
				}
				else if (strstr (adapt_info[slot].print_type, "SmartPort"))
				{
#if OSF || MRGDRV
					afd = epcafd;
#else
					afd = aspxfd;
#endif
					print_channel ();
				}
				else
				{
					afd = epcafd;	   /* epcadl device */
					print_Xemconf ();
				}

				show_panel (IdentPanel);
                                update_panels();
                                doupdate();

			}
			/* ONLY call print_adptconf if EPC or C/X */
			else
				/* the board is OK proceed to next screen */
			{
				afd = epcafd;		   /* epcadl device */
				hide_panel (IdentPanel);
				update_panels ();
				doupdate ();

				if (adapt_info[slot].bdtype == EPC_BD)
					print_adptconf (T_EPC);
				else if (adapt_info[slot].bdtype == CX_BD)
					print_adptconf (T_CX);

				show_panel (IdentPanel);
				update_panels ();
				doupdate ();
			}
			break;
#ifdef KEY_PRINT
		case KEY_PRINT:
#endif
		case ctrl ('P'):
			screen_save (IdentWin, logfile);
			touchwin (IdentWin);
			wrefresh (IdentWin);
			update_panels ();
			doupdate ();
			break;

#ifndef NO_MODEM_OPTS
		case 'm':
		case 'M':
			/*
			*  Load em Modem flash ROM selected, if
			*  no em Modems, invalid key
			*/

			if (em_modem)
				print_flashl (EM_SYS, 0);
			else
			{
				mvwprintw (IdentWin, 16, 60, "Invalid key");
				wrefresh (IdentWin);
				sleep (1);
				mvwprintw (IdentWin, 16, 60, "           ");
				wrefresh (IdentWin);
			}

			break;
#endif /* !NO_MODEM_OPTS */

		case KEY_F (1):		   /*  Help info  */
		case '?':
			info_screen ("dpa_info1", NULL);
			update_panels ();
			doupdate ();
			touchwin (IdentWin);
			wrefresh (IdentWin);
			break;
		default:
			mvwprintw (IdentWin, 16, 60, "Invalid key");
			wrefresh (IdentWin);
			sleep (1);
			mvwprintw (IdentWin, 16, 60, "           ");
			wrefresh (IdentWin);
			break;
		}						   /* End Case */

		if (option != EOF)
		{
			wattrset (MainWin, make_attr (A_NORMAL, WHITE, BLUE));

			if (em_modem)
				commandline (clbuf, helpstr, "ESC=Quit",
				 "RETURN=Accept", "M=LoadModem", updnstr,
				 "^P=Print", NULL);
			else
				commandline (clbuf, helpstr, "ESC=Quit",
				 "RETURN=Accept", updnstr, "^P=Print", NULL);
						
			mvwprintw (MainWin, KEY_LINE, 0, clbuf);
			wattroff (MainWin, make_attr (A_NORMAL, WHITE, BLUE));
			wrefresh (MainWin);
		}

	}							   /* End While Loop */
}



/**********************************************************************
*
*  Routine Name:	
*
*  Function:	
*
**********************************************************************/

void 
get_errors ()
{

	/* Sync-Link error structure */

	rw.rw_addr = 0xd40;
	rw.rw_size = 128;
	if (ioctl (afd, DIGI_KME, &rw) != 0)
		err_rec = -99999999;
	else
	{
		/* Taken from protocol.h fep file. */
		err_rec = GET_LE_INT(&rw.rw_data[8]);

		err_rec1 = GET_LE_INT(&rw.rw_data[12]);

		err_rec2 = GET_LE_INT(&rw.rw_data[16]);

		err_rec3 = GET_LE_INT(&rw.rw_data[20]);

		err_rec4 = GET_LE_INT(&rw.rw_data[24]);

		err_rec5 = GET_LE_INT(&rw.rw_data[28]);

		err_relay = GET_LE_INT(&rw.rw_data[40]);

		err_tbuf = GET_LE_INT(&rw.rw_data[44]);

		err_uframe = GET_LE_INT(&rw.rw_data[60]);

		err_fifo = GET_LE_INT(&rw.rw_data[72]);

		err_orun = GET_LE_INT(&rw.rw_data[80]);

		err_inc = GET_LE_INT(&rw.rw_data[84]);

		err_crc = GET_LE_INT(&rw.rw_data[88]);

		err_abstat = GET_LE_INT(&rw.rw_data[96]);

		err_abrec = GET_LE_INT(&rw.rw_data[100]);

		err_urun = GET_LE_INT(&rw.rw_data[104]);

		err_check = GET_LE_INT(&rw.rw_data[108]);

		err_ritem = GET_LE_INT(&rw.rw_data[112]);

		err_addr = GET_LE_INT(&rw.rw_data[116]);

		err_mtype = GET_LE_INT(&rw.rw_data[120]);

		err_msize = GET_LE_INT(&rw.rw_data[124]);

		rw.rw_addr = 0xde8;
		rw.rw_size = 12;
		if (ioctl (afd, DIGI_KME, &rw) != 0)
			err_rec = -99999999;
		else
		{
			err_host = GET_LE_INT(&rw.rw_data[0]);

			err_conc = GET_LE_INT(&rw.rw_data[4]);

			err_nack = GET_LE_INT(&rw.rw_data[8]);
		}
	}
}


#ifdef DXB

/**********************************************************************
*
*  Routine Name: get_dxb_chan()
*
*  Function: get port specific information for dxb controlled adapters.
*
**********************************************************************/

void 
get_dxb_chan (int req_channel, struct bs_struct *bsp)
{
	int mfd, i, error = 0;
	int board;
	int board_offset;
	get_serial_status_t status ;
	struct digi_stat dstat;
#ifdef UW7
	int j;
#endif
        int n;
	char device[80];

	/* NOTE: slot is a global. */
	board = slot - (num_boards1 + num_boards2 + num_boards3 + num_boards4);

#ifdef UW7
	//... for devices 0-7 /* 8 boards supported */

	for (i=0; i < 8; i++ ) {
		board_offset = board + i;
		for (j=1; j < 7; j++ ) {
			sprintf(device, "/dev/dxb%drasmon%d", board_offset,j);
			if (!access (device, F_OK))	   /* File Exists */
			{
				if ((mfd = open(device, O_RDWR | O_NONBLOCK) ) > 0) {
					i = 9; // to break out from the j loop
					break;
				}
			} 
		} // for i
	} // for j

#elif (defined(HPUX) || defined(SCO))
	for( n = FIRST_TRACE_CHAN; n < TRACE_CHAN_COUNT + FIRST_TRACE_CHAN;
	     n++ ) {
		/* try all devices */

		MK_DEV_NAME( device, DEVDIR, n, board );

		if( ( mfd=open( device, O_RDWR ) ) != -1 ) {
			break;
		}
	}

	if( n >= TRACE_CHAN_COUNT + FIRST_TRACE_CHAN ) {
		fprintf( stderr, "Cannot open device %s", device );
		exit( 1 );
	}

#else
        sprintf(device, DXB_MGMT0DEV, board);
        mfd = open(device, O_RDWR | O_NONBLOCK );
#endif

	status.channel = req_channel;

#ifdef UW7
	if (debug) {
		fprintf (dfp, "open(%s, board_offset=%d, channel=%d)\n",
			device, board_offset, status.channel);
	}
#endif

	error = 0;

	if (ioctl(mfd, GET_SERIAL_STATUS, &status) != 0) {
		error |= 1;
	}

	if (debug & GET_SERIAL_STATUS_DEBUG) {
			fprintf (dfp, "\t GET_SERIAL_STATUS channel =%d ,error=%d\n", channel, error);
			print_serial_status(&status.status);
	}
#ifdef UW7
	if (debug) {
		fprintf (dfp, "UW7: in_speed= %d, out_speed = %d \n", 
			status.status.in_speed, status.status.out_speed);
	}
#endif

	if (status.status.port_state == SERIAL_CLOSED)
		dxb_port_speed = 0;
	else
		dxb_port_speed = status.status.out_speed;
 
	dstat.info_brd = board;
	dstat.info_chan = req_channel;

	if (ioctl(afd, DIGI_GETSTAT, &dstat) != 0)
	{
		error |= 4;
	}
	if (debug && error)
	{
		fprintf (dfp, "ioctl failed, error = %d\n", error);
		fflush (dfp);
	} else {
		if (debug & DIGI_GETSTAT_DEBUG)
			print_digi_getstat(&dstat);
	}
#ifdef UW7
	if (debug) {
		fprintf (dfp, "UW7: close(mfd=%d)\n", mfd);
	}
#endif

	close(mfd);
	
	/*
	 * The first time this channel is displayed,
	 * make sure the tx/rx counts are initialized
	 * before using them to light up tx/rx display.
	 */
	if (save_channel == req_channel) {
		bsp->tx_tail = save_tx_head;
		bsp->rx_tail = save_rx_head;
	} else {
		save_channel = req_channel;
		bsp->tx_tail = (short)dstat.info_tx_data;
		bsp->rx_tail = (short)dstat.info_rx_data;
	}

	bsp->tx_head = save_tx_head = (short)dstat.info_tx_data;
	bsp->rx_head = save_rx_head = (short)dstat.info_rx_data;
	bsp->iflag = (short) dstat.info_iflag;
	bsp->oflag = (short) dstat.info_oflag;
	bsp->cflag = (short) dstat.info_cflag;

	bsp->m_stat = (short) dstat.info_mstat;

	bsp->hflow = (short) dstat.info_hflow;

#	if defined(HPUX)
	dxb_hpux_translate_flags(bsp, &dstat);
#	endif

	/*
	 * Modem Flags 
	 */
	XDM_RTS = 0x02;
	XDM_CD = 0x80;
	XDM_DSR = 0x20;
	XDM_CTS = 0x10;
	XDM_RI = 0x40;
	XDM_DTR = 0x01;


	XDM_IN_FLOW = 0;
	XDM_OUT_FLOW = 0;

	for (i=0;i<SERIAL_IN_FLOW_MAX;i++) {

		switch(i) {
		case SERIAL_IN_FLOW_XONXOFF_INDEX:
			if (status.status.in_flow_state[i] & SERIAL_FLOW_ASSERTED) {
				XDM_IN_FLOW++;
			}
			break;
		case SERIAL_IN_FLOW_RTS_INDEX:
			if (status.status.in_flow_state[i] & SERIAL_FLOW_ASSERTED) {
				XDM_IN_FLOW++;
			}
			break;
		case SERIAL_IN_FLOW_DTR_INDEX:
			if (status.status.in_flow_state[i] & SERIAL_FLOW_ASSERTED) {
				XDM_IN_FLOW++;
			}
			break;
		default:
			break;
		}
	}

	for (i=0; i< SERIAL_OUT_FLOW_MAX;i++) {
		switch(i) {
		case SERIAL_OUT_FLOW_XONXOFF_INDEX:
			if (status.status.out_flow_state[i] & 2) {
				XDM_OUT_FLOW |= 1;
			}
			break;
	
		case SERIAL_OUT_FLOW_CTS_INDEX:
			if (status.status.out_flow_state[i] & 2) {
				XDM_OUT_FLOW |= 2;
			}
			break;
	
		case SERIAL_OUT_FLOW_DSR_INDEX:
			if (status.status.out_flow_state[i] & 2) {
				XDM_OUT_FLOW |= 4;
			}
			break;
	
		default :
			break;
		}
	}

	if (debug)
	{
		fprintf (dfp, "***** Debug info from get_dxb_chan %d *****\n", req_channel);
		fprintf (dfp, "save_tx_head = %d\n", save_tx_head);
		fprintf (dfp, "save_rx_head = %d\n", save_rx_head);
		fprintf (dfp, "cflags=%x\n", dstat.info_cflag);
		fprintf (dfp, "oflags=%x\n", dstat.info_oflag);
		fprintf (dfp, "mstat=%x\n", dstat.info_mstat);
		fprintf (dfp, "XDM_OUT_FLOW=%x\n", XDM_OUT_FLOW);
		fprintf (dfp, "XDM_IN_FLOW=%x\n", XDM_IN_FLOW);
		fflush (dfp);
	}
}
#endif /* defined(DXB) */

/**********************************************************************
*
*  Routine Name:	
*
*  Function:	
*
**********************************************************************/

void 
get_channel (int req_channel, struct bs_struct *bsp)
{
	int i;

	/*
	 * If we're using adapter file descriptor 2 (/dev/epcadl) then
	 * subtract out the number of boards from pcxxfd (/dev/pcxxdl).
	 * Do the same thing for ad3 (/dev/pcxrdl).
	 */

	if (afd == epcafd)
		rw.rw_board = slot - num_boards1;
#ifndef MRGDRV
	else if (afd == pcxrfd)
		rw.rw_board = slot - (num_boards1 + num_boards2);
	else if (afd == aspxfd)
		rw.rw_board = slot - (num_boards1 + num_boards2 + num_boards3);
#endif
#ifdef DXB
	else if (afd == dxbfd) 
	{
		rw.rw_board = slot - (num_boards1 + num_boards2 + num_boards3 + num_boards4);

		get_dxb_chan (req_channel, bsp);
		return;
	}
#endif
	else
		rw.rw_board = slot;
	rw.rw_conc = 0;
	rw.rw_req = RW_READ;

	/* 
	 * If the adpater supports concentrators then let's show
	 * the user the number of packets that have been transmitted
	 * to concentrators and received from concentrators.
	 */
	if ((adapt_info[slot].bdtype == EPC_BD) ||
	    (adapt_info[slot].bdtype == CX_BD))
	{
		/* Sync-Link error structure */
		rw.rw_addr = 0xd40;
		rw.rw_size = 128;
		if (ioctl (afd, DIGI_KME, &rw) != 0)
		{
			host_transmit = -99999999;
			host_receive = -99999999;
		}
		else
		{
			/* Taken from protocol.h fep file. */
			/* Packets transmitted by host */
			host_trans_old = host_transmit;
			host_transmit = GET_LE_INT(&rw.rw_data[4]);

			/* Packets received by host */
			host_rec_old = host_receive;

			err_rec = GET_LE_INT(&rw.rw_data[8]);

			/* One packet / interrupt */
			host_receive = err_rec1 = GET_LE_INT(&rw.rw_data[12]);

			/* Two packets / interrupt */
			err_rec2 = GET_LE_INT(&rw.rw_data[16]);
			host_receive = host_receive + err_rec2;

			/* Three packets / interrupt */
			err_rec3 = GET_LE_INT(&rw.rw_data[20]);
			host_receive = host_receive + err_rec3;

			/* Four packets / interrupt */
			err_rec4 = GET_LE_INT(&rw.rw_data[24]);
			host_receive = host_receive + err_rec4;

			/* Five or more packets / interrupt */
			err_rec5 = GET_LE_INT(&rw.rw_data[28]);
			host_receive = host_receive + err_rec5;
		}
	}

	if (a_line == 1)
		rw.rw_addr = CHANBUF +
		 ((req_channel + adapt_info[slot].port_addr[conc]) * 128);
	else
		rw.rw_addr = CHANBUF + ((req_channel +
		 adapt_info[slot].port_addr[conc + adapt_info[slot].line1conc])
		 * 128);

	if (debug && 0)
	{
		fprintf (dfp, "***** Debug info from get_channel *****\n");
		fprintf (dfp, "channel: %d\tconc: %d\tline: %d\n", req_channel, 
			conc, a_line);
		fprintf (dfp, "rw.rw_board: %d\n", rw.rw_board);
		fprintf (dfp, "rw.rw_conc: %d\n", rw.rw_conc);
		fprintf (dfp, "rw.rw_req: %s\n", (rw.rw_req == RW_READ) ? 
			"RW_READ" : "RW_WRITE");
		fprintf (dfp, "rw.rw_addr: 0x%x\n", rw.rw_addr);
		fprintf (dfp, "rw.rw_size: %d\n", rw.rw_size);
		fflush (dfp);
	}

	rw.rw_size = 128;
	for (i = 0; i < 128; i++)
		rw.rw_data[i] = '\0';

	if (ioctl (afd, DIGI_KME, &rw) != 0)
	{
		if (a_line == 1)
			Strncpy (cons_tbl[conc], "vv", 2);
		else
			Strncpy (cons_tbl[conc + adapt_info[slot].line1conc], "ww",
			 2);
	}

	bsp->tx_seg = GET_LE_SHORT(&rw.rw_data[8]);
	bsp->tx_head = GET_LE_SHORT(&rw.rw_data[10]);
	bsp->tx_tail = GET_LE_SHORT(&rw.rw_data[12]);
	bsp->tx_max = GET_LE_SHORT(&rw.rw_data[14]);
	bsp->rx_seg = GET_LE_SHORT(&rw.rw_data[16]);
	bsp->rx_head = GET_LE_SHORT(&rw.rw_data[18]);
	bsp->rx_tail = GET_LE_SHORT(&rw.rw_data[20]);
	bsp->rx_max = GET_LE_SHORT(&rw.rw_data[22]);
	bsp->iflag = GET_LE_SHORT(&rw.rw_data[40]);
	bsp->oflag = GET_LE_SHORT(&rw.rw_data[42]);
	bsp->cflag = GET_LE_SHORT(&rw.rw_data[44]);
	bsp->ch_flags = GET_LE_SHORT(&rw.rw_data[80]);

	bsp->m_stat = rw.rw_data[84];
	bsp->hflow = rw.rw_data[95];

	/*
	 * Modem Flags
	 * If modem table is 1 then use EPC/X-C/X-Xem
	 * else use other values.
	 */
	if (adapt_info[slot].modem_table == 1)
	{
		XDM_RTS = 0x02;
		XDM_CD = 0x80;
		XDM_DSR = 0x20;
		XDM_CTS = 0x10;
		XDM_RI = 0x40;
		XDM_DTR = 0x01;
	}
	else
	{
		XDM_RTS = 0x02;
		XDM_CD = 0x08;
		XDM_DSR = 0x10;
		XDM_CTS = 0x20;
		XDM_RI = 0x40;
		XDM_DTR = 0x80;
	}
}



/**********************************************************************
*
*  Routine Name:	
*
*  Function:	
*
**********************************************************************/

void 
get_status (int bd)
{
	int i;

	/* 
	 * If we're using adapter file descriptor 2 (/dev/epcadl) then
	 * subtract out the number of boards from pcxxfd (/dev/pcxxdl).
	 * Do the same thing for ad3 (/dev/pcxrdl).
	 */
	if (afd == epcafd)
		rw.rw_board = bd - num_boards1;
#ifndef MRGDRV
	else if (afd == pcxrfd)
		rw.rw_board = bd - (num_boards1 + num_boards2);
	else if (afd == aspxfd)
		rw.rw_board = bd - (num_boards1 + num_boards2 + num_boards3);
#endif
#ifdef DXB
	else if (afd == dxbfd)
		rw.rw_board = bd - (num_boards1 + num_boards2 + num_boards3 + num_boards4);
#endif
	else
		rw.rw_board = bd;
	
	rw.rw_conc = 0;
	rw.rw_req = RW_READ;
	rw.rw_addr = 0xe10;
	rw.rw_size = 16;

	if (ioctl (afd, DIGI_KME, &rw) != 0)
	{
		for (i = 0; i < 16; i++)
			Strncpy (cons_tbl[i], "**", 2);
		return;
	}

	for (i = 0; i < adapt_info[bd].line1conc; i++)
	{
		if (rw.rw_data[i] == CS_OKAY)
			Strncpy (cons_tbl[i], "AC", 2);
		else
			Strncpy (cons_tbl[i], "DN", 2);
	}
	
	for (i = 0; i < adapt_info[bd].line2conc; i++)
	{
		if (rw.rw_data[i + 8] == CS_OKAY)
			Strncpy (cons_tbl[i + adapt_info[bd].line1conc], "AC", 2);
		else
			Strncpy (cons_tbl[i + adapt_info[bd].line1conc], "DN", 2);
	}
}



/**********************************************************************
*
*  Routine Name:	
*
*  Function:	
*
**********************************************************************/

void 
get_lbkey ()
{
	int option = '-';

	while ((option != ESC) && (option != 'Q') && (option != 'q'))
	{
		wattrset (MainWin, make_attr (A_STANDOUT|A_BLINK, WHITE, BLUE));
		commandline (clbuf, "Press ANY key to Continue", NULL);
		mvwprintw (MainWin, KEY_LINE, 0, clbuf);
		wattroff (MainWin, make_attr (A_STANDOUT|A_BLINK, WHITE, BLUE));
		wrefresh (MainWin);

		change_term (1, 0);

		switch (option = getch ())
		{
		case '-':
			break;
		default:
			option = ESC;
			break;
		}
		change_term (0, TIMEOUT);
	}
}

#ifdef DXB
int
get_adapter_info(int mgmt_fd, int board)
{
	int rtn_code;
	
	get_adapter_info_t info;


        if (ioctl(mgmt_fd, GET_ADAPTER_INFO, &info) != 0) {
                perror("GET_ADAPTER_INFO ioctl failed.") ;
        }

        switch (info.info.board_type)
        {
	    /* Hercules */
	case ADAPTER_AP2K2:
	case ADAPTER_AP2K4:
	case ADAPTER_AP2K8:
	case ADAPTER_AP2K16:

/*
 *  If one of the MPI defines exists, we assume the 32 port and all other
 *  MPI defines also exist
 */
#ifdef ADAPTER_AP2K4_MPI
	case ADAPTER_AP2K32:
	case ADAPTER_AP2K4_MPI:
	case ADAPTER_AP2K8_MPI:
	case ADAPTER_AP2K16_MPI:
#endif
		rtn_code = FALSE;
		break;
	default:
		rtn_code = TRUE;
		break;
	}

	return(rtn_code);
}

void
get_serial_test_mode(int mgmt_fd, getset_serial_channel_test_t *m, int board)
{

	memset(m, 0, sizeof(m));
	m->channel = channel;

	if(ioctl(mgmt_fd, GET_SERIAL_CHANNEL_MODE, m) != 0)
	{
	    	if (debug)
		{
		    fprintf (dfp, "GET_SERIAL_CHANNEL_MODE failed: %s (%d)\n",
			     strerror(errno), errno);
		    fflush (dfp);
		}
		perror("GET_SERIAL_CHANNEL_MODE");
	}

	if (debug)
	{
		fprintf (dfp, "***** get dxb loopback status *****\n");
		fprintf (dfp, "mode: %.8x\n", m->mode.mode);
		fprintf (dfp, "fail: %d\n", m->mode.fail);
		fprintf (dfp, "success: %d\n", m->mode.good);
		fprintf (dfp, "channel: %d\n", m->channel);
		fflush (dfp);
	}
	return;
}

void
set_serial_channel_mode(int mgmt_fd, int mode, int board)
{
	getset_serial_channel_test_t m;

	memset(&m, 0, sizeof(m));
	m.channel = channel;

	m.mode.mode = mode;

	if (debug)
	{
	    fprintf (dfp, "ioctl(SET_SERIAL_CHANNEL_MODE (channel=%d)\n", channel);
	}

	if(ioctl(mgmt_fd, SET_SERIAL_CHANNEL_MODE, &m) != 0)
	{
	    	if (debug)
		{
		    fprintf (dfp, "SET_SERIAL_CHANNEL_MODE failed: %s (%d)\n",
			     strerror(errno), errno);
		    fflush (dfp);
		}
		perror("SET_SERIAL_CHANNEL_MODE");
	}
	if (debug)
	{
		fprintf (dfp, "***** set dxb loopback *****\n");
		fprintf (dfp, "mode: %.8x\n", mode);
		fprintf (dfp, "fd: %d\n", mgmt_fd);
		fprintf (dfp, "channel: %d\n", channel);
		fflush (dfp);
		fprintf (dfp, "\tSOLARIS: set_serial_channel_mode(): return\n");
	}

	return;
}

/**********************************************************************
*
*  Routine Name: dxb_loop_back
*
*  Function: perform loopback test on Xp adapter port.
*
**********************************************************************/
void 
dxb_loop_back()
{
	int i = 0, j, option = EOF;
	int r = 3;

        int n;
	int mfd, board;
	unsigned long test_num = 0, test_fail = 0;
	char device[80];
	getset_serial_channel_test_t  curr_test;

	show_panel (LBPanel);
	update_panels ();
	doupdate ();
	
	board = slot - (num_boards1 + num_boards2 + num_boards3 + num_boards4);

#if UW7
	//... for devices 0-7 /* 8 boards supported */
	for (i=0; i < 8; i++ ) {
		for (j=1; j < 7; j++ ) {

			sprintf(device, "/dev/dxb%drasmon%d", i,j);
			if (!access (device, F_OK))	   /* File Exists */
			{
				if ((mfd = open(device, O_RDWR | O_NONBLOCK) ) > 0) {
					i = 1000;
					break;
				}
			} 
		}
	}

#elif (defined(HPUX) || defined(SCO))
        for( n = FIRST_TRACE_CHAN; n < TRACE_CHAN_COUNT + FIRST_TRACE_CHAN;
             n++ ) {
                /* try all devices */

                MK_DEV_NAME( device, DEVDIR, n, board );

                if( ( mfd=open( device, O_RDWR ) ) != -1 ) {
                        break;
                }
        }

        if( n >= TRACE_CHAN_COUNT + FIRST_TRACE_CHAN ) {
                fprintf(stderr, "Cannot open device %s", device );
                return;
        }

#else
			
	sprintf(device, DXB_MGMT5DEV, board);

	if ((mfd = open(device, O_RDONLY)) < 0)
	{
		fprintf (dfp, "\topen device - %s. board=%d FAILED.\n", device, board);
		fprintf(stderr, "Can not open management device %s.\n", device);
		return;
	}
#endif

	/*
	 * If this is a RAS adapter, loopback is not supported.
	 * Print an error message for the user.
	 */
	if (get_adapter_info(mfd, board)) {
		close(mfd);

		while (option == EOF)
		{
			r = 3;
	
			erase_win (LBWin);
			wattrset (LBWin, make_attr (A_BOLD, WHITE, BLUE));
			mvwprintw (LBWin, 1, 32, " Loop Back Test ");
	
			wattrset (LBWin, make_attr (A_ALTCHARSET, CYAN, BLACK));
			wmove (LBWin, 2, 1);
			for (i = 0; i < 77; i++)
				waddch (LBWin, ACS_HLINE);
	
			mvwaddch (LBWin, 2, 0, ACS_LTEE);
			mvwaddch (LBWin, 2, 77, ACS_RTEE);
	
			wattron (MainWin, make_attr (A_NORMAL, WHITE, BLUE));
			mvwprintw (MainWin, KEY_LINE, 0,
"      	                                                                         ");
			wattrset (LBWin, make_attr (A_NORMAL, WHITE, BLACK));
			wrefresh (LBWin);
			wrefresh (MainWin);
	
			mvwprintw (LBWin, r++, 2, "Loopback tests are not supported on this adapter type.");
			wrefresh (LBWin);
	
			wattrset (MainWin, make_attr (A_NORMAL, WHITE, BLUE));
			commandline (clbuf, "Press ANY key to return to the main menu.", NULL);
			mvwprintw (MainWin, KEY_LINE, 0, clbuf);
			wattroff (MainWin, make_attr (A_NORMAL, WHITE, BLUE));
			wrefresh (MainWin);
			change_term (0, 10);
	
			if ((option = getch ()) != EOF)
			{
				wattrset (MainWin, make_attr (A_NORMAL, WHITE, BLUE));
				commandline (clbuf, "Press ANY key to Halt the test", NULL);
				mvwprintw (MainWin, KEY_LINE, 0, clbuf);
				wattroff (MainWin, make_attr (A_NORMAL, WHITE, BLUE));
				wrefresh (MainWin);
			}
			wrefresh (LBWin);
		}
		return;
	}

	/*
	 * Loopback is supported on AccelePort Xp.
	 * Enter test mode and start automated loopback test.
	 */
	set_serial_channel_mode(mfd, TEST_MODE, board);
	set_serial_channel_mode(mfd, EXT_LOOP_AUTO, board);

	/*
	 * Loop waiting for user input to halt the test.
	 */
	while (option == EOF)
	{
		r = 3;

		erase_win (LBWin);
		wattrset (LBWin, make_attr (A_BOLD, WHITE, BLUE));
		mvwprintw (LBWin, 1, 32, " Loop Back Test ");

		wattrset (LBWin, make_attr (A_ALTCHARSET, CYAN, BLACK));
		wmove (LBWin, 2, 1);
		for (i = 0; i < 77; i++)
			waddch (LBWin, ACS_HLINE);

		mvwaddch (LBWin, 2, 0, ACS_LTEE);
		mvwaddch (LBWin, 2, 77, ACS_RTEE);

		wattron (MainWin, make_attr (A_NORMAL, WHITE, BLUE));
		mvwprintw (MainWin, KEY_LINE, 0,
"                                                                               ");
		wattrset (LBWin, make_attr (A_NORMAL, WHITE, BLACK));
		wrefresh (LBWin);
		wrefresh (MainWin);

		get_serial_test_mode(mfd, &curr_test, board);
		test_num = curr_test.mode.good;
		test_fail = curr_test.mode.fail;
		mvwprintw (LBWin, r++, 2, "successful = %d, failed = %d, Channel number = %2d",
				   test_num, test_fail, channel + 1);
		wrefresh (LBWin);

		wattrset (MainWin, make_attr (A_NORMAL, WHITE, BLUE));
		commandline (clbuf, "Press ANY key to Halt the test", NULL);
		mvwprintw (MainWin, KEY_LINE, 0, clbuf);
		wattroff (MainWin, make_attr (A_NORMAL, WHITE, BLUE));
		wrefresh (MainWin);
		change_term (0, 10);

		if ((option = getch ()) == EOF)
		{
/*
			mvwprintw (LBWin, 16, 22, "     No Response: Test will resume");
			wrefresh (LBWin);
*/
		}
		else
		{
			mvwprintw (LBWin, 16, 22, "     Test Halted by the user      ");
			wrefresh (LBWin);
			get_lbkey ();
			wrefresh (LBWin);
			wattrset (MainWin, make_attr (A_NORMAL, WHITE, BLUE));
			commandline (clbuf, "Press ANY key to Halt the test", NULL);
			mvwprintw (MainWin, KEY_LINE, 0, clbuf);
			wattroff (MainWin, make_attr (A_NORMAL, WHITE, BLUE));
			wrefresh (MainWin);
		}
		wrefresh (LBWin);

		if (debug)
		{
			fprintf (dfp, "***** dxb loopback test *****\n");
			fprintf (dfp, "device: %s\n", device);
			fprintf (dfp, "board: %d\n", board);
			fprintf (dfp, "channel: %d\n", channel);
			fflush (dfp);
		}
	} /* End Loop */

	/*
	 * Stop the test and exit test mode.
	 */
	set_serial_channel_mode(mfd, STOP_TEST, board);
	set_serial_channel_mode(mfd, TEST_EXIT, board);

	close(mfd);
	change_term (0, TIMEOUT);
	hide_panel (LBPanel);
	update_panels ();
	doupdate ();
}
#endif /* DXB */

/**********************************************************************
*
*  Routine Name:	
*
*  Function:	
*
**********************************************************************/

void 
loop_back ()
{
	char test_data[129], read_data[129], busy_data[48];
	int i = 0, option = EOF;
	int r = 3;
	unsigned long test_num = 0;
	unsigned short lrx_head;

	show_panel (LBPanel);
	update_panels ();
	doupdate ();

	while (option == EOF)
	{
		r = 3;

		erase_win (LBWin);
		wattrset (LBWin, make_attr (A_BOLD, WHITE, BLUE));
		mvwprintw (LBWin, 1, 32, " Loop Back Test ");

		wattrset (LBWin, make_attr (A_ALTCHARSET, CYAN, BLACK));
		wmove (LBWin, 2, 1);
		for (i = 0; i < 77; i++)
			waddch (LBWin, ACS_HLINE);

		mvwaddch (LBWin, 2, 0, ACS_LTEE);
		mvwaddch (LBWin, 2, 77, ACS_RTEE);

		wattron (MainWin, make_attr (A_NORMAL, WHITE, BLUE));
		mvwprintw (MainWin, KEY_LINE, 0,
"                                                                               ");
		wattrset (LBWin, make_attr (A_NORMAL, WHITE, BLACK));
		wrefresh (LBWin);
		wrefresh (MainWin);

		test_num++;
		for (i = 0; i < 128; i++)
			test_data[i] = 'A';
		test_data[128] = read_data[128] = '\0';

		mvwprintw (LBWin, r++, 2, "Test number = %d, Channel number = %2d",
				   test_num, channel + 1);
		mvwprintw (LBWin, r++, 2, "Loop Back: Verifying Channel.");
		wrefresh (LBWin);

		if (test_busy(&bs, channel, &busy_data[0]) == -1)
		{
			mvwprintw (LBWin, r++, 2, "***** Port is Busy  %s.", busy_data);
			wattrset (MainWin, make_attr (A_STANDOUT|A_BLINK, WHITE, BLUE));
			commandline (clbuf, "Press ANY key to Continue", NULL);
			mvwprintw (MainWin, KEY_LINE, 0, clbuf);
			wattroff (MainWin, make_attr (A_STANDOUT|A_BLINK, WHITE, BLUE));
			wrefresh (MainWin);
			wrefresh (LBWin);
			change_term (1, 0);
			wgetch (LBWin);
			change_term (0, TIMEOUT);
			hide_panel (LBPanel);
			update_panels ();
			doupdate ();
			return;
		}

		/*
		*  Save a copy of the receive head
		*/

		lrx_head = bs.rx_head;

		mvwprintw (LBWin, r++, 2, "Loop Back: Sending 128 bytes");
		wrefresh (LBWin);

		/* Send the Test Data */

		if ((i = test_send (&bs, channel, &test_data[0], 0x80)) != 0)
		{
			mvwprintw (LBWin, r++, 2,
			"***** Loop Back Test Failure=%d, Sending 128 Bytes", i);
			wrefresh (LBWin);
			get_lbkey ();
			wrefresh (LBWin);
			wrefresh (MainWin);
			hide_panel (LBPanel);
			update_panels ();
			doupdate ();
			return;
		}

		mvwprintw (LBWin, r++, 2, "Loop Back: 128 Bytes Sent");
		mvwprintw (LBWin, r++, 2, "Loop Back: Receiving 128 Bytes");
		wrefresh (LBWin);

		if ((i = test_recv (&bs, channel, lrx_head, &read_data[0],
		 0x80, 5)) != 0x80)
		{
			mvwprintw (LBWin, r++, 2,
				"***** Loop Back Failure=%d Receiving 128 bytes.", i);
			wrefresh (LBWin);
			get_lbkey ();
			wrefresh (MainWin);
			hide_panel (LBPanel);
			update_panels ();
			doupdate ();
			return;
		}

		mvwprintw (LBWin, r++, 2, "Loop Back: Verifying 128 bytes.");
		wrefresh (LBWin);

		if (Strncmp (test_data, read_data, 128))
		{
			mvwprintw (LBWin, r++, 2,
				"***** Loop Back Failure Verifying 128 Bytes.");
			mvwprintw (LBWin, r++, 2, "***** Data Incorrectly Transferred.");
			wrefresh (LBWin);
			get_lbkey ();
			wrefresh (LBWin);
			wrefresh (MainWin);
			hide_panel (LBPanel);
			update_panels ();
			doupdate ();

			if (debug)
			{
				fprintf (dfp, "***** loopback test *****\n");
				fprintf (dfp, "Data compare failure\n");
				fprintf (dfp, "test_data: %s\n", test_data);
				fprintf (dfp, "read_data: %s\n", read_data);
				fflush (dfp);
			}

			return;
		}
		else
		{
			mvwprintw (LBWin, r++, 2, "Loop Back Test Passed.");
			wrefresh (LBWin);
		}

		wattrset (MainWin, make_attr (A_NORMAL, WHITE, BLUE));
		commandline (clbuf, "Press ANY key to Halt the test", NULL);
		mvwprintw (MainWin, KEY_LINE, 0, clbuf);
		wattroff (MainWin, make_attr (A_NORMAL, WHITE, BLUE));
		wrefresh (MainWin);
		change_term (0, 10);

		if ((option = getch ()) == EOF)
		{
			mvwprintw (LBWin, 16, 22, "     No Response: Test will resume");
			wrefresh (LBWin);
		}
		else
		{
			mvwprintw (LBWin, 16, 22, "     Test Halted by the user      ");
			wrefresh (LBWin);
			get_lbkey ();
			wrefresh (LBWin);
			wattrset (MainWin, make_attr (A_NORMAL, WHITE, BLUE));
			commandline (clbuf, "Press ANY key to Halt the test", NULL);
			mvwprintw (MainWin, KEY_LINE, 0, clbuf);
			wattroff (MainWin, make_attr (A_NORMAL, WHITE, BLUE));
			wrefresh (MainWin);
		}
		wrefresh (LBWin);
	}							   /* End Loop */
	change_term (0, TIMEOUT);
	hide_panel (LBPanel);
	update_panels ();
	doupdate ();
}

#ifndef NO_MODEM_OPTS
/**********************************************************************
*
*  Routine Name:	loop_back_modem
*
*  Function:	
*  loop_back_modem() operates on em/Modem lines.  Unlike loop_back(),
*  which operates on a single line with a loop-back plug, an em/Modem
*  loop-back requires two em/Modem lines with an RJ11 phone cable
*  linking them.
*
**********************************************************************/

void 
loop_back_modem ()
{
	struct termio tio;
	char	test_data[129],
			read_data[129],
			*lbfn[2] = {"/tmp/digi_lbtmp0", "/tmp/digi_lbtmp1"};

	int	i = 0,
		j,
		k,
		option = EOF,
		first,
		mm_fail = 0,
		rel_conc;

	int r = 3;
	int cur_chan;
	unsigned long test_num = 0;
	char			chans_txt[80], temp[3] = {0x00, 0x00, 0x00};
	unsigned int	chans_int[48]; /* twice as long as needed */
	int				chans_cnt = 0;
	char	request_text[] = " = Second Channel";
	int		second_channel = -1, temp_channel;
	int		channels[2], mm_state[2], send_index, recv_index;
	int		lbfd[2] = {-1, -1};

	/* Modem response to AT commands will contain an OK */
	char	mm_resp[] = "OK";

	/* Modem response to Dial/Answer commands will contain CONNECT */
	char	mm_darsp[] = "CONNECT 38400";

	/* Set active configuration to factory settings */
	char	mm_factact[] = "\rAT&F\r";

	/* Surpress echo */
	char	mm_secho[] = "\rATE0\r";

	/* Initialize for loop back
	 AT		=> modem command
	 S64=10	=> set S register 64 to 10
	 W0		=> Only CONNECT and line speed reported
	 X3		=> Ignore dial tone
	 &D2	=> Hang up and go to command mode when DTR drops
	*/
	char	mm_loopi[] = "\rATS64=10X3&D2\r";

	/* loop back dial */
	char	mm_dial[] = "\rATD\r";

	/* loop back answer */
	char	mm_answ[] = "\rATA\r";

	/* put modem in command mode */
	char	mm_cmdm[] = "+++";

	/* Reset to default user profile */
	char	mm_resact[] = "\rATZ\r";

	show_panel (LBPanel);
	update_panels ();
	doupdate ();

	mm_state[0] = MM_INIT;
	mm_state[1] = MM_INIT;
	second_channel = -1;
	
	if (a_line == 1)
		rel_conc = conc;
	else
		rel_conc = conc + adapt_info[slot].line1conc;

	while (second_channel == -1)
	{
		r = 3;

		erase_win (LBWin);
		wattrset (LBWin, make_attr (A_BOLD, WHITE, BLUE));
		mvwprintw (LBWin, 1, 27, " Modem em Loop Back Test ");

		wattrset (LBWin, make_attr (A_ALTCHARSET, CYAN, BLACK));
		wmove (LBWin, 2, 1);
		for (i = 0; i < 77; i++)
			waddch (LBWin, ACS_HLINE);

		mvwaddch (LBWin, 2, 0, ACS_LTEE);
		mvwaddch (LBWin, 2, 77, ACS_RTEE);

		wattron (MainWin, make_attr (A_NORMAL, WHITE, BLUE));
		mvwprintw (MainWin, KEY_LINE, 0,
"                                                                               ");
		wattrset (LBWin, make_attr (A_NORMAL, WHITE, BLACK));

		mvwprintw (LBWin, r++, 2,
		 "Two lines required for Modem em Loop Back Test");
		mvwprintw (LBWin, r++, 2, "First line is: EBI %d, Port %d",
		 conc + 1, channel + 1);

		/*
		*  Calculate all of the legal second channels for loop back
		*/

		chans_txt[0] = 0x00;
		chans_cnt = 0;

		if (adapt_info[slot].emm_conc[rel_conc] & EMM_XEM)
		{
			for (k = 0, first = 1, cur_chan = 0;
			 k < (int)adapt_info[slot].nports_conc [rel_conc] [0];
			 ++k, ++cur_chan)
			{
				if (cur_chan == channel)
					continue;

				chans_int[chans_cnt] = cur_chan;
				++chans_cnt;

				if (first)
				{
					sprintf (temp, "%d", cur_chan + 1);
					strcat(chans_txt, temp);

					if (k + 1 == adapt_info[slot].nports_conc[rel_conc][0])
						break;

					if ((cur_chan + 1 == channel) &&
					(k + 2 == adapt_info[slot].nports_conc[rel_conc][0]))
						break;
					
					if (cur_chan + 1 == channel)
						strcat(chans_txt, ", ");
					else
					{
						strcat(chans_txt, " - ");
						first = 0;
					}
				} /* if (first) */
				else
				{

					if (k + 1 == adapt_info[slot].nports_conc[rel_conc][0])
					{
						sprintf (temp, "%d", cur_chan + 1);
						strcat(chans_txt, temp);
						break;
					}
					if (cur_chan + 1 == channel)
					{
						sprintf (temp, "%d", cur_chan + 1);
						strcat(chans_txt, temp);

						if (k + 2 == adapt_info[slot].nports_conc[rel_conc][0])
							break;
						else
						{
							strcat(chans_txt, ", ");
							first = 1;
						}
					}


				} /* else !first */
			} /* for */
		} /* if (adapt_info[slot].emm_conc[rel_conc] & EMM_XEM) */
		else
		{
			cur_chan = adapt_info[slot].nports_conc [rel_conc] [0];

			if (adapt_info[slot].emm_conc[rel_conc] & EMM_EPC1)
			{
				for (k = 0, first = 1;
				 k < (int)adapt_info[slot].nports_conc [rel_conc] [1];
				 ++k, ++cur_chan)
				{
					if (cur_chan == channel)
						continue;

					chans_int[chans_cnt] = cur_chan;
					++chans_cnt;

					if (first)
					{
						sprintf (temp, "%d", cur_chan + 1);
						strcat(chans_txt, temp);

						if (k + 1 == adapt_info[slot].nports_conc[rel_conc][1])
							break;

						if ((cur_chan + 1 == channel) &&
						(k + 2 == adapt_info[slot].nports_conc[rel_conc][1]))
							break;
					
						if (cur_chan + 1 == channel)
							strcat(chans_txt, ", ");
						else
						{
							strcat(chans_txt, " - ");
							first = 0;
						}
					} /* if (first) */
					else
					{

						if (k + 1 == adapt_info[slot].nports_conc[rel_conc][1])
						{
							sprintf (temp, "%d", cur_chan + 1);
							strcat(chans_txt, temp);
							break;
						}
						if (cur_chan + 1 == channel)
						{
							sprintf (temp, "%d", cur_chan + 1);
							strcat(chans_txt, temp);

							if (k + 2 == adapt_info[slot].nports_conc[rel_conc][1])
								break;
							else
							{
								strcat(chans_txt, ", ");
								first = 1;
							}
						}
					} /* else !first */
				} /* for */
			} /* if EMM_EPC1 */

			cur_chan = adapt_info[slot].nports_conc[rel_conc] [0] +
			 adapt_info[slot].nports_conc[rel_conc] [1];

			if (adapt_info[slot].emm_conc[rel_conc] & EMM_EPC2)
			{
				if (strlen(chans_txt))
					strcat(chans_txt, ", ");

				for (k = 0, first = 1;
				 k < (int)adapt_info[slot].nports_conc [rel_conc] [2];
				 ++k, ++cur_chan)
				{
					if (cur_chan == channel)
						continue;

					chans_int[chans_cnt] = cur_chan;
					++chans_cnt;

					if (first)
					{
						sprintf (temp, "%d", cur_chan + 1);
						strcat(chans_txt, temp);

						if (k + 1 == adapt_info[slot].nports_conc[rel_conc][2])
							break;

						if ((cur_chan + 1 == channel) &&
						(k + 2 == adapt_info[slot].nports_conc[rel_conc][2]))
							break;
					
						if (cur_chan + 1 == channel)
							strcat(chans_txt, ", ");
						else
						{
							strcat(chans_txt, " - ");
							first = 0;
						}
					} /* if (first) */
					else
					{

						if (k + 1 == adapt_info[slot].nports_conc[rel_conc][2])
						{
							sprintf (temp, "%d", cur_chan + 1);
							strcat(chans_txt, temp);
							break;
						}
						if (cur_chan + 1 == channel)
						{
							sprintf (temp, "%d", cur_chan + 1);
							strcat(chans_txt, temp);

							if (k + 2 == adapt_info[slot].nports_conc[rel_conc][2])
								break;
							else
							{
								strcat(chans_txt, ", ");
								first = 1;
							}
						}
					} /* else !first */
				} /* for */
			} /* if EMM_EPC2 */

			cur_chan = adapt_info[slot].nports_conc [rel_conc] [0] +
			 adapt_info[slot].nports_conc [rel_conc] [1] +
			 adapt_info[slot].nports_conc [rel_conc] [2];

			if (adapt_info[slot].emm_conc[rel_conc] & EMM_EPC3)
			{
				if (strlen(chans_txt))
					strcat(chans_txt, ", ");

				for (k = 0, first = 1;
				 k < (int)adapt_info[slot].nports_conc [rel_conc] [3];
				 ++k, ++cur_chan)
				{
					if (cur_chan == channel)
						continue;

					chans_int[chans_cnt] = cur_chan;
					++chans_cnt;

					if (first)
					{
						sprintf (temp, "%d", cur_chan + 1);
						strcat(chans_txt, temp);

						if (k + 1 == adapt_info[slot].nports_conc[rel_conc][3])
							break;

						if ((cur_chan + 1 == channel) &&
						(k + 2 == adapt_info[slot].nports_conc[rel_conc][3]))
							break;
					
						if (cur_chan + 1 == channel)
							strcat(chans_txt, ", ");
						else
						{
							strcat(chans_txt, " - ");
							first = 0;
						}
					} /* if (first) */
					else
					{

						if (k + 1 == adapt_info[slot].nports_conc[rel_conc][3])
						{
							sprintf (temp, "%d", cur_chan + 1);
							strcat(chans_txt, temp);
							break;
						}
						if (cur_chan + 1 == channel)
						{
							sprintf (temp, "%d", cur_chan + 1);
							strcat(chans_txt, temp);

							if (k + 2 == adapt_info[slot].nports_conc[rel_conc][3])
								break;
							else
							{
								strcat(chans_txt, ", ");
								first = 1;
							}
						}
					} /* else !first */
				} /* for */
			} /* if EMM_EPC3 */
		}

		mvwprintw (LBWin, r++, 2,
		 "Available lines on EBI %d: Ports %s",
		 conc + 1, chans_txt);
		mvwprintw (LBWin, r++, 2,
		 "Please enter your choice for second line");

		strcat(chans_txt, request_text);

		wattrset(MainWin, make_attr (A_NORMAL, WHITE, BLUE));

		commandline (clbuf, helpstr, "ESC=Quit", chans_txt,
		 "^P=Print", NULL);

		mvwprintw (MainWin, KEY_LINE, 0, clbuf);

		wattroff (MainWin, make_attr (A_NORMAL, WHITE, BLUE));
		wrefresh (LBWin);
		wrefresh (MainWin);

		/*
		*  Get the second channel from the user
		*/

		change_term(1, 0);	/* insure we don't timeout */

		switch (option = getch())
		{

		case EOF:

			break;

		case '0':
		case '1':
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9':

			temp[0] = option;
			temp[1] = 0x00;
			temp_channel = atoi(temp);

			switch (option = getch())
			{
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':

				temp[0] = option;
				temp[1] = 0x00;
				temp_channel = (temp_channel * 10) + atoi(temp);
				break;

			case RETURN:
				break;

			default:
				temp_channel = -1;
				break;

			}

			for (k = 0; k < chans_cnt; ++k)
				if (temp_channel - 1 == chans_int[k])
					break;

			if (k == chans_cnt)
			{
				mvwprintw (LBWin, 16, 55, "Invalid Port");
				wrefresh (LBWin);

				sleep (1);

				mvwprintw (LBWin, 16, 55, "               ");
				wrefresh (LBWin);
				break;
			}

			second_channel = temp_channel -1;
			break;

		case 'q':
		case 'Q':
		case ESC:

			hide_panel (LBPanel);
			erase_win (LBWin);
			update_panels ();
			doupdate ();

			return;

#ifdef KEY_PRINT
		case KEY_PRINT:
#endif
		case ctrl ('P'):

			screen_save (LBWin, logfile);
			touchwin (LBWin);
			wrefresh (LBWin);
			update_panels ();
			doupdate ();

			break;

		case KEY_F (1):
		case '?':

			info_screen ("dpa_info8", NULL);

			wattrset(MainWin, make_attr (A_NORMAL, WHITE, BLUE));

			commandline (clbuf, helpstr, "ESC=Quit", chans_txt,
			 "^P=Print", NULL);

			mvwprintw (MainWin, KEY_LINE, 0, clbuf);

			wattroff (MainWin, make_attr (A_NORMAL, WHITE, BLUE));

			break;

		} /* switch (option = getch()) */

	} /* while (second_channel == -1) */

	channels[0] = channel;
	channels[1] = second_channel;
	send_index = 0;
	recv_index =1;
	r = 3;

	erase_win (LBWin);
	wattrset (LBWin, make_attr (A_BOLD, WHITE, BLUE));
	mvwprintw (LBWin, 1, 27, " Modem em Loop Back Test ");

	wattrset (LBWin, make_attr (A_ALTCHARSET, CYAN, BLACK));
	wmove (LBWin, 2, 1);
	for (i = 0; i < 77; i++)
		waddch (LBWin, ACS_HLINE);

	mvwaddch (LBWin, 2, 0, ACS_LTEE);
	mvwaddch (LBWin, 2, 77, ACS_RTEE);

	wattron (MainWin, make_attr (A_NORMAL, WHITE, BLUE));
	mvwprintw (MainWin, KEY_LINE, 0,
"                                                                               ");
	wattrset (LBWin, make_attr (A_NORMAL, WHITE, BLACK));
	wrefresh (LBWin);
	wrefresh (MainWin);

	mvwprintw (LBWin, r++, 2,
	 "Ports %d and %d selected for Loop Back Testing",
	 channels[send_index] + 1, channels[recv_index] + 1);
	wrefresh (LBWin);

	if (debug)
	{
		fprintf (dfp, "***** modem loopback test *****\n");
		fprintf (dfp, "send chan: %d, recv chan: %d\n",
		 channels[send_index], channels[recv_index]);
		fprintf (dfp, "send dev: %s, recv dev: %s\n",
		 lbfn[send_index], lbfn[recv_index]);
		fflush (dfp);
	}

	mvwprintw (LBWin, r++, 2, "Loop Back: Opening Ports");
	wrefresh (LBWin);

	for (i = 0; i < 2; ++i)
	{

		/* calc abs concentrator number */

		k = conc;

		if (a_line != 1)
			k += adapt_info[slot].line1conc;

		remove (lbfn[i]); /* just in case */

		if (em_get_device (slot, k, channels[i], lbfn[i]) == -1)
		{
			mvwprintw (LBWin, r++, 2,
			"***** Create temp device failed for Port=%d",
			 channels[i] + 1);
			wrefresh (LBWin);

			mm_fail = 1;

			goto mm_done;
		}

		if ((lbfd[i] = open (lbfn[i], O_RDWR | O_EXCL)) == -1)
		{
			mvwprintw (LBWin, r++, 2,
			"***** Open failed for Port=%d", channels[i] + 1);
			wrefresh (LBWin);

			mm_fail = 1;

			goto mm_done;
		}

		if (!isatty(lbfd[i]))
		{
			mvwprintw (LBWin, r++, 2,
			"***** Can't find device name for Port=%d", channels[i] + 1);
			wrefresh (LBWin);

			mm_fail = 1;

			goto mm_done;
		}

		/*
		*  Set up the tty for our use
		*/

		if (ioctl (lbfd[i], TCGETA, &tio) == -1)
		{
			mvwprintw (LBWin, r++, 2,
			"***** Failed ioctl for Port=%d", channels[i] + 1);
			wrefresh (LBWin);

			mm_fail = 1;

			goto mm_done;
		}

		tio.c_iflag = BRKINT | IGNPAR | IXON | IXOFF;
		tio.c_lflag &= ~(ICANON | ISIG | ECHO | ECHOE | ECHOK);
		tio.c_cflag = B38400 | CS8 | CREAD | CLOCAL;
		tio.c_oflag = 0;
		tio.c_cc[VMIN] = 0;		/* get_em_resp requires this */
		tio.c_cc[VTIME] = 10;	/* get_em_resp requires this */

		if (ioctl (lbfd[i], TCSETA, &tio) == -1)
		{
			mvwprintw (LBWin, r++, 2,
			"***** Failed ioctl for Port=%d", channels[i] + 1);
			wrefresh (LBWin);

			mm_fail = 1;

			goto mm_done;
		}
	}

	/*
	*  Set up both modems for loop back operation
	*/

	mvwprintw (LBWin, r++, 2, "Loop Back: Set Modem Factory Options");
	wrefresh (LBWin);

	for (k = 0; k < 2; ++k)
	{
		mm_state[k] = MM_FACT;

		if ((i = write (lbfd[k], &mm_factact[0],
		 strlen(mm_factact))) != strlen(mm_factact))
		{
			mvwprintw (LBWin, r++, 2,
			 "***** Set Factory Defaults Write Failed To Port %d, rtn=%d",
			 channels[k] + 1, i);
			wrefresh (LBWin);

			mm_fail = 1;

			goto mm_done;
		}

		/*
		*  Response to this command is indeterminate, we can't
		*  know the modem response until after this command takes effect
		*/

		switch (get_em_resp(10, 1, 0x80, mm_resp, read_data, lbfd[k]))
		{
		default:
		case -1: /* sanity or I/O failure */

			mvwprintw (LBWin, r++, 2,
			 "***** Set Factory Defaults Read Failed on Port %d",
			 channels[k] + 1);
			wrefresh (LBWin);

			mm_fail = 1;

			goto mm_done;

		case 1: /* got no data */
		case 2: /* got data & bad compare */
			if (debug)
			{
				fprintf (dfp, "***** modem loopback test *****\n");
				fprintf (dfp, "Set factory defaults to chan=%d rsp=%s\n",
				 channels[k], read_data);
				fflush (dfp);
			}
		case 0: /* got data & good compare */
			break;
		}
	}


	/*
	*  Surpress echo
	*/

	mvwprintw (LBWin, r++, 2, "Loop Back: Set Surpress Echo");
	wrefresh (LBWin);

	for (k = 0; k < 2; ++k)
	{
		if ((i = write (lbfd[k], &mm_secho[0],
		 strlen(mm_secho))) != strlen(mm_secho))
		{
			mvwprintw (LBWin, r++, 2,
			 "***** Surpress Echo Write Failed To Port %d, rtn=%d",
			 channels[k] + 1, i);
			wrefresh (LBWin);

			mm_fail = 1;

			goto mm_done;
		}

		/*
		*  Response to this command will contain OK
		*/

		switch (get_em_resp(10, 1, 0x80, mm_resp, read_data, lbfd[k]))
		{
		default:
		case -1: /* sanity or I/O failure */
			mvwprintw (LBWin, r++, 2,
			 "***** Surpress Echo Read Failed on Port %d",
			 channels[k] + 1);
			wrefresh (LBWin);

			mm_fail = 1;

			goto mm_done;

		case 1: /* got no data */
		case 2: /* got data & bad compare */
			mvwprintw (LBWin, r++, 2,
			 "***** Set Surpress Echo Bad Response on Port %d",
			 channels[k] + 1);
			wrefresh (LBWin);

			mm_fail = 1;

			if (debug)
			{
				fprintf (dfp, "***** modem loopback test *****\n");
				fprintf (dfp, "Bad rsp to surpress echo cmd=%s\n",
				 read_data);
				fflush (dfp);
			}
			goto mm_done;
		
		case 0: /* got data & good compare */
			mm_state[k] = MM_ACT;
			break;
		}
	}

	/*
	*  Put the modems into a mode that supports loop back over an
	*  RJ11 cable back-to-back
	*/

	mvwprintw (LBWin, r++, 2, "Loop Back: Set Loop Back Modes");
	wrefresh (LBWin);

	for (k = 0; k < 2; ++k)
	{
		if ((i = write (lbfd[k], &mm_loopi[0],
		 strlen(mm_loopi))) != strlen(mm_loopi))
		{
			mvwprintw (LBWin, r++, 2,
			 "***** Set Loop Back Mode Write Failed To Port %d, rtn=%d",
			 channels[k] + 1, i);
			wrefresh (LBWin);

			mm_fail = 1;

			goto mm_done;
		}

		/*
		*  Response to this command will contain OK
		*/

		switch (get_em_resp(10, 1, 0x80, mm_resp, read_data, lbfd[k]))
		{
		default:
		case -1: /* sanity or I/O failure */
			mvwprintw (LBWin, r++, 2,
			 "***** Set Loop Back Mode Failed on Port %d",
			 channels[k] + 1);
			wrefresh (LBWin);

			mm_fail = 1;

			goto mm_done;

		case 1: /* got no data */
		case 2: /* got data & bad compare */
			mvwprintw (LBWin, r++, 2,
			 "***** Set Loop Back Mode Bad Response on Port %d",
			 channels[k] + 1);
			wrefresh (LBWin);

			mm_fail = 1;

			if (debug)
			{
				fprintf (dfp, "***** modem loopback test *****\n");
				fprintf (dfp, "Bad rsp to set loop back mode, rsp=%s\n",
				 read_data);
				fflush (dfp);
			}
			goto mm_done;
		
		case 0: /* got data & good compare */
			break;
		}
	}

	/*
	*  Dial on one line, answer on the other
	*/

	mvwprintw (LBWin, r++, 2,
	 "Loop Back: Dial on %d, Answer on %d",
	 channels[send_index] + 1, channels[recv_index] + 1);
	wrefresh (LBWin);

	if ((i = write (lbfd[send_index], &mm_dial[0],
	 strlen(mm_dial))) != strlen(mm_dial))
	{
		mvwprintw (LBWin, r++, 2,
		 "***** Dial Write Failed To Port %d, rtn=%d",
		 channels[send_index] + 1, i);
		wrefresh (LBWin);

		mm_fail = 1;

		goto mm_done;
	}

	if ((i = write (lbfd[recv_index], &mm_answ[0],
	 strlen(mm_answ))) != strlen(mm_answ))
	{
		mvwprintw (LBWin, r++, 2,
		 "***** Answer Write Failed To Port %d, rtn=%d",
		 channels[recv_index] + 1, i);
		wrefresh (LBWin);

		mm_fail = 1;

		goto mm_done;
	}

	/*
	*  Response to dial command will contain CONNECT
	*/

	switch (get_em_resp(60, 10, 0x80, mm_darsp, read_data, lbfd[send_index]))
	{
	default:
	case -1: /* sanity or I/O failure */
		mvwprintw (LBWin, r++, 2,
		 "***** Dial Read Failed on Port %d",
		 channels[send_index] + 1);
		wrefresh (LBWin);

		mm_fail = 1;

		goto mm_done;

	case 1: /* got no data */
	case 2: /* got data & bad compare */
		mvwprintw (LBWin, r++, 2,
		 "***** Dial Bad Response on Port %d",
		 channels[send_index] + 1);
		wrefresh (LBWin);

		mm_fail = 1;

		if (debug)
		{
			fprintf (dfp, "***** modem loopback test *****\n");
			fprintf (dfp, "Bad rsp to dial cmd=%s\n",
			 read_data);
			fflush (dfp);
		}
		goto mm_done;

	case 0: /* got data & good compare */
		break;
	}

	/*
	*  Response to answer command will contain CONNECT
	*/

	switch (get_em_resp(30, 1, 0x80, mm_darsp, read_data, lbfd[recv_index]))
	{
	default:
	case -1: /* sanity or I/O failure */
		mvwprintw (LBWin, r++, 2,
		 "***** Answer Read Failed on Port %d",
		 channels[recv_index] + 1);
		wrefresh (LBWin);

		mm_fail = 1;

		goto mm_done;

	case 1: /* got no data */
	case 2: /* got data & bad compare */
		mvwprintw (LBWin, r++, 2,
		 "***** Answer Bad Response on Port %d",
		 channels[recv_index] + 1);
		wrefresh (LBWin);

		mm_fail = 1;

		if (debug)
		{
			fprintf (dfp, "***** modem loopback test *****\n");
			fprintf (dfp, "Bad rsp to answer cmd=%s\n",
			 read_data);
			fflush (dfp);
		}
		goto mm_done;

	case 0: /* got data & good compare */
		break;
	}

	option = EOF;

	while (option == EOF)
	{
		r = 3;
		erase_win (LBWin);
		wattrset (LBWin, make_attr (A_BOLD, WHITE, BLUE));
		mvwprintw (LBWin, 1, 27, " Modem em Loop Back Test ");

		wattrset (LBWin, make_attr (A_ALTCHARSET, CYAN, BLACK));
		wmove (LBWin, 2, 1);
		for (i = 0; i < 77; i++)
			waddch (LBWin, ACS_HLINE);

		mvwaddch (LBWin, 2, 0, ACS_LTEE);
		mvwaddch (LBWin, 2, 77, ACS_RTEE);

		wattron (MainWin, make_attr (A_NORMAL, WHITE, BLUE));
		mvwprintw (MainWin, KEY_LINE, 0,
"                                                                               ");
		wattrset (LBWin, make_attr (A_NORMAL, WHITE, BLACK));
		wrefresh (LBWin);
		wrefresh (MainWin);

		test_num++;

		for (i = 0; i < 128; i++)
		{
			test_data[i] = 'A';
			read_data[i] = 0x00;
		}

		test_data[128] = read_data[128] = '\0';

		mvwprintw (LBWin, r++, 2,
		 "Test number = %d, Send Port = %d, Receive Port = %d",
		 test_num, channels[send_index] + 1,
		 channels[recv_index] + 1);

		mvwprintw (LBWin, r++, 2, "Loop Back: Sending 128 bytes");
		wrefresh (LBWin);

		/* Send the Test Data */

		if ((i = write(lbfd[send_index], &test_data[0], 0x80)) != 0x80)
		{
			mvwprintw (LBWin, r++, 2,
			"***** Loop Back Test Failure=%d, Sending 128 Bytes", i);
			wrefresh (LBWin);

			mm_fail = 1;

			goto mm_done;
		}

		mvwprintw (LBWin, r++, 2, "Loop Back: 128 Bytes Sent");
		mvwprintw (LBWin, r++, 2, "Loop Back: Receiving Data");
		wrefresh (LBWin);

		switch (get_em_resp(30, 3, 0x80, test_data, read_data,
		 lbfd[recv_index]))
		{
		case 0: /* got data & good compare */
			if (strlen (read_data) == 0x80)
				break;

			mvwprintw (LBWin, r++, 2,
				"***** Loop Back Failure:  Invalid receive length.");

			/* fall through */

		case 1: /* got no data */
		case 2: /* got data & bad compare */
			mvwprintw (LBWin, r++, 2,
				"***** Loop Back Failure Verifying 128 Bytes.");
			wrefresh (LBWin);

			if (debug)
			{
				fprintf (dfp, "***** modem loopback test *****\n");
				fprintf (dfp, "test_data: %s\n", test_data);
				fprintf (dfp, "read_data: %s\n", read_data);
				fflush (dfp);
			}


			mm_fail = 1;

			goto mm_done;

		default:
		case -1: /* sanity or I/O failure */
			mvwprintw (LBWin, r++, 2,
				"***** Loop Back Failure Receiving 128 bytes.");
			wrefresh (LBWin);

			mm_fail = 1;

			goto mm_done;
		}

		mvwprintw (LBWin, r++, 2, "Loop Back Test Passed.");
		wrefresh (LBWin);

		wattrset (MainWin, make_attr (A_NORMAL, WHITE, BLUE));
		commandline (clbuf, "Press ANY key to Halt the test", NULL);
		mvwprintw (MainWin, KEY_LINE, 0, clbuf);
		wattroff (MainWin, make_attr (A_NORMAL, WHITE, BLUE));
		wrefresh (MainWin);
		change_term (0, 10);

		if ((option = getch ()) == EOF)
		{
			send_index ^= 1;
			recv_index ^= 1;
		}
		else
		{
			mvwprintw (LBWin, 16, 22, "     Test Halted by the user      ");
		}
		wrefresh (LBWin);
	}							   /* End Loop */

mm_done:

		wattrset (MainWin, make_attr (A_NORMAL, WHITE, BLUE));
		commandline (clbuf,
		 "Returning Loop Back Modems to Original User Settings", NULL);
		mvwprintw (MainWin, KEY_LINE, 0, clbuf);
		wattroff (MainWin, make_attr (A_NORMAL, WHITE, BLUE));
		wrefresh (MainWin);

	/*
	*  If needed, restore modems to their original state
	*/

	sleep (2);  /* just in case the modem needs this */

	for (k = 0; k < 2; ++k)
	{
		switch (mm_state[k])
		{

		case MM_INIT:
			/* nothing was done to the modem, nothing to undo */
	
			break;

		default:

			if (debug)
			{
				fprintf (dfp, "***** modem loopback test *****\n");
				fprintf (dfp, "Invalid state=%d, channel=%d\n",
				 mm_state[k], channels[k]);
				fflush (dfp);
			}
		case MM_ACT:
		case MM_FACT:
			/* settings were changed to factory defaults */

			/*
			*  Put the modem in command mode
			*/

			mvwprintw (LBWin, r++, 2,
			 "Loop Back: Put modem on %d in command mode",
			 channels[k] + 1);
			wrefresh (LBWin);

			if ((i = write (lbfd[k], &mm_cmdm[0],
			 strlen(mm_cmdm))) != strlen(mm_cmdm))
			{
				mvwprintw (LBWin, r++, 2,
				 "***** Set Command Mode Write Failed To Port %d, rtn=%d",
				 channels[k] + 1, i);
				wrefresh (LBWin);

				mm_fail = 1;

				break;
			}

			/*
			*  Response to this command is ignored
			*/

		} /* switch (mm_state[k]) */

	} /* for (k = 0; k < 2; ++k) */

	sleep (2); /* might need this too */

	for (k = 0; k < 2; ++k)
	{
		switch (mm_state[k])
		{

		case MM_INIT:
			/* nothing was done to the modem, nothing to undo */
	
			break;

		default:

			if (debug)
			{
				fprintf (dfp, "***** modem loopback test *****\n");
				fprintf (dfp, "Invalid state=%d, channel=%d\n",
				 mm_state[k], channels[k]);
				fflush (dfp);
			}
		case MM_ACT:
		case MM_FACT:
			/* settings were changed to factory defaults */

			/*
			*  Send "hang up and restore user's default settings"
			*/

			mvwprintw (LBWin, r++, 2,
			 "Loop Back: Restore user's defaults on %d",
			 channels[k] + 1);
			wrefresh (LBWin);

			if ((i = write (lbfd[k], &mm_resact[0],
			 strlen(mm_resact))) != strlen(mm_resact))
			{
				mvwprintw (LBWin, r++, 2,
				 "***** Restore User Settings Write Failed To Port %d, rtn=%d",
				 channels[k] + 1, i);
				wrefresh (LBWin);

				mm_fail = 1;

				break;
			}

			/*
			*  Don't bother looking for a response
			*/

		} /* switch mm_state[k] */

		if (lbfd[k] != -1)
		{
			close (lbfd[k]);
			lbfd[k] = -1;
		}

		remove (lbfn[k]);

	} /* for (k = 0; k < 2; ++k) */

	/*
	*  Wait for user to hit a key
	*/

	wattrset (MainWin, make_attr (A_STANDOUT|A_BLINK, WHITE, BLUE));
	commandline (clbuf, "Press ANY key to Continue", NULL);
	mvwprintw (MainWin, KEY_LINE, 0, clbuf);
	wattroff (MainWin, make_attr (A_STANDOUT|A_BLINK, WHITE, BLUE));
	wrefresh (MainWin);
	wrefresh (LBWin);
	change_term (1, 0);
	wgetch (LBWin);

	change_term (0, TIMEOUT);
	hide_panel (LBPanel);
	update_panels ();
	doupdate ();
}

#endif /* !NO_MODEM_OPTS */

/**********************************************************************
*
*  Routine Name:	test_busy
*
*  Function:	Test a port to insure that it is not busy
*
**********************************************************************/

int
test_busy (struct bs_struct *bsp, int ch, char *bsy_txt)
{
	int busy = 0;

	bsy_txt[0] = '\0';

	/*
	*  get the channel structure
	*/

	get_channel(ch, bsp);

	/* If the port is busy don't do anything */

	if (bsp->tx_head != bsp->tx_tail)
	{
		Strcat (bsy_txt, ":TX");
		busy = -1;
	}
	else if (bsp->rx_head != bsp->rx_tail)
	{
		Strcat (bsy_txt, ":RX");
		busy = -1;
	}

	/* If Xall product then 
	 * 0x01 =   Output software flow control active.
	 * 0x04 =   Input software flow control active.
	 * Else
	 * 0x04 =   Output software flow control active.
	 * 0x08 =   Input software flow control active.
	 * This is the kludge the FEP/OS guys gave me......
	 */

	/* OFC */
	if ((bsp->hflow & ~bsp->m_stat) &
	 (XDM_CTS | XDM_CD | XDM_DSR | XDM_RI))
	{
		Strcat (bsy_txt, ":OFC");
		busy = -1;
	}
	else if (adapt_info[slot].bdtype == PCXX_BD)
	{
		if (bsp->m_stat & 0x1)
		{
			Strcat (bsy_txt, ":OFC");
			busy = -1;
		}
	}
	else if (bsp->m_stat & 0x4)
	{
		Strcat (bsy_txt, ":OFC");
		busy = -1;
	}

	/* IFC */
	if ((bsp->hflow & ~bsp->m_stat) & (XDM_RTS | XDM_DTR))
	{
		Strcat (bsy_txt, ":IFC");
		busy = -1;
	}
	else if (adapt_info[slot].bdtype == PCXX_BD)
	{
		if (bsp->m_stat & 0x4)
		{
			Strcat (bsy_txt, ":IFC");
			busy = -1;
		}
	}
	else if (bsp->m_stat & 0x8)
	{
		Strcat (bsy_txt, ":IFC");
		busy = -1;
	}

	if (bsp->m_stat & XDM_RTS)
	{
		Strcat (bsy_txt, ":RTS");
		busy = -1;
	}

	if (bsp->m_stat & XDM_CTS)
	{
		Strcat (bsy_txt, ":CTS");
		busy = -1;
	}

	if (((bsp->iflag & HW_ALTPIN) && (bsp->m_stat & XDM_CD)) ||
	    (!(bsp->iflag & HW_ALTPIN) && (bsp->m_stat & XDM_DSR)))
	{
		Strcat (bsy_txt, ":DSR");
		busy = -1;
	}

	if (((bsp->iflag & HW_ALTPIN) && (bsp->m_stat & XDM_DSR)) ||
	    (!(bsp->iflag & HW_ALTPIN) && (bsp->m_stat & XDM_CD)))
	{
		Strcat (bsy_txt, ":CD");
		busy = -1;
	}

	if (bsp->m_stat & XDM_DTR)
	{
		Strcat (bsy_txt, ":DTR");
		busy = -1;
	}

	if (bsp->m_stat & XDM_RI)
	{
		Strcat (bsy_txt, ":RI");
		busy = -1;
	}

	if (debug)
	{
		fprintf (dfp, "\n***** test_busy *****\n");
		fprintf (dfp, " Busy flag=%d\n", busy);
		if (busy != 0)
			fprintf (dfp, " Busy string=%s\n", bsy_txt);
		fflush (dfp);
	}

	return (busy); /* return busy indicator */
}


/**********************************************************************
*
*  Routine Name:	test_send
*
*  Function:	Send test data on the specified port
*
**********************************************************************/

int
test_send (struct bs_struct *bsp, int ch, char *dt, int ln)
{
	int				rtn,
					remains, 
					bs_addr, 
					total, 
					i;
	unsigned long	tx_seg_addr;
	unsigned short	last_head;
	char			*test_data;
	rw_t			lrw;

	/*
	*  Verify length is valid
	*/

	if (ln > 0x80)
	{
		if (debug)
		{
			fprintf (dfp, "\n***** test_send *****\n");
			fprintf (dfp, " Invalid length");
			fflush (dfp);
		}

		return (-1);
	}

	/*
	*  Get channel buffer structure
	*/

	get_channel (ch, bsp);

	/* Put the Test Data in the tx buffer */
	/* 
	 * If we're using adapter file descriptor 2 (/dev/epcadl) then
	 * subtract out the number of boards from pcxxfd (/dev/pcxxdl).
	 * Do the same thing for ad3 (/dev/pcxrdl).
	 */
	if (afd == epcafd)
		lrw.rw_board = slot - num_boards1;
#ifndef MRGDRV
	else if (afd == pcxrfd)
		lrw.rw_board = slot - (num_boards1 + num_boards2);
	else if (afd == aspxfd)
		lrw.rw_board = slot - (num_boards1 + num_boards2 + num_boards3);
#endif
#ifdef DXB
	else if (afd == dxbfd)
		lrw.rw_board = slot - (num_boards1 + num_boards2 + num_boards3 + num_boards4);
#endif
	else
		lrw.rw_board = slot;

	lrw.rw_conc = 0;
	lrw.rw_req = RW_WRITE;

	remains = ln;
	tx_seg_addr = bsp->tx_seg << 4;
	test_data = dt;

	if (a_line == 1)
		bs_addr = CHANBUF +
		 ((ch + adapt_info[slot].port_addr[conc]) * 128);
	else
		bs_addr = CHANBUF +
		 ((ch +
		 adapt_info[slot].port_addr[conc + adapt_info[slot].line1conc])
		 * 128);

	/* Check if tx_head is < remains from the end of the buffer */

	if ((int) (bsp->tx_head + remains) > (int) bsp->tx_max)
	{
		/* Add this data to the end of the buffer */

		lrw.rw_size = bsp->tx_max + 1 - bsp->tx_head;
		remains -= lrw.rw_size;
		total = lrw.rw_size;
		lrw.rw_addr = tx_seg_addr + (bsp->tx_head & bsp->tx_max);

		for (i = 0; i < (int)lrw.rw_size; i++)
			lrw.rw_data[i] = test_data[i];

		test_data += lrw.rw_size;

		/*
		*  Send the data
		*/

		if (lrw.rw_size > 0)
			if ((rtn = ioctl (afd, DIGI_KME, &lrw)) != 0)
			{
				if (debug)
				{
					fprintf (dfp, "\n***** test_send *****\n");
					fprintf (dfp, " copy data 1 ioctl failed=%d\n", rtn);
					fflush (dfp);
				}
				return (rtn);
			}

		/* Now add more data to the front the of buffer */

		lrw.rw_addr = tx_seg_addr;

		if (remains > (int)bsp->tx_head - 1)
			lrw.rw_size = bsp->tx_head - 1;
		else
			lrw.rw_size = remains;

		remains -= lrw.rw_size;
		total += lrw.rw_size;

		for (i = 0; i < (int)lrw.rw_size; ++i)
			lrw.rw_data[i] = test_data[i];

		test_data += lrw.rw_size;
	
		if (lrw.rw_size > 0)
			if ((rtn = ioctl (afd, DIGI_KME, &lrw)) != 0)
			{
				if (debug)
				{
					fprintf (dfp, "\n***** test_send *****\n");
					fprintf (dfp, " copy data 2 ioctl failed=%d\n", rtn);
					fflush (dfp);
				}
				return (rtn);
			}
	}
	else
	{
		/* Add this data to the end of the buffer */

		lrw.rw_size = total = remains;
		lrw.rw_addr = tx_seg_addr + (bsp->tx_head & bsp->tx_max);

		for (i = 0; i < remains; i++)
			lrw.rw_data[i] = test_data[i];

		remains = 0;

		if ((rtn = ioctl (afd, DIGI_KME, &lrw)) != 0)
			{
				if (debug)
				{
					fprintf (dfp, "\n***** test_send *****\n");
					fprintf (dfp, " copy data ioctl failed=%d\n", rtn);
					fflush (dfp);
				}
				return (rtn);
			}
	}

	lrw.rw_addr = bs_addr + 10;

	lrw.rw_size = 2;

	*((short *) &lrw.rw_data[0]) =
	 SHORT ((short) ((total + bsp->tx_head) & bsp->tx_max));

	if ((rtn = ioctl (afd, DIGI_KME, &lrw)) != 0)
	{
		if (debug)
		{
			fprintf (dfp, "\n***** test_send *****\n");
			fprintf (dfp, " tx_head ioctl failed=%d\n", rtn);
			fflush (dfp);
		}
		return (rtn);
	}

	/*
	*  Wait until all of the data is sent
	*/

	while (bsp->tx_head != bsp->tx_tail)
	{
		last_head = bsp->tx_head;

		get_channel (ch, bsp);

		/*
		*  if no data has moved since we last looked, error
		*/

		if (bsp->tx_head == last_head)
		{
			if (debug)
			{
				fprintf (dfp, "\n***** test_send *****\n");
				fprintf (dfp, " Data not moving\n");
				fflush (dfp);
			}
			return (-1);
		}
	}

	return (0); /* return "send successful" */
}


/**********************************************************************
*
*  Routine Name:	test_recv
*
*  Function:	Receive test data on the specified port
*
**********************************************************************/

int
test_recv (struct bs_struct *bsp, int ch, unsigned short lrx_head, char *dt, int mx_ln, int wt_sec)
{
	int		i, total, first_size;
	short	cur_head;
	char	*read_data;
	unsigned long rx_seg_addr;
	rw_t		lrw;

	read_data = dt;
	read_data[0] = 0x00;

	/*
	*  First, we wait until data starts coming in
	*/

	get_channel (ch, bsp);

	rx_seg_addr = bsp->rx_seg << 4;

	/*
	*  Validate max_ln, must be no larger than the buffer and 0x80
	*/

	if ((mx_ln > 0x80) || (mx_ln > (int)bsp->rx_max))
	{
		if (debug)
		{
			fprintf (dfp, "\n***** test_recv *****\n");
			fprintf (dfp, " Invalid length");
			fflush (dfp);
		}

		return (-1);
	}

	cur_head = lrx_head;

	while (bsp->rx_head == lrx_head)
	{
		if (wt_sec <= 0)
		{
			if (debug)
			{
				fprintf (dfp, "\n***** test_recv *****\n");
				fprintf (dfp, " rx_head never moved\n");
				fflush (dfp);
			}
			return (0);
		}

		sleep (1);
		--wt_sec;
		get_channel (ch, bsp);
	}

	/*
	*  Next, we wait until data stops coming in
	*/

	while (bsp->rx_head != cur_head)
	{
		cur_head = bsp->rx_head;

		sleep (1);

		get_channel (ch, bsp);
	}

	/*
	*  Calculate number of bytes received
	*/

	if (bsp->rx_head > lrx_head)
		total = bsp->rx_head - lrx_head;
	else
		total = bsp->rx_max + 1 - lrx_head + bsp->rx_head;

	if (total > mx_ln)
	{
		if (debug)
		{
			fprintf (dfp, "\n***** test_recv *****\n");
			fprintf (dfp, " too much data received\n");
			fflush (dfp);
		}
		return (-1);
	}

	/* Get the rx buffer */
	/* 
	 * If we're using adapter file descriptor 2 (/dev/epcadl) then
	 * subtract out the number of boards from pcxxfd (/dev/pcxxdl).
	 * Do the same thing for ad3 (/dev/pcxrdl).
	 */
	if (afd == epcafd)
		lrw.rw_board = slot - num_boards1;
#ifndef MRGDRV
	else if (afd == pcxrfd)
		lrw.rw_board = slot - (num_boards1 + num_boards2);
	else if (afd == aspxfd)
		lrw.rw_board = slot - (num_boards1 + num_boards2 + num_boards3);
#endif
	else
		lrw.rw_board = slot;

	lrw.rw_conc = 0;
	lrw.rw_req = RW_READ;

	/* Check if the data is contiguous in the buffer */

	if (bsp->rx_head <  lrx_head)
	{
		/* Not contiguous, get it out in two pieces */

		lrw.rw_addr = rx_seg_addr + lrx_head;
		lrw.rw_size = first_size = bsp->rx_max + 1 - lrx_head;
		
		for (i = 0; i < (int)lrw.rw_size; i++)
			lrw.rw_data[i] = '\0';

		if (ioctl (afd, DIGI_KME, &lrw) != 0)
			return (-1);

		for (i = 0; i < first_size; i++)
			read_data[i] = lrw.rw_data[i];

		read_data += first_size;

		/* Get the second piece */

		lrw.rw_addr = rx_seg_addr;
		lrw.rw_size = total - first_size;
		for (i = 0; i < (int)lrw.rw_size; i++)
			lrw.rw_data[i] = '\0';

		if (ioctl (afd, DIGI_KME, &lrw) != 0)
			return (-1);

		for (i = 0; i < (int)lrw.rw_size; ++i)
			read_data[i] = lrw.rw_data[i];

		read_data[i] = 0x00;
	}
	else
	{
		lrw.rw_addr = rx_seg_addr + lrx_head;
		lrw.rw_size = total;

		for (i = 0; i < (int)lrw.rw_size; i++)
			lrw.rw_data[i] = '\0';

		if (ioctl (afd, DIGI_KME, &lrw) != 0)
			return (-1);

		for (i = 0; i < total; ++i)
			read_data[i] = lrw.rw_data[i];

		read_data[i] = 0x00;
	}

	return (total); /* return "# bytes received" */
}

#ifndef NO_MODEM_OPTS
/**********************************************************************
*
*  Routine Name:	print_flashl
*
*  Function:	Reload some number of em/Modem flash ROMs
*
**********************************************************************/

void
print_flashl (int how_many, int chosen)
{
	int r, i, j, k, location, rel_conc;

	char	full_name [256],
			result[100];

	/*
	*  Initialize global variables
	*/

	emm_binarysz = 0;
	emm_binary = NULL;
	emm_loadersz = 0;
	emm_loader = NULL;
	emm_rptcnt = 0;

	switch (how_many)
	{
	case EM_SYS:
		strcpy (scrn2_msg, " System Wide em/Modem Flash ROM Load ");
		break;

	case EM_ADPT:
		sprintf (scrn2_msg, " Adapter %d em/Modem Flash ROM Load ",
		 slot + 1);
		break;
	
	case EM_MOD:
		sprintf (scrn2_msg,
		 " Adapter %d, Conc %d em/Modem Flash ROM Load ",
		 slot + 1, chosen + 1);
		break;

	case EM_PORT:
		sprintf (scrn2_msg,
		 " Adapter %d, Conc %d, Port %d em/Modem Flash ROM Load ",
		 slot + 1, conc + 1, chosen + 1);
	}

	/*
	*  Open the modem load report file
	*/

	strcpy (full_name, help_dir);
	strcat (full_name, report_file);

	emm_rptfd = fopen (full_name, "w");

	show_panel (FLPanel);
	update_panels ();
	doupdate ();

	/*
	*  Take the user to help screen immediately
	*/

	info_screen ("dpa_info9", scrn2_msg);
	update_panels ();
	doupdate ();
	touchwin (FLWin);
	wrefresh (FLWin);

	/*
	*  Time to select the Flash ROM binary to be used
	*  First let's figure out what the choices are
	*/

	if ((i = get_flr_name ()) != -1)
		/* found some file names, were any of them valid? */

		for (k = 0, j = 0; k < flashrom_c; ++k)
			if (strcmp (flashrom_r[k], "Invalid") != 0)
				++j;

	if ((i == -1) || (j == 0))
	{
		/* either no files were found or all found were invalid */

		erase_win (FLWin);
		wattrset (FLWin, make_attr (A_BOLD, WHITE, BLUE));
		mvwprintw (FLWin, 1, center (FLWin, strlen (scrn2_msg)),
		 "%s", scrn2_msg);
		mvwprintw (FLWin, 2, 25, " Select Flash ROM File for Load ");

		wattrset (FLWin, make_attr (A_ALTCHARSET, CYAN, BLACK));
		wmove (FLWin, 3, 1);
		for (i = 0; i < 77; i++)
			waddch (FLWin, ACS_HLINE);

		mvwaddch (FLWin, 3, 0, ACS_LTEE);
		mvwaddch (FLWin, 3, 77, ACS_RTEE);

		wattron (MainWin, make_attr (A_NORMAL, WHITE, BLUE));
		mvwprintw (MainWin, KEY_LINE, 0,
"                                                                               ");
		wattrset (FLWin, make_attr (A_STANDOUT, WHITE, BLUE));

		if (flashrom_c == 0)
			mvwprintw (FLWin, 4, 2, "No Flash ROM files in %s",
			 modem_dir);
		else
		{
			mvwprintw (FLWin, 4, 2,
			 "All Flash ROM files in %s are invalid", modem_dir);

			for (i = 0, r = 6; i < flashrom_c; ++i, ++r)
				mvwprintw (FLWin, r, 4, "%s, Invalid", flashrom_n[i]);
		}

		wattroff (FLWin, make_attr (A_STANDOUT, WHITE, BLUE));

		wattrset (MainWin, make_attr (A_NORMAL, WHITE, BLUE));

		commandline (clbuf, helpstr, "Hit Any Key To Continue",
		 "^P=Print", NULL);

		mvwprintw (MainWin, KEY_LINE, 0, clbuf);
		wattroff (MainWin, make_attr (A_NORMAL, WHITE, BLUE));
		wrefresh (FLWin);
		wrefresh (MainWin);

		change_term (1, 0); /* insure we don't time out */

		getch();

		hide_panel (FLPanel);
		erase_win (FLWin);
		update_panels ();
		doupdate ();

		return;
	}

	/* find the first valid flash rom file name */

	for (location = 0; location < flashrom_c; ++location)
		if (strcmp (flashrom_r[location], "Invalid") != 0)
			break;

	while (1)
	{
		r = 4;

		erase_win (FLWin);
		wattrset (FLWin, make_attr (A_BOLD, WHITE, BLUE));
		mvwprintw (FLWin, 1, center (FLWin, strlen (scrn2_msg)),
		 "%s", scrn2_msg);
		mvwprintw (FLWin, 2, 25, " Select Flash ROM File for Load ");

		wattrset (FLWin, make_attr (A_ALTCHARSET, CYAN, BLACK));
		wmove (FLWin, 3, 1);
		for (i = 0; i < 77; i++)
			waddch (FLWin, ACS_HLINE);

		mvwaddch (FLWin, 3, 0, ACS_LTEE);
		mvwaddch (FLWin, 3, 77, ACS_RTEE);

		wattron (MainWin, make_attr (A_NORMAL, WHITE, BLUE));
		mvwprintw (MainWin, KEY_LINE, 0,
"                                                                               ");
		wattrset (FLWin, make_attr (A_NORMAL, WHITE, BLACK));

		for (i = 0; i < flashrom_c; ++i)
		{
			if (i == location)
				wattrset (FLWin, make_attr (A_STANDOUT, WHITE, BLUE));
			else
				wattrset (FLWin, make_attr (A_NORMAL, GREEN, BLACK));

			mvwprintw (FLWin, r++, 2, "%s, Rev. %s",
			 flashrom_n[i], flashrom_r[i]);

			if (i == location)
				wattroff (FLWin, make_attr (A_STANDOUT, WHITE, BLUE));
			else
				wattroff (FLWin, make_attr (A_NORMAL, GREEN, BLACK));
		}

		wattrset (MainWin, make_attr (A_NORMAL, WHITE, BLUE));

		commandline (clbuf, helpstr, "ESC=Quit",
		 "RETURN=Accept", updnstr, "^P=Print", NULL);

		mvwprintw (MainWin, KEY_LINE, 0, clbuf);
		wattroff (MainWin, make_attr (A_NORMAL, WHITE, BLUE));
		wrefresh (FLWin);
		wrefresh (MainWin);

		change_term (1, 0); /* insure we don't timeout */

		switch (getch ())
		{
		case EOF:
			break;

		case ctrl ('L'):
			refresh_screen ();
			break;

#ifdef KEY_UP
		case KEY_UP:
#endif
		case 'k':
up_again:
			if (location)
				location--;
			else
				location = flashrom_c - 1;

			if (strcmp (flashrom_r[location], "Invalid") == 0)
				goto up_again;

			break;

#ifdef KEY_DOWN
		case KEY_DOWN:
#endif
		case 'j':
down_again:
			if (location < flashrom_c - 1)
				location++;
			else
				location = 0;

			if (strcmp (flashrom_r[location], "Invalid") == 0)
				goto down_again;

			break;

		case 'Q':
		case 'q':
		case ESC:
			hide_panel (FLPanel);
			erase_win (FLWin);
			update_panels ();
			doupdate ();

			return;

		case RETURN:

			/*
			*  Get the appropriate loader
			*/

			strcpy (full_name, modem_dir);
			strcat (full_name, loader_n[location]);

			if ((emm_loader = copylist(full_name,
			 &emm_loadersz)) == NULL)
			{
				sprintf (result,
				 "Unable to copy loader file '%s'", full_name);
				goto pf_fail;
			}

			/*
			*  Get the requested file
			*/

			strcpy (full_name, modem_dir);
			strcat (full_name, flashrom_n[location]);

			if ((emm_binary = copylist(full_name,
			 &emm_binarysz)) == NULL)
			{
				sprintf (result,
				 "Unable to copy Flash ROM binary file '%s'",
				 full_name);
				goto pf_fail;
			}

			/* save the index for global use */

			flashrom_i = location;
			
			/*
			*  Do the loads
			*/

			switch (how_many)
			{
			case EM_SYS:
				do_flashl_adpts (0, total_boards - 1);
				break;

			case EM_ADPT:
				do_flashl_adpts (slot, slot);
				break;

			case EM_MOD:
				if (adapt_info[slot].emm_conc[chosen] & EMM_XEM)
				{
					for (k = 0;
					 k < (int)adapt_info[slot].nports_conc[chosen] [0]; ++k)

						if (load_modem_flash (slot, chosen, k))
							goto stop_load;
				}
				if (adapt_info[slot].emm_conc[chosen] & EMM_EPC1)
				{
					for (k = adapt_info[slot].nports_conc[chosen] [0];
					 k < (int)adapt_info[slot].nports_conc[chosen] [0] +
					 (int)adapt_info[slot].nports_conc[chosen] [1]; ++k)

						if (load_modem_flash (slot, chosen, k))
							goto stop_load;
				}
				if (adapt_info[slot].emm_conc[chosen] & EMM_EPC2)
				{
					for (k = adapt_info[slot].nports_conc[chosen] [0] +
					 adapt_info[slot].nports_conc[chosen] [1];
					 k < (int)adapt_info[slot].nports_conc[chosen] [0] +
					 (int)adapt_info[slot].nports_conc[chosen] [1] +
					 (int)adapt_info[slot].nports_conc[chosen] [2]; ++k)

						if (load_modem_flash (slot, chosen, k))
							goto stop_load;
				}
				if (adapt_info[slot].emm_conc[chosen] & EMM_EPC3)
				{
					for (k = adapt_info[slot].nports_conc[chosen] [0] +
					 adapt_info[slot].nports_conc[chosen] [1] +
					 adapt_info[slot].nports_conc[chosen] [2];
					 k < (int)adapt_info[slot].nports_conc[chosen] [0] +
					 (int)adapt_info[slot].nports_conc[chosen] [1] +
					 (int)adapt_info[slot].nports_conc[chosen] [2] +
					 (int)adapt_info[slot].nports_conc[chosen] [3]; ++k)

						if (load_modem_flash (slot, chosen, k))
							break;
				}
stop_load:
				break;

			case EM_PORT:

				if (a_line == 1)
					rel_conc = conc;
				else
					rel_conc = conc + adapt_info[slot].line1conc;

				load_modem_flash (slot, rel_conc, chosen);
				break;

			}

			/* free up the space malloc'ed by copylist */

			if (emm_binary)
			{
				free (emm_binary);
				emm_binary = NULL;
			}

			if (emm_loader)
			{
				free (emm_loader);
				emm_loader = NULL;
			}

			goto pf_done;

#ifdef KEY_PRINT
		case KEY_PRINT:
#endif
		case ctrl ('P'):
			screen_save (FLWin, logfile);
			touchwin (FLWin);
			wrefresh (FLWin);
			update_panels ();
			doupdate ();
			break;

		case KEY_F (1):		   /*  Help info  */
		case '?':
			info_screen ("dpa_info9", NULL);
			update_panels ();
			doupdate ();
			touchwin (FLWin);
			wrefresh (FLWin);
			break;

		default:
			mvwprintw (FLWin, 16, 60, "Invalid key");
			wrefresh (FLWin);
			sleep (1);
			mvwprintw (FLWin, 16, 60, "           ");
			wrefresh (FLWin);
			break;
		}						   /* End Case */

	} /* while (1) */

pf_fail:
	++emm_rptcnt;

	fprintf (emm_rptfd, "%s\n", result);

pf_done:

	if (emm_rptcnt == 0)
		fprintf (emm_rptfd, "No Modems Loaded\n");

	fclose (emm_rptfd);

	info_screen (report_file, " em/Modem Load Report ");

	change_term (0, TIMEOUT);
	hide_panel (FLPanel);
	update_panels ();
	doupdate ();
	return;

}


/**********************************************************************
*
*  Routine Name:	do_flashl_adpts
*
*  Function:	
*
**********************************************************************/

void
do_flashl_adpts (int low_slot, int high_slot)
{
	int	i, j, k;

	for (i = low_slot; i <= high_slot; ++i)
	{
		if (adapt_info[i].emm_adpt)
		{
			for (j = 0;
			 j < adapt_info[i].line1conc + adapt_info[i].line2conc; ++j)
			{
				if (adapt_info[i].emm_conc[j] & EMM_XEM)
				{
					for (k = 0;
					 k < (int)adapt_info[i].nports_conc[j] [0]; ++k)

						if (load_modem_flash (i, j, k))
							return;
				}
				if (adapt_info[i].emm_conc[j] & EMM_EPC1)
				{
					for (k = adapt_info[i].nports_conc[j] [0];
					 k < (int)adapt_info[i].nports_conc[j] [0] +
					 (int)adapt_info[i].nports_conc[j] [1]; ++k)

						if (load_modem_flash (i, j, k))
							return;
				}
				if (adapt_info[i].emm_conc[j] & EMM_EPC2)
				{
					for (k = adapt_info[i].nports_conc[j] [0] +
					 adapt_info[i].nports_conc[j] [1];
					 k < (int)adapt_info[i].nports_conc[j] [0] +
					 (int)adapt_info[i].nports_conc[j] [1] +
					 (int)adapt_info[i].nports_conc[j] [2]; ++k)

						if (load_modem_flash (i, j, k))
							return;
				}
				if (adapt_info[i].emm_conc[j] & EMM_EPC3)
				{
					for (k = adapt_info[i].nports_conc[j] [0] +
					 adapt_info[i].nports_conc[j] [1] +
					 adapt_info[i].nports_conc[j] [2];
					 k < (int)adapt_info[i].nports_conc[j] [0] +
					 (int)adapt_info[i].nports_conc[j] [1] +
					 (int)adapt_info[i].nports_conc[j] [2] +
					 (int)adapt_info[i].nports_conc[j] [3]; ++k)

						if (load_modem_flash (i, j, k))
							return;
				}
			} /* for (all conc on this adapt) */
		} /* if (adapt_info[i].emm_adapt) */
	} /* for (i = low_slot; i <= high_slot; ++i) */

	return;
}


/**********************************************************************
*
*  Routine Name:	get_em_resp
*
*  Function:	Get a response or data from an em/Modem
*
**********************************************************************/

int
get_em_resp (int fc, int bc, int max, char *xrsp, char *rrsp, int fd)
{
	int i, cnt, tmr;
	char *data;

	/*
	*  Initialize local variables
	*/

	cnt = 0;
	data = rrsp;
	tmr = fc;

	for (i = 0; i < max; ++i)
		data[i] = 0x00;

	/*
	*  Sanity check
	*/

	if (max <= 0)
		return (-1);

	/*
	*  Get a character or timeout
	*/

	while (1)
	{

ignore_byte:

		switch (read (fd, data, 1))
		{
		case 1:
			/* got a byte, ignore leading cr or lf */

			if (cnt == 0)
			{
				if ((data[0] == '\r') || (data[0] == '\n'))
					goto ignore_byte;
				else
				{
					tmr = bc;
				}
			}

			++data;
			++cnt;

			if (max <= cnt)
			{
				if (strstr (rrsp, xrsp) == NULL)
					return (2);
				return (0);
			}

			break;

		case 0:
			/* timed out */

			if (--tmr > 0)
				break;

			if (cnt == 0)
			{
				data[0] = 0x00;
				return (1); /* no data received */
			}

			return (2); /* wrong data received */

		default:
		case -1:
			/* read error */

			return (-1);

		} /* switch (read (fd, data, 1)) */

		if (strstr (rrsp, xrsp) != NULL)
		{
			return (0); /* We got the string we're looking for */
		}
		
	} /* while (1) */
}


/**********************************************************************
*
*  Routine Name:	load_modem_flash
*
*  Function:	Reload em/Modem flash ROM for modem on this channel
*
**********************************************************************/

/*
*  Reload em/Modem flash ROM for this channel
*/

int
load_modem_flash (int fl_slot, int fl_conc, int fl_chan)
{
	int	i,
		r,
		tick = 10,
		rtn = 0,
		flfd = -1,
		fl_state,
		remains,
		size,
		retry;

	char	tick_str[12],
			read_data[129],
			trailer[] = "\r\n",
			flr_rev[7],
			result[100],
			*data,
			*next;

	struct termio tio;

	struct iovec iov[2];

	/* Temp Device name */
	char dev_name[64] = "/tmp/digi_fltmp";

	/* Modem OK response */
	char	mm_ok[] = "OK\r\n";

	/* Modem READY response */
	char	mm_ready[] = "READY\r\n";

	/* Erase Command echo response */
	char	mm_erase_resp[] = "REPROGRAM\r0";

	/* Modem '.' response */
	char	mm_period[] = ".";

	/* Modem error response */
	/* UNUSED: char	mm_err[] = "ERROR"; */

	/* Set active configuration to factory settings */
	char	mm_factact[] = "\rAT&F\r";

	/* Surpress echo */
	char	mm_secho[] = "\rATE0\r";

	/* Reset to new factory defaults */
	char	mm_resact[] = "\rAT&F&W0&W1\r";

	/* Get h/w & f/w version information and rev level */
	char	mm_firmver[] = "\rAT-V-N\r";

	/* Erase Command, caution */
	char	mm_erase[] = "REPROGRAM\r";

	/* Restart loader at the begining */
	char	mm_x[] = "X";

	/* Restart the modem */
	char	mm_startup[] = "STARTUP\r";

	/* Send Flash ROM to Modem */
	char	mm_load[] = "AT#C#C0000#\r\n";

	/*
	*  Initialize local variables
	*/

	strcpy (tick_str, ".");

	while (tick)
	{
		r = 4;

		erase_win (FLWin);
		wattrset (FLWin, make_attr (A_BOLD, WHITE, BLUE));
		mvwprintw (FLWin, 1, center (FLWin, strlen (scrn2_msg)),
		 "%s", scrn2_msg);
		mvwprintw (FLWin, 2, 21,
		 " Ready To Load Adapter %d, Conc %d, Port %d ",
		 fl_slot + 1, fl_conc + 1, fl_chan + 1);

		wattrset (FLWin, make_attr (A_ALTCHARSET, CYAN, BLACK));
		wmove (FLWin, 3, 1);
		for (i = 0; i < 77; i++)
			waddch (FLWin, ACS_HLINE);

		mvwaddch (FLWin, 3, 0, ACS_LTEE);
		mvwaddch (FLWin, 3, 77, ACS_RTEE);

		wattron (MainWin, make_attr (A_NORMAL, WHITE, BLUE));
		mvwprintw (MainWin, KEY_LINE, 0,
"                                                                               ");
		wattrset (FLWin, make_attr (A_NORMAL, WHITE, BLACK));

		mvwprintw (FLWin, 4, 2, "Load will begin in %d seconds", tick);
		mvwprintw (FLWin, 5, 2, tick_str);

		commandline (clbuf, helpstr, "ESC=Quit",
		 "RETURN=Load Now", "^P=Print", NULL);

		mvwprintw (MainWin, KEY_LINE, 0, clbuf);
		wattroff (MainWin, make_attr (A_NORMAL, WHITE, BLUE));
		wrefresh (MainWin);
		wrefresh (FLWin);

		change_term (0, TIMEOUT);

		switch (getch ())
		{
		case EOF:
			--tick;
			strcat (tick_str, ".");
			break;

		case ctrl ('L'):
			refresh_screen ();
			break;

		case 'Q':
		case 'q':
		case ESC:

			sprintf (result,
			"Flash ROM Load Canceled Prior to doing Adpt=%d, Conc=%d, Port=%d",
			 fl_slot + 1, fl_conc + 1, fl_chan + 1);

			rtn = 1;

			goto lmf_done;

		case RETURN:

			tick = 0;

			break;

#ifdef KEY_PRINT
		case KEY_PRINT:
#endif
		case ctrl ('P'):
			screen_save (FLWin, logfile);
			touchwin (FLWin);
			wrefresh (FLWin);
			update_panels ();
			doupdate ();

			tick = 10;
			strcpy (tick_str, ".");

			break;

		case KEY_F (1):		   /*  Help info  */
		case '?':
			info_screen ("dpa_info9", NULL);
			update_panels ();
			doupdate ();
			touchwin (FLWin);
			wrefresh (FLWin);

			tick = 10;
			strcpy (tick_str, ".");

			break;

		default:
			mvwprintw (FLWin, 16, 60, "Invalid key");
			wrefresh (FLWin);
			sleep (1);
			mvwprintw (FLWin, 16, 60, "           ");
			wrefresh (FLWin);

			tick = 10;
			strcpy (tick_str, ".");

			break;
		}						   /* End Case */

	} /* while (tick) */

	r = 4;

	erase_win (FLWin);
	wattrset (FLWin, make_attr (A_BOLD, WHITE, BLUE));
	mvwprintw (FLWin, 1, center (FLWin, strlen (scrn2_msg)),
	 "%s", scrn2_msg);

	mvwprintw (FLWin, 2, 23,
	 " Loading Adapter %d, Conc %d, Port %d ",
	 fl_slot + 1, fl_conc + 1, fl_chan + 1);

	wattrset (FLWin, make_attr (A_ALTCHARSET, CYAN, BLACK));
	wmove (FLWin, 3, 1);
	for (i = 0; i < 77; i++)
		waddch (FLWin, ACS_HLINE);

	mvwaddch (FLWin, 3, 0, ACS_LTEE);
	mvwaddch (FLWin, 3, 77, ACS_RTEE);

	wattron (MainWin, make_attr (A_NORMAL, WHITE, BLUE));
	mvwprintw (MainWin, KEY_LINE, 0,
"                                                                               ");
	wattrset (FLWin, make_attr (A_NORMAL, WHITE, BLACK));

	commandline (clbuf,
	 "em/Modem Load in Progress, DO NOT INTERRUPT", NULL);

	mvwprintw (MainWin, KEY_LINE, 0, clbuf);
	wattroff (MainWin, make_attr (A_NORMAL, WHITE, BLUE));
	wrefresh (MainWin);
	wrefresh (FLWin);

	mvwprintw (FLWin, r++, 2, "Flash ROM: Opening Port");
	wrefresh (FLWin);

	if (em_get_device(fl_slot, fl_conc, fl_chan, dev_name) == -1)
	{
		sprintf (result,
		"Can't create temp device for for Adpt=%d, Conc=%d, Port=%d",
		 fl_slot + 1, fl_conc + 1, fl_chan + 1);

		goto lmf_done;
	}

	if ((flfd = open (dev_name, O_RDWR | O_EXCL)) == -1)
	{
		sprintf (result,
		"Open failed for Adpt=%d, Conc=%d, Port=%d",
		 fl_slot + 1, fl_conc + 1, fl_chan + 1);

		goto lmf_done;
	}

	if (!isatty(flfd))
	{
		sprintf (result,
		"Can't find device name for Adpt=%d, Conc=%d, Port=%d",
		 fl_slot + 1, fl_conc + 1, fl_chan + 1);

		goto lmf_done;
	}

	/*
	*  Set up the tty for our use
	*/

	if (ioctl (flfd, TCGETA, &tio) == -1)
	{
		sprintf (result,
		"Failed ioctl for Adpt=%d, Conc=%d, Port=%d",
		 fl_slot + 1, fl_conc + 1, fl_chan + 1);

		goto lmf_done;
	}

	tio.c_iflag = BRKINT | IGNPAR | IXON | IXOFF;
	tio.c_lflag &= ~(ICANON | ISIG | ECHO | ECHOE | ECHOK);
	tio.c_cflag = B38400 | CS8 | CREAD | CLOCAL;
	tio.c_oflag = 0;
	tio.c_cc[VMIN] = 0;		/* get_em_resp requires this */
	tio.c_cc[VTIME] = 10;	/* get_em_resp requires this */

	if (ioctl (flfd, TCSETA, &tio) == -1)
	{
		sprintf (result,
		"Failed ioctl for Adpt=%d, Conc=%d, Port=%d",
		 fl_slot + 1, fl_conc + 1, fl_chan + 1);

		goto lmf_done;
	}

	/*
	*  Set up port for flash load
	*/

	mvwprintw (FLWin, r++, 2, "Flash ROM: Set Modem Factory Options");
	wrefresh (FLWin);

	fl_state = MM_FACT;

	if ((i = write (flfd, &mm_factact[0],
	 strlen(mm_factact))) != strlen(mm_factact))
	{
		sprintf (result,
		 "Set Factory Defaults Write Failed To Adpt=%d, Conc=%d, Port %d, rtn=%d",
		 fl_slot + 1, fl_conc + 1, fl_chan + 1, i);

		goto lmf_done;
	}

	/*
	*  Response to this command is indeterminate, we can't
	*  know the modem response until after this command takes effect
	*/

	switch (get_em_resp(30, 1, 0x80, mm_ok, read_data, flfd))
	{
	default:
	case -1: /* sanity or I/O failure */
		sprintf (result,
		 "Set Factory Defaults Read Failed on Adpt=%d, Conc=%d, Port %d",
		 fl_slot + 1, fl_conc + 1, fl_chan + 1);

		goto lmf_done;

	case 0: /* got data & good compare */
	case 1: /* got no data */
	case 2: /* got data & bad compare */
		if (debug)
		{
			fprintf (dfp, "***** flash rom load *****\n");
			fprintf (dfp, "Set factory defaults to chan=%d rsp=%s\n",
			 fl_chan, read_data);
			fflush (dfp);
		}
		break;
	}

	/*
	*  Surpress echo
	*/

	mvwprintw (FLWin, r++, 2, "Flash ROM: Set Surpress Echo");
	wrefresh (FLWin);

	if ((i = write (flfd, &mm_secho[0],
	 strlen(mm_secho))) != strlen(mm_secho))
	{
		sprintf (result,
		 "Surpress Echo Write Failed To Adpt=%d, Conc=%d, Port %d, rtn=%d",
		 fl_slot + 1, fl_conc + 1, fl_chan + 1, i);

		goto lmf_done;
	}

	/*
	*  Response to this command will contain OK
	*/

	switch (get_em_resp(10, 1, 0x80, mm_ok, read_data, flfd))
	{
	default:
	case -1: /* sanity or I/O failure */
		sprintf (result,
		 "Surpress Echo Read Failed on Adpt=%d, Conc=%d, Port %d",
		 fl_slot + 1, fl_conc + 1, fl_chan + 1);

		goto lmf_done;

	case 1: /* got no data */
	case 2: /* got data & bad compare */
		sprintf (result,
		 "Set Surpress Echo Bad Response on Adpt=%d, Conc=%d, Port %d",
		 fl_slot + 1, fl_conc + 1, fl_chan + 1);

		if (debug)
		{
			fprintf (dfp, "***** flash rom load *****\n");
			fprintf (dfp, "Bad rsp to surpress echo cmd=%s\n",
			 read_data);
			fflush (dfp);
		}
		goto lmf_done;
		
	case 0: /* got data & good compare */
		fl_state = MM_ACT;

		if (debug)
		{
			fprintf (dfp, "***** flash rom load *****\n");
			fprintf (dfp, "Surpress echo to chan=%d rsp=%s\n",
			 fl_chan, read_data);
			fflush (dfp);
		}
		break;
	}

	/*
	*  Get modem type and ROM Rev level
	*/

	mvwprintw (FLWin, r++, 2, "Flash ROM: Get Modem Version");
	wrefresh (FLWin);

	if ((i = write (flfd, &mm_firmver[0],
	 strlen(mm_firmver))) != strlen(mm_firmver))
	{
		sprintf (result,
		 "Get Modem Version Write Failed To Adpt=%d, Conc=%d, Port %d, rtn=%d",
		 fl_slot + 1, fl_conc + 1, fl_chan + 1, i);

		goto lmf_done;
	}

	/*
	*  Response to this command is chipset dependent
	*/

	switch (get_em_resp(10, 1, 0x80, mm_ok, read_data, flfd))
	{
	default:
	case -1: /* sanity or I/O failure */
		sprintf (result,
		 "Get Modem Version Read Failed on Adpt=%d, Conc=%d, Port %d",
		 fl_slot + 1, fl_conc + 1, fl_chan + 1);

		goto lmf_done;

	case 1: /* got no data */
		sprintf (result,
		 "Get Modem Version Timeout on Adpt=%d, Conc=%d, Port %d",
		 fl_slot + 1, fl_conc + 1, fl_chan + 1);

		if (debug)
		{
			fprintf (dfp, "***** flash rom load *****\n");
			fprintf (dfp, "Timeout on get modem version cmd=%s\n",
			 read_data);
			fflush (dfp);
		}
		goto lmf_done;
		
	case 2: /* got data & bad compare to OK */
	case 0: /* got data & good compare to OK */

		if (debug)
		{
			fprintf (dfp, "***** flash rom load *****\n");
			fprintf (dfp, "Get modem version to chan=%d rsp=%s\n",
			 fl_chan, read_data);
			fflush (dfp);
		}
		break;
	}

	/*
	*  Figure out the chipset and whether multiple versions
	*  of flash ROM are supported
	*/

	if (strncmp(read_data, "I34A2038", 8) == 0)
	{
		/* 1633 chipset, only one flash ROM rev */

		if (strncmp(flashrom_n[flashrom_i], "1633", 4) != 0)
		{
			/* flash ROM doesn't match chipset */

			sprintf (result,
			 "%s invalid for 1633 Modem on Adpt=%d, Conc=%d, Port %d",
			 flashrom_n[flashrom_i], fl_slot + 1, fl_conc + 1,
			 fl_chan + 1);

			if (debug)
			{
				fprintf (dfp, "***** flash rom load *****\n");
				fprintf (dfp, "File '%s' not valid for 1633 chipset\n",
				 flashrom_n[flashrom_i]);
				fflush (dfp);
			}
			goto lmf_done;

		}

		/* Use default rev number, there is only one */

		strcpy (flr_rev, "00.00");

	}
	else if (strncmp (read_data, "IC02069", 7) == 0)
	{
		/* 1634 AC chipset, only one flash ROM rev */

		if (strncmp(flashrom_n[flashrom_i], "1634ac", 6) != 0)
		{
			/* flash ROM doesn't match chipset */

			sprintf (result,
			 "%s invalid for 1634AC Modem on Adpt=%d, Conc=%d, Port %d",
			 flashrom_n[flashrom_i], fl_slot + 1, fl_conc + 1,
			 fl_chan + 1);

			if (debug)
			{
				fprintf (dfp, "***** flash rom load *****\n");
				fprintf (dfp, "File '%s' not valid for 1634 AC chipset\n",
				 flashrom_n[flashrom_i]);
				fflush (dfp);
			}
			goto lmf_done;

		}

		/* Use default rev number, there is only one */

		strcpy (flr_rev, "00.00");

	}
	else if (strncmp (read_data, "IE02069", 7) == 0)
	{
		/* 1634 AE chipset, multiple flash ROM revs */

		if (strncmp(flashrom_n[flashrom_i], "1634ae", 6) != 0)
		{
			/* flash ROM doesn't match chipset */

			sprintf (result,
			 "%s invalid for 1634AE Modem on Adpt=%d, Conc=%d, Port %d",
			 flashrom_n[flashrom_i], fl_slot + 1, fl_conc + 1,
			 fl_chan + 1);

			if (debug)
			{
				fprintf (dfp, "***** flash rom load *****\n");
				fprintf (dfp, "File '%s' not valid for 1634 AE chipset\n",
				 flashrom_n[flashrom_i]);
				fflush (dfp);
			}
			goto lmf_done;

		}

		/* rev number follows chipset version */

		next = read_data + 7;

		/* first advance past this field */

		while (next[0] != 0x00)
		{
			if ((next[0] == '\r') || (next[0] == '\n'))
				break;

			++next;
		}

		/* then past the cr and lf */

		while (next[0] != 0x00)
		{
			if ((next[0] != '\r') && (next[0] != '\n'))
				break;

			++next;
		}

		/* next now points to the start of the rev level field
		   now find the end of the field */

		for (i = 0; next[i] != 0x00; ++i)
			if ((next[i] == '\r') || (next[i] == '\n'))
				break;

		next[i] = 0x00;

		if ((strlen (next) < 5) || (strlen (next) > 7))
			strcpy (flr_rev, "00.00");
		else
			strcpy (flr_rev, next);

	}
	else
	{
		/* unknown response, fail the load */

		sprintf (result,
		 "Unidentifiable modem on Adpt=%d, Conc=%d, Port %d",
		 fl_slot + 1, fl_conc + 1, fl_chan + 1);

		if (debug)
		{
			fprintf (dfp, "***** flash rom load *****\n");
			fprintf (dfp, "Unidentified chipset\n",
			 flashrom_n[flashrom_i]);
			fflush (dfp);
		}
		goto lmf_done;

	}

	/*
	*  Verify that the Flash ROM level being loaded is
	*  higher that what is there
	*/

	i = compare_revs (flr_rev, flashrom_r[flashrom_i]);

	switch (i)
	{
	case 1: /* File ROM is higher than modem ROM */

		break; /* no problem */

	case 0: /* ROMs are at the same level */
	case -1: /* Modem ROM is higher than file ROM */

		wattrset (FLWin, make_attr (A_NORMAL, WHITE, BLUE));

		if ( i == 0)
			mvwprintw (FLWin, r, 2,
			 "File version of Flash ROM is the same as Modem version");
		else
			mvwprintw (FLWin, r, 2,
			 "File version of Flash ROM is less recent than Modem version");

		wattroff (FLWin, make_attr (A_NORMAL, WHITE, BLUE));
		wattrset (MainWin, make_attr (A_NORMAL, WHITE, BLUE));

		commandline (clbuf, helpstr, "ESC=Don't Load This Modem",
		 "RETURN=Load Anyway", "^P=Print", NULL);

		mvwprintw (MainWin, KEY_LINE, 0, clbuf);
		wattroff (MainWin, make_attr (A_NORMAL, WHITE, BLUE));
		wrefresh (MainWin);
		wrefresh (FLWin);

		change_term (1, 0);
		tick = 1;

		while (tick)
		{
			switch (getch ())
			{
			case ctrl ('L'):
				refresh_screen ();
				break;

			case 'Q':
			case 'q':
			case ESC:
				sprintf (result,
				"Flash ROM Load for Adpt=%d, Conc=%d, Port=%d, cancelled",
				 fl_slot + 1, fl_conc + 1, fl_chan + 1);

				wattrset (FLWin, make_attr (A_NORMAL, WHITE, BLACK));
				mvwprintw(FLWin, r, 2,
		 "                                                           ");
				wattroff (FLWin, make_attr (A_NORMAL, WHITE, BLACK));

				goto lmf_done;

			case RETURN:

				tick = 0;

				break;

#ifdef KEY_PRINT
			case KEY_PRINT:
#endif
			case ctrl ('P'):
				screen_save (FLWin, logfile);
				touchwin (FLWin);
				wrefresh (FLWin);
				update_panels ();
				doupdate ();

				break;

			case KEY_F (1):		   /*  Help info  */
			case '?':
				info_screen ("dpa_info9", NULL);
				update_panels ();
				doupdate ();
				touchwin (FLWin);
				wrefresh (FLWin);

				break;

			default:
				mvwprintw (FLWin, 16, 60, "Invalid key");
				wrefresh (FLWin);
				sleep (1);
				mvwprintw (FLWin, 16, 60, "           ");
				wrefresh (FLWin);

				break;
			}						   /* End Case */

		} /* while (tick) */

		wattrset (FLWin, make_attr (A_NORMAL, WHITE, BLACK));
		mvwprintw(FLWin, r, 2,
		 "                                                           ");
		wattroff (FLWin, make_attr (A_NORMAL, WHITE, BLACK));
		wattrset (MainWin, make_attr (A_NORMAL, WHITE, BLUE));
		commandline (clbuf,
		 "em/Modem Load in Progress, DO NOT INTERRUPT", NULL);

		mvwprintw (MainWin, KEY_LINE, 0, clbuf);
		wattroff (MainWin, make_attr (A_NORMAL, WHITE, BLUE));
		wrefresh (MainWin);
		wrefresh (FLWin);

	}

	/*
	*  Send the loader down to the modem
	*/

	mvwprintw (FLWin, r++, 2, "Flash ROM: Send Loader to Modem");
	wrefresh (FLWin);

	remains = emm_loadersz;
	data = emm_loader;

	/*
	*  If lines end with cr, this is DOS format
	*/

	if (data[strlen (data) - 1] == '\r')
	{
		strcpy (trailer, "\n");
	}
	else
	{
		strcpy (trailer, "\r\n");
	}

	iov[1].iov_len = strlen(trailer);
	iov[1].iov_base = trailer;

	while (remains)
	{
		mvwprintw (FLWin, r, 2, "Flash ROM: %d bytes remain       ",
		 remains);
		wrefresh (FLWin);

		size = strlen (data);
		iov[0].iov_len = size;
		iov[0].iov_base = data;
		next = data + size + 1;
		remains -= (size + 1);

		retry = 0;

retry_loader:

		if ((i = writev (flfd, iov, 2)) != size + strlen (trailer))
		{
			sprintf (result,
			 "Send Loader Write Failed To Adpt=%d, Conc=%d, Port %d, rtn=%d",
			 fl_slot + 1, fl_conc + 1, fl_chan + 1, i);

			goto lmf_done;
		}

		/*
		*  Response to this command will contain OK
		*/

		switch (get_em_resp(10, 1, 0x80, mm_ok, read_data, flfd))
		{
		default:
		case -1: /* sanity or I/O failure */
			sprintf (result,
			 "Send Loader Read Failed on Adpt=%d, Conc=%d, Port %d",
			 fl_slot + 1, fl_conc + 1, fl_chan + 1);

			goto lmf_done;

		case 1: /* got no data */
			if (retry == 0)
			{
				retry = 1;
				goto retry_loader;
			}

		case 2: /* got data & bad compare */
			sprintf (result,
			 "Send Loader Bad Response on Adpt=%d, Conc=%d, Port %d",
			 fl_slot + 1, fl_conc + 1, fl_chan + 1);

			if (debug)
			{
				fprintf (dfp, "***** flash rom load *****\n");
				fprintf (dfp, "Bad rsp to send loader cmd=%s\n",
				 read_data);
				fflush (dfp);
			}
			goto lmf_done;
		
		case 0: /* got data & good compare */
			if (debug)
			{
				fprintf (dfp, "***** flash rom load *****\n");
				fprintf (dfp, "Send loader to chan=%d rsp=%s\n",
				 fl_chan, read_data);
				fflush (dfp);
			}
			break;
		}

		data = next;

	} /* while (remains) */

	/*
	*  Issue start command to the loader in the modem
	*/

	mvwprintw (FLWin, r++, 2,
	 "Flash ROM: Send Start Loader Command to the Modem");
	wrefresh (FLWin);

	if ((i = write (flfd, &mm_load[0],
	 strlen(mm_load))) != strlen(mm_load))
	{
		sprintf (result,
		 "Start Loader Cmd Write Failed To Adpt=%d, Conc=%d, Port %d, rtn=%d",
		 fl_slot + 1, fl_conc + 1, fl_chan + 1, i);

		goto lmf_done;
	}

	/*
	*  Response to this command will contain READY
	*/

	switch (get_em_resp(10, 1, 0x80, mm_ready, read_data, flfd))
	{
	default:
	case -1: /* sanity or I/O failure */
		sprintf (result,
		 "Start Loader Cmd Read Failed on Adpt=%d, Conc=%d, Port %d",
		 fl_slot + 1, fl_conc + 1, fl_chan + 1);

		goto lmf_done;

	case 1: /* got no data */
	case 2: /* got data & bad compare */
		sprintf (result,
		 "Start Loader Cmd Bad Response on Adpt=%d, Conc=%d, Port %d",
		 fl_slot + 1, fl_conc + 1, fl_chan + 1);

		if (debug)
		{
			fprintf (dfp, "***** flash rom load *****\n");
			fprintf (dfp, "Bad rsp to start loader cmd=%s\n",
			 read_data);
			fflush (dfp);
		}
		goto lmf_done;

	case 0: /* got data & good compare */
		if (debug)
		{
			fprintf (dfp, "***** flash rom load *****\n");
			fprintf (dfp, "Start loader to chan=%d rsp=%s\n",
			 fl_chan, read_data);
			fflush (dfp);
		}
		break;
	}

	/*
	*  Send the Erase Flash ROM Command
	*/

	mvwprintw (FLWin, r++, 2, "Flash ROM: Erase Old Flash ROM");
	wrefresh (FLWin);

	if ((i = write (flfd, &mm_erase[0],
	 strlen(mm_erase))) != strlen(mm_erase))
	{
		sprintf (result,
		 "Erase Flash ROM Write Failed To Adpt=%d, Conc=%d, Port %d, rtn=%d",
		 fl_slot + 1, fl_conc + 1, fl_chan + 1, i);

		goto lmf_done;
	}

	/*
	*  Response to this command will contain REPROGRAM\r0
	*/

	switch (get_em_resp(90, 90, 0x80, mm_erase_resp, read_data, flfd))
	{
	default:
	case -1: /* sanity or I/O failure */
		sprintf (result,
		 "Erase Flash ROM Read Failed on Adpt=%d, Conc=%d, Port %d",
		 fl_slot + 1, fl_conc + 1, fl_chan + 1);

		goto lmf_done;

	case 1: /* got no data */
		sprintf (result,
		 "Erase Flash ROM Timeout on Adpt=%d, Conc=%d, Port %d",
		 fl_slot + 1, fl_conc + 1, fl_chan + 1);

		if (debug)
		{
			fprintf (dfp, "***** flash rom load *****\n");
			fprintf (dfp, "Timeout to erase ROM cmd=%s\n",
			 read_data);
			fflush (dfp);
		}
		goto lmf_done;

	case 2: /* got data & bad compare */
		sprintf (result,
		 "Erase Flash ROM Bad Response on Adpt=%d, Conc=%d, Port %d",
		 fl_slot + 1, fl_conc + 1, fl_chan + 1);

		if (debug)
		{
			fprintf (dfp, "***** flash rom load *****\n");
			fprintf (dfp, "Bad rsp to erase ROM cmd=%s\n",
			 read_data);
			fflush (dfp);
		}
		goto lmf_done;
		
	case 0: /* got data & good compare */
		if (debug)
		{
			fprintf (dfp, "***** flash rom load *****\n");
			fprintf (dfp, "Erase ROM to chan=%d rsp=%s\n",
			 fl_chan, read_data);
			fflush (dfp);
		}
		break;
	}

	/*
	*  Send the flash ROM down to the modem
	*/

	mvwprintw (FLWin, r++, 2, "Flash ROM: Send New Flash ROM to Modem");
	wrefresh (FLWin);

	remains = emm_binarysz;
	data = emm_binary;

	/*
	*  If lines end with cr, this is DOS format
	*/

	if (data[strlen (data) - 1] == '\r')
	{
		strcpy (trailer, "\n");
	}
	else
	{
		strcpy (trailer, "\r\n");
	}

	iov[1].iov_len = strlen(trailer);
	iov[1].iov_base = trailer;

	while (remains)
	{
		mvwprintw (FLWin, r, 2, "Flash ROM: %d bytes remain       ",
		 remains);
		wrefresh (FLWin);

		size = strlen (data);
		iov[0].iov_len = size;
		iov[0].iov_base = data;
		next = data + size + 1;
		remains -= (size + 1);

		if ((i = writev (flfd, iov, 2)) != size + strlen (trailer))
		{
			sprintf (result,
			 "Send Flash ROM Write Failed To Adpt=%d, Conc=%d, Port %d, rtn=%d",
			 fl_slot + 1, fl_conc + 1, fl_chan + 1, i);

			goto lmf_done;
		}

		/*
		*  Each block gets a '.' in response
		*/

		/*
		*  This is temp kluge until I find out why we don't
		*  get a response to these short blocks
		*/

		if ((strlen (data) < 20) && debug)
		{
			fprintf (dfp, "***** flash rom load *****\n");
			fprintf (dfp, "Short block, should timeout\n");
			fflush (dfp);
		}

		switch (get_em_resp(5, 1, 0x80, mm_period, read_data, flfd))
		{
		default:
		case -1: /* sanity or I/O failure */
			sprintf (result,
			 "Send Flash ROM Read Failed on Adpt=%d, Conc=%d, Port %d",
			 fl_slot + 1, fl_conc + 1, fl_chan + 1);

			goto lmf_done;
		
		case 1: /* got no data */
		case 2: /* got data & bad compare */
		case 0: /* got data & good compare */
			if (debug)
			{
				fprintf (dfp, "***** flash rom load *****\n");
				fprintf (dfp, "Send flash ROM to chan=%d rsp=%s\n",
				 fl_chan, read_data);
				fflush (dfp);
			}
			break;
		}

		data = next;

	} /* while (remains) */

	/*
	*  Tell the loader we're done
	*/

	mvwprintw (FLWin, r++, 2,
	 "Flash ROM: Send Reset Loader Command to the Modem");
	wrefresh (FLWin);

	if ((i = write (flfd, &mm_x[0],
	 strlen(mm_x))) != strlen(mm_x))
	{
		sprintf (result,
		 "Reset Loader Cmd Write Failed To Adpt=%d, Conc=%d, Port %d, rtn=%d",
		 fl_slot + 1, fl_conc + 1, fl_chan + 1, i);

		goto lmf_done;
	}

	/*
	*  Response to this command will contain READY
	*/

	switch (get_em_resp(10, 1, 0x80, mm_ready, read_data, flfd))
	{
	default:
	case -1: /* sanity or I/O failure */
		sprintf (result,
		 "Reset Loader Cmd Read Failed on Adpt=%d, Conc=%d, Port %d",
		 fl_slot + 1, fl_conc + 1, fl_chan + 1);

		goto lmf_done;

	case 1: /* got no data */
	case 2: /* got data & bad compare */
		sprintf (result,
		 "Reset Loader Cmd Bad Response on Adpt=%d, Conc=%d, Port %d",
		 fl_slot + 1, fl_conc + 1, fl_chan + 1);

		if (debug)
		{
			fprintf (dfp, "***** flash rom load *****\n");
			fprintf (dfp, "Bad rsp to reset loader cmd=%s\n",
			 read_data);
			fflush (dfp);
		}
		goto lmf_done;

	case 0: /* got data & good compare */
		if (debug)
		{
			fprintf (dfp, "***** flash rom load *****\n");
			fprintf (dfp, "Reset loader to chan=%d rsp=%s\n",
			 fl_chan, read_data);
			fflush (dfp);
		}
		break;
	}

	/*
	*  Restart the modem
	*/

	mvwprintw (FLWin, r++, 2,
	 "Flash ROM: Send Restart Command to the Modem");
	wrefresh (FLWin);

	if ((i = write (flfd, &mm_startup[0],
	 strlen(mm_startup))) != strlen(mm_startup))
	{
		sprintf (result,
		 "Startup Cmd Write Failed To Adpt=%d, Conc=%d, Port %d, rtn=%d",
		 fl_slot + 1, fl_conc + 1, fl_chan + 1, i);

		goto lmf_done;
	}

	/*
	*  There is no response to this command
	*/

	sleep (1); /* modem requires this */

	/*
	*  Close and open the port
	*/

	close (flfd);
	flfd = -1;

	if ((flfd = open (dev_name, O_RDWR | O_EXCL)) == -1)
	{
		sprintf (result,
		"Second open failed for Adpt=%d, Conc=%d, Port=%d",
		 fl_slot + 1, fl_conc + 1, fl_chan + 1);

		goto lmf_done;
	}

	/*
	*  Set to new factory default options
	*/

	mvwprintw (FLWin, r++, 2,
	 "Flash ROM: Send 'Set New Factory Defaults' Command to the Modem");
	wrefresh (FLWin);

	if ((i = write (flfd, &mm_resact[0],
	 strlen(mm_resact))) != strlen(mm_resact))
	{
		sprintf (result,
		 "Set New Factory Defaults Write Failed To Adpt=%d, Conc=%d, Port %d, rtn=%d",
		 fl_slot + 1, fl_conc + 1, fl_chan + 1, i);

		goto lmf_done;
	}

	/*
	*  Don't care about the response to this one
	*/

	sprintf (result,
	 "Flash ROM Load Successful on Adpt=%d, Conc=%d, Port %d",
	 fl_slot + 1, fl_conc + 1, fl_chan + 1);

lmf_done:

	mvwprintw (FLWin, r++, 2, "%s", result);
	wrefresh (FLWin);

	++emm_rptcnt;
	fprintf (emm_rptfd, "%s\n", result);
	fflush (emm_rptfd);

	sleep (4);

	if (flfd != -1)
	{
		close (flfd);
		flfd = -1;
	}

	remove (dev_name);

	return (rtn);
}



/**********************************************************************
*
*  Routine Name:	em_get_device
*
*  Function:	Figure out the major/minor for this port and do
*				a mknod for it
*
**********************************************************************/

int
em_get_device (int s, int c, int p, char *dn)
{
#ifdef SCO
	int	major, minor;
#else
	major_t	major;
	minor_t	minor;
#endif

	dev_t dev;

	int	cp, cs, i;

	FILE	*mdfd = NULL;

	char	buf[256];

#ifdef SVR4

	char s1[80], s2[80], s3[80], s4[80], s5[80], mdevice_file[80];
	int num;
	struct stat stbuf;
#endif
#ifdef SOLARIS
#endif
#ifdef SCO
	
	int	drv_index;

	char	drv_name_chr [] = "abcdefghijklmnopqrstuvwxyz",
			drv_name[] = "epc ";

#endif

	/*
	 * If we're using adapter file descriptor 2 (/dev/epcadl) then
	 * subtract out the number of boards from pcxxfd (/dev/pcxxdl).
	 * Do the same thing for ad3 (/dev/pcxrdl).
	 */
	if (afd == epcafd)
		cs = s - num_boards1;
#ifndef MRGDRV
	else if (afd == pcxrfd)
		cs = s - (num_boards1 + num_boards2);
	else if (afd == aspxfd)
		cs = s - (num_boards1 + num_boards2 + num_boards3);
#endif
	else
		cs = s;

#ifdef SVR4

	cp = p + adapt_info[s].port_addr[c];

	if (debug)
	{
		fprintf (dfp, "***** get_em_device *****\n");
		fprintf (dfp,
		 "slot=%d, calc_slot=%d, conc=%d, port=%d, calc port=%d\n",
		 s, cs, c, p, cp);
		fflush (dfp);
	}

	/*
	*  Get the major number out of the mdevice file
	*  but first figure out which file to use
	*/

	if (stat("/etc/conf/cf.d/mdevice", &stbuf) != -1)
	
		/* this is 4.0, not 4.2 */

		strcpy (mdevice_file, "/etc/conf/cf.d/mdevice");
	
	else
		/* this is 4.2 */

		strcpy (mdevice_file, "/etc/conf/mdevice.d/epca");

	if ((mdfd = fopen (mdevice_file, "r")) == NULL)
	{
		if (debug)
		{
			fprintf (dfp, "***** get_em_device *****\n");
			fprintf (dfp, "fopen(%s) failed, errno=%d\n",
			 mdevice_file, errno);
			fflush (dfp);
		}

		return (-1);

	}

	/*
	*  Look for the line that begins with 'epca'
	*/

	while (1)
	{
		if (fgets (buf, sizeof(buf), mdfd) == NULL)
		{
			if (debug)
			{
				fprintf (dfp, "***** get_em_device *****\n");
				fprintf (dfp, "fgets(%s) reached EOF\n", mdevice_file);
				fflush (dfp);
			}

			fclose (mdfd);
			mdfd = NULL;

			return (-1);

		}

		if (strncmp(buf, "epca", 4) == 0)
			break;
	}

	/*
	*  Close the file
	*/

	fclose (mdfd);
	mdfd = NULL;

	/*
	*  Get the major number from the sixth field
	*/

	if (sscanf (buf, "%s %s %s %s %s %d",
	 s1, s2, s3, s4, s5, &num) != 6)
	{
		if (debug)
		{
			fprintf (dfp, "***** get_em_device *****\n");
			fprintf (dfp, "sscanf(mdevice_file) couldn't find major\n");
			fprintf (dfp, "mdevice_file='%s'\n", mdevice_file);
			fflush (dfp);
		}

		return (-1);

	}

	major = num;

	/*
	*  Now calculate the minor number
	*/

	minor = ((cs & 0x07) << 10) | ((cp & 0xff) << 2) | NONMODEM;
#endif
#ifdef SOLARIS

	cp = p + adapt_info[s].port_addr[c];

	if (debug)
	{
		fprintf (dfp, "***** get_em_device *****\n");
		fprintf (dfp,
		 "slot=%d, calc_slot=%d, conc=%d, port=%d, calc port=%d\n",
		 s, cs, c, p, cp);
		fflush (dfp);
	}

	/*
	*  Issue the command to get epca's major
	*/

	if ((mdfd = popen ("modinfo -g epca", "r")) == NULL)
	{
		if (debug)
		{
			fprintf (dfp, "***** get_em_device *****\n");
			fprintf (dfp, "Couldn't do popen()\n");
			fprintf (dfp, "modinfo -g epca\n");
			fflush (dfp);
		}

		return (-1);

	}

	if (fscanf (mdfd, "%d", &i) != 1)
	{
		if (debug)
		{
			fprintf (dfp, "***** get_em_device *****\n");
			fprintf (dfp, "Couldn't do fscanf()\n");
			fprintf (dfp, "modinfo -g epca\n");
			fflush (dfp);
		}

		pclose (mdfd);
		mdfd = NULL;

		return (-1);

	}

	major = i;

	/*
	*  Close the pipe
	*/

	pclose (mdfd);
	mdfd = NULL;

	minor = ((cs & 0x07) << 10) | ((cp & 0xff) << 2) | NONMODEM;

#endif
#ifdef SCO

	/* count all of the epca ports before this one */

	cp = 0;

	for (i = s - cs; i < s; ++i)
		cp += adapt_info[i].nports;

	cp = cp + adapt_info[s].port_addr[c] + p;

	if (debug)
	{
		fprintf (dfp, "***** get_em_device *****\n");
		fprintf (dfp,
		 "slot=%d, calc_slot=%d, conc=%d, port=%d, calc port=%d\n",
		 s, cs, c, p, cp);
		fflush (dfp);
	}

	/* calculate the driver name index and form driver name */

	drv_index = cp / 64;

	drv_name[3] = drv_name_chr[drv_index];

	/* get the driver major from the system */

	sprintf (buf, "/etc/conf/cf.d/configure -j %s", drv_name);

	/*
	*  Issue the command
	*/

	if ((mdfd = popen (buf, "r")) == NULL)
	{
		if (debug)
		{
			fprintf (dfp, "***** get_em_device *****\n");
			fprintf (dfp, "Couldn't do popen()\n");
			fprintf (dfp, "buf='%s'\n", buf);
			fflush (dfp);
		}

		return (-1);

	}

	if (fscanf (mdfd, "%d", &i) != 1)
	{
		if (debug)
		{
			fprintf (dfp, "***** get_em_device *****\n");
			fprintf (dfp, "Couldn't do fscanf()\n");
			fprintf (dfp, "buf='%s'\n", buf);
			fflush (dfp);
		}

		pclose (mdfd);
		mdfd = NULL;

		return (-1);

	}

	major = i;

	/*
	*  Close the pipe
	*/

	pclose (mdfd);
	mdfd = NULL;

	/* calculate the minor number */

	minor = (cp % 64) + 128;

#endif

	/*
	*  Make the device
	*/

	if ((dev = makedev (major, minor)) == NODEV)
	{
		if (debug)
		{
			fprintf (dfp, "***** get_em_device *****\n");
			fprintf (dfp, "makedev() failed, errno=%d\n", errno);
			fprintf (dfp, "Calculated major=%d & minor=%d\n",
			 major, minor);
			fprintf (dfp, "Device name='%s'\n", dn);
			fflush (dfp);
		}

		return (-1);

	}

	/*
	*  Just in case, remove the device first
	*/

	remove (dn);

	/*
	*  Make the temp device
	*/

	if (mknod (dn, S_IFCHR | S_IRUSR | S_IWUSR, dev) == -1)
	{
		if (debug)
		{
			fprintf (dfp, "***** get_em_device *****\n");
			fprintf (dfp, "mknod() failed, errno=%d\n", errno);
			fprintf (dfp, "Calculated major=%d & minor=%d\n",
			 major, minor);
			fprintf (dfp, "Device name='%s'\n", dn);
			fflush (dfp);
		}

		return (-1);

	}

	if (debug)
	{
		fprintf (dfp, "***** get_em_device *****\n");
		fprintf (dfp, "mknod() done\n");
		fprintf (dfp, "Calculated major=%d & minor=%d\n",
		 major, minor);
		fprintf (dfp, "Device name='%s'\n", dn);
		fflush (dfp);
	}

	return (0);
}

#endif /* !NO_MODEM_OPTS */


/**********************************************************************
*
*  Routine Name:	compare_revs
*
*  Function:	Compare two modem flash ROM revision strings
*
**********************************************************************/

int
compare_revs (char *first, char *second)
{
	int	first_left,
		first_right,
		second_left,
		second_right;

	char	first_cpy[10],
			second_cpy[10];

	/*
	*  The strings are of the form nn.nnnn, nn.nnn or nn.nn where n
	*  is a number from 0 to 9
	*  Compare the two values left to right
	*/

	/* copy both strings and pad to insure nn.nnnn form */

	strcpy (first_cpy, first);
	strcpy (second_cpy, second);

	while (strlen (first_cpy) < 7)
		strcat (first_cpy, "0");

	while (strlen (second_cpy) < 7)
		strcat (second_cpy, "0");

	sscanf (first_cpy, "%2d.%4d", &first_left, &first_right);

	sscanf (second_cpy, "%2d.%4d", &second_left, &second_right);

	if (first_left > second_left)
		return (-1);

	if (first_left < second_left)
		return (1);

	if (first_right > second_right)
		return (-1);

	if (first_right < second_right)
		return (1);

	return (0);
}



/**********************************************************************
*
*  Routine Name:	get_flr_name
*
*  Function:	Get the name of all of the flash ROM microcode 
*				files in /etc/digi/em_modem
*
**********************************************************************/

int
get_flr_name (void)
{
	FILE *lsfd = NULL;

	char	buf[256],
			default_rev[] = "00.00",
			*rev_txt,
			*product_txt;

	int	i,
		j,
		left,
		right,
		rtn = 0;

	/*
	*  Initialize globals and local variables
	*/

	flashrom_c = 0;
	sprintf (buf, "cd %s 2>/dev/null;ls *.flrom 2>/dev/null",
	 modem_dir);

	/*
	*  Issue the ls command
	*/

	if ((lsfd = popen (buf, "r")) == NULL)
	{
		rtn = -1;
		goto flr_done;
	}

	for (i = 0; i < MAX_REVS; ++i)
	{
		if (fscanf (lsfd, "%s", flashrom_n[i]) != 1)
			break;

	}

	/*
	*  Close the pipe
	*/

	pclose (lsfd);
	lsfd = NULL;

	/*
	*  For each Flash ROM file:
	*  If possible, determine revision level
	*  Assign a loader file name
	*/

	if ((flashrom_c = i) == 0)
	{
		rtn = -1;
		goto flr_done;
	}

	for (i = 0; i < flashrom_c; ++i)
	{

		/*
		*  The following code allows flash ROM files for 1633
		*  and 1634 AC chipsets to be found and loaded into
		*  their respective modem em modules.  These chipsets 
		*  will exist only at Digi and will not ever be shipped 
		*  to customers.  If at some time the capability to load
		*  1633 and 1634 AC chipsets is to be removed, replace
		*  the code that copies default_rev into flashrom_r[i]
		*  with code that copies "Invalid" into flashrom_r[i].
		*
		*  Customers will have the 1634 AE chipset
		*  only.  The flash ROM file for a 1634 AE chipset will
		*  have in its fourth line two fields:
		*  The flash ROM revision number and the product ID.
		*  The revision number is of the form nn.nn, nn.nnn, or
		*  nn.nnnn and is encoded.  It is preceded and followed by
		*  the four character string "0D0A".  Revision number
		*  01.12 would be found as "0D0A30312E31320D0A".  The string
		*  is always followed by a "00".  If of the form 
		*  nn.nn, the "00" is also followed by "FFFF".  If of the form
		*  nn.nnn, the "00" is followed by "FF".  The revision 
		*  number string is followed by the product id string
		*  which must be "00000001".  Examples:
		*  "OD0A30312E31320D0A00FFFF00000001"
		*  "0D0A30312E3132310D0A00FF00000001"
		*  "0D0A30312E313231330D0A0000000001"
		*/

		/* For now, only one loader for all chipsets */

		strcpy (loader_n[i], flashrom_loader);

		sprintf (buf, "%s%s", modem_dir, flashrom_n[i]);

		if ((lsfd = fopen(buf, "r")) == NULL)
		{
			/* Can't open the file, set invalid revision */

			strcpy (flashrom_r[i], "Invalid");
			goto flr_file;
		}

		/* Advance to the fourth line of the file */

		for (j = 0; j < 4; ++j)
			if ((fgets (buf, sizeof (buf), lsfd) == NULL) ||
			 (strlen (buf) == sizeof (buf)))
			{
				/* Line is too long, can't be flash ROM */

				strcpy (flashrom_r[i], "Invalid");
				goto flr_file;
			}

		/* first character of the line must be ':' */

		if (buf[0] != ':')
		{
			/* No colon, can't be flash ROM */

			strcpy (flashrom_r[i], "Invalid");
			goto flr_file;
		}

		/* See if we can find a revision number */

		for (j = 1; j < (int)strlen (buf); ++j)
			if (strncmp(&buf[j], "0D0A", 4) == 0)
				break;

		j += 4;

		if (j >= (int)strlen (buf))
		{
			/* Reached end of line, put in default revision number */

			strcpy (flashrom_r[i], default_rev);
			goto flr_file;
		}

		rev_txt = &buf[j];

		/* Found what looks to be the rev number, look for trailer */

		for (j = 0; j < (int)strlen (rev_txt); ++j)
			if (strncmp(&rev_txt[j], "0D0A", 4) == 0)
				break;

		if ((j == strlen (rev_txt)) || (j == 0))
		{
			/* Reached end of line, put in default revision number */

			strcpy (flashrom_r[i], default_rev);
			goto flr_file;
		}

		rev_txt[j] = 0x00;

		/* Now point to the possible start of the product id field */

		product_txt = rev_txt + j + 6;

		if (strlen (rev_txt) == 10)
		{
			if (sscanf (rev_txt, "%4x2E%4x", &left, &right) != 2)
			{
				/* Not as expected, put in default revision number */

				strcpy (flashrom_r[i], default_rev);
				goto flr_file;
			}

			/* looks like what we want, put it where it belongs */

			sprintf (flashrom_r[i], "%c%c.%c%c",
			 (left >> 8) & 0xff, left & 0xff,
			 (right >> 8) & 0xff, right & 0xff);

			/* Adjust product id pointer for 4 bytes of pad */

			product_txt += 4;
		}

		else if (strlen (rev_txt) == 12)
		{
			if (sscanf (rev_txt, "%4x2E%6x", &left, &right) != 2)
			{
				/* Not as expected, put in default revision number */

				strcpy (flashrom_r[i], default_rev);
				goto flr_file;
			}

			/* looks like what we want, put it where it belongs */

			sprintf (flashrom_r[i], "%c%c.%c%c%c",
			 (left >> 8) & 0xff, left & 0xff,
			 (right >> 16) & 0xff,
			 (right >> 8) & 0xff, right & 0xff);

			/* Adjust product id pointer for 2 bytes of pad */

			product_txt += 2;
		}

		else if (strlen (rev_txt) == 14)
		{
			if (sscanf (rev_txt, "%4x2E%8x", &left, &right) != 2)
			{
				/* Not as expected, put in default revision number */

				strcpy (flashrom_r[i], default_rev);
				goto flr_file;
			}

			/* looks like what we want, put it where it belongs */

			sprintf (flashrom_r[i], "%c%c.%c%c%c%c",
			 (left >> 8) & 0xff, left & 0xff,
			 (right >> 24) & 0xff, (right >> 16) & 0xff,
			 (right >> 8) & 0xff, right & 0xff);

			/* Product id pointer is correct */
		}
		else
		{
			/* Not as expected, put in default revision number */

			strcpy (flashrom_r[i], default_rev);
			goto flr_file;
		}

		/*
		*  If we get this far, this must be a 1634 AE chipset
		*  The flash ROM file must contain "00000001" in the
		*  product id field, else invalid
		*/

		if (strlen(product_txt) < 8)
		{
			strcpy (flashrom_r[i], "Invalid");
			goto flr_file;
		}
		
		product_txt[8] = 0x00;

		if (strcmp (product_txt, "00000001") != 0)
		{
			strcpy (flashrom_r[i], "Invalid");
			goto flr_file;
		}

flr_file:

		if (lsfd)
		{
			fclose (lsfd);
			lsfd = NULL;
		}

	} /* for (i = 0; i < flashrom_c; ++i) */

flr_done:

	if (debug)
	{
		fprintf (dfp, "***** get_flr *****\n");
		fprintf (dfp, "flashrom_c=%d\n", flashrom_c);
		for (i = 0; i < flashrom_c; ++i)
			fprintf (dfp, "file %d =%s, Rev=%s\n",
			 i, flashrom_n[i], flashrom_r[i]);
		fflush (dfp);
	}

	return (rtn);
}




/**********************************************************************
*
*  Routine Name:	
*
*  Function:	
*
**********************************************************************/

/*
 * This is a kludge to reset a port that is 'stuck',
 * i.e., TBUSY and OFC problems
 */
void
reset_port()
{

#if defined(DXB)
	if (afd == dxbfd)
		return;
#endif /* DXB */

	if (afd == epcafd)
  		rw.rw_board = slot - num_boards1;
	else
  		rw.rw_board = slot;

	if (a_line == 1)
		rw.rw_addr = CHANBUF +
		 ((channel + adapt_info[slot].port_addr[conc]) * 128);
	else
		rw.rw_addr = CHANBUF + ((channel +
		 adapt_info[slot].port_addr[conc + adapt_info[slot].line1conc])
		 * 128);

	/* tbusy is the 75th byte in the channel structure */
	rw.rw_addr = rw.rw_addr + 75; 
	rw.rw_conc = 0;
	rw.rw_req = RW_WRITE;
	rw.rw_size = 1;
	rw.rw_data[0] = 0;

	if (ioctl(afd, DIGI_KME, &rw) != 0) 
	{
		ShowMsg ("Cannot reset (tbusy) the port!");
	}

	/* xval (OFC) is the 83rd byte in the channel structure */
	rw.rw_addr = rw.rw_addr + 83; 
	rw.rw_conc = 0;
	rw.rw_req = RW_WRITE;
	rw.rw_size = 1;
	rw.rw_data[0] = 0;

	if (ioctl(afd, DIGI_KME, &rw) != 0) 
	{
		ShowMsg ("Cannot reset (xval) the port!");
	}
}



/**********************************************************************
*
*  Routine Name:	
*
*  Function:	
*
**********************************************************************/

void 
print_channel ()
{
#ifdef DXB
	char device[32];
	int mfd;
	getset_serial_config_t config ;
	int j;
#endif
        int n;

	char temp[20];
	int i = 0, option = EOF, scr_opt;
	int	rel_conc;

	int test_emm = 0;

	/* 
	 * scr_opt is just used to determine which field to 
	 * highlight.
	 */

	show_panel (ChanPanel);
	update_panels ();
	doupdate ();

	/* 
	 * Make sure conc and a_line are correct for pcxx since they
	 * don't have conc and a_line's!
	 */
	if (adapt_info[slot].bdtype == AVXX_BD ||
		adapt_info[slot].bdtype == PCXX_BD ||
#ifdef DXB
		adapt_info[slot].bdtype == DXB_BD ||
#endif
		strstr (adapt_info[slot].print_type, "Xr "))
	{
		conc = 0;
		a_line = 1;
	}

	while ((option != 'Q') && (option != 'q') && (option != ESC))
	{
		get_channel (channel, &bs);
		wattrset (ChanWin, make_attr (A_NORMAL, WHITE, BLACK));

		if (adapt_info[slot].bdtype == PCXX_BD ||
			adapt_info[slot].bdtype == AVXX_BD ||
#ifdef DXB
			adapt_info[slot].bdtype == DXB_BD ||
#endif
			strstr (adapt_info[slot].print_type, "Xr "))
		{
			wattrset (ChanWin, make_attr (A_BOLD, WHITE, BLACK));
			mvwprintw (ChanWin, 5, 26, "%s Channel %2d",
					   adapt_info[slot].print_type, channel + 1);
			wattroff (ChanWin, make_attr (A_BOLD, WHITE, BLACK));
		}
		else if (adapt_info[slot].bdtype == XEM_BD)
		{
			get_status (slot);

			wattrset (ChanWin, make_attr (A_BOLD, WHITE, BLACK));
			mvwprintw (ChanWin, 1, 2, "Adapter Config:");
			wattroff (ChanWin, make_attr (A_BOLD, WHITE, BLACK));
			mvwprintw (ChanWin, 2, 8, "Number of EBI Modules = %d",
					   adapt_info[slot].nmodules);

			if (scr_opt == 2)
			{
				wattrset (ChanWin, make_attr (A_BOLD, WHITE, BLACK));
				mvwprintw (ChanWin, 5, 26, "EBI - %d", conc + 1);
				wattrset (ChanWin, make_attr (A_NORMAL, WHITE, BLACK));
				wprintw (ChanWin, ", Channel %2d", channel + 1);
			}
			else if (scr_opt == 3)
			{
				wattrset (ChanWin, make_attr (A_NORMAL, WHITE, BLACK));
				mvwprintw (ChanWin, 5, 26, "EBI - %d, ", conc + 1);
				wprintw (ChanWin, "Channel %2d", channel + 1);
				wattroff (ChanWin, make_attr (A_NORMAL, WHITE, BLACK));
			}
			else
			{
				wattrset (ChanWin, make_attr (A_NORMAL, WHITE, BLACK));
				mvwprintw (ChanWin, 5, 26, "EBI - %d,", conc + 1);
				wprintw (ChanWin, " Channel %2d", channel + 1);
				wattroff (ChanWin, make_attr (A_NORMAL, WHITE, BLACK));
			}
		}
		else
		{
			get_status (slot);
			wattrset (ChanWin, make_attr (A_BOLD, WHITE, BLACK));
			mvwprintw (ChanWin, 1, 2, "Adapter Config:");
			wattrset (ChanWin, make_attr (A_NORMAL, WHITE, BLACK));
			mvwprintw (ChanWin, 2, 8, "Line 1 - %d", adapt_info[slot].line1conc);
			mvwprintw (ChanWin, 3, 8, "Line 2 - %d", adapt_info[slot].line2conc);
			mvwprintw (ChanWin, 2, 55, "Sync Packets TxD : ");
			if (host_trans_old < host_transmit)
				sync_trans_index = (sync_trans_index + 1) & 3;
			wprintw (ChanWin, "%s", propeller[sync_trans_index]);
			mvwprintw (ChanWin, 3, 55, "Sync Packets RxD : ");

			if (host_rec_old < host_receive)
				sync_rec_index = (sync_rec_index + 1) & 3;
			wprintw (ChanWin, "%s", propeller[sync_rec_index]);

			if (scr_opt == 1)
			{
				wattrset (ChanWin, make_attr (A_REVERSE | A_STANDOUT, WHITE, BLACK));
				mvwprintw (ChanWin, 5, 21, "Line %d", a_line);
				wattrset (ChanWin, make_attr (A_NORMAL, WHITE, BLACK));
				wprintw (ChanWin, ", Concentrator %d, Channel %2d",
						 conc + 1, channel + 1);
			}
			else if (scr_opt == 2)
			{
				wattrset (ChanWin, make_attr (A_NORMAL, WHITE, BLACK));
				mvwprintw (ChanWin, 5, 21, "Line %d, ", a_line);
				wattrset (ChanWin, make_attr (A_REVERSE | A_STANDOUT, WHITE, BLACK));
				wprintw (ChanWin, "Concentrator %d", conc + 1);
				wattrset (ChanWin, make_attr (A_NORMAL, WHITE, BLACK));
				wprintw (ChanWin, ", Channel %2d", channel + 1);
			}
			else if (scr_opt == 3)
			{
				wattrset (ChanWin, make_attr (A_NORMAL, WHITE, BLACK));
				mvwprintw (ChanWin, 5, 21, "Line %d, Concentrator %d, ",
						   a_line, conc + 1);
				wattrset (ChanWin, make_attr (A_REVERSE | A_STANDOUT, WHITE, BLACK));
				wprintw (ChanWin, "Channel %2d", channel + 1);
				wattrset (ChanWin, make_attr (A_NORMAL, WHITE, BLACK));
			}
			else
			{
				mvwprintw (ChanWin, 5, 21,
						   "Line %d, Concentrator %d, Channel %2d",
						   a_line, conc + 1, channel + 1);
			}
		}

		wattrset (ChanWin, make_attr (A_ALTCHARSET, GREEN, BLACK));
		for (i = 0; i < 62; i++)
			mvwaddch (ChanWin, 6, 8 + i, ACS_HLINE);
		mvwaddch (ChanWin, 6, 7, ACS_ULCORNER);
		mvwaddch (ChanWin, 6, 70, ACS_URCORNER);
		mvwaddch (ChanWin, 7, 7, ACS_VLINE);
		mvwaddch (ChanWin, 7, 70, ACS_VLINE);
		mvwaddch (ChanWin, 8, 7, ACS_VLINE);
		mvwaddch (ChanWin, 8, 70, ACS_VLINE);
		mvwaddch (ChanWin, 9, 7, ACS_VLINE);
		mvwaddch (ChanWin, 9, 70, ACS_VLINE);

		wattrset (ChanWin, make_attr (A_NORMAL, WHITE, BLACK));
		mvwprintw (ChanWin, 13, 24, "Signal Active = ");
		wattrset (ChanWin, make_attr (A_STANDOUT, WHITE, GREEN));
		waddstr (ChanWin, " ");

		wattrset (ChanWin, make_attr (A_NORMAL, WHITE, BLACK));
		mvwaddstr (ChanWin, 13, 46, "Inactive =");
		wattrset (ChanWin, make_attr (A_NORMAL, GREEN, BLACK));
		mvwaddstr (ChanWin, 13, 57, "_");
		wattrset (ChanWin, make_attr (A_NORMAL, WHITE, BLACK));


		if (adapt_info[slot].bdtype == PCXX_BD ||
			adapt_info[slot].bdtype == AVXX_BD ||
#ifdef DXB
			adapt_info[slot].bdtype == DXB_BD ||
#endif
			strstr (adapt_info[slot].print_type, "Xr "))
		{
			mvwaddstr (ChanWin, 9, 13,
					   "TxD  RxD  RTS  CTS  DSR  DCD  DTR  RI  OFC  IFC");
		}
		else if (adapt_info[slot].bdtype == XEM_BD)
		{
			if (f_parallel & bs.ch_flags)	/* Is a parallel port */
				mvwaddstr (ChanWin, 9, 13,
						 "TxD  RxD            IP1  IP2  OP   IP3 OFC  IFC");
			else				   /*  Is a serial port */
				mvwaddstr (ChanWin, 9, 13,
						 "TxD  RxD  RTS  CTS  DSR  DCD  DTR  RI  OFC  IFC");
		}
		else
		{
			if (f_parallel & bs.ch_flags)	/* Is a parallel port */
				mvwaddstr (ChanWin, 9, 13,
				"TxD  RxD  INP       IP1  IP2  OP   IP3 OFC  IFC      (  )");
			else				   /*  Is a serial port */
				mvwaddstr (ChanWin, 9, 13,
				"TxD  RxD  RTS  CTS  DSR  DCD  DTR  RI  OFC  IFC      (  )");
		}

		wattrset (ChanWin, make_attr (A_NORMAL, WHITE, BLACK));
		if (adapt_info[slot].bdtype == PCXX_BD ||
			adapt_info[slot].bdtype == AVXX_BD ||
#ifdef DXB
			adapt_info[slot].bdtype == DXB_BD ||
#endif
			strstr (adapt_info[slot].print_type, "Xr "))
			mvwprintw (ChanWin, 9, 66, "   ");
		else if (adapt_info[slot].bdtype == XEM_BD)
			mvwprintw (ChanWin, 9, 66, "%s", adapt_info[slot].modtype[conc]);
		else if (a_line == 1)
		{
			if (!Strcmp (cons_tbl[conc], "AC"))
				wattrset (ChanWin, make_attr (A_STANDOUT, GREEN, BLACK));
			else
				wattrset (ChanWin, make_attr (A_STANDOUT, RED, BLACK));

			mvwprintw (ChanWin, 9, 67, "%s", cons_tbl[conc]);
			wattrset (ChanWin, make_attr (A_NORMAL, GREEN, BLACK));
		}
		else
		{
			if (!Strcmp (cons_tbl[conc + adapt_info[slot].line1conc], "AC"))
				wattrset (ChanWin, make_attr (A_STANDOUT, GREEN, BLACK));
			else
				wattrset (ChanWin, make_attr (A_STANDOUT, RED, BLACK));

			mvwprintw (ChanWin, 9, 67, "%s", cons_tbl[conc + adapt_info[slot].line1conc]);
			wattrset (ChanWin, make_attr (A_NORMAL, GREEN, BLACK));
		}

		wattrset (ChanWin, make_attr (A_ALTCHARSET, GREEN, BLACK));
		mvwaddch (ChanWin, 10, 7, ACS_VLINE);
		mvwaddch (ChanWin, 10, 70, ACS_VLINE);
		mvwaddch (ChanWin, 11, 7, ACS_VLINE);
		mvwaddch (ChanWin, 11, 70, ACS_VLINE);
		mvwaddch (ChanWin, 12, 7, ACS_LLCORNER);
		mvwaddch (ChanWin, 12, 70, ACS_LRCORNER);

		for (i = 0; i < 62; i++)
			mvwaddch (ChanWin, 12, 8 + i, ACS_HLINE);

		wattrset (ChanWin, make_attr (A_NORMAL, GREEN, BLACK));

		if (bs.tx_head != bs.tx_tail)
		{
			wattrset (ChanWin, make_attr (A_STANDOUT|A_BLINK, WHITE, GREEN));
			mvwaddstr (ChanWin, 10, 14, "X");
			wattrset (ChanWin, make_attr (A_NORMAL, GREEN, BLACK));
		}
		else
			mvwaddstr (ChanWin, 10, 14, "_");

		if (bs.rx_head != bs.rx_tail)
		{
			wattrset (ChanWin, make_attr (A_STANDOUT|A_BLINK, WHITE, GREEN));
			mvwaddstr (ChanWin, 10, 19, "X");
			wattrset (ChanWin, make_attr (A_NORMAL, GREEN, BLACK));
		}
		else
			mvwaddstr (ChanWin, 10, 19, "_");

		if (bs.m_stat & XDM_RTS)
		{
			wattrset (ChanWin, make_attr (A_STANDOUT, WHITE, GREEN));
			mvwaddstr (ChanWin, 10, 24, " ");
			wattrset (ChanWin, make_attr (A_NORMAL, GREEN, BLACK));
		}
		else
			mvwaddstr (ChanWin, 10, 24, "_");

		if (bs.m_stat & XDM_CTS)
		{
			wattrset (ChanWin, make_attr (A_STANDOUT, WHITE, GREEN));
			mvwaddstr (ChanWin, 10, 29, " ");
			wattrset (ChanWin, make_attr (A_NORMAL, GREEN, BLACK));
		}
		else
			mvwaddstr (ChanWin, 10, 29, "_");

#ifdef DXB


		if (adapt_info[slot].bdtype == DXB_BD)  {

#ifdef UW7
	//... for devices 0-7 /* 8 boards supported */
	for (i=0; i < 8; i++ ) {
		for (j=1; j < 7; j++ ) {

			sprintf(device, "/dev/dxb%drasmon%d", i,j);
			if (!access (device, F_OK))	   /* File Exists */
			{
				if ((mfd = open(device, O_RDWR | O_NONBLOCK) ) > 0) {
					i = 1000; // to break out from the j loop
					break;
				}
			} 
		} // for i
	} // for j

#elif (defined(HPUX) || defined(SCO))
			for( n = FIRST_TRACE_CHAN; n < TRACE_CHAN_COUNT + FIRST_TRACE_CHAN;
			     n++ ) {
				/* try all devices */

				MK_DEV_NAME( device, DEVDIR, n, slot - (num_boards1 + num_boards2 + num_boards3 + num_boards4) );

				if( ( mfd=open( device, O_RDWR ) ) != -1 ) {
					break;
				}
			}

			if( n >= TRACE_CHAN_COUNT + FIRST_TRACE_CHAN ) {
				fprintf( stderr, "Cannot open device %s", device );
			}

#else
			sprintf(device, DXB_MGMT5DEV, slot - (num_boards1 + num_boards2 + num_boards3 + num_boards4));
			
			if ((mfd = open(device, O_RDONLY)) < 0)
			{
			    	if (debug) {
				    fprintf (dfp, "Can not open management device - %s.\n", strerror(errno));
				    fflush (dfp);
			    	}
				fprintf(stderr, "Can not open management device %s.\n", device);
			}

#endif 

		        config.channel = channel;

		        if (ioctl(mfd, GET_SERIAL_CONFIG, &config) != 0) {


			    	if (debug)
				{
				    fprintf (dfp, "GET_SERIAL_CONFIG failed: %s\n", strerror(errno));
				    fflush (dfp);
				}
		                perror("GET_SERIAL_CONFIG ioctl failed");
		        }
		
			if (debug)
			{
				fprintf (dfp, "***** Debug GET_SERIAL_CONFIG *****\n");
				fprintf (dfp, "mfd: %d\n", mfd);
				fprintf (dfp, "Channel: %d\n", config.channel);
				fprintf (dfp, "Altpin: %d\n", config.config.alt_pin);
#ifdef SOLARIS
				if (SOL_DEBUG)
					print_serial_config(&config.config);
#endif
				fflush (dfp);
			}
			close(mfd);

		        if (config.config.alt_pin == SERIAL_ALTPIN_ON) {
				bs.iflag |= HW_ALTPIN;
			} else {
				bs.iflag &= ~HW_ALTPIN;
			}
		}

#endif /* end DXB */

		if (((bs.iflag & HW_ALTPIN) && (bs.m_stat & XDM_CD)) ||
		    (!(bs.iflag & HW_ALTPIN) && (bs.m_stat & XDM_DSR)))
		{
			wattrset (ChanWin, make_attr (A_STANDOUT, WHITE, GREEN));
			mvwaddstr (ChanWin, 10, 34, " ");
			wattrset (ChanWin, make_attr (A_NORMAL, GREEN, BLACK));
		}
		else
			mvwaddstr (ChanWin, 10, 34, "_");

		if (((bs.iflag & HW_ALTPIN) && (bs.m_stat & XDM_DSR)) ||
		    (!(bs.iflag & HW_ALTPIN) && (bs.m_stat & XDM_CD)))
		{
			wattrset (ChanWin, make_attr (A_STANDOUT, WHITE, GREEN));
			mvwaddstr (ChanWin, 10, 39, " ");
			wattrset (ChanWin, make_attr (A_NORMAL, GREEN, BLACK));
		}
		else
			mvwaddstr (ChanWin, 10, 39, "_");

		if (bs.m_stat & XDM_DTR)
		{
			wattrset (ChanWin, make_attr (A_STANDOUT, WHITE, GREEN));
			mvwaddstr (ChanWin, 10, 44, " ");
			wattrset (ChanWin, make_attr (A_NORMAL, GREEN, BLACK));
		}
		else
			mvwaddstr (ChanWin, 10, 44, "_");

		if (bs.m_stat & XDM_RI)
		{
			wattrset (ChanWin, make_attr (A_STANDOUT, WHITE, GREEN));
			mvwaddstr (ChanWin, 10, 49, " ");
			wattrset (ChanWin, make_attr (A_NORMAL, GREEN, BLACK));
		}
		else
			mvwaddstr (ChanWin, 10, 49, "_");

		/* OFC */
#if defined(DXB) && !defined(LINUX)
		if (adapt_info[slot].bdtype == DXB_BD) {
			if (XDM_OUT_FLOW) {
				wattrset (ChanWin, make_attr (A_STANDOUT, WHITE, GREEN));
				mvwaddstr (ChanWin, 10, 53, " ");
				wattrset (ChanWin, make_attr (A_NORMAL, GREEN, BLACK));
			} else
				mvwaddstr (ChanWin, 10, 53, "_");
		} else
#endif
		if ((bs.hflow & ~bs.m_stat) & (XDM_CTS | XDM_CD | XDM_DSR | XDM_RI))
		{
			wattrset (ChanWin, make_attr (A_STANDOUT, WHITE, GREEN));
			mvwaddstr (ChanWin, 10, 53, " ");
			wattrset (ChanWin, make_attr (A_NORMAL, GREEN, BLACK));
		}
		else if (adapt_info[slot].bdtype == PCXX_BD)
		{
			if (bs.m_stat & 0x1)
			{
				wattrset (ChanWin, make_attr (A_STANDOUT, WHITE, GREEN));
				mvwaddstr (ChanWin, 10, 53, " ");
				wattrset (ChanWin, make_attr (A_NORMAL, GREEN, BLACK));
			}
			else
				mvwaddstr (ChanWin, 10, 53, "_");
		}
		else if (bs.m_stat & 0x4)
		{
			wattrset (ChanWin, make_attr (A_STANDOUT, WHITE, GREEN));
			mvwaddstr (ChanWin, 10, 53, " ");
			wattrset (ChanWin, make_attr (A_NORMAL, GREEN, BLACK));
		}
		else
			mvwaddstr (ChanWin, 10, 53, "_");

		/* IFC */
#if defined(DXB) && !defined(LINUX)
		if (adapt_info[slot].bdtype == DXB_BD) {
			if (XDM_IN_FLOW)
			{
				wattrset (ChanWin, make_attr (A_STANDOUT, WHITE, GREEN));
				mvwaddstr (ChanWin, 10, 58, " ");
				wattrset (ChanWin, make_attr (A_NORMAL, GREEN, BLACK));
			} else
				mvwaddstr (ChanWin, 10, 58, "_");
		} else
#endif
		if ((bs.hflow & ~bs.m_stat) & (XDM_RTS | XDM_DTR))
		{
			wattrset (ChanWin, make_attr (A_STANDOUT, WHITE, GREEN));
			mvwaddstr (ChanWin, 10, 58, " ");
			wattrset (ChanWin, make_attr (A_NORMAL, GREEN, BLACK));
		}
		else if (adapt_info[slot].bdtype == PCXX_BD)
		{
			if (bs.m_stat & 0x4)
			{
				wattrset (ChanWin, make_attr (A_STANDOUT, WHITE, GREEN));
				mvwaddstr (ChanWin, 10, 58, " ");
				wattrset (ChanWin, make_attr (A_NORMAL, GREEN, BLACK));
			}
			else
				mvwaddstr (ChanWin, 10, 58, "_");
		}
		else if (bs.m_stat & 0x8)
		{
			wattrset (ChanWin, make_attr (A_STANDOUT, WHITE, GREEN));
			mvwaddstr (ChanWin, 10, 58, " ");
			wattrset (ChanWin, make_attr (A_NORMAL, GREEN, BLACK));
		}
		else
			mvwaddstr (ChanWin, 10, 58, "_");

		wattrset (ChanWin, make_attr (A_BOLD, WHITE, BLACK));
		mvwaddstr (ChanWin, 14, 1, "  Input Modes ");
		wattrset (ChanWin, make_attr (A_NORMAL, WHITE, BLACK));
		wprintw (ChanWin, "                                                           ");
		wmove (ChanWin, 14, 15);

		if (bs.iflag & HW_IGNBRK)
			wprintw (ChanWin, ":IGNBRK");
		if (bs.iflag & HW_BRKINT)
			wprintw (ChanWin, ":BRKINT");
		if (bs.iflag & HW_IGNPAR)
			wprintw (ChanWin, ":IGNPAR");
		if (bs.iflag & HW_PARMRK)
			wprintw (ChanWin, ":PARMRK");
		if (bs.iflag & HW_INPCK)
			wprintw (ChanWin, ":INPCK");
		if (bs.iflag & HW_ISTRIP)
			wprintw (ChanWin, ":ISTRIP");
		if (bs.iflag & 0x40)
			wprintw (ChanWin, ":ITOSS");
		if (bs.iflag & HW_IXON)
			wprintw (ChanWin, ":IXON");
		if (bs.iflag & HW_IXANY)
			wprintw (ChanWin, ":IXANY");
		if (bs.iflag & HW_IXOFF)
			wprintw (ChanWin, ":IXOFF");
		if (bs.iflag & DIGI_AIXON)
			wprintw (ChanWin, ":IXONA");
		if (bs.iflag & HW_DOSMODE)
			wprintw (ChanWin, ":DOSMODE");

		wprintw (ChanWin, ":");
		wattrset (ChanWin, make_attr (A_BOLD, WHITE, BLACK));
		mvwprintw (ChanWin, 15, 1, " Output Modes ");
		wattrset (ChanWin, make_attr (A_NORMAL, WHITE, BLACK));
		wprintw (ChanWin, "                                                           ");
		wmove (ChanWin, 15, 15);

		if (bs.oflag & HW_XCASE)
			wprintw (ChanWin, ":XCASE");
		if (bs.oflag & HW_OLCUC)
			wprintw (ChanWin, ":OLCUC");
		if (bs.oflag & HW_ONLCR)
			wprintw (ChanWin, ":ONLCR");
		if (bs.oflag & HW_OCRNL)
			wprintw (ChanWin, ":OCRNL");
		if (bs.oflag & HW_ONOCR)
			wprintw (ChanWin, ":ONOCR");
		if (bs.oflag & HW_ONLRET)
			wprintw (ChanWin, ":ONLRET");
		if (bs.oflag & HW_OFILL)
			wprintw (ChanWin, ":OFILL");
		if (bs.oflag & HW_OFDEL)
			wprintw (ChanWin, ":OFDEL");
		if (bs.oflag & HW_NL1)
			wprintw (ChanWin, ":NLDLY");

		if ((bs.oflag & HW_CR3) == HW_CR3)
			wprintw (ChanWin, ":CR3");
		else
		{
			if (bs.oflag & HW_CR1)
				wprintw (ChanWin, ":CR1");
			if (bs.oflag & HW_CR2)
				wprintw (ChanWin, ":CR2");
		}

		if ((bs.oflag & HW_TAB3) == HW_TAB3)
			wprintw (ChanWin, ":TAB3");
		else
		{
			if (bs.oflag & HW_TAB1)
				wprintw (ChanWin, ":TAB1");
			if (bs.oflag & HW_TAB2)
				wprintw (ChanWin, ":TAB2");
		}

		if (bs.oflag & HW_BS1)
			wprintw (ChanWin, ":BS1");
		if (bs.oflag & HW_VT1)
			wprintw (ChanWin, ":VT1");
		if (bs.oflag & HW_FF1)
			wprintw (ChanWin, ":FF1");

		wprintw (ChanWin, ":");
		wattrset (ChanWin, make_attr (A_BOLD, WHITE, BLACK));
		mvwprintw (ChanWin, 16, 1, "Control Modes ");
		wattrset (ChanWin, make_attr (A_NORMAL, WHITE, BLACK));
		/*
		 * clear the field, then write the new one
		 */
		wprintw (ChanWin, "                                                              ");
		wmove (ChanWin, 16, 15);

		/* If baud > 0 and FASTBAUD is on and not SmartPort */

		/*
		*  The tables are based on the "long fbaud_ [7][16]" table
		*  found in ditty.c
		* 
		* For adapters under dxb control, get the true speed straight
		* from the management channel and ignore any fastbaud tables.
		*
		*/

#ifdef DXB
		if (adapt_info[slot].bdtype != DXB_BD) 
#endif
		{
			if ((bs.cflag & HW_CBAUD) && (bs.cflag & HW_HUPCL))
			
				wprintw (ChanWin, "%s",
				 fastbaud [adapt_info[slot].bdtype] [bs.cflag & HW_CBAUD]);
			
			else
	
				wprintw (ChanWin, "%s", slowbaud[bs.cflag & HW_CBAUD]);
		} 
#ifdef DXB
		else {
			wprintw (ChanWin, "%d", dxb_port_speed);
		}
#endif

		switch (bs.cflag & HW_CSIZE)
		{
		case HW_CS5:
			wprintw (ChanWin, ":5 Char Bits");
			break;
		case HW_CS6:
			wprintw (ChanWin, ":6 Char Bits");
			break;
		case HW_CS7:
			wprintw (ChanWin, ":7 Char Bits");
			break;
		case HW_CS8:
			wprintw (ChanWin, ":8 Char Bits");
			break;
		default:
			wprintw (ChanWin, ":No Char Bits");
			break;
		}

		if (bs.cflag & HW_CSTOPB)
			wprintw (ChanWin, ":2 Stop Bits");
		else
			wprintw (ChanWin, ":1 Stop Bits");

		if (bs.cflag & HW_PARENB)
		{
			if (bs.cflag & HW_PARODD)
				wprintw (ChanWin, ":Parity Odd");
			else
				wprintw (ChanWin, ":Parity Even");
		}
		else
		{
			wprintw (ChanWin, ":No Parity");
		}

#ifdef DXB
		if (adapt_info[slot].bdtype != DXB_BD)
#endif
		{
			/* If FASTBAUD is on */
			if (bs.cflag & HW_HUPCL)
				wprintw (ChanWin, ":Fast Baud");
		}

		wattrset (MainWin, make_attr (A_NORMAL, WHITE, BLUE));

		if ((adapt_info[slot].bdtype == XEM_BD) ||
			(adapt_info[slot].bdtype == PCXX_BD))
		{
			Chan_usage = 0;

			if (adapt_info[slot].emm_conc[conc] & EMM_XEM)
				commandline (clbuf, helpstr, "ESC=Quit", lrudstr,
				 "M=LoadModem", "T=LoopBack", "^P=Print",
				 NULL);
			else
				commandline (clbuf, helpstr, "ESC=Quit", lrudstr,
				 "T=LoopBack", "^P=Print", NULL);
		}
		else
		{
			Chan_usage = 1;

			if (a_line == 1)
				rel_conc = conc;
			else
				rel_conc = conc +
				adapt_info[slot].line1conc;

			if (adapt_info[slot].emm_conc[rel_conc] & test_emm)
				commandline (clbuf, helpstr, "ESC=Quit", lrudstr,
				 "N=Change Line", "M=LoadModem", "T=LoopBack",
				  "^P=Print", NULL);
			else
				commandline (clbuf, helpstr, "ESC=Quit", lrudstr,
				 "N=Change Line", "T=LoopBack", "^P=Print",
				 NULL);
		}

		mvwprintw (MainWin, KEY_LINE, 0, clbuf);
		wattroff (MainWin, make_attr (A_NORMAL, WHITE, BLUE));
		wrefresh (MainWin);
		wrefresh (ChanWin);

		change_term (0, TIMEOUT);

		/*
		 * If the user hasn't selected anything keep doing the 
		 * original screen. 
		 */

		switch (option = getch ())
		{
		case EOF:
			scr_opt = 0;
			break;
		case ctrl ('L'):
			refresh_screen ();
			break;
#ifdef KEY_LEFT
		case KEY_LEFT:
#endif
		case 'h':
			if (adapt_info[slot].bdtype == PCXX_BD ||
			adapt_info[slot].bdtype == AVXX_BD ||
#ifdef DXB
			adapt_info[slot].bdtype == DXB_BD ||
#endif
				strstr (adapt_info[slot].print_type, "Xr "))
			{
				if (channel > 0)
					channel--;
				else
					channel = adapt_info[slot].nports - 1;
			}
			else if (adapt_info[slot].bdtype == XEM_BD)
			{

				if (channel > 0)
					channel--;
				else
					channel = adapt_info[slot].nports_conc[conc] [0] - 1;

			}
			else
			{
				if (channel > 0)
					channel--;
				else
					/* check for C/CON-8 or C/CON-16 */
					if (strstr(adapt_info[slot].print_type, "C/X") ||
					   (strstr(adapt_info[slot].print_type, "EPC/X"))) 
					{

						if (a_line == 1)
							rel_conc = conc;
						else
							 rel_conc = conc +
							 adapt_info[slot].line1conc;

						channel =
						 adapt_info[slot].nports_conc[rel_conc] [0] +
						 adapt_info[slot].nports_conc[rel_conc] [1] +
						 adapt_info[slot].nports_conc[rel_conc] [2] +
						 adapt_info[slot].nports_conc[rel_conc] [3] - 1;
					}

				if (channel < (int)adapt_info[slot].nports_conc[rel_conc] [0])
					test_emm = 0;
				else if
				 (channel < (int)adapt_info[slot].nports_conc[rel_conc] [0] +
				 (int)adapt_info[slot].nports_conc[rel_conc] [1])
					test_emm = EMM_EPC1;
				else if
				 (channel < (int)adapt_info[slot].nports_conc[rel_conc] [0] +
				 (int)adapt_info[slot].nports_conc[rel_conc] [1] +
				 (int)adapt_info[slot].nports_conc[rel_conc] [2])
					test_emm = EMM_EPC2;
				else
					test_emm = EMM_EPC3;

			}
			 
			scr_opt = 3;
			break;
#ifdef KEY_RIGHT
		case KEY_RIGHT:
#endif
		case 'l':
			if (adapt_info[slot].bdtype == PCXX_BD ||
			adapt_info[slot].bdtype == AVXX_BD ||
#ifdef DXB
			adapt_info[slot].bdtype == DXB_BD ||
#endif
				strstr (adapt_info[slot].print_type, "Xr "))
			{
				if (channel < (int) adapt_info[slot].nports - 1)
					channel++;
				else
					channel = 0;
			}
			else if (adapt_info[slot].bdtype == XEM_BD)
			{

				if (channel < (int)adapt_info[slot].nports_conc[conc] [0] - 1)
					channel++;
				else
					channel = 0;
			}
			else
			{
				/* EPCX or C/X */

				if (a_line == 1)
					rel_conc = conc;
				else
					rel_conc = conc + adapt_info[slot].line1conc;
					
				if (channel < 
				 (int)adapt_info[slot].nports_conc[rel_conc] [0] +
				 (int)adapt_info[slot].nports_conc[rel_conc] [1] +
				 (int)adapt_info[slot].nports_conc[rel_conc] [2] +
				 (int)adapt_info[slot].nports_conc[rel_conc] [3] - 1)
						channel++;
					else
						channel = 0;

				if (channel < (int)adapt_info[slot].nports_conc[rel_conc] [0])
					test_emm = 0;
				else if
				 (channel < (int)adapt_info[slot].nports_conc[rel_conc] [0] +
				 (int)adapt_info[slot].nports_conc[rel_conc] [1])
					test_emm = EMM_EPC1;
				else if
				 (channel < (int)adapt_info[slot].nports_conc[rel_conc] [0] +
				 (int)adapt_info[slot].nports_conc[rel_conc] [1] +
				 (int)adapt_info[slot].nports_conc[rel_conc] [2])
					test_emm = EMM_EPC2;
				else
					test_emm = EMM_EPC3;
			}
			 
			scr_opt = 3;
			break;
#ifdef KEY_UP
		case KEY_UP:
#endif
		case ctrl ('K'):
		case 'k':
			/* PCXX has no lines and conc's */
			if (adapt_info[slot].bdtype == PCXX_BD ||
			adapt_info[slot].bdtype == AVXX_BD ||
#ifdef DXB
			adapt_info[slot].bdtype == DXB_BD ||
#endif
				strstr (adapt_info[slot].print_type, "Xr "))
				break;
			if ((a_line == 1) && (adapt_info[slot].line1conc == 1))
			{
				(void) write (1, &beepc, 1);
				wattrset (ChanWin, make_attr (A_BOLD, WHITE, BLACK));
				mvwaddstr (ChanWin, 15, 55, "No more on line 1");
				wattroff (ChanWin, make_attr (A_BOLD, WHITE, BLACK));
				wrefresh (ChanWin);
				sleep (1);
				mvwaddstr (ChanWin, 15, 55, "                 ");
				wrefresh (ChanWin);
			}
			else if ((a_line == 2) && (adapt_info[slot].line2conc == 1))
			{
				(void) write (1, &beepc, 1);
				wattrset (ChanWin, make_attr (A_BOLD, WHITE, BLACK));
				mvwaddstr (ChanWin, 15, 55, "No more on line 2");
				wattroff (ChanWin, make_attr (A_BOLD, WHITE, BLACK));
				wrefresh (ChanWin);
				sleep (1);
				mvwaddstr (ChanWin, 15, 55, "                 ");
				wrefresh (ChanWin);
			}
			else if
			 ((a_line == 1) && (conc + 1 < adapt_info[slot].line1conc))
			{
				conc++;
				channel = 0;
			}
			else if
			 ((a_line == 2) && (conc + 1 < adapt_info[slot].line2conc))
			{
				conc++;
				channel = 0;
			}
			else
			{
				conc = 0;
				channel = 0;
			}

			if (a_line == 1)
				rel_conc = conc;
			else
				rel_conc = conc + adapt_info[slot].line1conc;

			if (channel < (int)adapt_info[slot].nports_conc[rel_conc] [0])
				test_emm = 0;
			else if
			 (channel < (int)adapt_info[slot].nports_conc[rel_conc] [0] +
			 (int)adapt_info[slot].nports_conc[rel_conc] [1])
				test_emm = EMM_EPC1;
			else if
			 (channel < (int)adapt_info[slot].nports_conc[rel_conc] [0] +
			 (int)adapt_info[slot].nports_conc[rel_conc] [1] +
			 (int)adapt_info[slot].nports_conc[rel_conc] [2])
				test_emm = EMM_EPC2;
			else
				test_emm = EMM_EPC3;
			 
			scr_opt = 2;
			break;
#ifdef KEY_DOWN
		case KEY_DOWN:
#endif
		case ctrl ('J'):
		case 'j':
			/* PCXX has no lines and conc's */
			if (adapt_info[slot].bdtype == PCXX_BD ||
				adapt_info[slot].bdtype == AVXX_BD ||
#ifdef DXB
				adapt_info[slot].bdtype == DXB_BD ||
#endif
				strstr (adapt_info[slot].print_type, "Xr "))
				break;
			if ((a_line == 1) && (adapt_info[slot].line1conc == 1))
			{
				(void) write (1, &beepc, 1);
				wattrset (ChanWin, make_attr (A_BOLD, WHITE, BLACK));
				mvwaddstr (ChanWin, 15, 55, "No more on line 1");
				wattroff (ChanWin, make_attr (A_BOLD, WHITE, BLACK));
				wrefresh (ChanWin);
				sleep (1);
				mvwaddstr (ChanWin, 15, 55, "                 ");
				wrefresh (ChanWin);
			}
			else if ((a_line == 2) && (adapt_info[slot].line2conc == 1))
			{
				(void) write (1, &beepc, 1);
				wattrset (ChanWin, make_attr (A_BOLD, WHITE, BLACK));
				mvwaddstr (ChanWin, 15, 55, "No more on line 2");
				wattroff (ChanWin, make_attr (A_BOLD, WHITE, BLACK));
				wrefresh (ChanWin);
				sleep (1);
				mvwaddstr (ChanWin, 15, 55, "                 ");
				wrefresh (ChanWin);
			}
			else if ((a_line == 1) && (conc == 0))
			{
				if (adapt_info[slot].line1conc)
					conc = adapt_info[slot].line1conc - 1;
				else
					conc = 0;
				channel = 0;
			}
			else if ((a_line == 2) && (conc == 0))
			{
				if (adapt_info[slot].line2conc)
					conc = adapt_info[slot].line2conc - 1;
				else
					conc = 0;
				channel = 0;
			}
			else
			{
				conc--;
				channel = 0;
			}

			if (a_line == 1)
				rel_conc = conc;
			else
				rel_conc = conc + adapt_info[slot].line1conc;

			if (channel < (int)adapt_info[slot].nports_conc[rel_conc] [0])
				test_emm = 0;
			else if
			 (channel < (int)adapt_info[slot].nports_conc[rel_conc] [0] +
			 (int)adapt_info[slot].nports_conc[rel_conc] [1])
				test_emm = EMM_EPC1;
			else if
			 (channel < (int)adapt_info[slot].nports_conc[rel_conc] [0] +
			 (int)adapt_info[slot].nports_conc[rel_conc] [1] +
			 (int)adapt_info[slot].nports_conc[rel_conc] [2])
				test_emm = EMM_EPC2;
			else
				test_emm = EMM_EPC3;
			 
			scr_opt = 2;
			break;
		case '1':
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9':
		case 'a':
		case 'b':
		case 'c':
		case 'd':
		case 'e':
		case 'f':
		case 'g':
			/*Watch for 8em and 8em(p) modules */
			/*
			 * if (adapt_info[slot].bdtype == XEM_BD 
			 * && !strstr(adapt_info[slot].print_type, "Xr "))
			 * {
			 * char temp[5];
			 * short numports=0;
			 * Strncpy(temp,
			 * adapt_info[slot].modtype[conc],
			 * 4);
			 * if ((!strncmp(temp,"8em ", 4)) && (option >= '8')) 
			 * break;
			 * else if ((!strncmp(temp,"8emp", 4)) && (option >= 'a')) 
			 * break;
			 * 
			 * }
			 * // PCXX has no lines and conc's //
			 * else if ((adapt_info[slot].bdtype == PCXX_BD ||
			 * strstr(adapt_info[slot].print_type, "Xr "))
			 * && (adapt_info[slot].nports < 9 )
			 * && ((option == '9') || (option >= 'a')))
			 * break;
			 * if (option >= '0' && option <= '9')
			 * channel = option - 49;
			 * else
			 * channel = option - 88;
			 * scr_opt = 3;
			 */
			break;
		case 'N':
		case 'n':
			/* PCXX has no lines and conc's */
			/* this is needed to clear the mode lines */
			mvwprintw (ChanWin, 14, 1,
"                                                                            ");
			mvwprintw (ChanWin, 15, 1,
"                                                                            ");
			mvwprintw (ChanWin, 16, 1,
"                                                                            ");
			wrefresh (ChanWin);
			if (adapt_info[slot].bdtype == PCXX_BD ||
				adapt_info[slot].bdtype == AVXX_BD ||
#ifdef DXB
				adapt_info[slot].bdtype == DXB_BD ||
#endif
				strstr (adapt_info[slot].print_type, "Xr "))
				break;
			if ((a_line == 1) && (adapt_info[slot].line2conc > 0))
			{
				a_line = 2;
				if ( channel >= (int)(adapt_info[slot].nports_conc[conc + adapt_info[slot].line1conc][0]))
				{
					channel = (int)(adapt_info[slot].nports_conc[conc + adapt_info[slot].line1conc][0]) - 1;
				}
			}
			else if ((a_line == 2) && (adapt_info[slot].line1conc > 0))
			{
				a_line = 1;
				if ( channel >= (int)(adapt_info[slot].nports_conc[conc][0]))
				{
					channel = (int)(adapt_info[slot].nports_conc[conc][0]) - 1;
				}
			}
			scr_opt = 1;
			break;

		case 'R':
		case 'r':
			scr_opt = 0;
			if (resetport)
			{
				reset_port();
			}
			else
			{
				mvwprintw (ChanWin, 16, 60, "Invalid key");
				wrefresh (ChanWin);
				sleep (1);
				mvwprintw (ChanWin, 16, 60, "           ");
				wrefresh (ChanWin);
			}
			break;

#ifndef NO_MODEM_OPTS 
		case 'M':
		case 'm':

			/*
			*  User wants to reload em/Modem flash ROM
			*/

			scr_opt = 0;

			if (a_line == 1)
				rel_conc = conc;
			else
				rel_conc = conc + adapt_info[slot].line1conc;

			if ((adapt_info[slot].emm_conc[rel_conc] & EMM_XEM) ||
			 (adapt_info[slot].emm_conc[rel_conc] & test_emm))
			{
				/*
				*  Do the reload
				*/

				print_flashl (EM_PORT, channel);
			}
			else
			{
				mvwprintw (ChanWin, 16, 60, "Invalid key");
				wrefresh (ChanWin);
				sleep (1);
				mvwprintw (ChanWin, 16, 60, "           ");
				wrefresh (ChanWin);
			}
			break;
#endif /* !NO_MODEM_OPTS */

		case 'q':
		case 'Q':
		case ESC:
			hide_panel (ChanPanel);
			erase_win (ChanWin);
			update_panels ();
			doupdate ();
			scr_opt = 0;
			channel = 0;
			break;
		case 'T':
		case 't':
			scr_opt = 0;

			/* if parallel port, loopback is not allowed */
			if (!((adapt_info[slot].bdtype != PCXX_BD &&
				!(adapt_info[slot].bdtype != AVXX_BD) &&
#ifdef DXB
				!(adapt_info[slot].bdtype != DXB_BD) &&
#endif
				   !strstr (adapt_info[slot].print_type, "Xr ")) &&
				  (f_parallel & bs.ch_flags)))
			{
				hide_panel (ChanPanel);
				update_panels ();
				doupdate ();

				if (a_line == 1)
					rel_conc = conc;
				else
					rel_conc = conc + adapt_info[slot].line1conc;

#ifndef NO_MODEM_OPTS
				if ((adapt_info[slot].emm_conc[rel_conc] & EMM_XEM) ||
				 (adapt_info[slot].emm_conc[rel_conc] & test_emm))
					loop_back_modem ();
                                else
#endif /* !NO_MODEM_OPTS*/
#ifdef DXB
				if (adapt_info[slot].bdtype == DXB_BD) 
					dxb_loop_back();
				else
#endif
					loop_back();

				change_term (0, TIMEOUT);

				show_panel (ChanPanel);
				update_panels ();
				doupdate ();
				wrefresh (ChanWin);
			}
			break;
#ifdef KEY_PRINT
		case KEY_PRINT:
#endif
		case ctrl ('P'):
			scr_opt = 0;
			screen_save (ChanWin, logfile);
			touchwin (ChanWin);
			wrefresh (ChanWin);
			update_panels ();
			doupdate ();
			break;
		case KEY_F (1):		   /*  Help info  */
		case '?':
			/* If Parallel Port */
			if ((adapt_info[slot].bdtype != PCXX_BD &&
			 (adapt_info[slot].bdtype != AVXX_BD) &&
#ifdef DXB
			 (adapt_info[slot].bdtype != DXB_BD) &&
#endif
			 !strstr (adapt_info[slot].print_type, "Xr ")) &&
			 (f_parallel & bs.ch_flags))
				info_screen ("dpa_info5", NULL);
			else
				/* If Serial Port */
				info_screen ("dpa_info4", NULL);

			update_panels ();
			doupdate ();
			break;
		default:
			scr_opt = 0;
			mvwprintw (ChanWin, 16, 60, "Invalid key");
			wrefresh (ChanWin);
			sleep (1);
			mvwprintw (ChanWin, 16, 60, "           ");
			wrefresh (ChanWin);
			break;
		}						   /* End Case */
	}							   /* End While */
}



/**********************************************************************
*
*  Routine Name:	
*
*  Function:	
*
**********************************************************************/

void 
DisplayHeader ()
{
	char msg[256];

	wattrset (HeadWin, make_attr (A_NORMAL, WHITE, BLUE));
	fillwin (HeadWin, ' ');
	box (HeadWin, 0, 0);
	wattrset (HeadWin, make_attr (A_BOLD, YELLOW, BLUE));
	sprintf (msg, "Digi Port Authority  version %s", VERSION);
	mvwprintw (HeadWin, 1, center (HeadWin, strlen (msg)), msg);
	sprintf (msg, "Copyright (c) 2000, Digi International Inc.");
	mvwprintw (HeadWin, 2, center (HeadWin, strlen (msg)), msg);
	wattroff (HeadWin, make_attr (A_BOLD, YELLOW, BLUE));
	show_panel (MainPanel);
	show_panel (HeadPanel);
	update_panels ();
	doupdate ();
	wrefresh (MainWin);
	wrefresh (HeadWin);
}



/**********************************************************************
*
*  Routine Name:	
*
*  Function:	
*
**********************************************************************/

void 
CreateWins ()
{
	/* print_channel */
	ChanPanel = new_panel (newwin (18, 78, 5, 1));
	ChanWin = panel_window (ChanPanel);
	wattrset (ChanWin, make_attr (A_NORMAL, CYAN, BLACK));
	box (ChanWin, 0, 0);
	wattroff (ChanWin, make_attr (A_NORMAL, CYAN, BLACK));
	keypad (ChanWin, TRUE);
	leaveok (ChanWin, TRUE);
	hide_panel (ChanPanel);

	/* print_config */
	ConfigPanel = new_panel (newwin (18, 78, 5, 1));
	ConfigWin = panel_window (ConfigPanel);
	wattrset (ConfigWin, make_attr (A_NORMAL, CYAN, BLACK));
	box (ConfigWin, 0, 0);
	wattroff (ConfigWin, make_attr (A_NORMAL, CYAN, BLACK));
	keypad (ConfigWin, TRUE);
	leaveok (ConfigWin, TRUE);
	hide_panel (ConfigPanel);

	/* copyright panel */
	CRPanel = new_panel (newwin (18, 60, 3, 10));
	CRWin = panel_window (CRPanel);
	wattrset (CRWin, make_attr (A_NORMAL, GREEN, BLACK));
	fillwin (CRWin, ' ');
	wattroff (CRWin, make_attr (A_NORMAL, GREEN, BLACK));
	solidbox (CRWin);
	keypad (CRWin, TRUE);
	leaveok (CRWin, TRUE);
	hide_panel (CRPanel);

	/* print_errcounts */
	ErrorPanel = new_panel (newwin (18, 78, 5, 1));
	ErrorWin = panel_window (ErrorPanel);
	wattrset (ErrorWin, make_attr (A_NORMAL, CYAN, BLACK));
	box (ErrorWin, 0, 0);
	wattroff (ErrorWin, make_attr (A_NORMAL, CYAN, BLACK));
	keypad (ErrorWin, TRUE);
	leaveok (ErrorWin, TRUE);
	hide_panel (ErrorPanel);

	/* DisplayHeader */
	HeadPanel = new_panel (newwin (4, COLS, 0, 0));
	HeadWin = panel_window (HeadPanel);
	wattrset (HeadWin, make_attr (A_NORMAL, WHITE, BLUE));
	fillwin (HeadWin, ' ');
	box (HeadWin, 0, 0);
	wattroff (HeadWin, make_attr (A_NORMAL, WHITE, BLUE));
	keypad (HeadWin, TRUE);
	hide_panel (HeadPanel);

	/* print_identify */
	IdentPanel = new_panel (newwin (18, 78, 5, 1));
	IdentWin = panel_window (IdentPanel);
	wattrset (IdentWin, make_attr (A_NORMAL, CYAN, BLACK));
	box (IdentWin, 0, 0);
	wattroff (IdentWin, make_attr (A_NORMAL, CYAN, BLACK));
	keypad (IdentWin, TRUE);
	leaveok (IdentWin, TRUE);
	hide_panel (IdentPanel);

	/* loop_back */
	LBPanel = new_panel (newwin (18, 78, 5, 1));
	LBWin = panel_window (LBPanel);
	wattrset (LBWin, make_attr (A_NORMAL, CYAN, BLACK));
	box (LBWin, 0, 0);
	wattroff (LBWin, make_attr (A_NORMAL, CYAN, BLACK));
	keypad (LBWin, TRUE);
	leaveok (LBWin, TRUE);
	hide_panel (LBPanel);

	/* loop_back */
	FLPanel = new_panel (newwin (18, 78, 5, 1));
	FLWin = panel_window (FLPanel);
	wattrset (FLWin, make_attr (A_NORMAL, CYAN, BLACK));
	box (FLWin, 0, 0);
	wattroff (FLWin, make_attr (A_NORMAL, CYAN, BLACK));
	keypad (FLWin, TRUE);
	leaveok (FLWin, TRUE);
	hide_panel (FLPanel);

	/* always display, this has the background pattern and colors */
	MainPanel = new_panel (newwin (0, 0, 0, 0));
	MainWin = panel_window (MainPanel);
	wattrset (MainWin, make_attr (A_NORMAL, GREEN, WHITE));
#ifdef OSF
	fillwin (MainWin, ' ');
#else
	fillwin (MainWin, 177);
#endif
	wattroff (MainWin, make_attr (A_NORMAL, GREEN, WHITE));
	keypad (MainWin, TRUE);
	leaveok (MainWin, TRUE);
	hide_panel (MainPanel);

	/* print_Xemconf */
	XemPanel = new_panel (newwin (18, 78, 5, 1));
	XemWin = panel_window (XemPanel);
	wattrset (XemWin, make_attr (A_NORMAL, CYAN, BLACK));
	box (XemWin, 0, 0);
	wattroff (XemWin, make_attr (A_NORMAL, CYAN, BLACK));
	keypad (XemWin, TRUE);
	leaveok (XemWin, TRUE);
	hide_panel (XemPanel);

	update_panels ();
	doupdate ();
}



/**********************************************************************
*
*  Routine Name:	
*
*  Function:	
*
**********************************************************************/

void 
DeleteWins ()
{
	hide_panel (HeadPanel);
	hide_panel (MainPanel);
	hide_panel (IdentPanel);
	update_panels ();
	doupdate ();

	del_panel (ChanPanel);
	del_panel (ErrorPanel);
	del_panel (IdentPanel);
	del_panel (LBPanel);
	del_panel (MainPanel);
	del_panel (XemPanel);
	del_panel (FLPanel);

	delwin (ChanWin);
	delwin (ErrorWin);
	delwin (IdentWin);
	delwin (LBWin);
	delwin (MainWin);
	delwin (XemWin);
	delwin (FLWin);

	erase ();
	refresh ();

	/*
	 * put original term settings back
	 */
	restore_term ();
	endwin ();
	close (pcxxfd);
	close (epcafd);
#ifndef MRGDRV
	close (pcxrfd);
	close (aspxfd);
#endif
#ifdef DXB
	close (dxbfd);
#endif

	if (debug)
	{
		fflush (dfp);
		fclose (dfp);
	}
}



/**********************************************************************
*
*  Routine Name:	
*
*  Function:	
*
**********************************************************************/

int 
main (argc, argv)
	int argc;
	char **argv;
{
	int c;
	extern char *optarg;
	char helpfile[1024];

	Strcpy (logfile, "/tmp/dpalog");

	if (getuid () != 0)
	{
		fprintf (stderr, "You must be a super-user to execute %s!\n", argv[0]);
		exit (1);
	}

	/*
	 * If the standard help info path does not exist,
	 * Then we must have been installed by dgap, and 
	 * that path must be used to find the help info.
	 */
	sprintf(helpfile, "%s/dpa_info1", help_dir);
	if (access(helpfile, F_OK) != 0 ) {
		help_dir="/etc/dgap/text/info/";
	}

	while ((c = getopt (argc, argv, "f:l:dm?r")) != -1)
	{
		switch (c)
		{
		case 'f':
		case 'l':
			Strcpy (logfile, optarg);
			break;
		case 'm':
			copyright_msg = FALSE;
			break;
		case 'd':
			dfp = fopen ("/tmp/dpadebug", "w");
			debug = (dfp != NULL) ? TRUE : FALSE;
			break;
		case '?':
			usage ();
			break;
		case 'r':
			resetport = TRUE;
			break;
		default:
			break;
		}						   /* End Case */
	}							   /* End While */

	/*
	check system type 
	*/
	check_svr3();

	/*
	 * Create the release number
	 */
	release_number ();

	/*
	 * Initialize the terminal and internal curses routines
	 */
	StartCurses ();

	/*
	 * create all of the windows and panels
	 */
	CreateWins ();

	/*
	 * Get the current terminal type, and do the right thing
	 */
	TermDepSetup ();

	/*
	 * Try to open the download devices
	 */
	Open_Devs ();

	/*
	 * show copyright info
	 */
	if (copyright_msg)			   /* if being called from MPI, no copyright */
		ShowCopyright ();

	/*
	 * display the header info
	 */
	DisplayHeader ();

	/*
	 * show all the boards, and allow user to select one
	 */
	print_identify ();

	/*
	 * everything is done, delete all the windows and panels
	 */
	DeleteWins ();

	exit (0);
}



#if defined(LINUX)
char *copylist(const char *filenm, off_t *szptr) {
        char	*buf;
        int	 fd;
        int	 ret;
        int	 filesize;
        int	 bytes_read;
        int	 i;
        struct stat statbuf;


        fd = open(filenm, O_RDONLY);
        if(fd < 0) {
                return(NULL);
        }

        ret = fstat(fd, &statbuf);
        if(ret < 0) {
                close(fd);
                return(NULL);
        }
        filesize = statbuf.st_size;

        buf = (char *)malloc(sizeof(char) * filesize);
        if(!buf) {
                close(fd);
                return(NULL);
        }
        memset(buf, 0, filesize);


        while(bytes_read < filesize) {
                ret = read(fd, &buf, filesize);
                if(ret < 0) {
                        if((errno != EINTR) && (errno != EAGAIN)) {
                                perror("read() failure in copylist()");
                                free(buf);
                                close(fd);
                                return(NULL);
                        }
                        ret = 0;
                }
                bytes_read += ret;
        }

        close(fd);


        /* convert all of the newlines to nulls */
        for (i=0; i < filesize; i++) {
                if (buf[i] == '\n')
                        buf[i] = 0;
        }

        *szptr = (off_t)filesize;
        return(buf);
}
#endif

#if defined(DXB)
void
print_serial_config(const serial_config_t * const s)
{
	fprintf(dfp, "\n\t***Debug: GET_SERIAL_CONFIG:*** \n");
	fprintf (dfp,"\tprint_serial_config(){ \n");


 	switch (s->port_type) {
	case SERIAL_PORTTYPE_RS232:
		fprintf(dfp, "\t\t Line Type\t: RS232\n");
		break;

	case SERIAL_PORTTYPE_RS422:
		fprintf(dfp, "\t\t Line Type\t: RS422\n");
		break;

	case SERIAL_PORTTYPE_RS423:
		fprintf(dfp, "\t\t Line Type\t: RS423\n");
		break;

	case SERIAL_PORTTYPE_V35:
		fprintf(dfp, "\t\t Line Type\t: V35\n");
		break;
	}

	/* clock_source */
 	switch (s->clock_source) {
	case SERIAL_CLOCKSOURCE_INT:
		fprintf(dfp, "\t\t Clock Source\t: INT\n");
		break;

	case SERIAL_CLOCKSOURCE_EXT:
		fprintf(dfp, "\t\t Clock Source\t: EXT\n");
		break;

	case SERIAL_CLOCKSOURCE_SPLIT:
		fprintf(dfp, "\t\t Clock Source\t: SPLIT\n");
		break;

	}

 	switch (s->alt_pin) {
	case SERIAL_ALTPIN_OFF:
		fprintf(dfp, "\t\t Alt Pin\t: RJ-45\n");
		break;

	case SERIAL_ALTPIN_ON:
		fprintf(dfp, "\t\t Alt Pin\t: SWAP DCD & DSR\n");
		break;
	default:
		fprintf(dfp, "\t\t Alt Pin\t: 0x%x\n", s->alt_pin);
		break;
	}
	fprintf (dfp,"\t } \n\n");
}

void
print_serial_status(const serial_status_t * const status)
{
	int i;
	int tmp_hold;

	fprintf(dfp, "\n\t**** Debug: GET_SERIAL_STATUS ****\n");
	fprintf(dfp, "\n\t print_serial_status() {\n");

	/* port_state */
	switch(status->port_state) {
    	case SERIAL_CLOSED:
			fprintf(dfp, "\t\tLINE_STATE: \tCLOSED");
			break;

    	case SERIAL_OPEN:
			fprintf(dfp, "\t\tLINE_STATE: \tOPEN");
			if (status->port_state & SERIAL_ACTIVE)
			{
				fprintf(dfp,"/ACTIVE");
			}
			break;

    	case SERIAL_ACTIVE:
			fprintf(dfp, "\t\tLINE_STATE:\t\t ACTIVE");
			break;

		default:
			fprintf(dfp, "\t\tdefault state:\n");
			fprintf(dfp, "\t\tLINE_STATE \t\t: %x \n",status->port_state);
			break;
	}

	/* modem signal states */
	fprintf(dfp, "\n");
	/* modem signals and states */

	for (i=0;i<SERIAL_SIGNAL_MAX;i++) {

	  switch(i) {
	  case SERIAL_SIGNAL_RTS:
		fprintf(dfp, "\t\tRTS:\t\t%s  \n", (status->mdm_sig_state[i] & 2) ? "ON" : "OFF") ;
		break;

	  case SERIAL_SIGNAL_CTS:
		fprintf(dfp, "\t\tCTS:\t\t%s  \n", (status->mdm_sig_state[i] & 2) ? "ON" : "OFF") ;
		break;

	  case SERIAL_SIGNAL_DTR:
		fprintf(dfp, "\t\tDTR:\t\t%s  \n", (status->mdm_sig_state[i] & 2) ? "ON" : "OFF") ;
		break;

	  case SERIAL_SIGNAL_DSR:
		fprintf(dfp, "\t\tDSR:\t\t%s  \n", (status->mdm_sig_state[i] & 2) ? "ON" : "OFF") ;
		break;

	  case SERIAL_SIGNAL_RI:
		fprintf(dfp, "\t\tRI:\t\t%s  \n", (status->mdm_sig_state[i] & 2) ? "ON" : "OFF") ;
		break;

	  case SERIAL_SIGNAL_DCD:
		fprintf(dfp, "\t\tDCD:\t\t%s\n", (status->mdm_sig_state[i] & 2) ? "ON" : "OFF") ;
		break;

	  default:
		break;
	 }
	}

	fprintf(dfp,"\t\tDATA_BITS:");
	/* data_bits */
	switch(status->data_bits) {
	case 1:
		fprintf(dfp, "\t8  ");
		break;

	case 2:
		fprintf(dfp, "\t7  ");
		break;

	case 3:
		fprintf(dfp, "\t6  ");
		break;

	case 4:
		fprintf(dfp, "\t5  ");
		break;

	default :
		fprintf(dfp, "\t0x%x  ",status->data_bits);
		break;
	}


	/* stop_bits */
	fprintf(dfp, "\n\t\tSTOP_BITS:");
	switch( status->stop_bits) {
	case 1:
		fprintf(dfp, "\t1  ");
		break;

	case 2:
		fprintf(dfp, "\t2  ");
		break;

	case 3:
		fprintf(dfp, "\tONE AND ONE HALF  ");
		break;
	default:
		fprintf(dfp, "\t0x%x  ",status->stop_bits);
		break;
	}


	/* parity */
	fprintf(dfp, "\n\t\tPARITY:");
	switch( status->parity) {
	case 1:
		fprintf(dfp, "\t\tNONE");
        	break;
	case 2:
		fprintf(dfp, "\t\tODD");
          	break;
	case 3:
		fprintf(dfp, "\t\tEVEN");
        	break;

	case 4:
		fprintf(dfp, "\t\tSPACE");
            	break;
	case 5:
		fprintf(dfp, "\t\tMARK");
		break;

	default:
		fprintf(dfp, "\t\t0x%x",status->parity);
            	break;
	}

		/* frame_mode */
	fprintf(dfp, " \n");

	switch(status->frame_mode) {
    	case SERIAL_FRAME_NONE:
		fprintf(dfp, "\t\tFRAME_MODE: \tNONE");
		break;

    	case SERIAL_FRAME_ASYNC_SLIP:
		fprintf(dfp, "\t\tFRAME_MODE: \tSLIP");
		break;

    	case SERIAL_FRAME_ASYNC_PPP:
		fprintf(dfp, "\t\tFRAME_MODE: \tPPP");
		break;

    	case SERIAL_FRAME_SYNC_HDLC:
		fprintf(dfp, "\t\tFRAME_MODE: \tHDLC");
		break;
	default:
		fprintf(dfp, "\t\tFRAME_MODE: \t0x%x \n",status->frame_mode);

		break;
	}

	fprintf(dfp, "\n\t\tINPUT FLOW:");
	tmp_hold = 0;
	for (i=0; i< SERIAL_IN_FLOW_MAX;i++) {
		switch(i) {
		case SERIAL_IN_FLOW_XONXOFF_INDEX:
			if (status->in_flow_type[i] & 2) {
				fprintf(dfp, "\t XON/XOFF");
				tmp_hold++;
			}
			break;
	
		case SERIAL_IN_FLOW_RTS_INDEX:
			if (status->in_flow_type[i] & 2) {
				fprintf(dfp, "\t RTS");
				tmp_hold++;
			}
			break;
	
		case SERIAL_IN_FLOW_DTR_INDEX:
			if (status->in_flow_type[i] & 2) {
				fprintf(dfp, "\t DTR");
				tmp_hold++;
			}
			break;
	
		default :
			break;
		}
	}


	if (!tmp_hold) {
		fprintf(dfp, "\tNONE");
	}

	fprintf(dfp, "\n\t\tOUTPUT FLOW:");
	tmp_hold = 0;
	for (i=0; i< SERIAL_OUT_FLOW_MAX;i++) {
		switch(i) {
		case SERIAL_OUT_FLOW_XONXOFF_INDEX:
			if (status->out_flow_type[i] & 2) {
				fprintf(dfp, "\t XON/XOFF\n");
				tmp_hold++;
			}
			break;
	
		case SERIAL_OUT_FLOW_CTS_INDEX:
			if (status->out_flow_type[i] & 2) {
				fprintf(dfp, "\t CTS\n");
				tmp_hold++;
			}
			break;
	
		case SERIAL_OUT_FLOW_DSR_INDEX:
			if (status->out_flow_type[i] & 2) {
				fprintf(dfp, "\t DSR\n");
				tmp_hold++;
			}
			break;
	
		default :
			break;
		}
	}

	if (!tmp_hold) {
		fprintf(dfp, "\tNONE");
	}

	tmp_hold=0;
	fprintf(dfp,"\n\t\tFLOW CONTROL ASSERTED:  INPUT-");
	for (i=0;i<SERIAL_IN_FLOW_MAX;i++) {

		switch(i) {
		case SERIAL_IN_FLOW_XONXOFF_INDEX:
			if (status->in_flow_state[i] & SERIAL_FLOW_ASSERTED) {
				tmp_hold++;
				fprintf(dfp, "\tXON-XOFF ") ;
			}
			break;
		case SERIAL_IN_FLOW_RTS_INDEX:
			if (status->in_flow_state[i] & SERIAL_FLOW_ASSERTED) {
				tmp_hold++;
				fprintf(dfp, "\tRTS ") ;
			}
			break;
		case SERIAL_IN_FLOW_DTR_INDEX:
			if (status->in_flow_state[i] & SERIAL_FLOW_ASSERTED) {
				tmp_hold++;
				fprintf(dfp, "\tDTR ") ;
			}
			break;
		default:
			break;
		}
	}

	if (!tmp_hold)
		fprintf(dfp,"\tNONE");
	fprintf(dfp, "     ");
	fprintf(dfp, " \n");


	tmp_hold=0;
	fprintf(dfp,"\t\tOUTPUT-");
	for (i=0;i<SERIAL_OUT_FLOW_MAX;i++) {

		switch(i) {
		case SERIAL_OUT_FLOW_XONXOFF_INDEX:
			if (status->out_flow_state[i] & SERIAL_FLOW_ASSERTED) {
				tmp_hold++;
				fprintf(dfp, "\tXON-XOFF") ;
			}
			break;
		case SERIAL_OUT_FLOW_CTS_INDEX:
			if (status->out_flow_state[i] & SERIAL_FLOW_ASSERTED) {
				tmp_hold++;
				fprintf(dfp, "\tCTS ") ;
			}
			break;
		case SERIAL_OUT_FLOW_DSR_INDEX:
			if (status->out_flow_state[i] & SERIAL_FLOW_ASSERTED) {
				tmp_hold++;
				fprintf(dfp, "\tDSR ") ;
			}
			break;
		default:
			break;
		}
	}

	if (!tmp_hold)
		fprintf(dfp,"\tNONE");
	
	fprintf(dfp,"\n\t\tIN/OUT SPEED: ");
	if(status->in_speed == 0 ) {
		fprintf(dfp, "UNKNOWN/");
	} else {
		fprintf(dfp, "%d/",status->in_speed);
	}
	if(status->out_speed == 0 ) {
		fprintf(dfp, "\tUNKNOWN");
	} else {
		fprintf(dfp, "%d",status->out_speed);
	}

	/* autobaud */

	fprintf(dfp,"\n\t\tAUTOBAUD: %s", (status->autobaud & SERIAL_AUTOBAUD_ENABLED) ? "ENABLED" : "DISABLED");

	fprintf(dfp, "\n\t }\n\n");
}

void
print_digi_getstat(const struct digi_stat * digistat)
{
	fprintf (dfp, "\t***** Debug DIGI_GETSTAT *****\n");
	fprintf (dfp, "\tprint_digi_getstat() {\n");
 	fprintf(dfp, "\t\tinfo_chan:\t%d\n \t\tinfo_brd:\t%d\n",
	digistat->info_chan, digistat->info_brd );

 	fprintf(dfp, "\t\tinfo_mstat:\t%x\n\t\tinfo_iflag:\t0x%x\n",
	digistat->info_mstat, digistat->info_iflag);

 	fprintf(dfp, "\t\tinfo_oflag:\t0x%x\n \t\tinfo_cflag:\t0x%x\n",
	digistat->info_oflag, digistat->info_cflag);

 	fprintf(dfp, "\t\tinfo_hflow:\t0x%x\n \t\tinfo_rx_data:\t%d\n \t\tinfo_tx_data\t%d\n", digistat->info_hflow, digistat->info_rx_data,digistat->info_tx_data);
	fprintf (dfp,"\t}\n\n");
}
#endif /* DXB */
