#
# DPA Universal Makefile
#
# This is the new universal Makefile, it will do a get, then will 
# allow as many compiles as you wish. If you are just going to make new version
# you can copy the makefile to the destination dir, and type "make all", this 
# will do the necessary get's and then compile dpa for you.  If you are going 
# to develop DPA more, simply copy the makefile to the dest dir, then type 
# "make get", change the files, then type "make dpa".  You are done.
#

include ../Makefile.inc

CURSES= $(shell if [ -f /usr/lib/libncurses.a ]; then echo ncurses; else echo curses; fi)

CC = gcc
SHELL = /bin/sh
HELPDIR= $(DRVLIBDIR)/dpa
INCLUDES=  -I.. -I../include/dxb -I../include/dxb/include -I../driver/include
CFLAGS = -O2 -DLINUX -DDXB -DEPC -DMRGDRV -DHELPDIR=\"$(HELPDIR)\" $(INCLUDES) -DDGAP_LINUX
LIBS = -lpanel -l$(CURSES)

ifneq ($(PACKAGE),"")
	PACKAGEEXT= .$(PACKAGE)
endif

all: dpa

build: dpa

dpa: dpa.c dpa.h attribs.o
	${CC} -s ${CFLAGS} -o dpa dpa.c attribs.o ${LIBS} 

install: build
	strip dpa
	install -d $(BUILDROOT)$(BINDIR)
	install -m 0755 dpa $(BUILDROOT)$(BINDIR)/dpa.$(PACKAGE)
	install -d $(BUILDROOT)$(DGAPDIR)/dpa
	install -m 0644 dpa_info* $(BUILDROOT)$(DGAPDIR)/dpa

uninstall:
	rm -rf $(BUILDROOT)$(BINDIR)/dpa.$(PACKAGE)
	rm -rf $(BUILDROOT)$(DGAPDIR)/dpa

attribs: attribs.c
	${CC} -c attribs.c

clean:
	rm -f dpa attribs.o

clobber:
	rm -f dpa attribs.o
