#
# Common definitions go here.
#

#
# TRUE_VERSION is the version string used in the driver build,
# it is intended to be in the form:
#
#   1.0-0
#
# A string noting a particular special modification could be
# used as well.  This string will be reported when the driver
# is loaded, and will be exposed by its /proc/dgap/info
# interface.
#
TRUE_VERSION="1.1-1"

#
# DGAP_PART_NUM is the part number string for the driver package.
# It should be in the form:
#
#   40002347_A
#
DGAP_PART_NUM=40002347_A

#
# DGAP_REL_NOTE is the part number string for the driver release
# notes.  It should be in the form:
#
#   93000511_A
#
DGAP_REL_NOTE=93000511_A

#
# DGAP_PKG_VER is the "version" number string included in the
# various documentation and packaging files.  It should be
# in the form:
#
#   1.0
#
DGAP_PKG_VER=1.1

#
# DGAP_PKG_REV is the "revision" of this version.  Together,
# a linux module revision is built with:
#
#   ${DGAP_PKG_VER}-${DGAP_PKG_REV}
#
DGAP_PKG_REV=1

#
# DRP_PKG_DATE is the "date" string included in (for now) the
# release notes.  It should be in the form:
#
#   09/09/2003
#
DGAP_PKG_DATE=04/14/2004

INIT_DIR= $(shell \
	if [ -d /etc/rc.d/init.d ]; \
	then echo "$(RPM_BUILD_ROOT)/etc/rc.d/init.d"; \
	else echo "$(RPM_BUILD_ROOT)/etc/init.d"; fi)

#
#	Miscelaneous path macro's
#

PACKAGE=	dgap
DEVDIR=		/dev/dg/$(PACKAGE)
SBINDIR=	/usr/sbin
SRCDIR=		/usr/src/dg/$(PACKAGE)
BINDIR=		/usr/bin
DRVLIBDIR=	/etc/$(PACKAGE)
MANDIR=		/usr/man
INCLUDEDIR=	/usr/include/linux
USRLIBDIR=	/usr/lib
DGAPDIR=	/etc/dgap


INIT_DIR= $(shell \
	if [ -d /etc/rc.d/init.d ]; \
	then echo "/etc/rc.d/init.d"; \
	else echo "/etc/init.d"; fi)
