/***************************************************************************
 *
 * Copyright (c) 2002 Promise Technology, Inc.  All rights reserved.
 * No part of this document may be reproduced or transmitted in any form or
 * by any means, electronic or mechanical, for any purpose, without the
 * express written permission of Promise Technology, Inc.
 *
 *
 * cam_xor.c - CAM XOR functions
 *
 ***************************************************************************/
#include "cam_con.h"
#include "cam_def.h"
#include "cam_imp.h"
#include "cam_macr.h"
#include "cam_gb.h"
#include "cam_exp.h"

void StartXOROperation(U8 bAdapterNumber);
PCAM_XOR_PACKET GetXOR_PacketFromXORQueue(U8 bAdapterNumber);

void Abort_All_Undone_XORPackets(U8 bAdapterNumber,PCAM_XOR_PACKET XORPacketAddress)
{
	PCAM_XOR_TASK pXORTask;
	PCAM_XOR_PACKET XORPacketAddress_next;

	/* 1.abort all packets at execute queue */
	while ((U32)XORPacketAddress != U32NULL)
	{

		pXORTask=(PCAM_XOR_TASK)XORPacketAddress->PacketHead.PTA;
		
		pXORTask->bFlag &= XOR_IsCmp;		
		pXORTask->bFlag |= XOR_ABORT;

		/* free sg resource */
		CAMFreeSG(bAdapterNumber, XOR_PAC, (PVOID)XORPacketAddress->PacketHead.PSG);	
		
		XORPacketAddress_next = (PCAM_XOR_PACKET)XORPacketAddress->PacketHead.NPA;
		/* free packet resource. */
		CAMFreePacket(bAdapterNumber, XOR_PAC, (PVOID)XORPacketAddress);		

		/* next packet */
		XORPacketAddress = XORPacketAddress_next;
		
		/* return xor task. */
		pXORTask->callback(pXORTask);							
	}

	
	/* 2. abort all packet at wait queue */
	/* get xor packet. */
	while(1)
	{
		XORPacketAddress = GetXOR_PacketFromXORQueue(bAdapterNumber);

		if ( XORPacketAddress == ZERO_NULL)	/* no packet */
			break;

		pXORTask=(PCAM_XOR_TASK)XORPacketAddress->PacketHead.PTA;
		
		pXORTask->bFlag &= XOR_IsCmp;		
		pXORTask->bFlag |= XOR_ABORT;

		/* free sg resource */
		CAMFreeSG(bAdapterNumber, XOR_PAC, (PVOID)XORPacketAddress->PacketHead.PSG);	
		
		/* free packet resource. */
		CAMFreePacket(bAdapterNumber, XOR_PAC, (PVOID)XORPacketAddress);		

		/* return xor task. */
		pXORTask->callback(pXORTask);	
		
	}

	return;
}

void XORSoftResetModule(U8 bAdapterNumber)
{

	U32  tmpData;

	ReadIndexUlong(XORBaseAddr[bAdapterNumber], 0x3C, tmpData);
	tmpData |=0x00000800;	/* bit 11.*/
	WriteIndexUlong(XORBaseAddr[bAdapterNumber], 0x3C, tmpData);

	ReadIndexUlong(XORBaseAddr[bAdapterNumber], 0x3C, tmpData);
	tmpData &=0xfffff7ff;	/* bit 11.*/
	WriteIndexUlong(XORBaseAddr[bAdapterNumber], 0x3C, tmpData);
}

 void stopXORModule(U8 bAdapterNumber)
{

	PSEQ_INFO	pCurSEQ_INFO=(PSEQ_INFO)U32NULL;
	U8	SEQCntCtrl;
	PCAM_XOR_PACKET ultmpXORPacketAddress;
	PCAM_XOR_PACKET ultmpXORPacketAddress_next;

	PCAM_XOR_TASK pXORTask;
	U8 SEQID;
	U8 STOPFlag=FALSE;
	U8	receiveStatus;
	
	if (bAdapterNumber > MAX_ADAPTER_NUM )
		return;
	
	/* disable receive task.*/
	receiveStatus=XORModuleReceiveTask[bAdapterNumber];
	XORModuleReceiveTask[bAdapterNumber]=FALSE;
	

	/* XOR */
	SEQID = XORModuleSEQID[bAdapterNumber];
	if (SEQID != U8NULL)
	{
		pCurSEQ_INFO = &(gSEQ_INFO[bAdapterNumber][SEQID]);	
		ultmpXORPacketAddress = (PCAM_XOR_PACKET)pCurSEQ_INFO->SEQID2PacketHead;
		pCurSEQ_INFO->SEQID2PacketHead=(PVOID)U32NULL;
		pCurSEQ_INFO->SEQID2PacketTail=(PVOID)U32NULL;
	}
	else
		ultmpXORPacketAddress = (PCAM_XOR_PACKET)U32NULL;
	
	/* soft reset XOR Module. so the xor module will stop after done current packet.*/
	XORSoftResetModule(bAdapterNumber);
			
	/* remove ata timeout timer */
	if (XOR_Timeout_TimerID[bAdapterNumber]!=ZERO_NULL){
		camTimer(0,(void *)XOR_Timeout_TimerID[bAdapterNumber]);	
		XOR_Timeout_TimerID[bAdapterNumber]=ZERO_NULL;
	}

	/* check with executing packets in seqID */
	if((U32)ultmpXORPacketAddress != U32NULL) {
					
		/* read Sequence Counter Control Register # */
		ReadPortUchar(HostBaseAddr[bAdapterNumber], SEQID*4, SEQCntCtrl);
		SEQCntCtrl &= 0x1F;
		
		while ((U32)ultmpXORPacketAddress != U32NULL)
		{

			pXORTask=(PCAM_XOR_TASK)ultmpXORPacketAddress->PacketHead.PTA;
		
			/* check is error packet */
			if (pCurSEQ_INFO->PACCNT == SEQCntCtrl)
			{ 	/* error packet */

				STOPFlag = TRUE;
			
				/* abort packets queue at the rear of this packet and and wait queue packets. */
				Abort_All_Undone_XORPackets(bAdapterNumber,ultmpXORPacketAddress->PacketHead.NPA);
				ultmpXORPacketAddress->PacketHead.NPA=(PVOID)U32NULL;
				pXORTask->bFlag = XOR_ABORT;
				STOPFlag = TRUE;
			}
			else		/* success done packet */
			{
				pCurSEQ_INFO->PACCNT--;
				pXORTask->bFlag &= XOR_IsCmp;		
			}

			/* free sg resource */
			CAMFreeSG(bAdapterNumber, XOR_PAC, (PVOID)ultmpXORPacketAddress->PacketHead.PSG);	
			
			ultmpXORPacketAddress_next = (PCAM_XOR_PACKET)ultmpXORPacketAddress->PacketHead.NPA;
		
			/* free packet resource. */
			CAMFreePacket(bAdapterNumber, XOR_PAC, (PVOID)ultmpXORPacketAddress);		

			/* next packet */
			ultmpXORPacketAddress = ultmpXORPacketAddress_next;
		
			/* return xor task. */
			pXORTask->callback(pXORTask);							

			if (STOPFlag==TRUE)
				break;
			
		}
	
		pCurSEQ_INFO->SEQID2PacketHead=(PVOID)U32NULL;
		pCurSEQ_INFO->SEQID2PacketTail=(PVOID)U32NULL;
		XORModuleBusy[bAdapterNumber]=FALSE;
		XORModuleSEQID[bAdapterNumber] = U8NULL;
		CAMFreeSEQID(bAdapterNumber,SEQID);
	}
	else{
		/* no executing packets,abort packets queue at wait queue packets. */
		Abort_All_Undone_XORPackets(bAdapterNumber,(PCAM_XOR_PACKET)U32NULL);
	}

	XORModuleReceiveTask[bAdapterNumber]=receiveStatus;
	return;

}

void XOR_Timeout(U8 bAdapterNumber)
{
	PSEQ_INFO	pCurSEQ_INFO;
	U8	SEQCntCtrl;
	PCAM_XOR_PACKET ultmpXORPacketAddress;
	PCAM_XOR_PACKET ultmpXORPacketAddress_next;

	PCAM_XOR_TASK pXORTask;
	U8 SEQID;
	U8 i;
	U8 errorFlag=FALSE;

	SEQID = XORModuleSEQID[bAdapterNumber];
	/* error timeout. If no SEQID assign to channel packets, timeout will not happen, so if timeout function be called at this case, it is a error timeout.*/
	if (SEQID == U8NULL)
		return;
		
	pCurSEQ_INFO = &(gSEQ_INFO[bAdapterNumber][SEQID]);

	XOR_Timeout_TimerID[bAdapterNumber]=ZERO_NULL;
	/* XOR */
	
	ultmpXORPacketAddress = (PCAM_XOR_PACKET)pCurSEQ_INFO->SEQID2PacketHead;

	/* read Sequence Counter Control Register # */
	ReadPortUchar(HostBaseAddr[bAdapterNumber], SEQID*4, SEQCntCtrl);
	SEQCntCtrl &= 0x1F;
		
	while ((U32)ultmpXORPacketAddress != U32NULL)
	{
		
		pXORTask=(PCAM_XOR_TASK)ultmpXORPacketAddress->PacketHead.PTA;
		
		/* check is error packet */
		if (pCurSEQ_INFO->PACCNT == SEQCntCtrl)
		{ 	/* error packet */

			errorFlag = TRUE;

			pCurSEQ_INFO->SEQID2PacketHead=(PVOID)U32NULL;
			pCurSEQ_INFO->SEQID2PacketTail=(PVOID)U32NULL;			
			/* abort packets queue at the rear of this packet and and wait queue packets. */
			Abort_All_Undone_XORPackets(bAdapterNumber,ultmpXORPacketAddress->PacketHead.NPA);
			ultmpXORPacketAddress->PacketHead.NPA=(PVOID)U32NULL;
	
			/* get XOR Global control & Status Register */
			ReadPortUchar(XORBaseAddr[bAdapterNumber], STATUS_REGISTER_OFFSET+2, pXORTask->bFlag);
	
			/* soft reset XOR Module. */
			XORSoftResetModule(bAdapterNumber);
									
			pXORTask->bFlag &= XORERR_HWERROR;
			pXORTask->bFlag	|= XOR_ERROR;					

		}
		else		/* success done packet */
		{
			pCurSEQ_INFO->PACCNT--;
			pXORTask->bFlag &= XOR_IsCmp;		
		}


		/* free sg resource */
		CAMFreeSG(bAdapterNumber, XOR_PAC, (PVOID)ultmpXORPacketAddress->PacketHead.PSG);	
		
		ultmpXORPacketAddress_next = (PCAM_XOR_PACKET)ultmpXORPacketAddress->PacketHead.NPA;
		/* free packet resource. */
		CAMFreePacket(bAdapterNumber, XOR_PAC, (PVOID)ultmpXORPacketAddress);		

		/* next packet */
		ultmpXORPacketAddress = ultmpXORPacketAddress_next;
		
		/* return xor task. */
		pXORTask->callback(pXORTask);							

		if (errorFlag==TRUE)
			break;
			
	}


	pCurSEQ_INFO->SEQID2PacketHead=(PVOID)U32NULL;
	pCurSEQ_INFO->SEQID2PacketTail=(PVOID)U32NULL;
	XORModuleBusy[bAdapterNumber]=FALSE;
	XORModuleSEQID[bAdapterNumber] = U8NULL;
	CAMFreeSEQID(bAdapterNumber,SEQID);

	/* must check module is need to push, By it maybe pushed when no SQEID. */
	if ( (XORModuleNeedPush[bAdapterNumber]==TRUE) && (XORModuleBusy[bAdapterNumber]==FALSE) ){
		/* start xor module */
		StartXOROperation(bAdapterNumber);
		return;
	}
	for (i=(bAdapterNumber*MAX_ATA_CHNL);i<((bAdapterNumber+1)*MAX_ATA_CHNL);i++) {
		if ( (ATAModuleNeedPush[i]==TRUE) && (ATAModuleBusy[i]==FALSE) ){
			/* start ata module */
			StartATAOperation(i);
			break;
		}
	}	

	return;
}

#if (MAX_ADAPTER_NUM>0)
void XOR_Timeout0(void)
{
	XOR_Timeout(0x00);
	return;
}
#endif
#if (MAX_ADAPTER_NUM>1)
void XOR_Timeout1(void)
{
	XOR_Timeout(0x01);
	return;
}
#endif
#if (MAX_ADAPTER_NUM>2)
void XOR_Timeout2(void)
{
	XOR_Timeout(0x02);
	return;
}
#endif
#if (MAX_ADAPTER_NUM>3)
void XOR_Timeout3(void)
{
	XOR_Timeout(0x03);
	return;
}
#endif


void (FARPTR *XOR_Timeout_Function[])(void) = {
	
#if (MAX_ADAPTER_NUM>0)
  XOR_Timeout0,
#endif  
#if (MAX_ADAPTER_NUM>1)  
  XOR_Timeout1,
#endif  
#if (MAX_ADAPTER_NUM>2)  
  XOR_Timeout2,
#endif  
#if (MAX_ADAPTER_NUM>3)  
  XOR_Timeout3,
#endif  
};


/* set the elements of XorQueue is the same as XORPacketQueue, this's means: if can allocate packet, it can insert to xorqueue. */
U8 Put2XORQueue(PCAM_XOR_PACKET CAM_XORPacket,U8 direction)
{
	PCAM_XOR_TASK pXORTask;

	pXORTask=CAM_XORPacket->PacketHead.PTA;	

	if (direction == QUEUETail){	/* put packet at the tail of packet queue */

		XorQueue[pXORTask->bID][XORQueueTail[pXORTask->bID]].pXORPacket=CAM_XORPacket;

		XORQueueTail[pXORTask->bID]++;

		if (XORQueueTail[pXORTask->bID]== (MAX_XOR_PAC+1))
			XORQueueTail[pXORTask->bID]=0;
	}
	else{	/* direction == QUEUEHead  */	 /* put packet at the head of packet queue */
		
		if (XORQueueHead[pXORTask->bID]==0)
			XORQueueHead[pXORTask->bID]=MAX_XOR_PAC;
		else
			XORQueueHead[pXORTask->bID]--;

		XorQueue[pXORTask->bID][XORQueueHead[pXORTask->bID]].pXORPacket=CAM_XORPacket;
	}

	XORModuleNeedPush[pXORTask->bID]=TRUE;

	return TRUE;
}

PCAM_XOR_PACKET GetXOR_PacketFromXORQueue(U8 bAdapterNumber)
{
	PCAM_XOR_PACKET pXORPacket;

	if(XORQueueHead[bAdapterNumber]==XORQueueTail[bAdapterNumber])	/* no queue packet */
	{
		XORModuleNeedPush[bAdapterNumber]=FALSE;
		return ZERO_NULL;
	}
	
	pXORPacket=XorQueue[bAdapterNumber][XORQueueHead[bAdapterNumber]].pXORPacket;

	XORQueueHead[bAdapterNumber]++;
	
	if (XORQueueHead[bAdapterNumber]==(MAX_XOR_PAC+1))
		XORQueueHead[bAdapterNumber]=0;

	/* still have packet */
	if(	XORQueueHead[bAdapterNumber]!=XORQueueTail[bAdapterNumber]){
		XORModuleNeedPush[bAdapterNumber]=TRUE;

	}else {
		XORModuleNeedPush[bAdapterNumber]=FALSE;
	}

	return pXORPacket;
}
   

U8 prepareXorPacketSEQID(U8 bAdapterNumber, U8 FreeSEQID)
{
	U8 PacketCount=0;
	PCAM_XOR_PACKET CAM_XORPacket;

	/* get xor packet. */
	while(1)
	{
		CAM_XORPacket = GetXOR_PacketFromXORQueue(bAdapterNumber);

		if ( CAM_XORPacket == ZERO_NULL)	/* no packet */
			break;

		PacketCount++;
		
		/* set SEQID */
		CAM_XORPacket->XORPacket.bSynSeqID=FreeSEQID; 		

		/* put xor packets to seqid2packet queue,so in isr, */
		/* driver can release the relevant resource and  */
		/* can point to the right PTA pointer */
		Put2SeqIDQueue(bAdapterNumber,(PVOID)CAM_XORPacket,FreeSEQID);
		
		if (PacketCount>=PacketQueueCount[bAdapterNumber].XORModule[0])
			break;
		
	}
	return PacketCount;
}

void StartXOROperation(U8 bAdapterNumber)
{
	U8 PacketCount=ZERO_NULL;
	U8 FreeSEQID;


	if (XORModuleBusy[bAdapterNumber]){
		/* XORModuleNeedPush[bAdapterNumber]=TRUE; */
		return;
	}

	/* get free seqid */
	FreeSEQID=CAMAllocSEQID(bAdapterNumber);

	if (FreeSEQID==U8NULL){
		/* XORModuleNeedPush[bAdapterNumber]=TRUE; */
		return;
	}

	PacketCount = prepareXorPacketSEQID(bAdapterNumber,FreeSEQID);
	if ( PacketCount== ZERO_NULL)	/* no packet */
	{
		CAMFreeSEQID(bAdapterNumber,FreeSEQID);
		return;		
	}

	XORModuleBusy[bAdapterNumber]=TRUE;
	XORModuleSEQID[bAdapterNumber]=FreeSEQID;

	/* set XOR Module timeout timer. */
	XOR_Timeout_TimerID[bAdapterNumber] = camTimer(CAMTimeoutTimes[bAdapterNumber].XORCommand,XOR_Timeout_Function[bAdapterNumber]);	/* 3 seconds */
	
	/* set Sequence Counter Control Register */
	WritePortUlong(HostBaseAddr[bAdapterNumber], FreeSEQID*4, PacketCount);

	/* start xor module */
	WritePortUlong(XORBaseAddr[bAdapterNumber], PACSTART_REGISTER_OFFSET, ((PPACKET_HEAD)gSEQ_INFO[bAdapterNumber][FreeSEQID].SEQID2PacketHead)->Address);
	
}


U8 CAM_SubmitXOR(PCAM_XOR_TASK pXORTask)
{

	PCAM_XOR_PACKET CAM_XORPacket;
	PCAM_XOR_SG CAM_XORSG;
	U8 bAdapterNumber;
	PCAMSG iSG;
	U16 i;
	

	bAdapterNumber=pXORTask->bID;

	/* can Receive task? */
	if (XORModuleReceiveTask[bAdapterNumber] != TRUE)
		return camBUSY;
		
	/* get free packet address */
	CAM_XORPacket = CAMAllocPacket(bAdapterNumber, XOR_PAC);

	if (CAM_XORPacket==(PVOID)U32NULL){	/* no free xor packet. */
		return camBUSY;		
	}	

	/* get free SG address */
	CAM_XORSG=CAMAllocSG(bAdapterNumber, XOR_PAC);
	
	if (CAM_XORSG==(PVOID)U32NULL){	/* no free xor sg. */
		CAMFreePacket(bAdapterNumber, XOR_PAC, (PVOID)CAM_XORPacket);
		return camBUSY;
	}
	
	/* prepare XOR packet */
	CAM_XORPacket->PacketHead.ModelType=XOR_PAC;
	CAM_XORPacket->PacketHead.NPA=(PVOID)U32NULL;
	CAM_XORPacket->PacketHead.PTA=pXORTask;
	CAM_XORPacket->PacketHead.PSG=CAM_XORSG;
	
	CAM_XORPacket->XORPacket.bSynSeqID=SEQ_NO_SEQID;	/* no SEQID now. */
	CAM_XORPacket->XORPacket.bDelaySeqID =SEQ_NO_DELAY;
	
	if (!(pXORTask->bFlag & XOR_IsCmp)){
		CAM_XORPacket->XORPacket.bControl=XORCTRL_XOR;
	}
	else{
		CAM_XORPacket->XORPacket.bControl=XORCTRL_CMP;
	}

	/* set sg control byte. */
	for(i=0;i<pXORTask->bCount;i++){

		checkConvertSG((PCAMSG)pXORTask->pSGTable[i],(PCAMSG)CAM_XORSG->XOR_SG[i]);
		
		iSG = (PCAMSG)CAM_XORSG->XOR_SG[i];
		while(1){

			/* set reserved byte to 0. */
			iSG->Reserved=0;
			iSG->CtrlFlag &= ~(XOR_DEST+XOR_SRC);

			if( i == (U16)(pXORTask->bCount-1)) {
				if (pXORTask->bFlag & XOR_IsCmp){
					iSG->CtrlFlag |= XOR_SRC;
				}
				else{
					iSG->CtrlFlag  |= XOR_DEST;
				}
			}
			else {
				iSG->CtrlFlag |= XOR_SRC;
			}
			
			if(iSG->CtrlFlag & EOT) 
				break;			
			iSG++;
		}


		/* set reserved byte to 0. */
		/*
		iSG = CAM_XORSG->XOR_SG[i];
		do{
			iSG>Reserved=0;
			if(( (iSG->CtrlFlag & 0x80)!=0){
				break;
			}
			iSG++;
		
		}while(1);
		*/

		CAM_XORPacket->XORPacket.ulPSG[i]=CAM_XORSG->Address+i*CAM_PRD_TBL_SIZE;
		
	}
	for (i=pXORTask->bCount;i<MAX_XOR_SG;i++)
		CAM_XORPacket->XORPacket.ulPSG[i]=0;
	

	/* put xor packet to xor queue */
	Put2XORQueue(CAM_XORPacket,QUEUETail);

	/* start xor module */
	StartXOROperation(pXORTask->bID);

	return camACCEPTED;
}

