/***************************************************************************
 *
 * Copyright (c) 2002 Promise Technology, Inc.  All rights reserved.
 * No part of this document may be reproduced or transmitted in any form or
 * by any means, electronic or mechanical, for any purpose, without the
 * express written permission of Promise Technology, Inc.
 *
 *
 * cam_var.c - contains declaration for global variables
 *
 ***************************************************************************/
#include "cam_con.h"
#include "cam_def.h"


/* 
 * 	adapter configuartion 
 */
ADAPTER_CONFIG	gAdapterConfig[MAX_ADAPTER_NUM];
U32 ATABaseAddr[MAX_ATA_MODULE];
U32 XORBaseAddr[MAX_ADAPTER_NUM];
U32 HostBaseAddr[MAX_ADAPTER_NUM];
/*
 *	ATA channel configuration
 */
CHNL_CONFIG		gChnlConfig[MAX_ATA_MODULE];
/*
 *	device configuration
 */
 
DEV_CONFIG		gDrvConfig[MAX_ATA_MODULE][2];
CAM_IDENTIFY_DATA	gIdentify_Data[MAX_ATA_MODULE][2];
ENCLOSURE_TYPE	gBOXConfig[MAX_ATA_MODULE];
ENCLOSURE_STATUS gBOXStatus[MAX_ATA_MODULE];
ATA_TASK	boxATATask[MAX_ATA_MODULE];
ATA_TASK	boxLEDATATask[MAX_ATA_MODULE];
ATA_TASK	InternalATATask[MAX_ATA_MODULE][2];

/*
 *	Memory management 
 */
 
/* 
 * 	packets and queues 
 */
PCAM_ATA_PACKET ATAPacketQueue[MAX_ADAPTER_NUM][MAX_ATA_PAC];
PCAM_XOR_PACKET XORPacketQueue[MAX_ADAPTER_NUM][MAX_XOR_PAC];
U16 ATAPacketCurrent[MAX_ADAPTER_NUM];
U16 XORPacketCurrent[MAX_ADAPTER_NUM];
MODULE_PACKET_COUNT PacketQueueCount[MAX_ADAPTER_NUM];
MODULE_TIMEOUT CAMTimeoutTimes[MAX_ADAPTER_NUM];

/* sg queue */
PCAM_ATA_SG PCAM_ATA_SG_Queue[MAX_ADAPTER_NUM][MAX_ATA_PAC];
PCAM_XOR_SG PCAM_XOR_SG_Queue[MAX_ADAPTER_NUM][MAX_XOR_PAC];
U16 CAM_ATA_SG_Current[MAX_ADAPTER_NUM];
U16 CAM_XOR_SG_Current[MAX_ADAPTER_NUM];

/* 
 *	Sequences 
 */
SEQ_INFO	gSEQ_INFO[MAX_ADAPTER_NUM][MAX_SEQ_ID];
U8 SEQIDPool[MAX_ADAPTER_NUM][MAX_SEQ_ID];
U8 SEQIDCurrent[MAX_ADAPTER_NUM];


/* for push queued module */
/* for XOR */
U8	XORModuleNeedPush[MAX_ADAPTER_NUM];
U16 XORQueueHead[MAX_ADAPTER_NUM],XORQueueTail[MAX_ADAPTER_NUM];
XOR_QUEUE XorQueue[MAX_ADAPTER_NUM][MAX_XOR_PAC+1];
U32 XORModuleBusy[MAX_ADAPTER_NUM];
U8 XORModuleSEQID[MAX_ADAPTER_NUM];
U32 XOR_Timeout_TimerID[MAX_ADAPTER_NUM*MAX_XOR_MODULE];
U8 XORModuleReceiveTask[MAX_ADAPTER_NUM]={FALSE};

/* for ATA */
U8 	ATAModuleNeedPush[MAX_ATA_MODULE];
U16 ATAQueueHead[MAX_ATA_MODULE];
U16 ATAQueueTail[MAX_ATA_MODULE];
ATA_QUEUE ATAQueue[MAX_ATA_MODULE][MAX_ATA_PAC+1];
U32 ATAModuleBusy[MAX_ATA_MODULE];
U8 ATAModuleSEQID[MAX_ATA_MODULE];
U32 ATA_Timeout_TimerID[MAX_ATA_MODULE];
U32 BOX_Timeout_TimerID[MAX_ATA_MODULE];
U8 ATAModuleReceiveTask[MAX_ATA_MODULE]={FALSE};

