/***************************************************************************
 *
 * Copyright (c) 2002 Promise Technology, Inc.  All rights reserved.
 * No part of this document may be reproduced or transmitted in any form or
 * by any means, electronic or mechanical, for any purpose, without the
 * express written permission of Promise Technology, Inc.
 *
 *
 * cam_macr.h - defines macros for CAM
 *
 ***************************************************************************/
#ifdef	_MMIO_
	#define	WritePortUlong(BaseAddress, Offset, Data )\
	{\
		camWriteRegDword(BaseAddress+Offset, Data);\
	}
	
	#define	ReadPortUlong(BaseAddress, Offset, Data )\
	{\
		Data = camReadRegDword(BaseAddress+Offset);\
	}
	
	#define	WritePortUchar(BaseAddress, Offset, Data )\
	{\
		camWriteRegByte(BaseAddress+Offset, Data);\
	}
	
	#define	ReadPortUchar(BaseAddress, Offset, Data )\
	{\
		Data = camReadRegByte(BaseAddress+Offset);\
	}
	
	#define WriteIndexUlong(BaseAddress, Index, Data )\
	{\
		camWriteRegDword(BaseAddress+Index, Data);\
	}	

	#define ReadIndexUlong(BaseAddress, Index, Data )\
	{\
		Data = camReadRegDword( BaseAddress+Index);\
	}	
	
	#define ReadBuffer(BaseIoAddress, Buffer, Count)\
	{\
		U32 i;\
		for (i = 0; i< Count; i++ ) {\
			*(Buffer+i) = camReadRegWord(BaseIoAddress);\
		}\
	}
	
	#define WriteBuffer(BaseIoAddress, Buffer, Count)\
	{\
		U32 i;\
		for (i = 0; i< Count; i++ ) {\
			camWriteRegWord(BaseIoAddress, *(Buffer+i));\
		}\
	}	
#else
	#define	WritePortUlong(BaseAddress, Offset, Data )\
	{\
		camOutPortDword(BaseAddress+Offset, Data);\
	}
	
	#define	ReadPortUlong(BaseAddress, Offset, Data )\
	{\
		Data = camInPortDword(BaseAddress+Offset);\
	}	
	
	#define	WritePortUchar(BaseAddress, Offset, Data )\
	{\
		camOutPortByte(BaseAddress+Offset, Data);\
	}
	
	#define	ReadPortUchar(BaseAddress, Offset, Data )\
	{\
		Data = camInPortByte(BaseAddress+Offset);\
	}
	
	
	#define WriteIndexUlong(BaseAddress, Index, Data )\
	{\
		camOutPortByte(BaseAddress+ INDEX_REGISTER_OFFSET, Index);\
		camOutPortDword(BaseAddress+ DATA_REGISTER_OFFSET, Data);\
	}

	#define ReadIndexUlong(BaseAddress, Index, Data )\
	{\
		camOutPortByte(BaseAddress+ INDEX_REGISTER_OFFSET, Index);\
		Data = camInPortDword(BaseAddress+ DATA_REGISTER_OFFSET);\
	}	
	
	#define ReadBuffer(BaseIoAddress, Buffer, Count)\
	{\
		U32 i;\
		camOutPortByte( BaseIoAddress+ INDEX_REGISTER_OFFSET, iNDEXIDEData);\
		for (i = 0; i< Count; i++ ) {\
			*(Buffer+i) = camInPortWord( BaseIoAddress+ DATA_REGISTER_OFFSET);\
		}\
	}
		
	#define WriteBuffer(BaseIoAddress, Buffer, Count)\
	{\
		U32 i;\
		camOutPortByte( BaseIoAddress+ INDEX_REGISTER_OFFSET, iNDEXIDEData);\
		for (i = 0; i< Count; i++ ) {\
			camOutPortWord( BaseIoAddress+ DATA_REGISTER_OFFSET, *(Buffer+i));\
		}\
	}	
		
#endif

/*
 *  Macros for ATA module 
 */
#define GetStatus(IDEBaseAddress, Status)\
	Status = ReadIndexUchar(IDEBaseAddress, iNDEXIDEAlternateStatus);\

#define GetBaseStatus(IDEBaseAddress, Status)\
	Status = ReadIndexUchar(IDEBaseAddress, iNDEXIDEStatus);\





