/***************************************************************************
 *
 * Copyright (c) 2002 Promise Technology, Inc.  All rights reserved.
 * No part of this document may be reproduced or transmitted in any form or
 * by any means, electronic or mechanical, for any purpose, without the
 * express written permission of Promise Technology, Inc.
 *
 *
 * cam_isr.c - contains declaration for global variables
 *
 ***************************************************************************/
#include "cam_con.h"
#include "cam_def.h"
#include "cam_imp.h"
#include "cam_macr.h"
#include "cam_gb.h"
#include "cam_exp.h"

/*
When the ISR of channel driver is called by OS, it should call CAM_ISR immediately.
Channel driver will tell CAM the interrupt may caused by which adapters. If several adapters 
share the same IRQ, channel driver will set mapped bits of IRQHandle to 1.
CAM will determine if its controllers generated a interrupt. CAM will return FALSE as soon as
possible if this interrupt is not generated by its controllers.
*/
U32 CAM_ISR(U32 IRQHandle)		/* bit#1	The interrupt may caused by adapter# */
{
	U8 bAdapterNumber;
	U8 SEQID;
	U8 returnValue=FALSE;	
	U32 INTStatus;

	U8	SEQCntCtrl;
	PSEQ_INFO	pCurSEQ_INFO;

	U8 ModuleType;

	U8	i;
	U8	errorFlag=FALSE;
	U8	IntReason=0;
	
	U8	PlugData;
	U8	MaskFlags;

	for (bAdapterNumber=0;bAdapterNumber<MAX_ADAPTER_NUM;bAdapterNumber++) {
		if (!((IRQHandle >> bAdapterNumber)&0x01) )
			continue;
		
		/* interrupt caused by adapter# */
		/* check is SATA plug/unplug interrupt */
		/* read SATA plug control and status register */
		ReadPortUchar(HostBaseAddr[bAdapterNumber], oFFSETHOSTSATAPLUG, PlugData);
		ReadPortUchar(HostBaseAddr[bAdapterNumber], oFFSETHOSTSATAPLUG+2, MaskFlags);
		PlugData &= ~MaskFlags;
		if (!PlugData)
			continue;
						
		/* clear plug/unplug flags */
		WritePortUchar(HostBaseAddr[bAdapterNumber], oFFSETHOSTSATAPLUG, PlugData);
		
		/* check unplug flag */
		for ( i=0; i < MAX_ATA_CHNL; i++){
			if ( (PlugData & 0x01) && (gChnlConfig[bAdapterNumber*MAX_ATA_CHNL+i].ChnlType == CHNL_SATA))
			{
				returnValue = TRUE;
				gDrvConfig[bAdapterNumber*MAX_ATA_CHNL+i][0].DevFlag = DEV_NOTFOUND;
				camCheckDriveStatus((U8) (bAdapterNumber*MAX_ATA_CHNL+i), 0, NO_DRIVE);
			}
			PlugData >>= 1;
		}
				
		/* check plug flag */
		for ( i=0; i < MAX_ATA_CHNL; i++){
			if ( (PlugData & 0x01) && (gChnlConfig[bAdapterNumber*MAX_ATA_CHNL+i].ChnlType == CHNL_SATA))
			{
				returnValue = TRUE;
				camCheckDriveStatus((U8) (bAdapterNumber*MAX_ATA_CHNL+i), 0, NEW_DRIVE);
			}
			PlugData >>= 1;
		}
		
	}
	if (returnValue == TRUE)
		return TRUE;

	for (bAdapterNumber=0;bAdapterNumber<MAX_ADAPTER_NUM;bAdapterNumber++){
		if (!((IRQHandle >> bAdapterNumber)&0x01))
			continue;
		/* channel dirver set the interrupt may caused by adapter# */
		
		/* read Sequence Interrupt Status register, if no sequence INT, return ASAP. */
#ifndef NETWARE
		ReadPortUlong(HostBaseAddr[bAdapterNumber], SEQINT_REGISTER_OFFSET, INTStatus);			
#else
		ReadPortUchar(HostBaseAddr[bAdapterNumber], SEQINT_REGISTER_OFFSET+1, i);
		INTStatus = (U32)i << 8;
#endif
		if (!(INTStatus & 0xFFFF))		/* check SEQ#0~F INT  */
			continue;	/* no SEQ INT */
				
		returnValue = TRUE;

		for (SEQID=START_SEQ_ID;SEQID<MAX_SEQ_ID;SEQID++) {
			if (!((INTStatus >> SEQID) & 0x01))
				continue;
				
			/* SEQ# INT */
			pCurSEQ_INFO = &(gSEQ_INFO[bAdapterNumber][SEQID]);
			
			/* if is a invalid seqID interrupt. */
			if (pCurSEQ_INFO->SEQID2PacketHead == ((PVOID)U32NULL) )
				continue;
						
			ModuleType= (U8)pCurSEQ_INFO->Owner;

			/* read Sequence Counter Control Register # */
			ReadPortUchar(HostBaseAddr[bAdapterNumber], SEQID*4, SEQCntCtrl);
			SEQCntCtrl &= 0x1F;
					
			if (ModuleType == XOR){	/* XOR Module */
				PCAM_XOR_PACKET ultmpXORPacketAddress;
				PCAM_XOR_PACKET ultmpXORPacketAddress_next;
				PCAM_XOR_TASK pXORTask;

				errorFlag = FALSE;

				/* remove xor timeout timer */
				camTimer(0,(void *)XOR_Timeout_TimerID[bAdapterNumber]);	
				XOR_Timeout_TimerID[bAdapterNumber]=ZERO_NULL;
						
				ultmpXORPacketAddress = (PCAM_XOR_PACKET)pCurSEQ_INFO->SEQID2PacketHead;
				pCurSEQ_INFO->SEQID2PacketHead=(PVOID)U32NULL;
				pCurSEQ_INFO->SEQID2PacketTail=(PVOID)U32NULL;				

				while ((U32)ultmpXORPacketAddress != U32NULL)
				{
					pXORTask=(PCAM_XOR_TASK)ultmpXORPacketAddress->PacketHead.PTA;

					if (SEQCntCtrl)	/* not success done all seq's packets */
					{	
						/* check is error packet */
						if (pCurSEQ_INFO->PACCNT == SEQCntCtrl)
						{
							errorFlag = TRUE;

							/* abort packets queue at the rear of this packet and and wait queue packets. */
							Abort_All_Undone_XORPackets(bAdapterNumber,ultmpXORPacketAddress->PacketHead.NPA);
							ultmpXORPacketAddress->PacketHead.NPA=(PVOID)U32NULL;
									
							/* get XOR Global control & Status Register */
							ReadPortUchar(XORBaseAddr[bAdapterNumber], STATUS_REGISTER_OFFSET+2, pXORTask->bFlag);
	
							/* soft reset XOR Module. */
							XORSoftResetModule(bAdapterNumber);
									
							pXORTask->bFlag &= XORERR_HWERROR;
							pXORTask->bFlag	|= XOR_ERROR;
						}
						else		/* success done packet */
						{
							pCurSEQ_INFO->PACCNT--;
							pXORTask->bFlag = 0;
						}
					}
					else
						pXORTask->bFlag = 0;

					/* free sg resource */
					CAMFreeSG(bAdapterNumber, XOR_PAC, (PVOID)ultmpXORPacketAddress->PacketHead.PSG);
					
					ultmpXORPacketAddress_next = (PCAM_XOR_PACKET)ultmpXORPacketAddress->PacketHead.NPA;
							
					/* free packet resource. */
					CAMFreePacket(bAdapterNumber, XOR_PAC, (PVOID)ultmpXORPacketAddress);		

					/* next packet */
					ultmpXORPacketAddress = ultmpXORPacketAddress_next;
		
					/* return xor task. */
					pXORTask->callback(pXORTask);							

					if (errorFlag==TRUE)
						break;
			
				}

				XORModuleBusy[bAdapterNumber]=FALSE;
				
				XORModuleSEQID[bAdapterNumber] = U8NULL;
				CAMFreeSEQID(bAdapterNumber,SEQID);	
							
				/* must check module is need to push, By it maybe pushed when no SQEID. */
				if ( (XORModuleNeedPush[bAdapterNumber]==TRUE) && (XORModuleBusy[bAdapterNumber]==FALSE) ){
					/* start xor module */
					StartXOROperation(bAdapterNumber);
				}
				for (i=(bAdapterNumber*MAX_ATA_CHNL);i<((bAdapterNumber+1)*MAX_ATA_CHNL);i++) {
					if ( (ATAModuleNeedPush[i]==TRUE) && (ATAModuleBusy[i]==FALSE) ){
						/* start ata module */
						StartATAOperation(i);
						break;
					}
				}
					
			}
			else {	/* ATA Modules */

				PCAM_ATA_PACKET ultmpATAPacketAddress;
				PCAM_ATA_PACKET ultmpATAPacketAddress_next;
				PATA_TASK pATATask;
				U8 bChannelNumber;

				bChannelNumber = bAdapterNumber*MAX_ATA_CHNL+ModuleType;

				errorFlag = FALSE;
						
				/* remove ata timeout timer */
				camTimer(0,(void *)ATA_Timeout_TimerID[bChannelNumber]);	
				ATA_Timeout_TimerID[bChannelNumber]=ZERO_NULL;
						
				ultmpATAPacketAddress = (PCAM_ATA_PACKET)pCurSEQ_INFO->SEQID2PacketHead;
				pCurSEQ_INFO->SEQID2PacketHead=(PVOID)U32NULL;
				pCurSEQ_INFO->SEQID2PacketTail=(PVOID)U32NULL;

				while ((U32)ultmpATAPacketAddress != U32NULL){						

					pATATask=(PATA_TASK)ultmpATAPacketAddress->PacketHead.PTA;
							
					if (SEQCntCtrl)	/* not success done all seq's packets */
					{
						/* check is error packet */
						if (pCurSEQ_INFO->PACCNT == SEQCntCtrl)
						{
							errorFlag = TRUE;								

							/* if swap box nop command, it will return error at all time, and it will not queue with others packets when execute,
									, needn't abort others packet at waiting queue */
							if (!(pATATask->ATACmdFlag & SWAPBOX_CMD)){
								/* abort packets queue at the rear of this packet and and wait queue packets. */
								Abort_All_Undone_ATAPackets(bChannelNumber,(PCAM_ATA_PACKET)ultmpATAPacketAddress->PacketHead.NPA);
								ultmpATAPacketAddress->PacketHead.NPA=(PVOID)U32NULL;
							}
															
							/* get ATA Global control & Status Register */
							ReadPortUchar(ATABaseAddr[bChannelNumber], (ATA_STATUS_REGISTER_OFFSET+2), pATATask->ATAStatus);

							/* soft reset ATA Module. */
							ATASoftResetModule(bChannelNumber);	

							pATATask->ATAStatus &= ATAERR_HWERROR;
							pATATask->ATAStatus |= ATA_ERROR;						

							/* read 3f6 */
							for ( i = 0; i < 100; i++ ) {
								if (!(ReadIndexUchar(ATABaseAddr[pATATask->bCh], iNDEXIDEAlternateStatus) & IDE_STATUS_BUSY))
									break; /* wait a while for ATAPI device */
							}
							GetStatus(ATABaseAddr[pATATask->bCh], pATATask->Cmd.ATACmd.bStatus);
							
							if (pATATask->Cmd.ATACmd.bStatus & IDE_STATUS_BUSY){
								pATATask->ATAStatus|=ATA_TIMEOUT;
							}
							else{				
								/* set disk status */
								if (pATATask->ATACmdFlag & ATA_DEVICE)									
									ATAErrorStatus(pATATask);
								else if (pATATask->ATACmdFlag & SWAPBOX_CMD)
									ATAErrorStatus(pATATask);
								else { 	/* ATAPI device */
									if ( pATATask->ATAStatus & ATAERR_OVERRUN )
									{	/* that is not a device error */
										pATATask->ATAStatus = 0;
										goto CommandCompleted;
									}
									if (!(pATATask->ATACmdFlag & INTERNAL_SENSE)){
										/* get ATAPI error , if INTERNAL_SENSE error, ingore it.*/
										ATAPIErrorStatus(pATATask);
										
										/* must have sense buffer so can do internel sense command */
										if ((pATATask->SenseInfoLength > 1)){
											/* If ATAPI packet command error, than send a internel "REQUEST SENSE Command" 
											     to get the sense datas. 	*/
											pATATask->ATACmdFlag = INTERNAL_SENSE;
											IntReason = INT_WAITCMD;
										}
									}
									else {
										pATATask->ATACmdFlag &= ~INTERNAL_SENSE;
										ATAPIErrorStatus(pATATask); /* even request sense is failed. */
 										ReadIndexUchar(ATABaseAddr[pATATask->bCh], iNDEXIDEStatus); /*clear possible device INT */
 									}											
								}
							}
						}
						else
						{
							pCurSEQ_INFO->PACCNT--;
							pATATask->ATAStatus= 0;
							if ( gChnlConfig[bChannelNumber].ChnlType == CHNL_SATA )
							{	/* check SATA Error Register */						
								U32 ldata;
								/* if the regidter offset large than 0x80, when use MMIO, must use this method */
								#ifdef	_MMIO_
								ReadIndexUlong( ATABaseAddr[bAdapterNumber*MAX_ATA_CHNL]  + 0x100 * (bChannelNumber%MAX_ATA_CHNL) , iNDEXIDESATAError, ldata );
								WriteIndexUlong( ATABaseAddr[bAdapterNumber*MAX_ATA_CHNL]  + 0x100 * (bChannelNumber%MAX_ATA_CHNL) , iNDEXIDESATAError, ldata );
								#else
								ReadIndexUlong( ATABaseAddr[bChannelNumber], iNDEXIDESATAError, ldata );
								WriteIndexUlong( ATABaseAddr[bChannelNumber], iNDEXIDESATAError, ldata );
								#endif
								if ( ldata & 0x00380100 ) {
									pATATask->ATAStatus = ATA_ERROR+ATAERR_DRV;
									pATATask->Cmd.ATACmd.bStatus = IDE_STATUS_DF+IDE_STATUS_IDLE;
								}
							}
						}
					}
					else { /* success done all seq's packets */
						pATATask->ATAStatus= 0;

						if ( gChnlConfig[bChannelNumber].ChnlType == CHNL_SATA )
						{	/* check SATA Error Register */						
							U32 ldata;
							/* if the regidter offset large than 0x80, when use MMIO, must use this method */
							#ifdef	_MMIO_
							ReadIndexUlong( ATABaseAddr[bAdapterNumber*MAX_ATA_CHNL]  + 0x100 * (bChannelNumber%MAX_ATA_CHNL) , iNDEXIDESATAError, ldata );
							WriteIndexUlong( ATABaseAddr[bAdapterNumber*MAX_ATA_CHNL]  + 0x100 * (bChannelNumber%MAX_ATA_CHNL) , iNDEXIDESATAError, ldata );
							#else
							ReadIndexUlong( ATABaseAddr[bChannelNumber], iNDEXIDESATAError, ldata );
							WriteIndexUlong( ATABaseAddr[bChannelNumber], iNDEXIDESATAError, ldata );
							#endif							
							if ( ldata & 0x00380100 ) {
								pATATask->ATAStatus = ATA_ERROR+ATAERR_DRV;
								pATATask->Cmd.ATACmd.bStatus = IDE_STATUS_DF+IDE_STATUS_IDLE;
							}
						}
						
						/* get INT reason */
						if (!(pATATask->ATACmdFlag & ATA_DEVICE))
							IntReason = ReadIndexUchar(ATABaseAddr[bChannelNumber], iNDEXIDESectorCount)& 0x07;
							
						/* If the packet's ATACmdFlag be set with ATA_STATUS_RETURN , it only can queued at the tail of execute packets queue(or only itself at the queue),
		     				   so when error or success completed, will return ata registers statses.*/
						if (pATATask->ATACmdFlag & ATA_STATUS_RETURN) /* need read it's ata registers statses when command success completed */
							ATAErrorStatus(pATATask);
					}
CommandCompleted:					
					/* free sg resource */
					CAMFreeSG(bAdapterNumber, ATA_PAC, (PVOID)ultmpATAPacketAddress->PacketHead.PSG);	
							
					ultmpATAPacketAddress_next = (PCAM_ATA_PACKET)ultmpATAPacketAddress->PacketHead.NPA;
					/* free packet resource. */
					CAMFreePacket(bAdapterNumber, ATA_PAC, (PVOID)ultmpATAPacketAddress);
					
					
					if (pATATask->ATACmdFlag & INTERNAL_SENSE) {
						switch (IntReason) {
							case INT_WAITCMD:
								SubmitInternelSense(pATATask);
								break;
						
							case INT_DATAIN:
								/* read sense data */
								WaitForDrq(ATABaseAddr[pATATask->bCh]);
								ReadBuffer(ATABaseAddr[pATATask->bCh],(PU16)pATATask->SenseInfoBuffer,((U32)pATATask->SenseInfoLength >>1) );									
								/* wait complete INT at here and clear it */
								pATATask->ATACmdFlag &= ~INTERNAL_SENSE;
								pATATask->ATAStatus = ATA_ERROR + ATAERR_DRV;
								for ( i = 0; i < 100; i ++ ) {
									if( ReadIndexUchar(ATABaseAddr[pATATask->bCh], iNDEXIDECICR+3) & 0x08 )
										break;
								}
								ReadIndexUchar(ATABaseAddr[pATATask->bCh], iNDEXIDEStatus); /*clear device INT */
								break;
						}
					}
					else if ( pATATask->ATACmdFlag & PIO_XFER )
					{
						U32	DataTransferLength = (pATATask->DataTransferLength >> 1);
						if (!(pATATask->ATACmdFlag & ATA_DEVICE) ) {
							DataTransferLength = (U32)ReadIndexUchar(ATABaseAddr[pATATask->bCh], iNDEXIDECylinderLow)
							                    | ((U32)ReadIndexUchar(ATABaseAddr[pATATask->bCh], iNDEXIDECylinderHigh) << 8);
							DataTransferLength >>= 1;           
						}
						
						if ( pATATask->ATACmdFlag & camDATA_IN ){
  							ReadBuffer(ATABaseAddr[pATATask->bCh],(PU16)pATATask->DataBuffer, DataTransferLength );
						}
						else {
							WriteBuffer(ATABaseAddr[pATATask->bCh],(PU16)pATATask->DataBuffer, DataTransferLength );
    						}
					}										
				
					if ( !(pATATask->ATACmdFlag & INTERNAL_SENSE) )
						pATATask->callback(pATATask);		

					if (errorFlag==TRUE)
						break;
						
					/* next packet */
					ultmpATAPacketAddress = ultmpATAPacketAddress_next;
					
				}/* end of while ((U32)ultmpATAPacketAddress != U32NULL)*/

				ATAModuleBusy[bChannelNumber]=FALSE;
				ATAModuleSEQID[bChannelNumber] = U8NULL;
				CAMFreeSEQID(bAdapterNumber,SEQID);	

				/* if ( ATAModuleNeedPush[bChannelNumber] == FALSE )
					ATASoftResetModule(bChannelNumber); */	/* turn off the LED */


				/* must check module is need to push, By it maybe pushed when no SQEID. */
				for (i=(bAdapterNumber*MAX_ATA_CHNL);i<((bAdapterNumber+1)*MAX_ATA_CHNL);i++) {
					if ( (ATAModuleNeedPush[i]==TRUE) && (ATAModuleBusy[i]==FALSE) ){
						/* start ata module */
						StartATAOperation(i);
						break;
					}
				}
				if ( (XORModuleNeedPush[bAdapterNumber]==TRUE) && (XORModuleBusy[bAdapterNumber]==FALSE) ){
					/* start xor module */
					StartXOROperation(bAdapterNumber);
				}				
			} /* end of ATA module */	
		}/* end of SEQID */
	}/* end of bAdapterNumber */

	return returnValue;
}
