/***************************************************************************
 *
 * Copyright (c) 2002 Promise Technology, Inc.  All rights reserved.
 * No part of this document may be reproduced or transmitted in any form or
 * by any means, electronic or mechanical, for any purpose, without the
 * express written permission of Promise Technology, Inc.
 *
 *
 * cam_global.h - declarations for global variables
 *
 ***************************************************************************/ 

/* 
 * 	adapter configuartion 
 */
extern ADAPTER_CONFIG	gAdapterConfig[MAX_ADAPTER_NUM];	
extern U32 ATABaseAddr[MAX_ATA_MODULE];
extern U32 XORBaseAddr[MAX_ADAPTER_NUM];
extern U32 HostBaseAddr[MAX_ADAPTER_NUM];
/*
 *	ATA channel configuration
 */
extern CHNL_CONFIG		gChnlConfig[MAX_ATA_MODULE];
/*
 *	device configuration
 */
 
extern DEV_CONFIG	gDrvConfig[MAX_ATA_MODULE][2];
extern CAM_IDENTIFY_DATA	gIdentify_Data[MAX_ATA_MODULE][2];
extern ENCLOSURE_TYPE	gBOXConfig[MAX_ATA_MODULE];
extern ENCLOSURE_STATUS gBOXStatus[MAX_ATA_MODULE];
extern ATA_TASK	boxATATask[MAX_ATA_MODULE];
extern ATA_TASK	boxLEDATATask[MAX_ATA_MODULE];
extern ATA_TASK	InternalATATask[MAX_ATA_MODULE][2];

/*
 *	Memory management 
 */
extern PCAM_ATA_PACKET ATAPacketQueue[MAX_ADAPTER_NUM][MAX_ATA_PAC];
extern PCAM_XOR_PACKET XORPacketQueue[MAX_ADAPTER_NUM][MAX_XOR_PAC];
extern U16 ATAPacketCurrent[MAX_ADAPTER_NUM];
extern U16 XORPacketCurrent[MAX_ADAPTER_NUM];

/* sg queue */
extern PCAM_ATA_SG PCAM_ATA_SG_Queue[MAX_ADAPTER_NUM][MAX_ATA_PAC];
extern PCAM_XOR_SG PCAM_XOR_SG_Queue[MAX_ADAPTER_NUM][MAX_XOR_PAC];
extern U16 CAM_ATA_SG_Current[MAX_ADAPTER_NUM];
extern U16 CAM_XOR_SG_Current[MAX_ADAPTER_NUM];

/* 
 * 	packets and queues 
 */
extern U32	ATAPacketQHead[MAX_ADAPTER_NUM][MAX_ATA_CHNL];  
extern U32	ATAPacketQTail[MAX_ADAPTER_NUM][MAX_ATA_CHNL];  	
extern U8	ATAPacketQCount[MAX_ADAPTER_NUM][MAX_ATA_CHNL];  	
extern MODULE_PACKET_COUNT PacketQueueCount[MAX_ADAPTER_NUM];

/* 
 *	Sequences 
 */
extern SEQ_INFO	gSEQ_INFO[MAX_ADAPTER_NUM][MAX_SEQ_ID];
extern U8 SEQIDPool[MAX_ADAPTER_NUM][MAX_SEQ_ID];
extern U8 SEQIDCurrent[MAX_ADAPTER_NUM];



/* for push queued module */

/* for XOR */
extern U8	XORModuleNeedPush[MAX_ADAPTER_NUM];
extern U16 XORQueueHead[MAX_ADAPTER_NUM],XORQueueTail[MAX_ADAPTER_NUM];
extern XOR_QUEUE XorQueue[MAX_ADAPTER_NUM][MAX_XOR_PAC+1];
extern U32 XORModuleBusy[MAX_ADAPTER_NUM];
extern U8 XORModuleSEQID[MAX_ADAPTER_NUM];
extern U32 XOR_Timeout_TimerID[MAX_ADAPTER_NUM*MAX_XOR_MODULE];
extern U8 XORModuleReceiveTask[MAX_ADAPTER_NUM];

/* for ATA */
extern U8 	ATAModuleNeedPush[MAX_ATA_MODULE];
extern U16 ATAQueueHead[MAX_ATA_MODULE];
extern U16 ATAQueueTail[MAX_ATA_MODULE];
extern ATA_QUEUE ATAQueue[MAX_ATA_MODULE][MAX_ATA_PAC+1];
extern U32 ATAModuleBusy[MAX_ATA_MODULE];
extern U8 ATAModuleSEQID[MAX_ATA_MODULE];
extern U32 ATA_Timeout_TimerID[MAX_ATA_MODULE];
extern U32 BOX_Timeout_TimerID[MAX_ATA_MODULE];
extern U8 ATAModuleReceiveTask[MAX_ATA_MODULE];

/* timeout times */
extern MODULE_TIMEOUT CAMTimeoutTimes[MAX_ADAPTER_NUM];
