/***************************************************************************
 *
 * Copyright (c) 1995 Promise Technology, Inc.  All rights reserved.
 * No part of this document may be reproduced or transmitted in any form or
 * by any means, electronic or mechanical, for any purpose, without the
 * express written permission of Promise Technology, Inc.
 *
 *
 * cam_exp.h - function prototypes provided by CAM
 *
 *
 ***************************************************************************/
 
#ifndef CAM_EXP_H
#define CAM_EXP_H
 
/* 
 *	cam.c
 */
extern void CAM_GetInfo(PCAM_INFO pCAMInfo);
extern U8 CAM_Init(PADAPTER_CONFIG_INFO pAdapter);
extern U8 CAM_ReInit(PADAPTER_CONFIG_INFO pAdapter);
extern U8 CAM_Close(PADAPTER_CONFIG_INFO pAdapter);
extern U32 CAM_GetExtraData(U8 Adapter_ID, U8 bID);
extern void CAM_SetExtraData(U8 Adapter_ID, U8 bID, U32 value);
extern void CAM_GetPacketCount(U8 bAdapterNumber,PMODULE_PACKET_COUNT pCAM_Module);
extern void CAM_SetPacketCount(U8 bAdapterNumber,PMODULE_PACKET_COUNT pCAM_Module);
extern void CAM_GetTimeoutTime(U8 bAdapterNumber,PMODULE_TIMEOUT pCAM_Timeout);
extern void CAM_SetTimeoutTime(U8 bAdapterNumber,PMODULE_TIMEOUT pCAM_Timeout);
void WriteIndexUchar(U32 BaseAddress, U8 Index, U8 Data );
U8 ReadIndexUchar(U32 BaseAddress, U8 Index );


extern U8 CAMAllocSEQID(U8 card_no);
extern void CAMFreeSEQID(U8 card_no, U8 SEQID);
extern PVOID CAMAllocPacket(U8 card_no, PAC_Q_TYPE q_type);
extern void CAMFreePacket(U8 card_no, PAC_Q_TYPE q_type, PVOID PacketAddress);
extern PVOID CAMAllocSG(U8 card_no, PAC_Q_TYPE q_type);
extern void CAMFreeSG(U8 card_no, PAC_Q_TYPE q_type, PVOID PacketAddress);
extern void checkConvertSG(PCAMSG  source_sg,PCAMSG target_sg);
extern void Put2SeqIDQueue(U8 bAdapterNumber,PVOID PacketAddress,U8 SeqID);

/* 
 *	cam_ata.c
 */
extern U8 CAM_InitATAChannel(U8 bChannelNumber);
extern U8 CAM_ResetATAChannel(U8 bChannelNumber);
extern U8 CAM_EnumATAChannel(PCHNL_CONFIG pChnlConfig);
extern U8 CAM_ConfigATAChannel(PCHNL_CONFIG pChnlConfig);
extern U8 CAM_EnumATADevice(PDEV_CONFIG pDevConfig);
extern U8 CAM_ConfigATADevice(PDEV_CONFIG pDevConfig);
extern U8 CAM_SubmitATA (PATA_TASK pATATask);
extern void ATASoftResetModule(U8 bChannelNumber);
extern void ATAErrorStatus(PATA_TASK pATATask);
extern void ATAPIErrorStatus(PATA_TASK pATATask);
extern void SubmitInternelSense(PATA_TASK pATATask);
extern void (*ATA_Timeout_Function[])(void);
extern void Abort_All_Undone_ATAPackets(U8 bCh,PCAM_ATA_PACKET pATAPacket);
extern void stopATAModule(U8 bChannelNumber);
extern U8 WaitForDrq(U32 IDEBaseAddress);

/* 
 *	cam_xor.c
 */
extern U8 CAM_SubmitXOR(PCAM_XOR_TASK pXORTask);
extern void XORSoftResetModule(U8 bAdapterNumber);
extern void (*XOR_Timeout_Function[])(void);
extern void Abort_All_Undone_XORPackets(U8 bAdapterNumber,PCAM_XOR_PACKET XORPacketAddress);
extern void stopXORModule(U8 bAdapterNumber);

/* 
 * cam_swap.c
 */
extern U8 CAM_EnumEnclosure(U8 bCh, PENCLOSURE_TYPE pBox);
extern U8 CAM_Get_Enclosure_Status(U8 bID, PENCLOSURE_STATUS pBoxStatus);
extern void CAM_CtrlLED(U8 bID, U8 bColor); 
extern void CAM_Enclosure_PowerOn(U8 bID);
extern void CAM_Enclosure_PowerOff(U8 bID);
extern void Check_Enclosure_PowerState(U8 bID);

/*
 *	cam_isr.c
 */
extern U32 CAM_ISR(U32 IRQHandle);
extern void StartATAOperation(U8 bChannelNumber);
extern void StartXOROperation(U8 bAdapterNumber);

#endif
