/***************************************************************************
 *
 * Copyright (c) 2002 Promise Technology, Inc.  All rights reserved.
 * No part of this document may be reproduced or transmitted in any form or
 * by any means, electronic or mechanical, for any purpose, without the
 * express written permission of Promise Technology, Inc.
 *
 *
 * cam_con.h - defines standard typedefs and other useful constants
 *
 ***************************************************************************/
 
#ifndef CAM_CON_H
#define CAM_CON_H
 
#ifndef bit
  	#define bit(x)  (1 << x)
#endif

#define U32NULL				0xFFFFFFFF
#define U16NULL				0xFFFF
#define U8NULL				0xFF
#define ZERO_NULL			0x0

#ifndef	TRUE
	#define TRUE	1
	#define FALSE	0
#endif

#define camSUCCESS					TRUE			
#define	camACCEPTED					TRUE
#define camFREE						TRUE
#define	camFAIL						FALSE
#define	camDEVICE_NOT_FOUND			FALSE
#define	camBUSY						FALSE
#define	camWARNING					0x02
#define	camCHNL_NOT_FOUND			0xFF


/* definitions for CAMFlag of CAM_INFO */	
#define IO_ACCESS	0x01			/* CAM will do IO access */
#define MEM_ACCESS	0x02			/* CAM will do memory-mapped IO access */

/* definitions for DeviceID CAM_INFO */
#define	CAM_PDC20620	0x6620		/* the CAM is for PDC20620/617 series ASIC */
#define CAM_PDC20621	0x6621		/* the CAM is for PDC20621 */


/*  CAM base information */
#ifndef	OEM_PROMISE
	#define OEM_PROMISE		0
#endif

#ifndef	CAM_VerMajor
	#define CAM_VerMajor			1
	#define CAM_VerMinor			0
	#define CAM_VerOEM				OEM_PROMISE
	#define CAM_VerBuild			24
#endif

#ifdef	_MMIO_
	#define ACCESS_TYPE		MEM_ACCESS
#else
	#define	ACCESS_TYPE		IO_ACCESS
#endif
#define CAM_DEVICEID	CAM_PDC20620

#define MAX_ADAPTER_NUM 			2			/* start from 1 adapter */
#define	MAX_ATA_CHNL				4 			/* The number of ATA channels per controller */
#define MAX_XOR_MODULE				1			/* The number of XOR modules per controller */
#define MAX_HDMA_MODULE				0			/* The number of HDMA modules per controller */
#define	MAX_SEQ_ID				  	16			/* The number of SEQ ID per controller */
#define MAX_ATA_MODULE				MAX_ADAPTER_NUM * MAX_ATA_CHNL
#define	MAX_XOR_SG					4
#define	MAX_HDMA_SG					2
#ifndef NETWARE
  #define	START_SEQ_ID				1		/* SEQ ID 0 reserved to direct commands */
#else
  #define	START_SEQ_ID				8		/* NETWARE and BIOS should SEQs in differnt bytes */	
#endif


/*  for memory and packet management */
#define MAXREGCNT		0x34	/* I think that is enough for ATA and ATAPI both
								 * Then ATA packet size is 32 * N bytes 
								 */
#ifndef	USE_XOR
  #define MAX_XOR_PAC		0x01	/* reduce to 1 */
#else
  #define MAX_XOR_PAC		0x10
#endif

#define MAX_ATA_PAC		0x10
#define XOR_BASE_ADDR	0x00
#define ATA_BASE_ADDR	(XOR_BASE_ADDR + MAX_XOR_PAC * XOR_PAC_SIZE)	
#define XOR_SG_BASE_ADDR	(ATA_BASE_ADDR + MAX_ATA_PAC * ATA_PAC_SIZE)
#define ATA_SG_BASE_ADDR	(XOR_SG_BASE_ADDR + MAX_XOR_PAC * XOR_SG_SIZE)


#define MIN_CAM_MEMSIZE		(ATA_SG_BASE_ADDR + MAX_ATA_PAC * ATA_SG_SIZE)+4

/* Registers */
#define	HOSTMEMBASE		0x000
#define XORMEMBASE		0x180
#define ATAMEMBASE		0x200

#ifdef _MMIO_
#define ATA_PACSTART_REGISTER_OFFSET	0x40
#define ATA_STATUS_REGISTER_OFFSET		0x48
#else
#define ATA_PACSTART_REGISTER_OFFSET	0x00
#define ATA_STATUS_REGISTER_OFFSET		0x04
#endif

#define PACSTART_REGISTER_OFFSET	0x00
#define STATUS_REGISTER_OFFSET		0x04
#define INDEX_REGISTER_OFFSET		0x08
#define DATA_REGISTER_OFFSET		0x0C

#define	SEQINT_REGISTER_OFFSET		0x40

/* Host Offset of ASIC */
#define oFFSETHOSTFlashCTL			0x44
#define oFFSETHOSTPCICTL			0x48
#define oFFSETHOSTPLLCNT			0x4C
#define oFFSETHOSTEXTRA0			0x5C
#define oFFSETHOSTEXTRA1			0x60
#define oFFSETHOSTEXTRA2			0x64
#define oFFSETMSICTL				0x68
#define oFFSETHOSTSATAPLUG			0x6C

/* IDE Index of ASIC */
#define iNDEXIDEData                0x00
#define iNDEXIDEFeature				0x04
#define iNDEXIDEError				0x04
#define iNDEXIDESectorCount		    0x08
#define iNDEXIDESectorNumber        0x0c
#define iNDEXIDECylinderLow         0x10
#define iNDEXIDECylinderHigh        0x14
#define iNDEXIDEDeviceHead          0x18
#define iNDEXIDECommand             0x1c
#define iNDEXIDEStatus				0x1c

#define iNDEXSwapBox				0x20
#define iNDEXIDEAlternateStatus     0x38
#define iNDEXIDEDeviceControl		0x38
#define iNDEXIDEPacketPointer		0x40
#define iNDEXIDECGCR				0x48
#define iNDEXIDEDrvTiming1			0x50
#define iNDEXIDECICR				0x60
#define iNDEXSATAStatus				0x80
#ifdef	_MMIO_
	#define iNDEXIDESATAError		0x204   /*0x404*/
	#define iNDEXIDESATAControl		0x208   /*0x408*/
	#define iNDEXIDETBGmode			0x21C	/*0x41C*/
	#define iNDEXIDEPowermodeControl	0x230	/*0x430*/
	#define iNDEXIDESlewrate			0x270	/*0x470*/
	#define iNDEXIDESATAmode			0x274	/*0x474*/
#else
	#define iNDEXIDESATAError		0x84
	#define iNDEXIDESATAControl		0x88
	#define iNDEXIDETBGmode			0x9C
	#define iNDEXIDEPowermodeControl	0xB0
	#define iNDEXIDESlewrate			0xF0
	#define iNDEXIDESATAmode			0xF4	
#endif

/* IDE status definitions */
#define IDE_STATUS_ERROR			0x01
#define IDE_STATUS_INDEX			0x02
#define IDE_STATUS_CORRECTED_ERROR	0x04
#define IDE_STATUS_DRQ				0x08
#define IDE_STATUS_DSC				0x10
#define IDE_STATUS_SERVICE			0x10
#define IDE_STATUS_DF				0x20	/* Device Fault */
#define IDE_STATUS_DRDY				0x40
#define IDE_STATUS_IDLE				0x50
#define IDE_STATUS_BUSY				0x80


/* XOR Index of ASIC */
#define XOR_COMMAND_XOR						0x01
#define XOR_COMMAND_COMPARE					0x0

#define ATRLREG_REG_SIZE_8                  (0x00)
#define ATRLREG_REG_SIZE_7                  (0x07 << 5)
#define ATRLREG_REG_SIZE_6                  (0x06 << 5)
#define ATRLREG_REG_SIZE_5                  (0x05 << 5)
#define ATRLREG_REG_SIZE_4                  (0x04 << 5)
#define ATRLREG_REG_SIZE_3                  (0x03 << 5)
#define ATRLREG_REG_SIZE_2                  (0x02 << 5)
#define ATRLREG_REG_SIZE_1                  (0x01 << 5)

#define ATRLREG_CONDITION_NO                0x00
#define ATRLREG_CONDITION_CHECK_NOT_BUSY    0x10
#define ATRLREG_CONDITION_CHECK_DRQ         0x18
#define ATRLREG_CONDITION_X_DEFINE          0x08

#define ATRLREG_X_3F6                       0x0E
#define ATRLREG_X_END_1F7                   0x0F
#define ATRLREG_X_END_1F0                   0x08
#define ATRLREG_X_END_1FX                   0x08

#define ATRLREG_DATA                        0x00
#define ATRLREG_FEATURE                     0x01
#define ATRLREG_SECTOR_COUNT                0x02
#define ATRLREG_LBA0_7                      0x03
#define ATRLREG_LBA8_15                     0x04
#define ATRLREG_LBA16_23                    0x05
#define ATRLREG_LBA24_27                    0x06
#define ATRLREG_COMMAND                     0x07

#define ATRLREG_SECTORNUM                   0x03
#define ATRLREG_LBALOW                      0x04
#define ATRLREG_LBAHIGH                     0x05
#define ATRLREG_DEVICESELECT                0x06

#define SEQ_NO_SEQID            			0xFF
#define SEQ_NO_DELAY            			0xFF

/*
 * IDE command definitions
 */
#define IDE_COMMAND_NOP								0x00
#define IDE_COMMAND_ATAPI_RESET                     0x08
#define IDE_COMMAND_RECALIBRATE                     0x10
#define IDE_COMMAND_READ                    		0x20
#define IDE_COMMAND_WRITE                   		0x30
#define IDE_COMMAND_SEEK                            0x70
#define IDE_COMMAND_SET_DRIVE_PARAMETERS    		0x91
#define IDE_COMMAND_VERIFY                          0x40
#define IDE_COMMAND_ATAPI_PACKET                    0xA0
#define IDE_COMMAND_ATAPI_IDENTIFY                  0xA1
#define IDE_COMMAND_WRITE_DMA                       0xCA
#define IDE_COMMAND_READ_DMA                        0xC8
#define IDE_COMMAND_SMART_CMD		           		0xB0
#define IDE_COMMAND_IDENTIFY                        0xEC
#define IDE_COMMAND_SET_FEATURES           			0xEF

#define IDE_COMMAND_READ_EXT 						0x24
#define IDE_COMMAND_READ_DMA_EXT     				0x25
#define IDE_COMMAND_READ_DMA_QUEUED_EXT  			0x26
#define IDE_COMMAND_READ_MULTIPLE_EXT    			0x29
#define IDE_COMMAND_WRITE_EXT            			0x34
#define IDE_COMMAND_WRITE_DMA_EXT     				0x35
#define IDE_COMMAND_WRITE_DMA_QUEUED_EXT  			0x36
#define IDE_COMMAND_WRITE_MULTIPLE_EXT   			0x39
#define IDE_COMMAND_VERIFY_EXT						0x42

/*
 * ATAPI command definitions
 */

#define REQUEST_SENSE_COMMAND                     	0x03

/* Int reason	*/
#define INT_WAITCMD			0x01		/* Ready to accept command packet */
#define INT_DATAOUT			0x00		/* Data to Host */
#define INT_DATAIN			0x02		/* Data From Host */
#define INT_COMPELTE		0x03		/* Command Complete */


/* queue direction */
#define QUEUEHead 0x00
#define QUEUETail 0x01


/* Enclosure */
#define WINBONDID	0x5CA3
#define DEF_FANDIV	2
#define	DEF_CHKREPTIME		18*10	/* 10 seconds  */
#define	DEF_CHKSTATETIME	3	/* 30 seconds */
#define	NEW_DRIVE	TRUE
#define	NO_DRIVE	FALSE

/* Timeout Value */
#define DEF_ATATIMEOUT		18*3	/* 3 seconds  */
#define DEF_ATAPITIMEOUT	18*20	/* 20 seconds  */
#define	DEF_XORTIMEOUT		18*3	/* 3 seconds  */

#endif
